/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.equipment.valve;

import com.google.gson.GsonBuilder;
import java.util.Map;
import java.util.UUID;
import neqsim.physicalproperties.PhysicalPropertyType;
import neqsim.process.equipment.TwoPortEquipment;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.valve.ValveInterface;
import neqsim.process.mechanicaldesign.valve.ValveMechanicalDesign;
import neqsim.process.util.monitor.ValveResponse;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThrottlingValve
extends TwoPortEquipment
implements ValveInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ThrottlingValve.class);
    SystemInterface thermoSystem;
    private boolean valveKvSet = false;
    private boolean isoThermal = false;
    double pressure = 0.0;
    private double Kv;
    private double maxMolarFlow = 1000.0;
    private double minMolarFlow = 0.0;
    private double maxValveOpening = 100.0;
    private double minValveOpening = 0.0;
    private double percentValveOpening = 100.0;
    double molarFlow = 0.0;
    private String pressureUnit = "bara";
    private boolean acceptNegativeDP = true;
    ValveMechanicalDesign valveMechanicalDesign;
    boolean isCalcPressure = false;
    private boolean gasValve = true;
    private double Fp = 1.0;
    private double deltaPressure = 0.0;
    private boolean allowChoked = false;
    private boolean allowLaminar = true;
    private double xt = 0.6;

    public ThrottlingValve(String name) {
        super(name);
        this.setCalculateSteadyState(true);
        this.initMechanicalDesign();
    }

    public ThrottlingValve(String name, StreamInterface inletStream) {
        this(name);
        this.setInletStream(inletStream);
        this.valveMechanicalDesign = new ValveMechanicalDesign(this);
    }

    public double getDeltaPressure(String unit) {
        return this.inStream.getFluid().getPressure(unit) - this.thermoSystem.getPressure(unit);
    }

    @Override
    public double getOutletPressure() {
        return this.pressure;
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.thermoSystem;
    }

    @Override
    public double getInletPressure() {
        return this.getInletStream().getThermoSystem().getPressure();
    }

    @Override
    public void setPressure(double pressure) {
        this.setOutletPressure(pressure);
    }

    public void setPressure(double pressure, String unit) {
        this.setOutletPressure(pressure, unit);
    }

    @Override
    public void setOutletPressure(double pressure) {
        this.pressure = pressure;
        this.getOutletStream().getThermoSystem().setPressure(pressure, this.pressureUnit);
    }

    public void setOutletPressure(double pressure, String unit) {
        this.pressureUnit = unit;
        this.pressure = pressure;
        this.getOutletStream().getThermoSystem().setPressure(pressure, this.pressureUnit);
    }

    @Override
    public boolean needRecalculation() {
        return this.getInletStream().getThermoSystem().getTemperature() != this.thermoSystem.getTemperature() || this.getInletStream().getThermoSystem().getPressure() != this.thermoSystem.getPressure() || this.getInletStream().getThermoSystem().getFlowRate("kg/hr") != this.thermoSystem.getFlowRate("kg/hr") || this.getOutletPressure() != this.getOutletStream().getPressure();
    }

    public void calcKv() {
        Map<String, Object> design = this.getMechanicalDesign().calcValveSize();
        this.setKv((Double)design.get("Kv"));
    }

    public double calculateMolarFlow() {
        double flow_m3_sec = this.getMechanicalDesign().getValveSizingMethod().calculateFlowRateFromValveOpening(this.adjustKv(this.Kv, this.percentValveOpening), this.inStream, this.outStream);
        return flow_m3_sec * this.inStream.getFluid().getDensity("kg/m3") / this.inStream.getFluid().getMolarMass("kg/mol");
    }

    public double calculateOutletPressure(double KvAdjusted) {
        return this.getMechanicalDesign().getValveSizingMethod().findOutletPressureForFixedKv(KvAdjusted, this.inStream) / 100000.0;
    }

    private double adjustKv(double Kv, double percentValveOpening) {
        return this.getMechanicalDesign().getValveCharacterizationMethod().getActualKv(Kv, percentValveOpening);
    }

    @Override
    public void run(UUID id) {
        if (this.getInletStream().getThermoSystem() == null) {
            logger.error("Inlet stream thermo system is null");
            return;
        }
        this.thermoSystem = this.getInletStream().getThermoSystem().clone();
        this.thermoSystem.initProperties();
        if (this.thermoSystem.hasPhaseType(PhaseType.GAS) && this.thermoSystem.getVolumeFraction(0) > 0.5) {
            this.setGasValve(true);
        } else {
            this.setGasValve(false);
        }
        if (!this.valveKvSet) {
            this.calcKv();
            this.valveKvSet = true;
        }
        this.inStream.getThermoSystem().initProperties();
        double enthalpy = this.thermoSystem.getEnthalpy();
        double outPres = this.getOutletStream().getThermoSystem().getPressure();
        double molarFlowStart = this.getInletStream().getThermoSystem().getFlowRate("mole/sec");
        double inletPressure = this.inStream.getThermoSystem().getPressure("bara");
        double outletPressure = this.outStream.getThermoSystem().getPressure("bara");
        double deltaP = Math.max(inletPressure - outletPressure, 0.0);
        this.molarFlow = deltaP > 0.0 && !this.isCalcPressure ? this.calculateMolarFlow() : 0.0;
        if (this.valveKvSet && this.isCalcPressure) {
            outPres = this.calculateOutletPressure(this.adjustKv(this.Kv, this.percentValveOpening));
            this.setOutletPressure(outPres);
        }
        if (this.deltaPressure != 0.0) {
            this.thermoSystem.setPressure(this.thermoSystem.getPressure(this.pressureUnit) - this.deltaPressure, this.pressureUnit);
            this.setOutletPressure(this.thermoSystem.getPressure());
        }
        if (this.thermoSystem.getPressure(this.pressureUnit) - this.pressure < 0.0) {
            if (this.isAcceptNegativeDP()) {
                this.thermoSystem.setPressure(this.pressure, this.pressureUnit);
            }
        } else {
            this.thermoSystem.setPressure(this.pressure, this.pressureUnit);
        }
        if (this.getSpecification().equals("out stream")) {
            this.thermoSystem.setPressure(this.outStream.getPressure(), this.pressureUnit);
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        if (this.isIsoThermal() || Math.abs(this.pressure - this.inStream.getThermoSystem().getPressure()) < 1.0E-6 || this.thermoSystem.getTotalNumberOfMoles() < 1.0E-12 || this.pressure == 0.0) {
            this.thermoSystem.setPressure(outPres, this.pressureUnit);
            thermoOps.TPflash();
        } else {
            thermoOps.PHflash(enthalpy, 0);
        }
        this.outStream.setThermoSystem(this.thermoSystem);
        this.setCalculationIdentifier(id);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        this.thermoSystem.display(this.getName());
    }

    @Override
    public String[][] getResultTable() {
        return this.thermoSystem.getResultTable();
    }

    @Override
    public void runTransient(double dt, UUID id) {
        double outPres;
        if (this.getCalculateSteadyState()) {
            this.run(id);
            this.increaseTime(dt);
            return;
        }
        this.runController(dt, id);
        this.inStream.getFluid().initProperties();
        this.thermoSystem = this.inStream.getThermoSystem().clone();
        this.thermoSystem.init(3);
        double enthalpy = this.thermoSystem.getEnthalpy();
        this.pressure = outPres = this.getOutletStream().getThermoSystem().getPressure();
        double deltaP = Math.max(this.inStream.getPressure() - outPres, 0.0);
        if (this.thermoSystem.getPressure(this.pressureUnit) - outPres < 0.0) {
            if (this.isAcceptNegativeDP()) {
                this.thermoSystem.setPressure(outPres, this.pressureUnit);
            }
        } else {
            this.thermoSystem.setPressure(outPres, this.pressureUnit);
        }
        if (this.getSpecification().equals("out stream")) {
            this.thermoSystem.setPressure(this.outStream.getPressure(), this.pressureUnit);
        }
        double adjustKv = this.adjustKv(this.Kv, this.percentValveOpening);
        if (deltaP > 0.0 && !this.isCalcPressure) {
            this.molarFlow = this.calculateMolarFlow();
            this.inStream.getThermoSystem().setTotalFlowRate(this.molarFlow, "mole/sec");
            this.inStream.getThermoSystem().init(1);
            this.inStream.run(id);
        }
        if (this.valveKvSet && this.isCalcPressure) {
            this.inStream.getFluid().initProperties();
            outPres = this.calculateOutletPressure(adjustKv);
            this.thermoSystem.setPressure(outPres);
            this.setOutletPressure(outPres);
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        if (this.isIsoThermal()) {
            thermoOps.TPflash();
        } else {
            thermoOps.PHflash(enthalpy, 0);
        }
        this.thermoSystem.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
        this.outStream.setThermoSystem(this.thermoSystem);
        this.molarFlow = deltaP > 0.0 ? this.calculateMolarFlow() : 0.0;
        try {
            this.inStream.getThermoSystem().setTotalFlowRate(this.molarFlow, "mole/sec");
            this.inStream.getThermoSystem().init(1);
            this.inStream.run(id);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        try {
            this.outStream.getThermoSystem().setTotalFlowRate(this.molarFlow, "mole/sec");
            this.outStream.getThermoSystem().init(1);
            this.outStream.run(id);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        this.setCalculationIdentifier(id);
    }

    public void runController(double dt, UUID id) {
        if (this.hasController && this.getController().isActive()) {
            this.getController().runTransient(this.percentValveOpening, dt, id);
            this.percentValveOpening = this.getController().getResponse();
            if (this.percentValveOpening > this.maxValveOpening) {
                this.percentValveOpening = this.maxValveOpening;
            }
            if (this.percentValveOpening < this.minValveOpening) {
                this.percentValveOpening = this.minValveOpening;
            }
        }
        this.setCalculationIdentifier(id);
    }

    public void setMinimumValveOpening(double minopen) {
        this.minValveOpening = minopen;
    }

    @Override
    public double getKv() {
        return this.Kv;
    }

    @Override
    public double getCv() {
        return this.getCv("US");
    }

    @Override
    public double getCv(String unit) {
        if (unit.equals("US")) {
            return this.Kv * 1.156;
        }
        if (unit.equalsIgnoreCase("SI") || unit.isEmpty()) {
            return this.Kv;
        }
        logger.warn("Invalid unit specified for getKv. Returning SI value.");
        return this.Kv;
    }

    @Override
    public void setCv(double Cv) {
        this.setCv(Cv, "US");
    }

    @Override
    public void setKv(double Kv) {
        this.setCv(Kv, "SI");
    }

    @Override
    public void setCv(double cv, String unit) {
        this.Kv = unit.equals("US") ? cv / 1.156 : cv;
        this.valveKvSet = true;
    }

    @Override
    public double getCg() {
        double Cl = 1360.0;
        return this.getCv() * Cl;
    }

    @Override
    public double getPercentValveOpening() {
        return this.percentValveOpening;
    }

    @Override
    public void setPercentValveOpening(double percentValveOpening) {
        this.percentValveOpening = percentValveOpening;
    }

    public boolean isValveKvSet() {
        return this.valveKvSet;
    }

    public void setValveKvSet(boolean valveKvSet) {
        this.valveKvSet = valveKvSet;
    }

    @Override
    public boolean isIsoThermal() {
        return this.isoThermal;
    }

    @Override
    public void setIsoThermal(boolean isoThermal) {
        this.isoThermal = isoThermal;
    }

    @Override
    public double getEntropyProduction(String unit) {
        this.outStream.getThermoSystem().init(3);
        this.inStream.getThermoSystem().init(3);
        return this.outStream.getThermoSystem().getEntropy(unit) - this.inStream.getThermoSystem().getEntropy(unit);
    }

    @Override
    public double getExergyChange(String unit, double surroundingTemperature) {
        this.outStream.getThermoSystem().init(3);
        this.inStream.getThermoSystem().init(3);
        return this.outStream.getThermoSystem().getExergy(surroundingTemperature, unit) - this.inStream.getThermoSystem().getExergy(surroundingTemperature, unit);
    }

    public boolean isAcceptNegativeDP() {
        return this.acceptNegativeDP;
    }

    public void setAcceptNegativeDP(boolean acceptNegativeDP) {
        this.acceptNegativeDP = acceptNegativeDP;
    }

    @Override
    public void initMechanicalDesign() {
        this.valveMechanicalDesign = new ValveMechanicalDesign(this);
    }

    @Override
    public ValveMechanicalDesign getMechanicalDesign() {
        return this.valveMechanicalDesign;
    }

    public void setIsCalcOutPressure(boolean isSetPres) {
        this.isCalcPressure = isSetPres;
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new ValveResponse(this));
    }

    public boolean isGasValve() {
        return this.gasValve;
    }

    public void setGasValve(boolean gasValve) {
        this.gasValve = gasValve;
    }

    public double getFp() {
        return this.Fp;
    }

    public void setFp(double fp) {
        this.Fp = fp;
    }

    public double getDeltaPressure() {
        return this.deltaPressure;
    }

    public void setDeltaPressure(double deltaPressure, String unit) {
        this.deltaPressure = deltaPressure;
        this.pressureUnit = unit;
    }

    public boolean isAllowChoked() {
        return this.allowChoked;
    }

    public void setAllowChoked(boolean allowChoked) {
        this.allowChoked = allowChoked;
    }

    public boolean isAllowLaminar() {
        return this.allowLaminar;
    }

    public void setAllowLaminar(boolean allowLaminar) {
        this.allowLaminar = allowLaminar;
    }
}

