/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import java.util.HashMap;
import java.util.Map;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.measurementdevice.StreamMeasurementDeviceBaseClass;

public class CombustionEmissionsCalculator
extends StreamMeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    private static final Map<String, Double> NATURAL_GAS_COMPOSITION = new HashMap<String, Double>();
    private static final Map<String, Double> CO2_EMISSIONS_FACTORS = new HashMap<String, Double>();
    private static final Map<String, Double> COMPONENT_MOLAR_MASS = new HashMap<String, Double>();

    public CombustionEmissionsCalculator(StreamInterface stream) {
        this("EmissionCalculator", stream);
    }

    public CombustionEmissionsCalculator(String name, StreamInterface stream) {
        super(name, "kg/hr", stream);
    }

    public void setComponents() {
        NATURAL_GAS_COMPOSITION.clear();
        CO2_EMISSIONS_FACTORS.clear();
        if (this.stream.getFluid().getPhase(0).hasComponent("methane")) {
            NATURAL_GAS_COMPOSITION.put("Methane", this.stream.getFluid().getComponent("methane").getz());
            CO2_EMISSIONS_FACTORS.put("Methane", 2.75);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("ethane")) {
            NATURAL_GAS_COMPOSITION.put("Ethane", this.stream.getFluid().getComponent("ethane").getz());
            CO2_EMISSIONS_FACTORS.put("Ethane", 3.75);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("propane")) {
            NATURAL_GAS_COMPOSITION.put("Propane", this.stream.getFluid().getComponent("propane").getz());
            CO2_EMISSIONS_FACTORS.put("Propane", 5.5);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("n-butane")) {
            NATURAL_GAS_COMPOSITION.put("n-butane", this.stream.getFluid().getComponent("n-butane").getz());
            CO2_EMISSIONS_FACTORS.put("n-butane", 6.5);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("i-butane")) {
            NATURAL_GAS_COMPOSITION.put("i-butane", this.stream.getFluid().getComponent("i-butane").getz());
            CO2_EMISSIONS_FACTORS.put("i-butane", 6.5);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("n-pentane")) {
            NATURAL_GAS_COMPOSITION.put("n-pentane", this.stream.getFluid().getComponent("n-pentane").getz());
            CO2_EMISSIONS_FACTORS.put("n-pentane", 7.5);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("i-pentane")) {
            NATURAL_GAS_COMPOSITION.put("i-pentane", this.stream.getFluid().getComponent("i-pentane").getz());
            CO2_EMISSIONS_FACTORS.put("i-pentane", 7.5);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("hexane")) {
            NATURAL_GAS_COMPOSITION.put("hexane", this.stream.getFluid().getComponent("hexane").getz());
            CO2_EMISSIONS_FACTORS.put("hexane", 8.5);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("nitrogen")) {
            NATURAL_GAS_COMPOSITION.put("Nitrogen", this.stream.getFluid().getComponent("nitrogen").getz());
            CO2_EMISSIONS_FACTORS.put("Nitrogen", 0.0);
        }
        if (this.stream.getFluid().getPhase(0).hasComponent("CO2")) {
            NATURAL_GAS_COMPOSITION.put("CO2", this.stream.getFluid().getComponent("CO2").getz());
            CO2_EMISSIONS_FACTORS.put("CO2", 0.0);
        }
    }

    @Override
    public double getMeasuredValue(String unit) {
        this.setComponents();
        return CombustionEmissionsCalculator.calculateCO2Emissions(NATURAL_GAS_COMPOSITION, CO2_EMISSIONS_FACTORS) * this.stream.getFluid().getFlowRate(unit);
    }

    public static double calculateCO2Emissions(Map<String, Double> composition, Map<String, Double> emissionsFactors) {
        double moleFraction;
        String component;
        double totalEmissions = 0.0;
        double totalMass = 0.0;
        for (Map.Entry<String, Double> entry : composition.entrySet()) {
            component = entry.getKey();
            moleFraction = entry.getValue();
            if (!COMPONENT_MOLAR_MASS.containsKey(component)) continue;
            totalMass += moleFraction * COMPONENT_MOLAR_MASS.get(component);
        }
        for (Map.Entry<String, Double> entry : composition.entrySet()) {
            component = entry.getKey();
            moleFraction = entry.getValue();
            if (!COMPONENT_MOLAR_MASS.containsKey(component) || !emissionsFactors.containsKey(component)) continue;
            double massFraction = moleFraction * COMPONENT_MOLAR_MASS.get(component) / totalMass;
            double emissionsFactor = emissionsFactors.get(component);
            double componentEmissions = massFraction * emissionsFactor;
            totalEmissions += componentEmissions;
        }
        return totalEmissions;
    }

    static {
        COMPONENT_MOLAR_MASS.put("Methane", 0.01604);
        COMPONENT_MOLAR_MASS.put("Ethane", 0.03007);
        COMPONENT_MOLAR_MASS.put("Propane", 0.0441);
        COMPONENT_MOLAR_MASS.put("n-butane", 0.05812);
        COMPONENT_MOLAR_MASS.put("i-butane", 0.05812);
        COMPONENT_MOLAR_MASS.put("n-pentane", 0.07215);
        COMPONENT_MOLAR_MASS.put("i-pentane", 0.07215);
        COMPONENT_MOLAR_MASS.put("hexane", 0.08617);
        COMPONENT_MOLAR_MASS.put("Nitrogen", 0.02802);
        COMPONENT_MOLAR_MASS.put("CO2", 0.04401);
    }
}

