/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.measurementdevice.StreamMeasurementDeviceBaseClass;
import neqsim.pvtsimulation.simulation.SaturationPressure;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CricondenbarAnalyser
extends StreamMeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(CricondenbarAnalyser.class);

    public CricondenbarAnalyser(StreamInterface stream) {
        this("CricondenbarAnalyser", stream);
    }

    public CricondenbarAnalyser(String name, StreamInterface stream) {
        super(name, "K", stream);
        this.setConditionAnalysisMaxDeviation(1.0);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
    }

    @Override
    public double getMeasuredValue(String unit) {
        SystemInterface tempFluid = this.stream.getThermoSystem().clone();
        tempFluid.removeComponent("water");
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
        try {
            thermoOps.setRunAsThread(true);
            thermoOps.calcPTphaseEnvelope(false, 1.0);
            thermoOps.waitAndCheckForFinishedCalculation(15000);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return thermoOps.get("cricondenbar")[1];
    }

    public double getMeasuredValue2(String unit, double temp) {
        SystemInterface tempFluid = this.stream.getThermoSystem().clone();
        tempFluid.setTemperature(temp, "C");
        tempFluid.setPressure(10.0, "bara");
        if (tempFluid.getPhase(0).hasComponent("water")) {
            tempFluid.removeComponent("water");
        }
        SaturationPressure thermoOps = new SaturationPressure(tempFluid);
        try {
            thermoOps.run();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return thermoOps.getSaturationPressure();
    }
}

