/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import neqsim.process.equipment.pipeline.PipeBeggsAndBrills;
import neqsim.process.measurementdevice.MeasurementDeviceBaseClass;
import neqsim.process.measurementdevice.WaterDewPointAnalyser;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FlowInducedVibrationAnalyser
extends MeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(WaterDewPointAnalyser.class);
    private double supportDistance = 3.0;
    private Boolean calcSupportArrangement = false;
    private String supportArrangement = "Stiff";
    private String method = "LOF";
    private PipeBeggsAndBrills pipe;
    private Boolean segmentSet = false;
    private int segment;
    private double FRMSConstant = 6.7;

    public FlowInducedVibrationAnalyser(PipeBeggsAndBrills pipe) {
        this("Pipeline Flow Induced Vibration Analyzer", pipe);
    }

    public FlowInducedVibrationAnalyser(String name, PipeBeggsAndBrills pipe) {
        super(name, pipe.getName() + " FIV analyser");
        this.pipe = pipe;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
    }

    @Override
    public double getMeasuredValue(String unit) {
        if (!this.segmentSet.booleanValue()) {
            this.segment = this.pipe.getNumberOfIncrements();
        }
        double mixDensity = this.pipe.getSegmentMixtureDensity(this.segment);
        double mixVelocity = this.pipe.getSegmentMixtureSuperficialVelocity(this.segment);
        double gasVelocity = this.pipe.getSegmentGasSuperficialVelocity(this.segment);
        double GVF = gasVelocity / mixVelocity;
        if (this.method.equals("LOF")) {
            double FVF = 1.0;
            if (GVF > 0.88) {
                FVF = GVF > 0.99 ? Math.sqrt(this.pipe.getSegmentMixtureViscosity(this.segment) / Math.sqrt(0.001)) : -27.882 * GVF * GVF + 45.545 * GVF - 17.495;
            } else if (GVF < 0.2) {
                FVF = 0.2 + 4.0 * GVF;
            }
            double externalDiamater = (this.pipe.getDiameter() + 2.0 * this.pipe.getThickness()) * 1000.0;
            double alpha = 0.0;
            double betta = 0.0;
            if (this.supportArrangement.equals("Stiff")) {
                alpha = 446187.0 + 646.0 * externalDiamater + 9.17E-4 * externalDiamater * externalDiamater * externalDiamater;
                betta = 0.1 * Math.log(externalDiamater) - 1.3739;
            } else if (this.supportArrangement.equals("Medium stiff")) {
                alpha = 283921.0 + 370.0 * externalDiamater;
                betta = 0.1106 * Math.log(externalDiamater) - 1.501;
            } else if (this.supportArrangement.equals("Medium")) {
                alpha = 150412.0 + 209.0 * externalDiamater;
                betta = 0.0815 * Math.log(externalDiamater) - 1.3269;
            } else {
                alpha = 41.21 * Math.log(externalDiamater) + 49397.0;
                betta = 0.0815 * Math.log(externalDiamater) - 1.3842;
            }
            double diameterOverThickness = externalDiamater / (1000.0 * this.pipe.getThickness());
            double Fv = alpha * Math.pow(diameterOverThickness, betta);
            double LOF = mixDensity * mixVelocity * mixVelocity * FVF / Fv;
            return LOF;
        }
        if (this.method.equals("FRMS")) {
            double C = Math.min(Math.min(1.0, 5.0 * (1.0 - GVF)), 5.0 * GVF) * this.FRMSConstant;
            return C * Math.pow(this.pipe.getDiameter(), 1.6) * Math.pow(this.pipe.getSegmentLiquidDensity(this.segment), 0.6) * Math.pow(mixVelocity, 1.2);
        }
        return Double.NaN;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setSegment(int segment) {
        this.segment = segment;
        this.segmentSet = true;
    }

    public void setFRMSConstant(double frms) {
        this.FRMSConstant = frms;
    }

    public void setSupportArrangement(String arrangement) {
        this.supportArrangement = arrangement;
    }

    public void setSupportDistance(Double distance) {
        this.supportDistance = distance;
    }
}

