/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.measurementdevice.StreamMeasurementDeviceBaseClass;
import neqsim.process.measurementdevice.WaterDewPointAnalyser;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HydrocarbonDewPointAnalyser
extends StreamMeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(WaterDewPointAnalyser.class);
    private double referencePressure = 50.0;
    private String method = "EOS";

    public HydrocarbonDewPointAnalyser(StreamInterface stream) {
        this("HydrocarbonDewPointAnalyser", stream);
    }

    public HydrocarbonDewPointAnalyser(String name, StreamInterface stream) {
        super(name, "K", stream);
        this.setConditionAnalysisMaxDeviation(1.0);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
    }

    @Override
    public double getMeasuredValue(String unit) {
        SystemInterface tempFluid = this.stream.getThermoSystem().clone();
        if (tempFluid.hasComponent("water")) {
            tempFluid.removeComponent("water");
        }
        tempFluid.setPressure(this.referencePressure);
        tempFluid.setTemperature(-10.0, "C");
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
        try {
            thermoOps.dewPointTemperatureFlash(false);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return tempFluid.getTemperature(unit);
    }

    public double getReferencePressure() {
        return this.referencePressure;
    }

    public void setReferencePressure(double referencePressure) {
        this.referencePressure = referencePressure;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }
}

