/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.measurementdevice;

import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.measurementdevice.StreamMeasurementDeviceBaseClass;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.exception.InvalidInputException;

public class pHProbe
extends StreamMeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    protected SystemInterface reactiveThermoSystem;
    protected ThermodynamicOperations thermoOps;
    private double alkalinity = 0.0;

    public pHProbe(StreamInterface stream) {
        this("phProbe", stream);
    }

    public pHProbe(String name, StreamInterface stream) {
        super(name, "", stream);
    }

    public void run() {
        if (this.stream != null && this.stream.getFluid().hasPhaseType("aqueous")) {
            this.reactiveThermoSystem = this.stream.getFluid().clone();
            this.reactiveThermoSystem = this.reactiveThermoSystem.setModel("Electrolyte-CPA-EOS-statoil");
            if (this.getAlkalinity() > 1.0E-10) {
                double waterkg = this.reactiveThermoSystem.getComponent("water").getTotalFlowRate("kg/sec");
                this.reactiveThermoSystem.addComponent("Na+", waterkg * this.getAlkalinity() / 1000.0);
                this.reactiveThermoSystem.addComponent("OH-", waterkg * this.getAlkalinity() / 1000.0);
            }
            if (!this.reactiveThermoSystem.isChemicalSystem()) {
                this.reactiveThermoSystem.chemicalReactionInit();
                this.reactiveThermoSystem.setMixingRule(10);
                this.reactiveThermoSystem.setMultiPhaseCheck(false);
            }
            this.thermoOps = new ThermodynamicOperations(this.reactiveThermoSystem);
            this.thermoOps.TPflash();
        }
    }

    @Override
    public double getMeasuredValue(String unit) {
        if (!unit.equalsIgnoreCase("")) {
            throw new RuntimeException(new InvalidInputException(this, "getMeasuredValue", "unit", "can only be empty."));
        }
        if (this.stream != null) {
            if (this.stream.getFluid().hasPhaseType("aqueous")) {
                this.reactiveThermoSystem = this.stream.getFluid().clone();
                this.reactiveThermoSystem = this.reactiveThermoSystem.setModel("Electrolyte-CPA-EOS-statoil");
                if (this.getAlkalinity() > 1.0E-10) {
                    double waterkg = this.reactiveThermoSystem.getComponent("water").getTotalFlowRate("kg/sec");
                    this.reactiveThermoSystem.addComponent("Na+", waterkg * this.getAlkalinity() / 1000.0);
                    this.reactiveThermoSystem.addComponent("OH-", waterkg * this.getAlkalinity() / 1000.0);
                }
                if (!this.reactiveThermoSystem.isChemicalSystem()) {
                    this.reactiveThermoSystem.chemicalReactionInit();
                    this.reactiveThermoSystem.setMixingRule(10);
                    this.reactiveThermoSystem.setMultiPhaseCheck(false);
                }
                this.thermoOps = new ThermodynamicOperations(this.reactiveThermoSystem);
                this.thermoOps.TPflash();
                return this.reactiveThermoSystem.getPhase("aqueous").getpH();
            }
            System.out.println("no aqueous phase for pH analyser");
            return 7.0;
        }
        System.out.println("no stream connected to pH analyser");
        return Double.NaN;
    }

    public double getAlkalinity() {
        return this.alkalinity;
    }

    public void setAlkalinity(double alkalinity) {
        this.alkalinity = alkalinity;
    }
}

