/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.designstandards;

import java.sql.ResultSet;
import neqsim.process.mechanicaldesign.MechanicalDesign;
import neqsim.process.mechanicaldesign.designstandards.DesignStandard;
import neqsim.util.database.NeqSimProcessDesignDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbsorptionColumnDesignStandard
extends DesignStandard {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(AbsorptionColumnDesignStandard.class);
    private double molecularSieveWaterCapacity = 20.0;

    public AbsorptionColumnDesignStandard(String name, MechanicalDesign equipmentInn) {
        super(name, equipmentInn);
        ResultSet dataSet = null;
        try (NeqSimProcessDesignDataBase database = new NeqSimProcessDesignDataBase();){
            dataSet = database.getResultSet("SELECT * FROM technicalrequirements WHERE EQUIPMENTTYPE='Absorber' AND Company='" + this.standardName + "'");
            while (dataSet.next()) {
                String specName = dataSet.getString("SPECIFICATION");
                if (!specName.equals("MolecularSieve3AWaterCapacity")) continue;
                this.molecularSieveWaterCapacity = Double.parseDouble(dataSet.getString("MAXVALUE"));
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public double getMolecularSieveWaterCapacity() {
        return this.molecularSieveWaterCapacity;
    }

    public void setMolecularSieveWaterCapacity(double molecularSieveWaterCapacity) {
        this.molecularSieveWaterCapacity = molecularSieveWaterCapacity;
    }
}

