/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.designstandards;

import java.sql.ResultSet;
import neqsim.process.mechanicaldesign.MechanicalDesign;
import neqsim.process.mechanicaldesign.designstandards.DesignStandard;
import neqsim.util.database.NeqSimProcessDesignDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GasScrubberDesignStandard
extends DesignStandard {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(GasScrubberDesignStandard.class);
    double gasLoadFactor = 0.11;
    double designFactorVolumeFlow = 1.1;
    double lengthGasInletToMeshpad = 550.0;
    double lengthGasInetToHHLL = 550.0;
    double lengthMeshPadToDemistingCyclone = 550.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GasScrubberDesignStandard(String name, MechanicalDesign equipmentInn) {
        super(name, equipmentInn);
        try (NeqSimProcessDesignDataBase database = new NeqSimProcessDesignDataBase();){
            ResultSet dataSet = null;
            try {
                dataSet = database.getResultSet("SELECT * FROM technicalrequirements_process WHERE EQUIPMENTTYPE='Gas scrubber' AND Company='" + this.standardName + "'");
                while (dataSet.next()) {
                    String specName = dataSet.getString("SPECIFICATION");
                    if (specName.equals("GasLoadFactor")) {
                        this.gasLoadFactor = Double.parseDouble(dataSet.getString("MAXVALUE"));
                        continue;
                    }
                    if (specName.equals("FlowDesignFactor")) {
                        this.designFactorVolumeFlow = Double.parseDouble(dataSet.getString("MAXVALUE"));
                        continue;
                    }
                    if (specName.equals("LengthGasInetToHHLL")) {
                        this.designFactorVolumeFlow = Double.parseDouble(dataSet.getString("MINVALUE"));
                        continue;
                    }
                    if (!specName.equals("LengthMeshPadToDemistingCyclone")) continue;
                    this.designFactorVolumeFlow = Double.parseDouble(dataSet.getString("MINVALUE"));
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                }
                catch (Exception ex) {
                    System.out.println("error closing database.....GasScrubberDesignStandard");
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public double getGasLoadFactor() {
        return this.gasLoadFactor;
    }

    public double getVolumetricDesignFactor() {
        return this.designFactorVolumeFlow;
    }
}

