/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.pipeline;

import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.pipeline.AdiabaticPipe;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.mechanicaldesign.MechanicalDesign;
import neqsim.process.mechanicaldesign.designstandards.MaterialPipeDesignStandard;
import neqsim.process.mechanicaldesign.designstandards.PipelineDesignStandard;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.ExcludeFromJacocoGeneratedReport;

public class PipelineMechanicalDesign
extends MechanicalDesign {
    private static final long serialVersionUID = 1000L;
    double innerDiameter = 1.0;
    String designStandardCode = "ANSI/ASME Standard B31.8";

    public PipelineMechanicalDesign(ProcessEquipmentInterface equipment) {
        super(equipment);
    }

    @Override
    public void readDesignSpecifications() {
        super.readDesignSpecifications();
        if (this.getDesignStandard().containsKey("material pipe design codes")) {
            ((MaterialPipeDesignStandard)this.getDesignStandard().get("material pipe design codes")).getDesignFactor();
        }
        if (this.getDesignStandard().containsKey("pipeline design codes")) {
            System.out.println("pressure vessel code standard: " + this.getDesignStandard().get("pipeline design codes").getStandardName());
            this.wallThickness = ((PipelineDesignStandard)this.getDesignStandard().get("pipeline design codes")).calcPipelineWallThickness();
        } else {
            System.out.println("no pressure vessel code standard specified......");
        }
    }

    @Override
    public void calcDesign() {
        super.calcDesign();
        if (this.designStandardCode.equals("ANSI/ASME Standard B31.8")) {
            this.wallThickness = this.getMaxOperationPressure() * this.innerDiameter / (2.0 * this.getMaterialPipeDesignStandard().getDesignFactor() * this.getMaterialPipeDesignStandard().getEfactor() * this.getMaterialPipeDesignStandard().getTemperatureDeratingFactor() * this.getMaterialPipeDesignStandard().getMinimumYeildStrength());
        } else if (this.designStandardCode.equals("ANSI/ASME Standard B31.3")) {
            this.wallThickness = 1.0E-4;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(293.15, 90.0);
        testSystem.addComponent("methane", 600000.0, "kg/hr");
        testSystem.addComponent("ethane", 7000.0, "kg/hr");
        testSystem.addComponent("propane", 12000.0, "kg/hr");
        testSystem.createDatabase(true);
        testSystem.setMultiPhaseCheck(true);
        testSystem.setMixingRule(2);
        Stream stream_1 = new Stream("Stream1", testSystem);
        AdiabaticPipe pipe = new AdiabaticPipe("pipe", stream_1);
        pipe.setDiameter(1.0);
        pipe.setLength(1000.0);
        pipe.getMechanicalDesign().setMaxOperationPressure(100.0);
        pipe.getMechanicalDesign().setMaxOperationTemperature(333.155);
        pipe.getMechanicalDesign().setMinOperationPressure(50.0);
        pipe.getMechanicalDesign().setMaxDesignGassVolumeFlow(100.0);
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(pipe);
        operations.run();
    }
}

