/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.valve;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.process.mechanicaldesign.valve.ControlValveSizingInterface;
import neqsim.process.mechanicaldesign.valve.ValveMechanicalDesign;
import neqsim.thermo.system.SystemInterface;

public class ControlValveSizing
implements ControlValveSizingInterface,
Serializable {
    ValveMechanicalDesign valveMechanicalDesign = null;
    private static final double KV_TO_CV_FACTOR = 1.156;
    private static final double SECONDS_PER_HOUR = 3600.0;
    private static final int MAX_BISECTION_ITERATIONS = 100;
    private static final double MAX_VALVE_OPENING_PERCENTAGE = 100.0;
    double xT = 0.137;
    boolean allowChoked = true;

    public ValveMechanicalDesign getValveMechanicalDesign() {
        return this.valveMechanicalDesign;
    }

    public ControlValveSizing() {
    }

    public ControlValveSizing(ValveMechanicalDesign valveMechanicalDesign) {
        this.valveMechanicalDesign = valveMechanicalDesign;
    }

    @Override
    public double getxT() {
        return this.xT;
    }

    @Override
    public void setxT(double xT) {
        this.xT = xT;
    }

    @Override
    public boolean isAllowChoked() {
        return this.allowChoked;
    }

    @Override
    public void setAllowChoked(boolean allowChoked) {
        this.allowChoked = allowChoked;
    }

    @Override
    public Map<String, Object> calcValveSize(double percentOpening) {
        HashMap<String, Object> result = this.valveMechanicalDesign.fullOutput ? new HashMap<String, Object>() : null;
        double Kv = this.calcKv(percentOpening);
        result.put("choked", false);
        result.put("Kv", Kv);
        result.put("Cv", this.Kv_to_Cv(Kv));
        result.put("Cg", this.Kv_to_Cv(Kv) * 1360.0);
        return result;
    }

    public double calcKv(double percentOpening) {
        SystemInterface fluid = ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getFluid();
        HashMap result = this.valveMechanicalDesign.fullOutput ? new HashMap() : null;
        double density = fluid.getDensity("kg/m3");
        double Y = 1.0;
        if (!((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).isGasValve()) {
            density = fluid.getDensity("kg/m3") / 1000.0;
        }
        return ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getFlowRate("m3/hr") / Math.sqrt((((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getPressure("bara") - ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getOutletStream().getPressure("bara")) / density) / this.valveMechanicalDesign.getValveCharacterizationMethod().getOpeningFactor(percentOpening);
    }

    @Override
    public double calculateFlowRateFromValveOpening(double actualKv, StreamInterface inletStream, StreamInterface outletStream) {
        return this.calculateMolarFlow(actualKv, inletStream, outletStream);
    }

    public double calculateMolarFlow(double actualKv, StreamInterface inStream, StreamInterface outStream) {
        double density = inStream.getFluid().getDensity("kg/m3");
        if (!((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).isGasValve()) {
            density = inStream.getFluid().getDensity("kg/m3") / 1000.0;
        }
        double flow_m3_s = actualKv / 3600.0 * Math.sqrt((inStream.getPressure("bara") - outStream.getPressure("bara")) / density);
        return flow_m3_s;
    }

    @Override
    public double calculateValveOpeningFromFlowRate(double Q, double actualKv, StreamInterface inletStream, StreamInterface outletStream) {
        double dP;
        if (actualKv <= 0.0) {
            return 0.0;
        }
        double density = inletStream.getFluid().getDensity("kg/m3");
        if (!((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).isGasValve()) {
            density /= 1000.0;
        }
        if ((dP = inletStream.getPressure("bara") - outletStream.getPressure("bara")) <= 0.0) {
            return 0.0;
        }
        double Q_m3h = Q * 3600.0;
        double requiredKv = Q_m3h / Math.sqrt(dP / density);
        double requiredOpeningFactor = requiredKv / actualKv;
        requiredOpeningFactor = Math.max(0.0, Math.min(1.0, requiredOpeningFactor));
        double low = 0.0;
        double high = 100.0;
        double percentOpening = 0.0;
        for (int i = 0; i < 100; ++i) {
            percentOpening = (low + high) / 2.0;
            double factor = this.valveMechanicalDesign.getValveCharacterizationMethod().getOpeningFactor(percentOpening);
            if (factor < requiredOpeningFactor) {
                low = percentOpening;
                continue;
            }
            high = percentOpening;
        }
        return percentOpening;
    }

    @Override
    public double findOutletPressureForFixedKv(double actualKv, StreamInterface inletStream) {
        return this.calculateOutletPressure(actualKv, inletStream);
    }

    public double calculateOutletPressure(double KvAdjusted, StreamInterface inStream) {
        double density = inStream.getFluid().getDensity("kg/m3");
        double molarMass = inStream.getFluid().getMolarMass("kg/mol");
        double molarFlow = inStream.getFlowRate("mole/sec");
        double Q_m3_s = molarFlow * molarMass / density;
        if (!((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).isGasValve()) {
            density /= 1000.0;
        }
        double dP_bar = Math.pow(Q_m3_s * 3600.0 / KvAdjusted, 2.0) * density;
        return (inStream.getPressure("bara") - dP_bar) * 100000.0;
    }

    private double Kv_to_Cv(double Kv) {
        return Kv * 1.156;
    }

    private double Cv_to_Kv(double Cv) {
        return Cv / 1.156;
    }
}

