/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.valve;

import java.util.HashMap;
import java.util.Map;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.process.equipment.valve.ValveInterface;
import neqsim.process.mechanicaldesign.valve.ControlValveSizing;
import neqsim.process.mechanicaldesign.valve.ValveMechanicalDesign;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;

public class ControlValveSizing_IEC_60534
extends ControlValveSizing {
    static final double N1 = 0.1;
    static final double N9 = 24.6;
    static final double rho0 = 999.103;
    static final double R = 8.314462;
    static final double KV_TO_CV_FACTOR = 1.156;
    double FL = 0.9;
    double Fd = 1.0;
    double D1 = 0.0;
    double D2 = 0.0;
    double d = 0.0;
    double FD = 1.0;
    boolean allowLaminar = true;
    boolean fullOutput = true;

    @Override
    public boolean isAllowChoked() {
        return this.allowChoked;
    }

    @Override
    public void setAllowChoked(boolean allowChoked) {
        this.allowChoked = allowChoked;
    }

    public boolean isAllowLaminar() {
        return this.allowLaminar;
    }

    public void setAllowLaminar(boolean allowLaminar) {
        this.allowLaminar = allowLaminar;
    }

    public boolean isFullOutput() {
        return this.fullOutput;
    }

    public void setFullOutput(boolean fullOutput) {
        this.fullOutput = fullOutput;
    }

    public ControlValveSizing_IEC_60534() {
    }

    public ControlValveSizing_IEC_60534(ValveMechanicalDesign valveMechanicalDesign) {
        super(valveMechanicalDesign);
    }

    public double getFL() {
        return this.FL;
    }

    public void setFL(double FL) {
        this.FL = FL;
    }

    public double getFd() {
        return this.Fd;
    }

    public void setFd(double Fd) {
        this.Fd = Fd;
    }

    public double getD1() {
        return this.D1;
    }

    public void setD1(double D1) {
        this.D1 = D1;
    }

    public double getD2() {
        return this.D2;
    }

    public void setD2(double D2) {
        this.D2 = D2;
    }

    public double getD() {
        return this.d;
    }

    public void setD(double d) {
        this.d = d;
    }

    @Override
    public Map<String, Object> calcValveSize(double percentOpening) {
        SystemInterface fluid = ((ThrottlingValve)this.valveMechanicalDesign.getProcessEquipment()).getInletStream().getFluid();
        if (fluid.hasPhaseType(PhaseType.GAS)) {
            return this.sizeControlValveGas(fluid.getTemperature(), fluid.getMolarMass("gr/mol"), fluid.getGamma2(), fluid.getZ(), this.getValve().getInletPressure() * 100000.0, this.getValve().getOutletPressure() * 100000.0, fluid.getFlowRate("m3/sec"), percentOpening);
        }
        return this.sizeControlValveLiquid(fluid.getDensity("kg/m3"), fluid.getZ(), fluid.getPC() * 100000.0, this.getValve().getInletPressure() * 100000.0, this.getValve().getOutletPressure() * 100000.0, fluid.getFlowRate("m3/sec"), percentOpening);
    }

    public ValveInterface getValve() {
        return (ValveInterface)this.valveMechanicalDesign.getProcessEquipment();
    }

    public Map<String, Object> sizeControlValve(FluidType type, double rhoOrT, double MW, double mu, double gammaOrPsat, double ZOrPc, double P1, double P2, double Q, Double D1, Double D2, Double d, double FL, double Fd, double xTOrNone, boolean allowChoked, boolean allowLaminar, boolean fullOutput, double percentOpening) {
        HashMap result;
        HashMap hashMap = result = fullOutput ? new HashMap() : null;
        if (type == FluidType.LIQUID) {
            return this.sizeControlValveLiquid(rhoOrT, gammaOrPsat, ZOrPc, P1, P2, Q, percentOpening);
        }
        if (type == FluidType.GAS) {
            return this.sizeControlValveGas(rhoOrT, MW, gammaOrPsat, ZOrPc, P1, P2, Q, percentOpening);
        }
        throw new IllegalArgumentException("Invalid fluid type");
    }

    public Map<String, Object> sizeControlValveLiquid(double rho, double Psat, double Pc, double P1, double P2, double Q, double percentOpening) {
        HashMap<String, Object> ans = new HashMap<String, Object>();
        double locP1 = P1 / 1000.0;
        double locP2 = P2 / 1000.0;
        double locPsat = Psat / 1000.0;
        double locPc = Pc / 1000.0;
        double Qloc = Q * 3600.0;
        double dP = locP1 - locP2;
        double FF = this.ffCriticalPressureRatioL(locPsat, locPc);
        boolean choked = this.isChokedTurbulentL(dP, locP1, locPsat, FF, this.FL);
        double Kv = choked && this.isAllowChoked() ? Qloc / (0.1 * this.FL * Math.sqrt((locP1 - FF * locPsat) * 999.103 / rho)) : Qloc / (0.1 * Math.sqrt(dP * 999.103 / rho));
        if (this.valveMechanicalDesign != null) {
            Kv /= this.valveMechanicalDesign.getValveCharacterizationMethod().getOpeningFactor(percentOpening);
        }
        ans.put("FF", FF);
        ans.put("choked", choked);
        ans.put("Kv", Kv);
        ans.put("Cv", this.Kv_to_Cv(Kv));
        return ans;
    }

    @Override
    public double calculateFlowRateFromValveOpening(double adjustedKv, StreamInterface inletStream, StreamInterface outletStream) {
        if (inletStream.getThermoSystem().hasPhaseType(PhaseType.GAS)) {
            return this.calculateFlowRateFromValveOpeningGas(adjustedKv, inletStream, outletStream);
        }
        return this.calculateFlowRateFromValveOpeningLiquid(adjustedKv, inletStream, outletStream);
    }

    public double calculateFlowRateFromValveOpeningGas(double adjustedKv, StreamInterface inletStream, StreamInterface outletStream) {
        return this.calculateFlowRateFromKvAndValveOpeningGas(adjustedKv, inletStream.getThermoSystem().getTemperature("K"), inletStream.getThermoSystem().getMolarMass("gr/mol"), inletStream.getThermoSystem().getViscosity("kg/msec"), inletStream.getThermoSystem().getGamma2(), inletStream.getThermoSystem().getZ(), inletStream.getPressure("Pa"), outletStream.getPressure("Pa"), this.FL, this.xT, this.allowChoked);
    }

    public double calculateFlowRateFromValveOpeningLiquid(double adjustedKv, double rho, double Psat, double Pc, double P1, double P2) {
        double locP1 = P1 / 1000.0;
        double locP2 = P2 / 1000.0;
        double locPsat = Psat / 1000.0;
        double dP = locP1 - locP2;
        double effectiveKv = adjustedKv;
        double FF = this.ffCriticalPressureRatioL(Psat / 1000.0, Pc / 1000.0);
        boolean choked = this.isChokedTurbulentL(dP, locP1, locPsat, FF, this.FL);
        double Qloc = choked && this.isAllowChoked() ? 0.1 * effectiveKv * this.FL * Math.sqrt((locP1 - FF * locPsat) * 999.103 / rho) : 0.1 * effectiveKv * Math.sqrt(dP * 999.103 / rho);
        return Qloc / 3600.0;
    }

    public double calculateFlowRateFromValveOpeningLiquid(double adjustedKv, StreamInterface inletStream, StreamInterface outletStream) {
        return this.calculateFlowRateFromValveOpeningLiquid(adjustedKv, inletStream.getThermoSystem().getDensity("kg/m3"), inletStream.getThermoSystem().getPhase(0).getPressure("Pa"), inletStream.getThermoSystem().getPhase(0).getPseudoCriticalPressure() * 100000.0, inletStream.getPressure("Pa"), outletStream.getPressure("Pa"));
    }

    public double calculateValveOpeningFromFlowRateLiquid(double Q, double Kv, double rho, double Psat, double Pc, double P1, double P2) {
        double locP1 = P1 / 1000.0;
        double locP2 = P2 / 1000.0;
        double locPsat = Psat / 1000.0;
        double locPc = Pc / 1000.0;
        double dP = locP1 - locP2;
        double Qloc = Q * 3600.0;
        double FF = this.ffCriticalPressureRatioL(locPsat, locPc);
        boolean choked = this.isChokedTurbulentL(dP, locP1, locPsat, FF, this.FL);
        double requiredKv = choked && this.isAllowChoked() ? Qloc / (0.1 * this.FL * Math.sqrt((locP1 - FF * locPsat) * 999.103 / rho)) : Qloc / (0.1 * Math.sqrt(dP * 999.103 / rho));
        double valveOpening = requiredKv / Kv * 100.0;
        return Math.max(0.0, Math.min(100.0, valveOpening));
    }

    public double calculateValveOpeningFromFlowRateLiquid(double Q, double Kv, StreamInterface inletStream, StreamInterface outletStream) {
        return this.calculateValveOpeningFromFlowRateLiquid(Q, Kv, inletStream.getThermoSystem().getDensity("kg/m3"), inletStream.getThermoSystem().getPhase(0).getPressure("Pa"), inletStream.getThermoSystem().getPhase(0).getPseudoCriticalPressure() * 100000.0, inletStream.getPressure("Pa"), outletStream.getPressure("Pa"));
    }

    public double findOutletPressureForFixedKvLiquid(double rho, double Psat, double Pc, double mu, double P1, double Q, double actualKv, double FL, double Fd, boolean allowChoked, boolean allowLaminar) {
        double P2_low_kPa = 0.1;
        double P2_high_kPa = P1 / 1000.0 - 1.0E-4;
        double P2_mid_kPa = 0.5 * (P2_low_kPa + P2_high_kPa);
        double tolerance = 1.0E-6;
        int maxIter = 50;
        for (int i = 0; i < maxIter; ++i) {
            double guessP2_pa = P2_mid_kPa * 1000.0;
            Map<String, Object> result = this.sizeControlValveLiquid(rho, Psat, Pc, P1, guessP2_pa, Q, ((ValveInterface)this.getValveMechanicalDesign().getProcessEquipment()).getPercentValveOpening());
            double requiredKv = (Double)result.get("Kv");
            if (requiredKv < actualKv) {
                P2_low_kPa = P2_mid_kPa;
            } else {
                P2_high_kPa = P2_mid_kPa;
            }
            double oldMid_kPa = P2_mid_kPa;
            P2_mid_kPa = 0.5 * (P2_low_kPa + P2_high_kPa);
            if (Math.abs(P2_mid_kPa - oldMid_kPa) < tolerance) break;
        }
        return P2_mid_kPa * 1000.0;
    }

    public double findOutletPressureForFixedKvLiquid(double actualKv, StreamInterface inletStream) {
        return this.findOutletPressureForFixedKvLiquid(inletStream.getThermoSystem().getDensity("kg/m3"), inletStream.getThermoSystem().getPhase(0).getPressure("Pa"), inletStream.getThermoSystem().getPhase(0).getPseudoCriticalPressure() * 100000.0, inletStream.getThermoSystem().getViscosity("kg/msec"), inletStream.getPressure("Pa"), inletStream.getFlowRate("m3/sec"), actualKv, this.FL, this.FD, this.allowChoked, this.allowLaminar);
    }

    public Map<String, Object> sizeControlValveGas(double T, double MW, double gamma, double Z, double P1, double P2, double Q, double percentOpening) {
        HashMap<String, Object> ans = new HashMap<String, Object>();
        double locP1 = P1 / 1000.0;
        double locP2 = P2 / 1000.0;
        double Qloc = Q * 3600.0;
        double dP = locP1 - locP2;
        double x = dP / locP1;
        double Fgamma = gamma / 1.4;
        double Y = Math.max(1.0 - x / (3.0 * Fgamma * this.xT), 0.6666666666666666);
        boolean choked = this.isChokedTurbulentG(x, Fgamma, this.xT);
        double Kv = choked && this.isAllowChoked() ? Qloc / (24.6 * locP1 * Y) * Math.sqrt(MW * T * Z / (this.xT * Fgamma)) : Qloc / (24.6 * locP1 * Y) * Math.sqrt(MW * T * Z / x);
        if (this.valveMechanicalDesign != null) {
            Kv /= this.valveMechanicalDesign.getValveCharacterizationMethod().getOpeningFactor(percentOpening);
        }
        ans.put("choked", choked);
        ans.put("Y", Y);
        ans.put("Fgamma", Fgamma);
        ans.put("Kv", Kv);
        ans.put("Cv", this.Kv_to_Cv(Kv));
        return ans;
    }

    public double calculateFlowRateFromKvAndValveOpeningGas(double adjustedKv, double T, double MW, double mu, double gamma, double Z, double P1, double P2, double FL, double xT, boolean allowChoked) {
        double locP1 = P1 / 1000.0;
        double locP2 = P2 / 1000.0;
        double effectiveKv = adjustedKv;
        double Vm = Z * 8.314462 * T / (locP1 * 1000.0);
        double rho = MW * 0.001 / Vm;
        double dP = locP1 - locP2;
        double Fgamma = gamma / 1.4;
        double x = dP / locP1;
        double Y = Math.max(1.0 - x / (3.0 * Fgamma * xT), 0.6666666666666666);
        boolean choked = this.isChokedTurbulentG(x, Fgamma, xT);
        double Qloc = choked && allowChoked ? effectiveKv * 24.6 * locP1 * Y / Math.sqrt(MW * T * Z / xT / Fgamma) : effectiveKv * 24.6 * locP1 * Y / Math.sqrt(MW * T * Z / x);
        return Qloc / 3600.0;
    }

    public double calculateFlowRateFromKvAndValveOpeningGas(double adjustedKv, StreamInterface inletStream, StreamInterface outletStream) {
        return this.calculateFlowRateFromKvAndValveOpeningGas(adjustedKv, inletStream.getThermoSystem().getTemperature("K"), inletStream.getThermoSystem().getMolarMass("g/mol"), inletStream.getThermoSystem().getViscosity("kg/msec"), inletStream.getThermoSystem().getGamma2(), inletStream.getThermoSystem().getZ(), inletStream.getPressure("Pa"), outletStream.getPressure("Pa"), this.FL, this.FD, this.allowChoked);
    }

    public double calculateValveOpeningFromFlowRateGas(double Q, double Kv, double T, double MW, double mu, double gamma, double Z, double P1, double P2, double FL, double xT, boolean allowChoked) {
        double locP1 = P1 / 1000.0;
        double locP2 = P2 / 1000.0;
        double Qloc = Q * 3600.0;
        double Vm = Z * 8.314462 * T / (locP1 * 1000.0);
        double rho = MW * 0.001 / Vm;
        double dP = locP1 - locP2;
        double Fgamma = gamma / 1.4;
        double x = dP / locP1;
        double Y = Math.max(1.0 - x / (3.0 * Fgamma * xT), 0.6666666666666666);
        boolean choked = this.isChokedTurbulentG(x, Fgamma, xT);
        double effectiveKv = choked && allowChoked ? Qloc / (24.6 * locP1 * Y) * Math.sqrt(MW * T * Z / xT / Fgamma) : Qloc / (24.6 * locP1 * Y) * Math.sqrt(MW * T * Z / x);
        double valveOpening = effectiveKv / Kv * 100.0;
        if (valveOpening < 0.0) {
            valveOpening = 0.0;
        }
        if (valveOpening > 100.0) {
            valveOpening = 100.0;
        }
        return valveOpening;
    }

    public double calculateValveOpeningFromFlowRateGas(double Q, double Kv, double valveOpening, StreamInterface inletStream, StreamInterface outletStream) {
        return this.calculateValveOpeningFromFlowRateGas(Q, Kv, inletStream.getThermoSystem().getTemperature("K"), inletStream.getThermoSystem().getMolarMass("g/mol"), inletStream.getThermoSystem().getViscosity("kg/msec"), inletStream.getThermoSystem().getGamma2(), inletStream.getThermoSystem().getZ(), inletStream.getPressure("Pa"), outletStream.getPressure("Pa"), this.FL, this.FD, this.allowChoked);
    }

    public double findOutletPressureForFixedKvGas(double T, double MW, double gamma, double Z, double P1, double Q, double actualKv) {
        double P2_low = 1.0;
        double P2_high = P1 - 1.0E-4;
        double P2_mid = 0.5 * (P2_low + P2_high);
        double tolerance = 1.0E-6;
        int maxIter = 50;
        for (int i = 0; i < maxIter; ++i) {
            Map<String, Object> result = this.sizeControlValveGas(T, MW, gamma, Z, P1, P2_mid, Q, 100.0);
            double requiredKv = (Double)result.get("Kv");
            if (requiredKv < actualKv) {
                P2_low = P2_mid;
            } else {
                P2_high = P2_mid;
            }
            double oldMid = P2_mid;
            P2_mid = 0.5 * (P2_low + P2_high);
            if (P2_mid > 1.0E-9 && Math.abs(P2_mid - oldMid) / P2_mid < tolerance) break;
            if (i != maxIter - 1) continue;
        }
        return P2_mid;
    }

    public double findOutletPressureForFixedKvGas(double actualKv, StreamInterface inletStream) {
        return this.findOutletPressureForFixedKvGas(inletStream.getThermoSystem().getTemperature("K"), inletStream.getThermoSystem().getMolarMass("gr/mol"), inletStream.getThermoSystem().getGamma2(), inletStream.getThermoSystem().getZ(), inletStream.getPressure("Pa"), inletStream.getFlowRate("m3/sec"), actualKv);
    }

    boolean isChokedTurbulentL(double dP, double P1, double Psat, double FF, double FL) {
        return dP >= FL * FL * (P1 - FF * Psat);
    }

    boolean isChokedTurbulentG(double x, double Fgamma, double xT) {
        return x >= Fgamma * xT;
    }

    double ffCriticalPressureRatioL(double Psat, double Pc) {
        return 0.96 - 0.28 * Math.sqrt(Psat / Pc);
    }

    double Kv_to_Cv(double Kv) {
        return Kv * 1.156;
    }

    double Cv_to_Kv(double Cv) {
        return Cv / 1.156;
    }

    @Override
    public double findOutletPressureForFixedKv(double actualKv, StreamInterface inletStream) {
        if (inletStream.getThermoSystem().hasPhaseType(PhaseType.GAS)) {
            return this.findOutletPressureForFixedKvGas(actualKv, inletStream);
        }
        return this.findOutletPressureForFixedKvLiquid(actualKv, inletStream);
    }

    public static enum FluidType {
        LIQUID,
        GAS;

    }
}

