/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.mechanicaldesign.valve;

import java.awt.BorderLayout;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.process.costestimation.valve.ValveCostEstimate;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.process.equipment.valve.ValveInterface;
import neqsim.process.mechanicaldesign.MechanicalDesign;
import neqsim.process.mechanicaldesign.designstandards.ValveDesignStandard;
import neqsim.process.mechanicaldesign.valve.ControlValveSizing;
import neqsim.process.mechanicaldesign.valve.ControlValveSizingInterface;
import neqsim.process.mechanicaldesign.valve.ControlValveSizing_IEC_60534;
import neqsim.process.mechanicaldesign.valve.ControlValveSizing_IEC_60534_full;
import neqsim.process.mechanicaldesign.valve.ControlValveSizing_simple;
import neqsim.process.mechanicaldesign.valve.LinearCharacteristic;
import neqsim.process.mechanicaldesign.valve.ValveCharacteristic;
import neqsim.util.ExcludeFromJacocoGeneratedReport;

public class ValveMechanicalDesign
extends MechanicalDesign {
    private static final long serialVersionUID = 1000L;
    double valveCvMax = 1.0;
    double valveWeight = 100.0;
    double inletPressure = 0.0;
    double outletPressure = 0.0;
    double dP = 0.0;
    double diameter = 0.2032;
    double diameterInlet = 0.2032;
    double diameterOutlet = 0.2032;
    double xT = 0.137;
    double FL = 1.0;
    double FD = 1.0;
    boolean allowChoked = false;
    boolean allowLaminar = true;
    boolean fullOutput = true;
    String valveSizingStandard = "default";
    String valveCharacterization = "linear";
    ValveCharacteristic valveCharacterizationMethod = null;
    ControlValveSizingInterface valveSizingMethod = null;

    public String getValveCharacterization() {
        return this.valveCharacterization;
    }

    public ValveCharacteristic getValveCharacterizationMethod() {
        return this.valveCharacterizationMethod;
    }

    public void setValveCharacterizationMethod(ValveCharacteristic valveCharacterizationMethod) {
        this.valveCharacterizationMethod = valveCharacterizationMethod;
    }

    public String getValveSizingStandard() {
        return this.valveSizingStandard;
    }

    public void setValveSizingStandard(String valveSizingStandard) {
        this.valveSizingStandard = valveSizingStandard;
        this.valveSizingMethod = valveSizingStandard.equals("IEC 60534") ? new ControlValveSizing_IEC_60534(this) : (valveSizingStandard.equals("IEC 60534 full") ? new ControlValveSizing_IEC_60534_full(this) : (valveSizingStandard.equals("prod choke") ? new ControlValveSizing_simple(this) : new ControlValveSizing(this)));
    }

    public void setValveCharacterization(String valveCharacterization) {
        this.valveCharacterization = valveCharacterization;
        this.valveCharacterizationMethod = valveCharacterization.equals("linear") ? new LinearCharacteristic() : (valveCharacterization.equals("equal percentage") ? new LinearCharacteristic() : new LinearCharacteristic());
    }

    public ValveMechanicalDesign(ProcessEquipmentInterface equipment) {
        super(equipment);
        this.costEstimate = new ValveCostEstimate(this);
        this.valveSizingMethod = new ControlValveSizing(this);
        this.valveCharacterizationMethod = new LinearCharacteristic();
    }

    public ControlValveSizingInterface getValveSizingMethod() {
        return this.valveSizingMethod;
    }

    public Map<String, Object> calcValveSize() {
        HashMap<String, Object> result = this.fullOutput ? new HashMap() : null;
        result = this.valveSizingMethod.calcValveSize(((ValveInterface)this.getProcessEquipment()).getPercentValveOpening());
        return result;
    }

    @Override
    public void readDesignSpecifications() {
        super.readDesignSpecifications();
        if (this.getDesignStandard().containsKey("valve design codes")) {
            System.out.println("valve code standard: " + this.getDesignStandard().get("valve design codes").getStandardName());
            this.valveCvMax = ((ValveDesignStandard)this.getDesignStandard().get("valve design codes")).getValveCvMax();
        } else {
            System.out.println("no valve code standard specified......using default");
        }
    }

    @Override
    public void calcDesign() {
        super.calcDesign();
        ThrottlingValve valve1 = (ThrottlingValve)this.getProcessEquipment();
        this.inletPressure = valve1.getInletPressure();
        this.outletPressure = valve1.getOutletPressure();
        this.dP = this.inletPressure - this.outletPressure;
        Map<String, Object> result = this.calcValveSize();
        this.valveCvMax = (Double)result.get("Cv");
        this.valveWeight = this.valveCvMax * 100.0;
        this.setWeightTotal(this.valveWeight);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResults() {
        JFrame dialog = new JFrame("Unit design " + this.getProcessEquipment().getName());
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Object[] names = new String[]{"Name", "Value", "Unit"};
        Object[][] table = new String[16][3];
        table[1][0] = "Valve weight [kg]";
        table[1][1] = Double.toString(this.valveWeight);
        table[1][2] = "kg";
        table[2][0] = "Valve Cv";
        table[2][1] = Double.toString(this.valveCvMax);
        table[2][2] = "-";
        table[3][0] = "Inlet pressure [bar]";
        table[3][1] = Double.toString(this.inletPressure);
        table[3][2] = "bar";
        table[4][0] = "outlet pressure [bar]";
        table[4][1] = Double.toString(this.outletPressure);
        table[4][2] = "bar";
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.setSize(800, 600);
        dialog.setVisible(true);
    }
}

