/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.processmodel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;

public class ProcessLoader {
    public static void loadProcessFromYaml(File yamlFile, String yamlString, ProcessSystem process) throws Exception {
        Map data;
        ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
        if (yamlFile != null) {
            data = mapper.readValue(yamlFile, Map.class);
        } else if (yamlString != null) {
            data = mapper.readValue(yamlString, Map.class);
        } else {
            throw new IllegalArgumentException("Either yamlFile or yamlString must be provided");
        }
        List steps = (List)data.get("process");
        for (Map step : steps) {
            String unitType = (String)step.get("unit");
            Map properties = (Map)step.get("properties");
            Object unit = process.addUnit(unitType);
            if (properties == null) continue;
            for (Map.Entry entry : properties.entrySet()) {
                ProcessLoader.setProperty(unit, (String)entry.getKey(), entry.getValue());
            }
        }
    }

    public static void loadProcessFromYaml(File yamlFile, ProcessSystem process) throws Exception {
        ProcessLoader.loadProcessFromYaml(yamlFile, null, process);
    }

    public static void loadProcessFromYaml(String yamlString, ProcessSystem process) throws Exception {
        ProcessLoader.loadProcessFromYaml(null, yamlString, process);
    }

    private static void setProperty(ProcessEquipmentInterface unit, String property, Object value) {
        try {
            String setterName = "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
            if (value instanceof List) {
                List list = (List)value;
                Method method = unit.getClass().getMethod(setterName, Double.TYPE, String.class);
                method.invoke((Object)unit, ((Number)list.get(0)).doubleValue(), list.get(1));
            } else if (value instanceof Map && property.equalsIgnoreCase("fluid")) {
                SystemSrkEos fluid = new SystemSrkEos();
                Map components = (Map)value;
                for (Map.Entry comp : components.entrySet()) {
                    fluid.addComponent((String)comp.getKey(), (double)((Double)comp.getValue()));
                }
                Method method = unit.getClass().getMethod("setFluid", SystemInterface.class);
                method.invoke((Object)unit, fluid);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

