/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.processmodel;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.process.util.report.Report;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessModel
implements Runnable {
    static Logger logger = LogManager.getLogger(ProcessModel.class);
    private Map<String, ProcessSystem> processes = new LinkedHashMap<String, ProcessSystem>();
    private boolean runStep = false;
    private int maxIterations = 50;

    public boolean isRunStep() {
        return this.runStep;
    }

    public void setRunStep(boolean runStep) {
        this.runStep = runStep;
    }

    public boolean add(String name, ProcessSystem process) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be null or empty");
        }
        if (process == null) {
            throw new IllegalArgumentException("Process cannot be null");
        }
        if (this.processes.containsKey(name)) {
            throw new IllegalArgumentException("A process with the given name already exists");
        }
        process.setName(name);
        this.processes.put(name, process);
        return true;
    }

    public ProcessSystem get(String name) {
        return this.processes.get(name);
    }

    public boolean remove(String name) {
        return this.processes.remove(name) != null;
    }

    @Override
    public void run() {
        if (this.runStep) {
            for (ProcessSystem process : this.processes.values()) {
                try {
                    if (Thread.currentThread().isInterrupted()) {
                        logger.debug("Thread was interrupted, exiting run()...");
                        return;
                    }
                    process.run_step();
                }
                catch (Exception e) {
                    System.err.println("Error running process step: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        } else {
            for (int iterations = 0; !Thread.currentThread().isInterrupted() && !this.isFinished() && iterations < this.maxIterations; ++iterations) {
                for (ProcessSystem process : this.processes.values()) {
                    if (Thread.currentThread().isInterrupted()) {
                        logger.debug("Thread was interrupted, exiting run()...");
                        return;
                    }
                    try {
                        process.run();
                    }
                    catch (Exception e) {
                        System.err.println("Error running process: " + e.getMessage());
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public Thread runAsThread() {
        Thread processThread = new Thread(this);
        processThread.start();
        return processThread;
    }

    public boolean isFinished() {
        for (ProcessSystem process : this.processes.values()) {
            if (process.solved()) continue;
            return false;
        }
        return true;
    }

    public void runStep() {
        for (ProcessSystem process : this.processes.values()) {
            try {
                if (Thread.currentThread().isInterrupted()) {
                    logger.debug("Thread was interrupted, exiting run()...");
                    return;
                }
                process.run_step();
            }
            catch (Exception e) {
                System.err.println("Error in runStep: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public Map<String, Thread> getThreads() {
        LinkedHashMap<String, Thread> threads = new LinkedHashMap<String, Thread>();
        try {
            for (ProcessSystem process : this.processes.values()) {
                Thread thread = new Thread(process);
                thread.setName(process.getName() + " thread");
                threads.put(process.getName(), thread);
            }
        }
        catch (Exception ex) {
            logger.debug(ex.getMessage(), (Throwable)ex);
        }
        return threads;
    }

    public Collection<ProcessSystem> getAllProcesses() {
        return this.processes.values();
    }

    public String getReport_json() {
        return new Report(this).generateJsonReport();
    }
}

