/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.processmodel;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import neqsim.process.SimulationBaseClass;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.equipment.util.Recycle;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.process.util.report.Report;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProcessModule
extends SimulationBaseClass {
    private static final long serialVersionUID = 1000L;
    private static final Logger logger = LogManager.getLogger(ProcessModule.class);
    private int unitIndex = 0;
    private final List<ProcessEquipmentInterface> recycleModules = new ArrayList<ProcessEquipmentInterface>();
    private List<ProcessSystem> addedUnitOperations = new ArrayList<ProcessSystem>();
    private List<Integer> operationsIndex = new ArrayList<Integer>();
    private List<ProcessModule> addedModules = new ArrayList<ProcessModule>();
    private List<Integer> modulesIndex = new ArrayList<Integer>();
    private boolean solved = false;

    public ProcessModule(String name) {
        super(name);
    }

    public void add(ProcessSystem processSystem) {
        this.addedUnitOperations.add(processSystem);
        this.operationsIndex.add(this.unitIndex++);
    }

    public void add(ProcessModule module) {
        this.addedModules.add(module);
        this.modulesIndex.add(this.unitIndex++);
    }

    public List<ProcessSystem> getAddedUnitOperations() {
        return this.addedUnitOperations;
    }

    public List<Integer> getOperationsIndex() {
        return this.operationsIndex;
    }

    public List<ProcessModule> getAddedModules() {
        return this.addedModules;
    }

    public List<Integer> getModulesIndex() {
        return this.modulesIndex;
    }

    @Override
    public void run(UUID id) {
        logger.info("Running module " + this.getName());
        this.checkModulesRecycles();
        int iteration = 0;
        do {
            for (int i = 0; i < this.unitIndex; ++i) {
                int index;
                if (this.operationsIndex.contains(i)) {
                    index = this.operationsIndex.indexOf(i);
                    for (ProcessEquipmentInterface unitOperation : this.addedUnitOperations.get(index).getUnitOperations()) {
                        if (iteration != 0 && !unitOperation.needRecalculation()) continue;
                        unitOperation.run(id);
                    }
                    continue;
                }
                if (!this.modulesIndex.contains(i)) continue;
                index = this.modulesIndex.indexOf(i);
                this.addedModules.get(index).run(id);
            }
            logger.info("Iteration : " + ++iteration + "  module : " + this.getName() + " ");
        } while (!this.recyclesSolved() && iteration <= 100);
        logger.info("Finished running module " + this.getName());
        this.solved = true;
    }

    public void checkModulesRecycles() {
        for (ProcessSystem operation : this.addedUnitOperations) {
            for (ProcessEquipmentInterface unitOperation : operation.getUnitOperations()) {
                if (!(unitOperation instanceof Recycle)) continue;
                this.recycleModules.add(unitOperation);
            }
        }
    }

    public boolean recyclesSolved() {
        for (ProcessEquipmentInterface recycle : this.recycleModules) {
            if (recycle.solved()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean solved() {
        return this.solved;
    }

    public Thread runAsThread() {
        Thread processThread = new Thread(this);
        processThread.start();
        return processThread;
    }

    public Object getUnit(String name) {
        Object unit;
        for (ProcessSystem processSystem : this.addedUnitOperations) {
            unit = processSystem.getUnit(name);
            if (unit == null) continue;
            return unit;
        }
        for (ProcessModule processModule : this.addedModules) {
            unit = processModule.getUnit(name);
            if (unit == null) continue;
            return unit;
        }
        return null;
    }

    public Object getMeasurementDevice(String name) {
        Object unit;
        for (ProcessSystem processSystem : this.addedUnitOperations) {
            unit = processSystem.getMeasurementDevice(name);
            if (unit == null) continue;
            return unit;
        }
        for (ProcessModule processModule : this.addedModules) {
            unit = processModule.getMeasurementDevice(name);
            if (unit == null) continue;
            return unit;
        }
        return null;
    }

    public ProcessModule copy() {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(this);
            out.flush();
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            return (ProcessModule)in.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy ProcessModule", e);
        }
    }

    public ArrayList<String[]> getReport() {
        return null;
    }

    @Override
    public String getReport_json() {
        return new Report(this).generateJsonReport();
    }

    @Override
    public void run_step(UUID id) {
        this.run(id);
    }
}

