/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.processmodel.processmodules;

import java.util.UUID;
import neqsim.process.equipment.compressor.Compressor;
import neqsim.process.equipment.compressor.CompressorInterface;
import neqsim.process.equipment.heatexchanger.Cooler;
import neqsim.process.equipment.heatexchanger.Heater;
import neqsim.process.equipment.stream.Stream;
import neqsim.process.equipment.stream.StreamInterface;
import neqsim.process.equipment.valve.ThrottlingValve;
import neqsim.process.processmodel.ProcessModuleBaseClass;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.ExcludeFromJacocoGeneratedReport;

public class PropaneCoolingModule
extends ProcessModuleBaseClass {
    private static final long serialVersionUID = 1000L;
    StreamInterface refrigerantStream;
    private double condenserTemperature = 303.15;
    private double vaporizerTemperature = 233.14999999999998;

    public PropaneCoolingModule(String name) {
        super(name);
    }

    public void setCondenserTemperature(double condenserTemperature) {
        this.condenserTemperature = condenserTemperature;
    }

    public void setVaporizerTemperature(double vaporizerTemperature) {
        this.vaporizerTemperature = vaporizerTemperature;
    }

    @Override
    public void addInputStream(String streamName, StreamInterface stream) {
        if (streamName.equals("refrigerant")) {
            this.refrigerantStream = stream;
        }
    }

    @Override
    public StreamInterface getOutputStream(String streamName) {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        if (streamName.equals("refrigerant")) {
            return this.refrigerantStream;
        }
        if (streamName.equals("refrigerant...")) {
            return this.refrigerantStream;
        }
        return null;
    }

    @Override
    public void initializeModule() {
        this.isInitializedModule = true;
        this.refrigerantStream.getThermoSystem().setTemperature(this.condenserTemperature);
        ((Stream)this.refrigerantStream).setSpecification("bubT");
        UUID id = UUID.randomUUID();
        this.refrigerantStream.run(id);
        ThrottlingValve JTvalve = new ThrottlingValve("JTvalve", this.refrigerantStream);
        Cooler cooler = new Cooler("propane evaporator", JTvalve.getOutletStream());
        cooler.setPressureDrop(0.35);
        cooler.setSpecification("out stream");
        Stream stream_2 = new Stream("stream_2", cooler.getOutletStream());
        stream_2.setSpecification("dewT");
        stream_2.getThermoSystem().setTemperature(this.vaporizerTemperature);
        stream_2.run(id);
        cooler.setOutletStream(stream_2);
        JTvalve.setOutletPressure(stream_2.getPressure());
        Compressor compressor1 = new Compressor("propane compressor", stream_2);
        compressor1.setOutletPressure(this.refrigerantStream.getPressure());
        Heater condenser = new Heater("propane condenser", compressor1.getOutletStream());
        condenser.setPressureDrop(0.07);
        condenser.setSpecification("out stream");
        condenser.setOutletStream(this.refrigerantStream);
        System.out.println("adding operations....");
        this.getOperations().add(this.refrigerantStream);
        this.getOperations().add(JTvalve);
        this.getOperations().add(cooler);
        this.getOperations().add(stream_2);
        this.getOperations().add(compressor1);
        this.getOperations().add(condenser);
        System.out.println("finished adding operations....");
    }

    @Override
    public void run(UUID id) {
        if (!this.isInitializedModule) {
            this.initializeModule();
        }
        System.out.println("running model....");
        this.getOperations().run(id);
        this.setCalculationIdentifier(id);
    }

    @Override
    public void initializeStreams() {
        this.isInitializedStreams = true;
    }

    @Override
    public void calcDesign() {
    }

    @Override
    public void setDesign() {
    }

    @Override
    public void setSpecification(String specificationName, double value) {
        if (specificationName.equals("vaporizerTemperature")) {
            this.setVaporizerTemperature(value);
        } else if (specificationName.equals("condenserTemperature")) {
            this.setCondenserTemperature(value);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(253.14999999999998, 1.0);
        testSystem.addComponent("propane", 0.3);
        testSystem.createDatabase(true);
        Stream porpane = new Stream("porpane", testSystem);
        PropaneCoolingModule propaneModule = new PropaneCoolingModule("propaneModule");
        propaneModule.setCondenserTemperature(303.15);
        propaneModule.setVaporizerTemperature(233.14999999999998);
        propaneModule.addInputStream("refrigerant", porpane);
        propaneModule.run();
        double compressorWork = ((CompressorInterface)propaneModule.getOperations().getUnit("propane compressor")).getEnergy();
        double evaporatorDuty = ((Cooler)propaneModule.getOperations().getUnit("propane evaporator")).getEnergyInput();
        double evaporatorPressure = ((Cooler)propaneModule.getOperations().getUnit("propane evaporator")).getOutletStream().getPressure();
        double evaporatorTemperature = ((Cooler)propaneModule.getOperations().getUnit("propane evaporator")).getOutletStream().getTemperature();
        double condenserDuty = ((Heater)propaneModule.getOperations().getUnit("propane condenser")).getEnergyInput();
        double condenserPressure = ((Heater)propaneModule.getOperations().getUnit("propane condenser")).getOutletStream().getPressure();
        double condenserTemperature = ((Heater)propaneModule.getOperations().getUnit("propane condenser")).getOutletStream().getTemperature();
        System.out.println("Compressor work " + compressorWork + " W");
        System.out.println("evaporator duty " + evaporatorDuty + " W");
        System.out.println("evaporator temperature " + (evaporatorTemperature - 273.15) + " C");
        System.out.println("evaporator pressure " + evaporatorPressure + " bara");
        System.out.println("condenser duty " + condenserDuty + " W");
        System.out.println("condenser temperature " + (condenserTemperature - 273.15) + " C");
        System.out.println("condenser pressure " + condenserPressure + " bara");
    }
}

