/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.util.monitor;

import java.util.HashMap;
import neqsim.process.equipment.manifold.Manifold;
import neqsim.process.util.monitor.BaseResponse;
import neqsim.process.util.monitor.Value;
import neqsim.util.unit.Units;

public class ManifoldResponse
extends BaseResponse {
    public HashMap<String, Value> data = new HashMap();

    public ManifoldResponse(Manifold manifold) {
        super(manifold);
        this.data.put("mixed mass flow", new Value(Double.toString(manifold.getMixedStream().getFlowRate(Units.getSymbol("mass flow"))), Units.getSymbol("mass flow")));
        this.data.put("mixed temperature", new Value(Double.toString(manifold.getMixedStream().getTemperature(Units.getSymbol("temperature"))), Units.getSymbol("temperature")));
        this.data.put("mixed pressure", new Value(Double.toString(manifold.getMixedStream().getPressure(Units.getSymbol("pressure"))), Units.getSymbol("pressure")));
        for (int i = 0; i < manifold.getNumberOfOutputStreams(); ++i) {
            this.data.put("split mass flow " + (i + 1), new Value(Double.toString(manifold.getSplitStream(i).getFlowRate(Units.getSymbol("mass flow"))), Units.getSymbol("mass flow")));
        }
    }
}

