/*
 * Decompiled with CFR 0.152.
 */
package neqsim.process.util.report;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import neqsim.process.equipment.ProcessEquipmentBaseClass;
import neqsim.process.equipment.ProcessEquipmentInterface;
import neqsim.process.processmodel.ProcessModel;
import neqsim.process.processmodel.ProcessModule;
import neqsim.process.processmodel.ProcessModuleBaseClass;
import neqsim.process.processmodel.ProcessSystem;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Report {
    static Logger logger = LogManager.getLogger(Report.class);
    ProcessSystem process = null;
    ProcessModel processmodel = null;
    ProcessEquipmentBaseClass processEquipment = null;
    SystemInterface fluid = null;

    public Report(ProcessSystem process) {
        this.process = process;
    }

    public Report(ProcessModel processmodel) {
        this.processmodel = processmodel;
    }

    public Report(SystemInterface fluid) {
        this.fluid = fluid;
    }

    public Report(ProcessEquipmentBaseClass processEquipmentBaseClass) {
        this.processEquipment = processEquipmentBaseClass;
    }

    public Report(ProcessModule processModule) {
    }

    public Report(ProcessModuleBaseClass processModuleBaseClass) {
    }

    public String generateJsonReport() {
        HashMap<String, String> json_reports = new HashMap<String, String>();
        if (this.process != null) {
            for (ProcessEquipmentInterface processEquipmentInterface : this.process.getUnitOperations()) {
                json_reports.put(processEquipmentInterface.getName(), processEquipmentInterface.toJson());
            }
        }
        if (this.processEquipment != null) {
            json_reports.put(this.processEquipment.getName(), this.processEquipment.toJson());
        }
        if (this.fluid != null) {
            json_reports.put(this.fluid.getFluidName(), this.fluid.toJson());
        }
        if (this.processmodel != null) {
            for (ProcessSystem processSystem : this.processmodel.getAllProcesses()) {
                JsonObject jsonObject = new JsonObject();
                for (ProcessEquipmentInterface unit : processSystem.getUnitOperations()) {
                    try {
                        String unitName;
                        String unitJson = unit.toJson();
                        String string = unitName = unit.getName() != null ? unit.getName() : "UnnamedUnit";
                        if (unitJson != null && !unitJson.isEmpty()) {
                            try {
                                JsonElement parsedJson = JsonParser.parseString(unitJson);
                                jsonObject.add(unitName, parsedJson);
                            }
                            catch (Exception parseEx) {
                                logger.error("Failed to parse JSON for unit: " + unitName, (Throwable)parseEx);
                            }
                            continue;
                        }
                        logger.warn("unit.toJson() returned null or empty for unit: " + unitName);
                    }
                    catch (Exception unitEx) {
                        logger.error("Error handling unit: " + unit.getName(), (Throwable)unitEx);
                    }
                }
                if (jsonObject.size() == 0) {
                    logger.warn("processJson is empty for process: " + processSystem.getName());
                }
                try {
                    Gson prettyGson = new GsonBuilder().serializeSpecialFloatingPointValues().setPrettyPrinting().create();
                    String jsonString = prettyGson.toJson(jsonObject);
                    json_reports.put(processSystem.getName(), jsonString);
                }
                catch (Exception ex) {
                    logger.error("Error converting final JSON object to string for process: " + processSystem.getName(), (Throwable)ex);
                }
            }
        }
        JsonObject finalJsonObject = new JsonObject();
        for (Map.Entry entry : json_reports.entrySet()) {
            try {
                String s;
                String string = s = entry.getValue() instanceof String ? (String)entry.getValue() : null;
                if (s == null) continue;
                JsonObject nestedJsonObject = JsonParser.parseString(s).getAsJsonObject();
                finalJsonObject.add((String)entry.getKey(), nestedJsonObject);
            }
            catch (Exception ex) {
                logger.error(ex.getMessage());
            }
        }
        Gson gson = new GsonBuilder().serializeSpecialFloatingPointValues().setPrettyPrinting().create();
        return gson.toJson(finalJsonObject);
    }
}

