/*
 * Decompiled with CFR 0.152.
 */
package neqsim.pvtsimulation.modeltuning;

import neqsim.pvtsimulation.modeltuning.BaseTuningClass;
import neqsim.pvtsimulation.simulation.SimulationInterface;

public class TuneToSaturation
extends BaseTuningClass {
    public TuneToSaturation(SimulationInterface simulation) {
        super(simulation);
    }

    @Override
    public void run() {
        double maxError = 0.01;
        int plusNumber = 0;
        double plusMolarMass = 0.0;
        this.getSimulation().getThermoSystem().setTemperature(this.saturationTemperature);
        this.getSimulation().getThermoSystem().setPressure(this.saturationPressure - 50.0);
        for (int i = 0; i < this.getSimulation().getThermoSystem().getPhase(0).getNumberOfComponents(); ++i) {
            if (!this.getSimulation().getThermoSystem().getPhase(0).getComponent(i).isIsPlusFraction()) continue;
            plusNumber = i;
            plusMolarMass = this.getSimulation().getThermoSystem().getPhase(0).getComponent(plusNumber).getMolarMass();
        }
        this.getSimulation().getThermoSystem().getCharacterization().characterisePlusFraction();
        this.getSimulation().getThermoSystem().createDatabase(true);
        this.getSimulation().getThermoSystem().setMixingRule(this.getSimulation().getThermoSystem().getMixingRule());
        this.getSimulation().getThermoSystem().init(0);
        this.getSimulation().getThermoSystem().init(1);
        this.getSimulation().run();
        double dp = this.getSimulation().getThermoSystem().getPressure() - this.saturationPressure;
        if (Math.abs(dp) < maxError) {
            return;
        }
        double dpOld = 0.0;
        int iter = 0;
        double sign = 1.0;
        while (Math.abs(dp) > 0.001 && iter < 50) {
            ++iter;
            dp = this.getSimulation().getThermoSystem().getPressure() - this.saturationPressure;
            plusMolarMass -= sign * dp / 1000.0;
            this.getSimulation().setThermoSystem(this.getSimulation().getBaseThermoSystem().clone());
            this.getSimulation().getThermoSystem().resetCharacterisation();
            this.getSimulation().getThermoSystem().createDatabase(true);
            this.getSimulation().getThermoSystem().setMixingRule(this.getSimulation().getThermoSystem().getMixingRule());
            this.getSimulation().getThermoSystem().setTemperature(this.saturationTemperature);
            this.getSimulation().getThermoSystem().setPressure(this.saturationPressure);
            for (int i = 0; i < this.getSimulation().getThermoSystem().getMaxNumberOfPhases(); ++i) {
                this.getSimulation().getThermoSystem().getPhase(i).getComponent(plusNumber).setMolarMass(plusMolarMass);
            }
            this.getSimulation().getThermoSystem().getCharacterization().characterisePlusFraction();
            this.getSimulation().getThermoSystem().createDatabase(true);
            this.getSimulation().getThermoSystem().setMixingRule(this.getSimulation().getThermoSystem().getMixingRule());
            this.getSimulation().run();
            if (Math.abs(dpOld) < Math.abs(dp)) {
                sign *= -1.0;
            }
            dpOld = dp;
            System.out.println("pressure " + this.getSimulation().getThermoSystem().getPressure() + "dp " + dp + " molarmass" + plusMolarMass);
        }
    }
}

