/*
 * Decompiled with CFR 0.152.
 */
package neqsim.pvtsimulation.util.parameterfitting;

import java.util.ArrayList;
import neqsim.pvtsimulation.util.parameterfitting.WaxFunction;
import neqsim.statistics.parameterfitting.SampleSet;
import neqsim.statistics.parameterfitting.SampleValue;
import neqsim.statistics.parameterfitting.nonlinearparameterfitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestWaxTuning {
    static Logger logger = LogManager.getLogger(TestWaxTuning.class);

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        try {
            System.out.println("adding....");
            boolean i = false;
            while (i < true) {
                WaxFunction function = new WaxFunction();
                double[] guess = new double[]{1.074, 6.584E-4, 0.1915};
                function.setInitialGuess(guess);
                SystemSrkEos tempSystem = new SystemSrkEos(293.15, 10.0);
                tempSystem.addComponent("methane", 67.42);
                tempSystem.addTBPfraction("C10", 10.8, 0.1353, 0.7864);
                tempSystem.addPlusFraction("C11", 12.58, 0.4562, 0.89398);
                tempSystem.getCharacterization().characterisePlusFraction();
                tempSystem.getWaxModel().addTBPWax();
                tempSystem.createDatabase(true);
                tempSystem.setMixingRule(2);
                tempSystem.addSolidComplexPhase("wax");
                tempSystem.setMultiphaseWaxCheck(true);
                tempSystem.init(0);
                tempSystem.init(1);
                double[] sample1 = new double[]{293.15};
                double waxContent = 2.0;
                double[] standardDeviation1 = new double[]{1.5};
                SampleValue sample = new SampleValue(waxContent, waxContent / 100.0, sample1, standardDeviation1);
                sample.setFunction(function);
                function.setInitialGuess(guess);
                sample.setThermodynamicSystem(tempSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception ex) {
            logger.error("database error", (Throwable)ex);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        LevenbergMarquardt optim = new LevenbergMarquardt();
        optim.setMaxNumberOfIterations(5);
        optim.setSampleSet(sampleSet);
        optim.displayCurveFit();
    }
}

