/*
 * Decompiled with CFR 0.152.
 */
package neqsim.pvtsimulation.util.parameterfitting;

import neqsim.statistics.parameterfitting.nonlinearparameterfitting.LevenbergMarquardtFunction;

public class WaxFunction
extends LevenbergMarquardtFunction {
    double molarMass = 0.0;

    public WaxFunction() {
        this.params = new double[3];
    }

    @Override
    public double calcValue(double[] dependentValues) {
        this.system.setTemperature(dependentValues[0]);
        this.thermoOps.TPflash();
        double waxFraction = 0.0;
        if (this.system.hasPhaseType("wax")) {
            waxFraction = this.system.getWtFraction(this.system.getPhaseNumberOfPhase("wax"));
        }
        return waxFraction * 100.0;
    }

    @Override
    public void setFittingParams(int i, double value) {
        this.params[i] = value;
        if (i < 3) {
            this.system.getWaxModel().setWaxParameter(i, this.params[i]);
        } else if (i == 3) {
            this.system.getWaxModel().setParameterWaxHeatOfFusion(i - 3, value);
        } else {
            this.system.getWaxModel().setParameterWaxTriplePointTemperature(i - 4, value);
        }
        this.system.getWaxModel().removeWax();
        this.system.getWaxModel().addTBPWax();
    }
}

