/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.gasquality;

import neqsim.standards.Standard;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BestPracticeHydrocarbonDewPoint
extends Standard {
    static Logger logger = LogManager.getLogger(BestPracticeHydrocarbonDewPoint.class);
    private static final long serialVersionUID = 1000L;
    String dewPointTemperatureUnit = "C";
    String pressureUnit = "bar";
    double dewPointTemperature = 273.0;
    double dewPointTemperatureSpec = -12.0;
    double specPressure = 50.0;
    double initTemperature = 253.14999999999998;
    SystemInterface thermoSystem = new SystemSrkEos(this.initTemperature, this.specPressure);
    ThermodynamicOperations thermoOps;

    public BestPracticeHydrocarbonDewPoint(SystemInterface thermoSystem) {
        super("StatoilBestPracticeHydrocarbonDewPoint", "hydrocarbon dew point calculation method");
        for (int i = 0; i < thermoSystem.getPhase(0).getNumberOfComponents(); ++i) {
            if (thermoSystem.getPhase(0).getComponent(i).getName().equals("water")) continue;
            this.thermoSystem.addComponent(thermoSystem.getPhase(0).getComponent(i).getName(), thermoSystem.getPhase(0).getComponent(i).getNumberOfmoles());
        }
        this.thermoSystem.setMixingRule(2);
        thermoSystem.init(0);
        thermoSystem.init(1);
        this.thermoOps = new ThermodynamicOperations(this.thermoSystem);
    }

    @Override
    public void calculate() {
        this.thermoSystem.setTemperature(this.initTemperature);
        this.thermoSystem.setPressure(this.specPressure);
        try {
            this.thermoOps.dewPointTemperatureFlash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.dewPointTemperature = this.thermoSystem.getTemperature() - 273.15;
    }

    @Override
    public double getValue(String returnParameter, String returnUnit) {
        if (returnParameter.equals("hydrocarbondewpointTemperature")) {
            return this.dewPointTemperature;
        }
        return this.dewPointTemperature;
    }

    @Override
    public double getValue(String returnParameter) {
        if (returnParameter.equals("hydrocarbondewpointTemperature")) {
            return this.dewPointTemperature;
        }
        if (returnParameter.equals("pressure")) {
            return this.thermoSystem.getPressure();
        }
        return this.dewPointTemperature;
    }

    @Override
    public String getUnit(String returnParameter) {
        if (returnParameter.equals("hydrocarbondewpointTemperature")) {
            return this.dewPointTemperatureUnit;
        }
        if (returnParameter.equals("pressureUnit")) {
            return this.pressureUnit;
        }
        return this.dewPointTemperatureUnit;
    }

    @Override
    public boolean isOnSpec() {
        return this.dewPointTemperature < this.getSalesContract().getWaterDewPointTemperature();
    }
}

