/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.characterization;

import Jama.Matrix;
import java.io.Serializable;
import neqsim.thermo.characterization.PlusFractionModel;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PedersenPlusModelSolver
implements Serializable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PedersenPlusModelSolver.class);
    int iter = 0;
    Matrix JacAB;
    Matrix JacCD;
    Matrix fvecAB;
    Matrix fvecCD;
    Matrix solAB;
    Matrix solCD;
    Matrix dx;
    int numberOfComponents = 0;
    PlusFractionModel.PedersenPlusModel characterizeClass;
    SystemInterface system = null;

    public PedersenPlusModelSolver() {
    }

    public PedersenPlusModelSolver(SystemInterface system, PlusFractionModel.PedersenPlusModel characterizeClass) {
        this.system = system;
        this.characterizeClass = characterizeClass;
        this.numberOfComponents = system.getPhase(0).getNumberOfComponents();
        this.JacAB = new Matrix(2, 2);
        this.fvecAB = new Matrix(2, 1);
        this.solAB = new Matrix(2, 1);
        this.solAB.set(0, 0, characterizeClass.getCoef(0));
        this.solAB.set(1, 0, characterizeClass.getCoef(1));
        this.JacCD = new Matrix(2, 2);
        this.fvecCD = new Matrix(2, 1);
        this.solCD = new Matrix(2, 1);
        this.solCD.set(0, 0, characterizeClass.getCoef(2));
        this.solCD.set(1, 0, characterizeClass.getCoef(3));
    }

    public void setfvecAB() {
        double zSum = 0.0;
        double mSum = 0.0;
        for (int i = this.characterizeClass.getFirstPlusFractionNumber(); i < this.characterizeClass.getLastPlusFractionNumber(); ++i) {
            double ztemp = Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
            double M = this.characterizeClass.PVTsimMolarMass[i - 6] / 1000.0;
            zSum += ztemp;
            mSum += ztemp * M;
        }
        this.fvecAB.set(0, 0, zSum - this.characterizeClass.getZPlus());
        this.fvecAB.set(1, 0, mSum / zSum - this.characterizeClass.getMPlus());
    }

    public void setJacAB() {
        int j;
        this.JacAB.timesEquals(0.0);
        double tempJ = 0.0;
        for (j = 0; j < 2; ++j) {
            double nTot = 0.0;
            double nTot2 = 0.0;
            for (int i = this.characterizeClass.getFirstPlusFractionNumber(); i < this.characterizeClass.getLastPlusFractionNumber(); ++i) {
                nTot += Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
                nTot2 += (double)i * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
            }
            if (j == 0) {
                tempJ = nTot;
            } else if (j == 1) {
                tempJ = nTot2;
            }
            this.JacAB.set(0, j, tempJ);
        }
        for (j = 0; j < 2; ++j) {
            double mTot1 = 0.0;
            double mTot2 = 0.0;
            double zSum2 = 0.0;
            double zSum = 0.0;
            double zSum3 = 0.0;
            for (int i = this.characterizeClass.getFirstPlusFractionNumber(); i < this.characterizeClass.getLastPlusFractionNumber(); ++i) {
                mTot1 += this.characterizeClass.PVTsimMolarMass[i - 6] / 1000.0 * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
                mTot2 += (double)i * (this.characterizeClass.PVTsimMolarMass[i - 6] / 1000.0) * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
                zSum2 += Math.pow(Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i), 2.0);
                zSum += Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
                zSum3 += (double)i * Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i);
            }
            if (j == 0) {
                tempJ = (mTot1 * zSum - mTot1 * zSum) / zSum2;
            } else if (j == 1) {
                tempJ = (mTot2 * zSum - mTot1 * zSum3) / zSum2;
            }
            this.JacAB.set(1, j, tempJ);
        }
    }

    public void setfvecCD() {
        double densTBO = this.characterizeClass.PVTsimDensities[this.characterizeClass.getFirstPlusFractionNumber() - 6];
        this.fvecCD.set(0, 0, this.characterizeClass.getCoef(2) + this.characterizeClass.getCoef(3) * Math.log(this.characterizeClass.getFirstPlusFractionNumber() - 1) - densTBO);
        double temp = 0.0;
        double temp2 = 0.0;
        for (int i = this.characterizeClass.getFirstPlusFractionNumber(); i < this.characterizeClass.getLastPlusFractionNumber(); ++i) {
            temp += Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i) * this.characterizeClass.PVTsimMolarMass[i - 6];
            temp2 += Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i) * this.characterizeClass.PVTsimMolarMass[i - 6] / (this.characterizeClass.getCoef(2) + this.characterizeClass.getCoef(3) * Math.log(i));
        }
        this.fvecCD.set(1, 0, temp / temp2 - this.characterizeClass.getDensPlus());
    }

    public void setJacCD() {
        this.JacCD.timesEquals(0.0);
        this.JacCD.set(0, 0, 1.0);
        this.JacCD.set(0, 1, Math.log(this.characterizeClass.getFirstPlusFractionNumber() - 1));
        double temp = 0.0;
        double temp2 = 0.0;
        double temp3 = 0.0;
        for (int i = this.characterizeClass.getFirstPlusFractionNumber(); i < this.characterizeClass.getLastPlusFractionNumber(); ++i) {
            temp += Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i) * this.characterizeClass.PVTsimMolarMass[i - 6];
            temp2 += Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i) * this.characterizeClass.PVTsimMolarMass[i - 6] / (this.characterizeClass.getCoef(2) + this.characterizeClass.getCoef(3) * Math.log(i));
            temp3 -= Math.exp(this.characterizeClass.getCoef(0) + this.characterizeClass.getCoef(1) * (double)i) * this.characterizeClass.PVTsimMolarMass[i - 6] / Math.pow(this.characterizeClass.getCoef(2) + this.characterizeClass.getCoef(3) * Math.log(i), 2.0);
        }
        double dAdC = temp3 * 1.0;
        double ans = temp / (temp2 * temp2) * dAdC;
        this.JacCD.set(1, 0, ans);
    }

    public void solve() {
        this.iter = 0;
        do {
            ++this.iter;
            this.setfvecAB();
            this.setJacAB();
            this.dx = this.JacAB.solve(this.fvecAB);
            this.solAB.minusEquals(this.dx.times((double)this.iter / ((double)this.iter + 50.0)));
            this.characterizeClass.setCoefs(this.solAB.transpose().copy().getArray()[0]);
        } while ((this.fvecAB.norm2() > 1.0E-6 || this.iter < 3) && this.iter < 200);
        this.iter = 0;
        do {
            ++this.iter;
            this.setfvecCD();
            this.setJacCD();
            this.dx = this.JacCD.solve(this.fvecCD);
            this.solCD.minusEquals(this.dx.times((double)this.iter / ((double)this.iter + 5.0)));
            this.characterizeClass.setCoefs(this.solCD.transpose().copy().getArray()[0][0], 2);
            this.characterizeClass.setCoefs(this.solCD.transpose().copy().getArray()[0][1], 3);
        } while ((this.fvecCD.norm2() > 1.0E-6 || this.iter < 3) && this.iter < 200);
    }
}

