/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentEos;
import neqsim.thermo.phase.PhaseInterface;

public class ComponentGERG2008Eos
extends ComponentEos {
    private static final long serialVersionUID = 1000L;

    public ComponentGERG2008Eos(String name, double moles, double molesInPhase, int compIndex) {
        super(name, moles, molesInPhase, compIndex);
    }

    public ComponentGERG2008Eos(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentGERG2008Eos clone() {
        ComponentGERG2008Eos clonedComponent = null;
        try {
            clonedComponent = (ComponentGERG2008Eos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedComponent;
    }

    @Override
    public double getVolumeCorrection() {
        return 0.0;
    }

    @Override
    public void Finit(PhaseInterface phase, double T, double p, double totalNumberOfMoles, double beta, int numberOfComponents, int initType) {
        super.Finit(phase, T, p, totalNumberOfMoles, beta, numberOfComponents, initType);
        if (initType == 3) {
            double phi = this.fugcoef(phase);
            phase.getComponent(this.getComponentNumber()).setFugacityCoefficient(phi);
        }
    }

    @Override
    public double calca() {
        return 0.0;
    }

    @Override
    public double calcb() {
        return 0.0;
    }

    @Override
    public double alpha(double temperature) {
        return 1.0;
    }

    @Override
    public double diffaT(double temperature) {
        return 1.0;
    }

    @Override
    public double diffdiffaT(double temperature) {
        return 1.0;
    }

    @Override
    public double dFdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return 0.0;
    }

    @Override
    public double dFdNdN(int i, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return 0.0;
    }

    @Override
    public double dFdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return 0.0;
    }

    @Override
    public double dFdNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return 0.0;
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        double temperature = phase.getTemperature();
        double pressure = phase.getPressure();
        double logFugacityCoefficient = this.dFdN(phase, phase.getNumberOfComponents(), temperature, pressure) - Math.log(phase.getZ());
        double fugacityCoefficient = Math.exp(logFugacityCoefficient);
        return fugacityCoefficient;
    }
}

