/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.thermo.atomelement.UNIFACgroup;
import neqsim.thermo.component.ComponentGEUniquac;
import neqsim.thermo.phase.PhaseGEUnifac;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentGEUnifac
extends ComponentGEUniquac {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ComponentGEUnifac.class);
    ArrayList<UNIFACgroup> unifacGroups = new ArrayList();
    UNIFACgroup[] unifacGroupsArray = new UNIFACgroup[0];
    double[] lnGammakComp = null;
    double[] lnGammakMix = null;
    double Q = 0.0;
    double R = 0.0;
    int numberOfUnifacSubGroups = 133;

    public ComponentGEUnifac(String name, double moles, double molesInPhase, int compIndex) {
        super(name, moles, molesInPhase, compIndex);
        if (!this.getClass().equals(ComponentGEUnifac.class)) {
            return;
        }
        if (name.contains("_PC")) {
            double number = this.getMolarMass() / 0.014;
            int intNumb = (int)Math.round(number) - 2;
            this.unifacGroups.add(new UNIFACgroup(1, 2));
            this.unifacGroups.add(new UNIFACgroup(2, intNumb));
            logger.info("adding unifac pseudo.." + intNumb);
            return;
        }
        try (NeqSimDataBase database = new NeqSimDataBase();){
            ResultSet dataSet = null;
            try {
                dataSet = database.getResultSet("SELECT * FROM unifaccomp WHERE Name='" + name + "'");
                dataSet.next();
                dataSet.getClob("name");
            }
            catch (Exception ex) {
                dataSet.close();
                dataSet = database.getResultSet("SELECT * FROM unifaccomp WHERE Name='" + name + "'");
                dataSet.next();
            }
            for (int p = 1; p < this.numberOfUnifacSubGroups; ++p) {
                int temp = Integer.parseInt(dataSet.getString("sub" + Integer.toString(p)));
                if (temp <= 0) continue;
                this.unifacGroups.add(new UNIFACgroup(p, temp));
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void addUNIFACgroup(int p, int n) {
        this.unifacGroups.add(new UNIFACgroup(p, n));
        this.unifacGroupsArray = this.unifacGroups.toArray(this.unifacGroupsArray);
    }

    public double getQ() {
        double sum = 0.0;
        for (int i = 0; i < this.getNumberOfUNIFACgroups(); ++i) {
            sum += this.getUnifacGroup(i).getQ() * (double)this.getUnifacGroup(i).getN();
        }
        this.Q = sum;
        return sum;
    }

    public double getR() {
        double sum = 0.0;
        for (int i = 0; i < this.getNumberOfUNIFACgroups(); ++i) {
            sum += this.getUnifacGroup(i).getR() * (double)this.getUnifacGroup(i).getN();
        }
        this.R = sum;
        return sum;
    }

    @Override
    public double fugcoef(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        this.fugacityCoefficient = this.getGamma(phase, numberOfComponents, temperature, pressure, pt) * this.getAntoineVaporPressure(temperature) / pressure;
        return this.fugacityCoefficient;
    }

    public void calclnGammak(int k, PhaseInterface phase) {
        double sum1Comp = 0.0;
        double sum1Mix = 0.0;
        double sum3Comp = 0.0;
        double sum3Mix = 0.0;
        for (int i = 0; i < this.getNumberOfUNIFACgroups(); ++i) {
            sum1Comp += this.getUnifacGroup(i).getQComp() * Math.exp(-1.0 / phase.getTemperature() * ((PhaseGEUnifac)phase).getAij(this.getUnifacGroup(i).getGroupIndex(), this.getUnifacGroup(k).getGroupIndex()));
            sum1Mix += this.getUnifacGroup(i).getQMix() * Math.exp(-1.0 / phase.getTemperature() * ((PhaseGEUnifac)phase).getAij(this.getUnifacGroup(i).getGroupIndex(), this.getUnifacGroup(k).getGroupIndex()));
            double sum2Comp = 0.0;
            double sum2Mix = 0.0;
            for (int j = 0; j < this.getNumberOfUNIFACgroups(); ++j) {
                sum2Comp += this.getUnifacGroup(j).getQComp() * Math.exp(-1.0 / phase.getTemperature() * ((PhaseGEUnifac)phase).getAij(this.getUnifacGroup(j).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex()));
                sum2Mix += this.getUnifacGroup(j).getQMix() * Math.exp(-1.0 / phase.getTemperature() * ((PhaseGEUnifac)phase).getAij(this.getUnifacGroup(j).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex()));
            }
            sum3Comp += this.getUnifacGroup(i).getQComp() * Math.exp(-1.0 / phase.getTemperature() * ((PhaseGEUnifac)phase).getAij(this.getUnifacGroup(k).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex())) / sum2Comp;
            sum3Mix += this.getUnifacGroup(i).getQMix() * Math.exp(-1.0 / phase.getTemperature() * ((PhaseGEUnifac)phase).getAij(this.getUnifacGroup(k).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex())) / sum2Mix;
        }
        double tempGammaComp = this.getUnifacGroup(k).getQ() * (1.0 - Math.log(sum1Comp) - sum3Comp);
        double tempGammaMix = this.getUnifacGroup(k).getQ() * (1.0 - Math.log(sum1Mix) - sum3Mix);
        this.getUnifacGroup(k).setLnGammaComp(tempGammaComp);
        this.getUnifacGroup(k).setLnGammaMix(tempGammaMix);
    }

    @Override
    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        int i;
        double lngammaCombinational = 0.0;
        double lngammaResidual = 0.0;
        this.dlngammadn = new double[numberOfComponents];
        this.dlngammadt = 0.0;
        ComponentGEUnifac[] compArray = (ComponentGEUnifac[])phase.getcomponentArray();
        double temp1 = 0.0;
        double temp2 = 0.0;
        double suml = 0.0;
        double V = 0.0;
        double F = 0.0;
        for (int j = 0; j < numberOfComponents; ++j) {
            temp1 += compArray[j].getx() * compArray[j].getR();
            temp2 += compArray[j].getQ() * compArray[j].getx();
            suml += compArray[j].getx() * (5.0 * (compArray[j].getR() - compArray[j].getQ()) - (compArray[j].getR() - 1.0));
        }
        V = this.getx() * this.getR() / temp1;
        F = this.getx() * this.getQ() / temp2;
        double li = 5.0 * (this.getR() - this.getQ()) - (this.getR() - 1.0);
        lngammaCombinational = Math.log(V / this.getx()) + 5.0 * this.getQ() * Math.log(F / V) + li - V / this.getx() * suml;
        for (i = 0; i < this.getNumberOfUNIFACgroups(); ++i) {
            this.getUnifacGroup(i).calcXComp(this);
            this.getUnifacGroup(i).calcQComp(this);
            this.getUnifacGroup(i).calcQMix((PhaseGEUnifac)phase);
        }
        this.lnGammakComp = new double[this.getNumberOfUNIFACgroups()];
        this.lnGammakMix = new double[this.getNumberOfUNIFACgroups()];
        for (i = 0; i < this.getNumberOfUNIFACgroups(); ++i) {
            this.calclnGammak(i, phase);
        }
        lngammaResidual = 0.0;
        for (i = 0; i < this.getNumberOfUNIFACgroups(); ++i) {
            lngammaResidual += (double)this.getUnifacGroup(i).getN() * (this.getUnifacGroup(i).getLnGammaMix() - this.getUnifacGroup(i).getLnGammaComp());
        }
        this.lngamma = lngammaResidual + lngammaCombinational;
        this.gamma = Math.exp(this.lngamma);
        return this.gamma;
    }

    @Override
    public double fugcoefDiffPres(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        this.dfugdp = (Math.log(this.fugcoef(phase, numberOfComponents, temperature, pressure + 0.01, pt)) - Math.log(this.fugcoef(phase, numberOfComponents, temperature, pressure - 0.01, pt))) / 0.02;
        return this.dfugdp;
    }

    @Override
    public double fugcoefDiffTemp(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        this.dfugdt = (Math.log(this.fugcoef(phase, numberOfComponents, temperature + 0.01, pressure, pt)) - Math.log(this.fugcoef(phase, numberOfComponents, temperature - 0.01, pressure, pt))) / 0.02;
        return this.dfugdt;
    }

    public ArrayList<UNIFACgroup> getUnifacGroups2() {
        return this.unifacGroups;
    }

    public UNIFACgroup[] getUnifacGroups() {
        return this.unifacGroupsArray;
    }

    public UNIFACgroup getUnifacGroup2(int i) {
        return this.unifacGroups.get(i);
    }

    public UNIFACgroup getUnifacGroup(int i) {
        return this.unifacGroupsArray[i];
    }

    public void setUnifacGroups(ArrayList<UNIFACgroup> unifacGroups) {
        this.unifacGroups = unifacGroups;
        this.unifacGroupsArray = unifacGroups.toArray(this.unifacGroupsArray);
    }

    public int getNumberOfUNIFACgroups() {
        return this.unifacGroups.size();
    }

    public void setQ(double Q) {
        this.Q = Q;
    }

    public void setR(double R) {
        this.R = R;
    }
}

