/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentGEUnifac;
import neqsim.thermo.phase.PhaseGEUnifac;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseType;

public class ComponentGEUnifacPSRK
extends ComponentGEUnifac {
    private static final long serialVersionUID = 1000L;
    double[][] bij = new double[1][1];
    double[][] cij = new double[1][1];

    public ComponentGEUnifacPSRK(String name, double moles, double molesInPhase, int compIndex) {
        super(name, moles, molesInPhase, compIndex);
    }

    public double calcaij(PhaseInterface phase, int i, int j) {
        return ((PhaseGEUnifac)phase).getAij(i, j) + ((PhaseGEUnifac)phase).getBij(i, j) * phase.getTemperature() + ((PhaseGEUnifac)phase).getCij(i, j) * Math.pow(phase.getTemperature(), 2.0);
    }

    public double calcaijdT(PhaseInterface phase, int i, int j) {
        return ((PhaseGEUnifac)phase).getBij(i, j) + 2.0 * ((PhaseGEUnifac)phase).getCij(i, j) * phase.getTemperature();
    }

    @Override
    public void calclnGammak(int k, PhaseInterface phase) {
        double sum1Comp = 0.0;
        double sum1Mix = 0.0;
        double sum3Comp = 0.0;
        double sum3Mix = 0.0;
        for (int i = 0; i < this.getNumberOfUNIFACgroups(); ++i) {
            sum1Comp += this.getUnifacGroup(i).getQComp() * Math.exp(-1.0 / phase.getTemperature() * this.calcaij(phase, this.getUnifacGroup(i).getGroupIndex(), this.getUnifacGroup(k).getGroupIndex()));
            sum1Mix += this.getUnifacGroup(i).getQMix() * Math.exp(-1.0 / phase.getTemperature() * this.calcaij(phase, this.getUnifacGroup(i).getGroupIndex(), this.getUnifacGroup(k).getGroupIndex()));
            double sum2Comp = 0.0;
            double sum2Mix = 0.0;
            for (int j = 0; j < this.getNumberOfUNIFACgroups(); ++j) {
                sum2Comp += this.getUnifacGroup(j).getQComp() * Math.exp(-1.0 / phase.getTemperature() * this.calcaij(phase, this.getUnifacGroup(j).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex()));
                sum2Mix += this.getUnifacGroup(j).getQMix() * Math.exp(-1.0 / phase.getTemperature() * this.calcaij(phase, this.getUnifacGroup(j).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex()));
            }
            sum3Comp += this.getUnifacGroup(i).getQComp() * Math.exp(-1.0 / phase.getTemperature() * this.calcaij(phase, this.getUnifacGroup(k).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex())) / sum2Comp;
            sum3Mix += this.getUnifacGroup(i).getQMix() * Math.exp(-1.0 / phase.getTemperature() * this.calcaij(phase, this.getUnifacGroup(k).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex())) / sum2Mix;
        }
        double tempGammaComp = this.getUnifacGroup(k).getQ() * (1.0 - Math.log(sum1Comp) - sum3Comp);
        double tempGammaMix = this.getUnifacGroup(k).getQ() * (1.0 - Math.log(sum1Mix) - sum3Mix);
        this.getUnifacGroup(k).setLnGammaComp(tempGammaComp);
        this.getUnifacGroup(k).setLnGammaMix(tempGammaMix);
    }

    public void calclnGammakdT(int k, PhaseInterface phase) {
        double sum1Comp = 0.0;
        double sum1Mix = 0.0;
        double sum3Comp = 0.0;
        double sum3Mix = 0.0;
        for (int i = 0; i < this.getNumberOfUNIFACgroups(); ++i) {
            sum1Comp += this.getUnifacGroup(i).getQComp() * Math.exp(-1.0 / phase.getTemperature() * this.calcaijdT(phase, this.getUnifacGroup(i).getGroupIndex(), this.getUnifacGroup(k).getGroupIndex()));
            sum1Mix += this.getUnifacGroup(i).getQMix() * Math.exp(-1.0 / phase.getTemperature() * this.calcaijdT(phase, this.getUnifacGroup(i).getGroupIndex(), this.getUnifacGroup(k).getGroupIndex()));
            double sum2Comp = 0.0;
            double sum2Mix = 0.0;
            for (int j = 0; j < this.getNumberOfUNIFACgroups(); ++j) {
                sum2Comp += this.getUnifacGroup(j).getQComp() * Math.exp(-1.0 / phase.getTemperature() * this.calcaijdT(phase, this.getUnifacGroup(j).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex()));
                sum2Mix += this.getUnifacGroup(j).getQMix() * Math.exp(-1.0 / phase.getTemperature() * this.calcaijdT(phase, this.getUnifacGroup(j).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex()));
            }
            sum3Comp += this.getUnifacGroup(i).getQComp() * Math.exp(-1.0 / phase.getTemperature() * this.calcaijdT(phase, this.getUnifacGroup(k).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex())) / sum2Comp;
            sum3Mix += this.getUnifacGroup(i).getQMix() * Math.exp(-1.0 / phase.getTemperature() * this.calcaijdT(phase, this.getUnifacGroup(k).getGroupIndex(), this.getUnifacGroup(i).getGroupIndex())) / sum2Mix;
        }
        double tempGammaComp = this.getUnifacGroup(k).getQ() * (1.0 - Math.log(sum1Comp) - sum3Comp);
        double tempGammaMix = this.getUnifacGroup(k).getQ() * (1.0 - Math.log(sum1Mix) - sum3Mix);
        this.getUnifacGroup(k).setLnGammaCompdT(tempGammaComp);
        this.getUnifacGroup(k).setLnGammaMixdT(tempGammaMix);
    }

    @Override
    public double getGamma(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, PhaseType pt) {
        int i;
        int initType = phase.getInitType();
        double lngammaCombinational = 0.0;
        double lngammaResidual = 0.0;
        double lngammaResidualdT = 0.0;
        this.dlngammadn = new double[numberOfComponents];
        this.dlngammadt = 0.0;
        ComponentGEUnifac[] compArray = (ComponentGEUnifac[])phase.getcomponentArray();
        double temp1 = 0.0;
        double temp2 = 0.0;
        double suml = 0.0;
        double V = 0.0;
        double F = 0.0;
        for (int j = 0; j < numberOfComponents; ++j) {
            temp1 += compArray[j].getx() * compArray[j].getR();
            temp2 += compArray[j].getQ() * compArray[j].getx();
            suml += compArray[j].getx() * (5.0 * (compArray[j].getR() - compArray[j].getQ()) - (compArray[j].getR() - 1.0));
        }
        V = this.getx() * this.getR() / temp1;
        F = this.getx() * this.getQ() / temp2;
        double li = 5.0 * (this.getR() - this.getQ()) - (this.getR() - 1.0);
        lngammaCombinational = 5.0 * this.getQ() * Math.log(F / V) + li - V / this.getx() * suml + Math.log(V / this.getx());
        for (i = 0; i < this.getNumberOfUNIFACgroups(); ++i) {
            this.getUnifacGroup(i).calcXComp(this);
            this.getUnifacGroup(i).calcQComp(this);
            this.getUnifacGroup(i).calcQMix((PhaseGEUnifac)phase);
        }
        for (i = 0; i < this.getNumberOfUNIFACgroups(); ++i) {
            this.calclnGammak(i, phase);
        }
        lngammaResidual = 0.0;
        for (i = 0; i < this.getNumberOfUNIFACgroups(); ++i) {
            lngammaResidual += (double)this.getUnifacGroup(i).getN() * (this.getUnifacGroup(i).getLnGammaMix() - this.getUnifacGroup(i).getLnGammaComp());
        }
        this.lngamma = lngammaResidual + lngammaCombinational;
        this.gamma = Math.exp(this.lngamma);
        if (initType > 1) {
            lngammaResidualdT = 0.0;
            for (i = 0; i < this.getNumberOfUNIFACgroups(); ++i) {
                this.calclnGammakdT(i, phase);
                lngammaResidualdT += (double)this.getUnifacGroup(i).getN() * (this.getUnifacGroup(i).getLnGammaMixdT() - this.getUnifacGroup(i).getLnGammaCompdT());
            }
            this.dlngammadt = lngammaResidualdT;
        }
        return this.gamma;
    }
}

