/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveeosterm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermSrk;

public class AttractiveTermCPAstatoil
extends AttractiveTermSrk {
    private static final long serialVersionUID = 1000L;
    double orgpar = 0.0;

    public AttractiveTermCPAstatoil(ComponentEosInterface component) {
        super(component);
        this.m = 0.48 + 1.574 * component.getAcentricFactor() - 0.176 * component.getAcentricFactor() * component.getAcentricFactor();
        if (component.getName().equals("waterG")) {
            this.parameters[0] = 0.7892765953;
            this.parameters[1] = -1.0606510837;
            this.parameters[2] = 2.207193651;
        } else if (component.getName().equals("MEG2")) {
            this.parameters[0] = 0.8581331725;
            this.parameters[1] = -1.005318015;
            this.parameters[2] = 1.2736063639;
        } else if (component.getName().equals("TEG2")) {
            this.parameters[0] = 1.0008858863;
            this.parameters[1] = 1.864964547;
            this.parameters[2] = -4.6720397496;
        } else if (component.getName().equals("TEG")) {
            this.parameters[0] = 0.903477158616734;
            this.parameters[1] = 1.514853438;
            this.parameters[2] = -1.86430399826;
        } else {
            this.parameters[0] = this.m;
            this.parameters[1] = 0.0;
            this.parameters[2] = 0.0;
        }
    }

    @Override
    public AttractiveTermCPAstatoil clone() {
        AttractiveTermCPAstatoil attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermCPAstatoil)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public void init() {
        super.init();
        if (!this.getComponent().getName().equals("TEG")) {
            this.parameters[0] = this.m;
        }
    }

    @Override
    public double alpha(double temperature) {
        double Tr = temperature / this.getComponent().getTC();
        double temp1 = 1.0 - Math.sqrt(Tr);
        double var = 1.0 + this.parameters[0] * temp1 + this.parameters[1] * temp1 * temp1 + this.parameters[2] * temp1 * temp1 * temp1;
        return var * var;
    }

    @Override
    public double aT(double temperature) {
        if (temperature / this.getComponent().getTC() > 1.0) {
            return super.aT(temperature);
        }
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        double Tr = temperature / this.getComponent().getTC();
        double TC = this.getComponent().getTC();
        return 2.0 * (1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0)) * (-this.parameters[0] / Math.sqrt(Tr) / TC / 2.0 - this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Math.sqrt(Tr) / TC - 1.5 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Math.sqrt(Tr) / TC);
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        double Tr = temperature / this.getComponent().getTC();
        double TC = this.getComponent().getTC();
        return 2.0 * Math.pow(-this.parameters[0] / Math.sqrt(Tr) / TC / 2.0 - this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Math.sqrt(Tr) / TC - 1.5 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Math.sqrt(Tr) / TC, 2.0) + 2.0 * (1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0)) * (this.parameters[0] / Math.sqrt(Tr * Tr * Tr) / (TC * TC) / 4.0 + this.parameters[1] / temperature / TC / 2.0 + this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Math.sqrt(Tr * Tr * Tr) / (TC * TC) / 2.0 + 1.5 * this.parameters[2] * (1.0 - Math.sqrt(Tr)) / temperature / TC + 0.75 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Math.sqrt(Tr * Tr * Tr) / (TC * TC));
    }

    @Override
    public double diffaT(double temperature) {
        if (temperature / this.getComponent().getTC() > 1.0) {
            return super.diffaT(temperature);
        }
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        if (temperature / this.getComponent().getTC() > 1.0) {
            return super.diffdiffaT(temperature);
        }
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

