/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveeosterm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermPr;

public class AttractiveTermMatCopPRUMR
extends AttractiveTermPr {
    private static final long serialVersionUID = 1000L;
    double orgpar = 0.0;
    boolean useStandardAlphaForSupercritical = false;

    public AttractiveTermMatCopPRUMR(ComponentEosInterface component) {
        super(component);
        this.m = 0.384401 + 1.52276 * component.getAcentricFactor() - 0.213808 * component.getAcentricFactor() * component.getAcentricFactor() + 0.034616 * Math.pow(component.getAcentricFactor(), 3.0) - 0.001976 * Math.pow(component.getAcentricFactor(), 4.0);
        if (component.getName().equals("water")) {
            this.parameters[0] = 0.9125673511881881;
            this.parameters[1] = -0.28722436397952344;
            this.parameters[2] = 0.23952676305837425;
        }
        if (component.getName().equals("TEG")) {
            this.parameters[0] = 1.051;
            this.parameters[1] = 2.945;
            this.parameters[2] = -5.982;
        }
    }

    public AttractiveTermMatCopPRUMR(ComponentEosInterface component, double[] params) {
        this(component);
        System.arraycopy(params, 0, this.parameters, 0, params.length);
        this.orgpar = this.parameters[0];
        if (Math.abs(this.parameters[0]) < 1.0E-12) {
            this.parameters[0] = this.m;
        }
        if (component.getName().equals("water")) {
            this.parameters[0] = 0.9125673511881881;
            this.parameters[1] = -0.28722436397952344;
            this.parameters[2] = 0.23952676305837425;
        }
        if (component.getName().equals("TEG")) {
            this.parameters[0] = 1.05;
            this.parameters[1] = 2.95;
            this.parameters[2] = -5.98;
        }
    }

    @Override
    public AttractiveTermMatCopPRUMR clone() {
        AttractiveTermMatCopPRUMR attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermMatCopPRUMR)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public double alpha(double temperature) {
        if (this.useStandardAlphaForSupercritical && temperature / this.getComponent().getTC() > 1.0 || this.parameters[0] < 1.0E-20) {
            return super.alpha(temperature);
        }
        double Tr = temperature / this.getComponent().getTC();
        return Math.pow(1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0), 2.0);
    }

    @Override
    public double aT(double temperature) {
        if (this.useStandardAlphaForSupercritical && temperature / this.getComponent().getTC() > 1.0 || this.parameters[0] < 1.0E-20) {
            return super.aT(temperature);
        }
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        if (this.useStandardAlphaForSupercritical && temperature / this.getComponent().getTC() > 1.0 || this.parameters[0] < 1.0E-20) {
            return super.diffalphaT(temperature);
        }
        double Tr = temperature / this.getComponent().getTC();
        double TC = this.getComponent().getTC();
        return 2.0 * (1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0)) * (-this.parameters[0] / Math.sqrt(Tr) / TC / 2.0 - this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Math.sqrt(Tr) / TC - 1.5 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Math.sqrt(Tr) / TC);
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        if (this.useStandardAlphaForSupercritical && temperature / this.getComponent().getTC() > 1.0 || this.parameters[0] < 1.0E-20) {
            return super.diffdiffalphaT(temperature);
        }
        double Tr = temperature / this.getComponent().getTC();
        double TC = this.getComponent().getTC();
        return 2.0 * Math.pow(-this.parameters[0] / Math.sqrt(Tr) / TC / 2.0 - this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Math.sqrt(Tr) / TC - 1.5 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Math.sqrt(Tr) / TC, 2.0) + 2.0 * (1.0 + this.parameters[0] * (1.0 - Math.sqrt(Tr)) + this.parameters[1] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) + this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 3.0)) * (this.parameters[0] / Math.sqrt(Tr * Tr * Tr) / (TC * TC) / 4.0 + this.parameters[1] / temperature / TC / 2.0 + this.parameters[1] * (1.0 - Math.sqrt(Tr)) / Math.sqrt(Tr * Tr * Tr) / (TC * TC) / 2.0 + 1.5 * this.parameters[2] * (1.0 - Math.sqrt(Tr)) / temperature / TC + 0.75 * this.parameters[2] * Math.pow(1.0 - Math.sqrt(Tr), 2.0) / Math.sqrt(Tr * Tr * Tr) / (TC * TC));
    }

    @Override
    public double diffaT(double temperature) {
        if (this.useStandardAlphaForSupercritical && temperature / this.getComponent().getTC() > 1.0 || this.parameters[0] < 1.0E-20) {
            return super.diffaT(temperature);
        }
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        if (this.useStandardAlphaForSupercritical && temperature / this.getComponent().getTC() > 1.0 || this.parameters[0] < 1.0E-20) {
            return super.diffdiffaT(temperature);
        }
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

