/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveeosterm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermPr;

public class AttractiveTermPrGassem2001
extends AttractiveTermPr {
    private static final long serialVersionUID = 1000L;
    protected double A = 2.0;
    protected double B = 0.836;
    protected double C = 0.134;
    protected double D = 0.508;
    protected double E = -0.0467;

    public AttractiveTermPrGassem2001(ComponentEosInterface component) {
        super(component);
    }

    @Override
    public AttractiveTermPrGassem2001 clone() {
        AttractiveTermPrGassem2001 attractiveTerm = null;
        try {
            attractiveTerm = (AttractiveTermPrGassem2001)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return attractiveTerm;
    }

    @Override
    public void init() {
        this.m = 0.37464 + 1.54226 * this.getComponent().getAcentricFactor() - 0.26992 * this.getComponent().getAcentricFactor() * this.getComponent().getAcentricFactor();
    }

    @Override
    public double alpha(double temperature) {
        return Math.exp((this.A + this.B * temperature / this.getComponent().getTC()) * (1.0 - Math.pow(temperature / this.getComponent().getTC(), this.C + this.D * this.getComponent().getAcentricFactor() + this.E * this.getComponent().getAcentricFactor() * this.getComponent().getAcentricFactor())));
    }

    @Override
    public double aT(double temperature) {
        return this.getComponent().geta() * this.alpha(temperature);
    }

    @Override
    public double diffalphaT(double temperature) {
        return 1.0 / this.getComponent().getTC() * this.alpha(temperature) * (this.B * (1.0 - Math.pow(temperature / this.getComponent().getTC(), this.C + this.D * this.getComponent().getAcentricFactor() + this.E * this.getComponent().getAcentricFactor() * this.getComponent().getAcentricFactor())) - (this.A + this.B * temperature / this.getComponent().getTC()) * (this.C + this.D * this.getComponent().getAcentricFactor() + this.E * this.getComponent().getAcentricFactor() * this.getComponent().getAcentricFactor()) * Math.pow(temperature / this.getComponent().getTC(), this.C + this.D * this.getComponent().getAcentricFactor() + this.E * this.getComponent().getAcentricFactor() * this.getComponent().getAcentricFactor() - 1.0));
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        return this.m * this.m / temperature / this.getComponent().getTC() / 2.0 + (1.0 + this.m * (1.0 - Math.sqrt(temperature / this.getComponent().getTC()))) * this.m / Math.sqrt(temperature * temperature * temperature / Math.pow(this.getComponent().getTC(), 3.0)) / (this.getComponent().getTC() * this.getComponent().getTC()) / 2.0;
    }

    @Override
    public double diffaT(double temperature) {
        return this.getComponent().geta() * this.diffalphaT(temperature);
    }

    @Override
    public double diffdiffaT(double temperature) {
        return this.getComponent().geta() * this.diffdiffalphaT(temperature);
    }
}

