/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component.attractiveeosterm;

import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.component.attractiveeosterm.AttractiveTermPr1978;

public class AttractiveTermSoreideWhitson
extends AttractiveTermPr1978 {
    private static final long serialVersionUID = 1L;
    private double salinityFromPhase = 0.0;

    public AttractiveTermSoreideWhitson(ComponentEosInterface component) {
        super(component);
    }

    public void setSalinityFromPhase(double salinity) {
        this.salinityFromPhase = salinity;
    }

    private double getSalinityFromPhase() {
        return this.salinityFromPhase;
    }

    @Override
    public double alpha(double temperature) {
        if (!this.getComponent().getComponentName().equalsIgnoreCase("water")) {
            return super.alpha(temperature);
        }
        double Tr = temperature / this.getComponent().getTC();
        double alpha_A = 1.0 + 0.453 * (1.0 - Tr * (1.0 - 0.0103 * Math.pow(this.salinityFromPhase, 1.1))) + 0.0034 * (Math.pow(1.0 / Tr, 3.0) - 1.0);
        return alpha_A * alpha_A;
    }

    @Override
    public double diffalphaT(double temperature) {
        if (!this.getComponent().getComponentName().equalsIgnoreCase("water")) {
            return super.diffalphaT(temperature);
        }
        double Tr = temperature / this.getComponent().getTC();
        double Tc = this.getComponent().getTC();
        double salinity = this.getSalinityFromPhase();
        double dTrdT = 1.0 / Tc;
        double powSal = Math.pow(salinity, 1.1);
        double dAlpha_dTr = -0.453 * (1.0 - 0.0103 * powSal) - 0.010199999999999999 * Math.pow(1.0 / Tr, 4.0);
        double alpha_A = 1.0 + 0.453 * (1.0 - Tr * (1.0 - 0.0103 * powSal)) + 0.0034 * (Math.pow(1.0 / Tr, 3.0) - 1.0);
        return 2.0 * alpha_A * dAlpha_dTr * dTrdT;
    }

    @Override
    public double diffdiffalphaT(double temperature) {
        if (!this.getComponent().getComponentName().equalsIgnoreCase("water")) {
            return super.diffdiffalphaT(temperature);
        }
        double Tr = temperature / this.getComponent().getTC();
        double Tc = this.getComponent().getTC();
        double salinity = this.getSalinityFromPhase();
        double dTrdT = 1.0 / Tc;
        double powSal = Math.pow(salinity, 1.1);
        double dAlpha_dTr = -0.453 * (1.0 - 0.0103 * powSal) - 0.010199999999999999 * Math.pow(1.0 / Tr, 4.0);
        double d2Alpha_dTr2 = 0.040799999999999996 * Math.pow(1.0 / Tr, 5.0);
        double alpha_A = 1.0 + 0.453 * (1.0 - Tr * (1.0 - 0.0103 * powSal)) + 0.0034 * (Math.pow(1.0 / Tr, 3.0) - 1.0);
        return 2.0 * dAlpha_dTr * dAlpha_dTr * dTrdT * dTrdT + 2.0 * alpha_A * d2Alpha_dTr2 * dTrdT * dTrdT;
    }
}

