/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentCSPsrk;
import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.phase.PhaseBWRSEos;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.thermo.phase.PhaseType;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;

public class PhaseCSPsrkEos
extends PhaseSrkEos {
    private static final long serialVersionUID = 1000L;
    double f_scale_mix = 0.0;
    double h_scale_mix = 0.0;
    PhaseSrkEos refBWRSPhase = new PhaseBWRSEos();
    double brefBWRSPhase = 0.0;
    double acrefBWRSPhase = 0.0;
    double mrefBWRSPhase = 0.0;

    public PhaseCSPsrkEos() {
        this.refBWRSPhase.addComponent("methane", 1.0, 1.0, 0);
        this.refBWRSPhase.calcMolarVolume(false);
        this.brefBWRSPhase = (Math.pow(2.0, 0.3333333333333333) - 1.0) / 3.0 * 8.3144621 * this.refBWRSPhase.getComponent(0).getTC() / this.refBWRSPhase.getComponent(0).getPC();
        this.mrefBWRSPhase = 0.48 + 1.574 * this.refBWRSPhase.getComponent(0).getAcentricFactor() - 0.175 * this.refBWRSPhase.getComponent(0).getAcentricFactor() * this.refBWRSPhase.getComponent(0).getAcentricFactor();
        this.acrefBWRSPhase = 1.0 / (9.0 * (Math.pow(2.0, 0.3333333333333333) - 1.0)) * 8.3144621 * 8.3144621 * this.refBWRSPhase.getComponent(0).getTC() * this.refBWRSPhase.getComponent(0).getTC() / this.refBWRSPhase.getComponent(0).getPC();
    }

    @Override
    public PhaseCSPsrkEos clone() {
        PhaseCSPsrkEos clonedPhase = null;
        try {
            clonedPhase = (PhaseCSPsrkEos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        super.addComponent(name, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentCSPsrk(name, moles, molesInPhase, compNumber);
        ((ComponentCSPsrk)this.componentArray[compNumber]).setRefPhaseBWRS(this);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int initType, PhaseType pt, double beta) {
        double oldtemp = this.getTemperature();
        if (initType == 0) {
            this.refBWRSPhase.init(1.0, 1, 0, pt, 1.0);
        }
        this.refBWRSPhase.init(1.0, 1, 3, pt, 1.0);
        do {
            super.init(totalNumberOfMoles, numberOfComponents, initType, pt, beta);
            oldtemp = this.refBWRSPhase.getTemperature();
            this.h_scale_mix = this.getNumberOfMolesInPhase() * this.getb() / this.brefBWRSPhase;
            double term1 = this.getA() / ((ComponentEosInterface)this.refBWRSPhase.getComponent(0)).getaT();
            this.f_scale_mix = term1 / this.h_scale_mix;
            this.refBWRSPhase.setTemperature(this.temperature * this.numberOfMolesInPhase / this.f_scale_mix);
            this.refBWRSPhase.setMolarVolume(this.getTotalVolume() / this.h_scale_mix);
            this.refBWRSPhase.setPressure(this.pressure * this.h_scale_mix / this.f_scale_mix);
            this.refBWRSPhase.init(1.0, 1, initType, pt, 1.0);
        } while (Math.abs((oldtemp - this.refBWRSPhase.getTemperature()) / oldtemp) > 1.0E-8);
    }

    @Override
    public double getF() {
        return this.f_scale_mix * this.refBWRSPhase.getF() / this.refBWRSPhase.getNumberOfMolesInPhase() * this.refBWRSPhase.getTemperature() / this.getTemperature();
    }

    @Override
    public double dFdV() {
        return this.f_scale_mix * this.refBWRSPhase.dFdV() / this.refBWRSPhase.getNumberOfMolesInPhase() / this.h_scale_mix * this.refBWRSPhase.getTemperature() / this.getTemperature();
    }

    @Override
    public double dFdVdV() {
        return this.f_scale_mix * this.refBWRSPhase.dFdVdV() / this.refBWRSPhase.getNumberOfMolesInPhase() / this.h_scale_mix / this.h_scale_mix * this.refBWRSPhase.getTemperature() / this.getTemperature();
    }

    @Override
    public double dFdVdVdV() {
        return this.f_scale_mix * this.refBWRSPhase.dFdVdVdV() / this.refBWRSPhase.getNumberOfMolesInPhase() / this.h_scale_mix / this.h_scale_mix / this.h_scale_mix * this.refBWRSPhase.getTemperature() / this.getTemperature();
    }

    public double getF_scale_mix() {
        return this.f_scale_mix;
    }

    public void setF_scale_mix(double f_scale_mix) {
        this.f_scale_mix = f_scale_mix;
    }

    public double getH_scale_mix() {
        return this.h_scale_mix;
    }

    public void setH_scale_mix(double h_scale_mix) {
        this.h_scale_mix = h_scale_mix;
    }

    public double getBrefBWRSPhase() {
        return this.brefBWRSPhase;
    }

    public void setBrefBWRSPhase(double brefBWRSPhase) {
        this.brefBWRSPhase = brefBWRSPhase;
    }

    public double getAcrefBWRSPhase() {
        return this.acrefBWRSPhase;
    }

    public void setAcrefBWRSPhase(double acrefBWRSPhase) {
        this.acrefBWRSPhase = acrefBWRSPhase;
    }

    public PhaseSrkEos getRefBWRSPhase() {
        return this.refBWRSPhase;
    }

    public void setRefBWRSPhase(PhaseBWRSEos refBWRSPhase) {
        this.refBWRSPhase = refBWRSPhase;
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, PhaseType pt) throws IsNaNException, TooManyIterationsException {
        double BonV;
        double d = BonV = pt == PhaseType.LIQUID ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV < 0.0) {
            BonV = 0.0;
        }
        if (BonV > 1.0) {
            BonV = 1.0;
        }
        double Btemp = this.getB();
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        double Dtemp = this.getA();
        double BonVold = 0.0;
        int iterations = 0;
        int maxIterations = 1000;
        do {
            ++iterations;
            BonVold = BonV;
            double h = BonV + Btemp * this.gV() + Btemp * Dtemp / (this.numberOfMolesInPhase * temperature) * this.fv() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            double dh = 1.0 - Btemp / (BonV * BonV) * (Btemp * this.gVV() + Btemp * Dtemp * this.fVV() / (this.numberOfMolesInPhase * temperature));
            double fvvv = 1.0 / (8.3144621 * Btemp * (this.delta1 - this.delta2)) * (2.0 / Math.pow(this.numberOfMolesInPhase * this.getMolarVolume() + Btemp * this.delta1, 3.0) - 2.0 / Math.pow(this.numberOfMolesInPhase * this.getMolarVolume() + Btemp * this.delta2, 3.0));
            double gvvv = 2.0 / Math.pow(this.numberOfMolesInPhase * this.getMolarVolume() - Btemp, 3.0) - 2.0 / Math.pow(this.numberOfMolesInPhase * this.getMolarVolume(), 3.0);
            double d1 = -h / dh;
            double dhh = 2.0 * Btemp / Math.pow(BonV, 3.0) * (Btemp * this.gVV() + Btemp * Dtemp / (this.numberOfMolesInPhase * temperature) * this.fVV()) + Btemp * Btemp / Math.pow(BonV, 4.0) * (Btemp * gvvv + Btemp * Dtemp / (this.numberOfMolesInPhase * temperature) * fvvv);
            double d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += d1 * 0.5;
            } else if (d1 / d2 > 1.0) {
                BonV += d2;
                double hnew = h + d2 * dh;
                if (Math.abs(hnew) > Math.abs(h)) {
                    BonV += 0.0;
                }
            }
            if (BonV > 1.0) {
                BonV = 0.9999999999999999;
                BonVold = 10.0;
            }
            if (BonV < 0.0) {
                BonV = 1.0E-16;
                BonVold = 10.0;
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs(BonV - BonVold) > 1.0E-10 && iterations < maxIterations);
        if (iterations >= maxIterations) {
            throw new TooManyIterationsException(this, "molarVolume", (long)maxIterations);
        }
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException(this, "molarVolume", "Molar volume");
        }
        return this.getMolarVolume();
    }
}

