/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentSrkCPAs;
import neqsim.thermo.phase.PhaseSrkCPAs;

public class PhaseSrkCPAsOld
extends PhaseSrkCPAs {
    private static final long serialVersionUID = 1000L;

    @Override
    public void addComponent(String name, double moles, double molesInPhase, int compNumber) {
        super.addComponent(name, moles, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentSrkCPAs(name, moles, molesInPhase, compNumber);
    }

    @Override
    public PhaseSrkCPAsOld clone() {
        PhaseSrkCPAsOld clonedPhase = null;
        try {
            clonedPhase = (PhaseSrkCPAsOld)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedPhase;
    }

    @Override
    public double calc_g() {
        double x = 0.475 * this.getB() / this.getTotalVolume();
        double g = 1.0 / (1.0 - x);
        return g;
    }

    @Override
    public double calc_lngV() {
        double x = 0.475 * this.getB() / this.getTotalVolume();
        double gv = x / this.getTotalVolume() / (1.0 - x);
        return -gv;
    }

    @Override
    public double calc_lngVV() {
        double x = 0.475 * this.getB() / this.getTotalVolume();
        double xV = -0.475 * this.getB() / (this.getTotalVolume() * this.getTotalVolume());
        double u = 1.0 - x;
        double val = -x / (this.getTotalVolume() * this.getTotalVolume() * u) + xV / (this.getTotalVolume() * u) - x / (this.getTotalVolume() * u * u) * -1.0 * xV;
        return -val;
    }

    @Override
    public double calc_lngVVV() {
        double totVol = this.getTotalVolume();
        double totVol4 = totVol * totVol * totVol * totVol;
        double totVol5 = totVol4 * totVol;
        double temp1 = 1.0 - 0.475 * this.getB() / this.getTotalVolume();
        double gvv = -0.21434375 / (temp1 * temp1 * temp1) * this.getB() * this.getB() * this.getB() / (totVol5 * totVol) - 1.35375 / (temp1 * temp1) * this.getB() * this.getB() / totVol5 - 2.85 / temp1 * this.getB() / totVol4;
        return gvv;
    }
}

