/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.util.exception.InvalidInputException;

public enum PhaseType {
    LIQUID("liquid", 0),
    GAS("gas", 1),
    OIL("oil", 2),
    AQUEOUS("aqueous", 3),
    HYDRATE("hydrate", 4),
    WAX("wax", 5),
    SOLID("solid", 6),
    SOLIDCOMPLEX("solidComplex", 7);

    private final int value;
    private final String desc;
    private static final PhaseType[] copyOfValues;

    private PhaseType(String desc, int value) {
        this.desc = desc;
        this.value = value;
    }

    @Deprecated
    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static PhaseType byName(String name) {
        for (PhaseType pt : copyOfValues) {
            if (!pt.name().equals(name)) continue;
            return pt;
        }
        throw new RuntimeException(new InvalidInputException("PhaseType", "byName", "name", "is not valid."));
    }

    public static PhaseType byDesc(String desc) {
        for (PhaseType pt : copyOfValues) {
            if (!pt.getDesc().equals(desc)) continue;
            return pt;
        }
        throw new RuntimeException(new InvalidInputException("PhaseType", "byDesc", "desc", "is not valid."));
    }

    public static PhaseType byValue(int value) {
        for (PhaseType pt : copyOfValues) {
            if (pt.getValue() != value) continue;
            return pt;
        }
        throw new RuntimeException(new InvalidInputException("PhaseType", "byValue", "value", "is not valid."));
    }

    static {
        copyOfValues = PhaseType.values();
    }
}

