/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseBWRSEos;
import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.system.SystemEos;

public class SystemBWRSEos
extends SystemEos {
    private static final long serialVersionUID = 1000L;
    double[][] TBPfractionCoefs = new double[][]{{163.12, 86.052, 0.43475, -1877.4, 0.0}, {-0.13408, 2.5019, 208.46, -3987.2, 1.0}, {0.7431, 0.004812, 0.009671, -3.7E-6, 0.0}};

    public SystemBWRSEos() {
        this(298.15, 1.0, false);
    }

    public SystemBWRSEos(double T, double P) {
        this(T, P, false);
    }

    public SystemBWRSEos(double T, double P, boolean checkForSolids) {
        super(T, P, checkForSolids);
        this.modelName = "BWRS-EOS";
        this.attractiveTermNumber = 0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseBWRSEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.setNumberOfPhases(5);
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemBWRSEos clone() {
        SystemBWRSEos clonedSystem = null;
        try {
            clonedSystem = (SystemBWRSEos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

