/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePrEos;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.system.SystemPrEos;

public class SystemPrEosDelft1998
extends SystemPrEos {
    private static final long serialVersionUID = 1000L;

    public SystemPrEosDelft1998() {
        this(298.15, 1.0, false);
    }

    public SystemPrEosDelft1998(double T, double P) {
        super(T, P, false);
    }

    public SystemPrEosDelft1998(double T, double P, boolean checkForSolids) {
        super(T, P, checkForSolids);
        this.modelName = "PR Delft1998 EOS";
        this.attractiveTermNumber = 7;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhasePrEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemPrEosDelft1998 clone() {
        SystemPrEosDelft1998 clonedSystem = null;
        try {
            clonedSystem = (SystemPrEosDelft1998)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

