/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSrkCPAs;
import neqsim.thermo.system.SystemSrkCPAs;

public class SystemSrkCPAstatoil
extends SystemSrkCPAs {
    private static final long serialVersionUID = 1000L;

    public SystemSrkCPAstatoil() {
        this(298.15, 1.0, false);
    }

    public SystemSrkCPAstatoil(double T, double P) {
        this(T, P, false);
    }

    public SystemSrkCPAstatoil(double T, double P, boolean checkForSolids) {
        super(T, P, checkForSolids);
        this.modelName = "CPAs-SRK-EOS-statoil";
        this.attractiveTermNumber = 15;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseSrkCPAs();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        this.useVolumeCorrection(true);
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemSrkCPAstatoil clone() {
        SystemSrkCPAstatoil clonedSystem = null;
        try {
            clonedSystem = (SystemSrkCPAstatoil)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

