/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import com.google.gson.GsonBuilder;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.chemicalreactions.ChemicalReactionOperations;
import neqsim.datapresentation.filehandling.TextFile;
import neqsim.physicalproperties.PhysicalPropertyType;
import neqsim.physicalproperties.interfaceproperties.InterfaceProperties;
import neqsim.physicalproperties.interfaceproperties.InterphasePropertiesInterface;
import neqsim.process.util.monitor.FluidComponentResponse;
import neqsim.process.util.monitor.FluidResponse;
import neqsim.standards.StandardInterface;
import neqsim.standards.gasquality.Draft_ISO18453;
import neqsim.standards.gasquality.Standard_ISO6976;
import neqsim.thermo.characterization.Characterise;
import neqsim.thermo.characterization.PlusCharacterize;
import neqsim.thermo.characterization.WaxCharacterise;
import neqsim.thermo.characterization.WaxModelInterface;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.mixingrule.EosMixingRuleHandler;
import neqsim.thermo.mixingrule.MixingRuleTypeInterface;
import neqsim.thermo.phase.PhaseEosInterface;
import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSolid;
import neqsim.thermo.phase.PhaseSolidComplex;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.phase.PhaseWax;
import neqsim.thermo.system.SystemDuanSun;
import neqsim.thermo.system.SystemElectrolyteCPAstatoil;
import neqsim.thermo.system.SystemEos;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.system.SystemGERG2004Eos;
import neqsim.thermo.system.SystemGERGwaterEos;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemPCSAFT;
import neqsim.thermo.system.SystemPrEos;
import neqsim.thermo.system.SystemProperties;
import neqsim.thermo.system.SystemSrkCPAs;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.system.SystemSrkSchwartzentruberEos;
import neqsim.thermo.system.SystemSrkTwuCoonParamEos;
import neqsim.thermo.system.SystemSrkTwuCoonStatoilEos;
import neqsim.thermo.system.SystemUMRPRUMCEos;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import neqsim.util.database.NeqSimBlobDatabase;
import neqsim.util.database.NeqSimDataBase;
import neqsim.util.database.NeqSimFluidDataBase;
import neqsim.util.exception.InvalidInputException;
import neqsim.util.unit.PressureUnit;
import neqsim.util.unit.RateUnit;
import neqsim.util.unit.TemperatureUnit;
import neqsim.util.unit.Units;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SystemThermo
implements SystemInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SystemThermo.class);
    private static final int MAX_PHASES = 6;
    protected int a;
    protected boolean allowPhaseShift = true;
    protected int attractiveTermNumber = 0;
    protected double[] beta = new double[6];
    protected String[] CapeOpenProperties10 = new String[]{"molecularWeight", "speedOfSound", "jouleThomsonCoefficient", "energy", "energy.Dtemperature", "gibbsFreeEnergy", "helmholtzFreeEnergy", "fugacityCoefficient", "logFugacityCoefficient", "logFugacityCoefficient.Dtemperature", "logFugacityCoefficient.Dpressure", "logFugacityCoefficient.Dmoles", "enthalpy", "enthalpy.Dmoles", "enthalpy.Dtemperature", "enthalpy.Dpressure", "entropy", "entropy.Dtemperature", "entropy.Dpressure", "entropy.Dmoles", "heatCapacity", "heatCapacityCv", "density", "density.Dtemperature", "density.Dpressure", "density.Dmoles", "volume", "volume.Dpressure", "volume.Dtemperature", "molecularWeight.Dtemperature", "molecularWeight.Dpressure", "molecularWeight.Dmoles", "compressibilityFactor"};
    protected String[] CapeOpenProperties11 = new String[]{"molecularWeight", "speedOfSound", "jouleThomsonCoefficient", "internalEnergy", "internalEnergy.Dtemperature", "gibbsEnergy", "helmholtzEnergy", "fugacityCoefficient", "logFugacityCoefficient", "logFugacityCoefficient.Dtemperature", "logFugacityCoefficient.Dpressure", "logFugacityCoefficient.Dmoles", "enthalpy", "enthalpy.Dmoles", "enthalpy.Dtemperature", "enthalpy.Dpressure", "entropy", "entropy.Dtemperature", "entropy.Dpressure", "entropy.Dmoles", "heatCapacityCp", "heatCapacityCv", "density", "density.Dtemperature", "density.Dpressure", "density.Dmoles", "volume", "volume.Dpressure", "volume.Dtemperature", "molecularWeight.Dtemperature", "molecularWeight.Dpressure", "molecularWeight.Dmoles", "compressibilityFactor"};
    public Characterise characterization = null;
    protected boolean checkStability = true;
    protected ChemicalReactionOperations chemicalReactionOperations = null;
    protected boolean chemicalSystem = false;
    private ArrayList<String> componentNames = new ArrayList();
    public String componentNameTag = "";
    protected double criticalPressure = 0.0;
    protected double criticalTemperature = 0.0;
    protected String fluidInfo = "No Information Available";
    protected String fluidName = "DefaultName";
    private boolean forcePhaseTypes = false;
    protected boolean hydrateCheck = false;
    private boolean implementedCompositionDeriativesofFugacity = true;
    private boolean implementedPressureDeriativesofFugacity = true;
    private boolean implementedTemperatureDeriativesofFugacity = true;
    protected InterphasePropertiesInterface interfaceProp = null;
    boolean isInitialized = false;
    public int maxNumberOfPhases = 2;
    private MixingRuleTypeInterface mixingRuleType;
    protected String modelName = "Default";
    protected boolean multiPhaseCheck = false;
    private boolean multiphaseWaxCheck = false;
    protected int numberOfComponents = 0;
    protected int numberOfPhases = 2;
    protected boolean numericDerivatives = false;
    protected PhaseInterface[] phaseArray = new PhaseInterface[6];
    protected int[] phaseIndex;
    protected PhaseType[] phaseType = new PhaseType[6];
    protected String[][] resultTable = null;
    protected boolean solidPhaseCheck = false;
    protected StandardInterface standard = null;
    private double totalNumberOfMoles = 0.0;
    private boolean useTVasIndependentVariables = false;
    protected WaxCharacterise waxCharacterisation = null;

    public SystemThermo() {
        this.characterization = new Characterise(this);
        this.interfaceProp = new InterfaceProperties(this);
        this.reInitPhaseInformation();
    }

    public SystemThermo(double T, double P, boolean checkForSolids) {
        this();
        if (T < 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "SystemThermo", "T", "is negative"));
        }
        if (P < 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "SystemThermo", "P", "is negative"));
        }
        this.solidPhaseCheck = checkForSolids;
    }

    @Override
    public void addCapeOpenProperty(String propertyName) {
        String[] tempString = new String[this.CapeOpenProperties11.length + 1];
        System.arraycopy(this.CapeOpenProperties11, 0, tempString, 0, this.CapeOpenProperties11.length);
        tempString[this.CapeOpenProperties11.length] = propertyName;
        this.CapeOpenProperties11 = tempString;
        tempString = new String[this.CapeOpenProperties10.length + 1];
        System.arraycopy(this.CapeOpenProperties10, 0, tempString, 0, this.CapeOpenProperties10.length);
        tempString[this.CapeOpenProperties10.length] = propertyName;
        this.CapeOpenProperties10 = tempString;
    }

    @Override
    public void addCharacterized(String[] charNames, double[] charFlowrate, double[] molarMass, double[] relativedensity) {
        if (charNames.length != charFlowrate.length) {
            logger.error("component names and mole fractions need to be same length...");
        }
        for (int i = 0; i < charNames.length; ++i) {
            this.addTBPfraction(charNames[i], charFlowrate[i], molarMass[i], relativedensity[i]);
        }
    }

    @Override
    public void addComponent(ComponentInterface inComponent) {
        if (inComponent.isIsTBPfraction()) {
            this.addTBPfraction(inComponent.getComponentName(), inComponent.getNumberOfmoles(), inComponent.getMolarMass(), inComponent.getNormalLiquidDensity());
            String componentName = inComponent.getComponentName();
            this.changeComponentName(componentName + "_PC", componentName.replaceFirst("_PC", ""));
            for (int i = 0; i < this.numberOfPhases; ++i) {
                this.getPhase(i).getComponent(componentName).setAttractiveTerm(inComponent.getAttractiveTermNumber());
                this.getPhase(i).getComponent(componentName).setTC(inComponent.getTC());
                this.getPhase(i).getComponent(componentName).setPC(inComponent.getPC());
                this.getPhase(i).getComponent(componentName).setMolarMass(inComponent.getMolarMass());
                this.getPhase(i).getComponent(componentName).setComponentType("TBPfraction");
                this.getPhase(i).getComponent(componentName).setNormalLiquidDensity(inComponent.getNormalLiquidDensity());
                this.getPhase(i).getComponent(componentName).setNormalBoilingPoint(inComponent.getNormalBoilingPoint());
                this.getPhase(i).getComponent(componentName).setAcentricFactor(inComponent.getAcentricFactor());
                this.getPhase(i).getComponent(componentName).setCriticalVolume(inComponent.getCriticalVolume());
                this.getPhase(i).getComponent(componentName).setRacketZ(inComponent.getRacketZ());
                this.getPhase(i).getComponent(componentName).setRacketZCPA(inComponent.getRacketZCPA());
                this.getPhase(i).getComponent(componentName).setIsTBPfraction(true);
                this.getPhase(i).getComponent(componentName).setParachorParameter(inComponent.getParachorParameter());
                this.getPhase(i).getComponent(componentName).setTriplePointTemperature(inComponent.getTriplePointTemperature());
                this.getPhase(i).getComponent(componentName).setIdealGasEnthalpyOfFormation(inComponent.getIdealGasEnthalpyOfFormation());
                this.getPhase(i).getComponent(componentName).setCpA(inComponent.getCpA());
                this.getPhase(i).getComponent(componentName).setCpB(inComponent.getCpB());
                this.getPhase(i).getComponent(componentName).setCpC(inComponent.getCpC());
                this.getPhase(i).getComponent(componentName).setCpD(inComponent.getCpD());
            }
        } else {
            this.addComponent(inComponent.getComponentName(), inComponent.getNumberOfmoles());
        }
    }

    @Override
    public void addComponent(int index, double moles) {
        if (index >= this.getPhase(0).getNumberOfComponents()) {
            logger.error("componentIndex higher than number of components in system");
            return;
        }
        for (PhaseInterface tmpPhase : this.phaseArray) {
            if (tmpPhase == null) continue;
            tmpPhase.addMolesChemReac(index, moles, moles);
        }
        this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() + moles);
    }

    @Override
    public void addComponent(int index, double moles, int phaseNumber) {
        if (index >= this.getPhase(0).getNumberOfComponents()) {
            logger.error("componentIndex higher than number of components in system");
            return;
        }
        double k = 1.0;
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            k = phaseNumber == i ? 1.0 : 0.0;
            this.phaseArray[this.phaseIndex[i]].addMolesChemReac(index, moles * k, moles);
        }
        this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() + moles);
    }

    @Override
    public void addComponent(String componentName, double moles) {
        componentName = ComponentInterface.getComponentNameFromAlias(componentName);
        int index = 0;
        boolean addForFirstTime = true;
        for (int p = 0; p < this.componentNames.size(); ++p) {
            if (!this.componentNames.get(p).equals(componentName)) continue;
            addForFirstTime = false;
            index = p;
            break;
        }
        if (addForFirstTime) {
            if (!NeqSimDataBase.hasComponent(componentName)) {
                throw new RuntimeException(new InvalidInputException(this, "addComponent", "componentName", "with value " + componentName + " not found in database."));
            }
            if (moles < 0.0) {
                String msg = "is negative input for component: " + componentName;
                throw new RuntimeException(new InvalidInputException(this, "addComponent", "moles", msg));
            }
            this.componentNames.add(componentName);
            for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
                this.getPhase(i).addComponent(componentName, moles, moles, this.numberOfComponents);
                this.getPhase(i).setAttractiveTerm(this.attractiveTermNumber);
            }
            ++this.numberOfComponents;
        } else {
            for (PhaseInterface tmpPhase : this.phaseArray) {
                if (tmpPhase == null || !(tmpPhase.getComponent(componentName).getNumberOfMolesInPhase() + moles < 0.0)) continue;
                this.init(0);
                break;
            }
            for (PhaseInterface tmpPhase : this.phaseArray) {
                if (tmpPhase == null) continue;
                tmpPhase.addMolesChemReac(index, moles, moles);
            }
        }
        this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() + moles);
    }

    @Override
    public void addComponent(String componentName, double moles, double TC, double PC, double acs) {
        String comNam = componentName = ComponentInterface.getComponentNameFromAlias(componentName);
        if (this.getPhase(0).hasComponent(componentName)) {
            this.addComponent(componentName, moles);
        } else {
            this.addComponent("default", moles);
            comNam = "default";
        }
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            this.getPhase(i).getComponent(comNam).setComponentName(componentName);
            this.getPhase(i).getComponent(componentName).setTC(TC);
            this.getPhase(i).getComponent(componentName).setPC(PC);
            this.getPhase(i).getComponent(componentName).setAcentricFactor(acs);
        }
        if (comNam.equals("default")) {
            this.componentNames.remove("default");
            this.componentNames.add(componentName);
        }
    }

    @Override
    public void addComponent(String componentName, double moles, int phaseNumber) {
        if (!NeqSimDataBase.hasComponent(componentName = ComponentInterface.getComponentNameFromAlias(componentName))) {
            throw new RuntimeException("No component with name: " + componentName + " in database");
        }
        for (int p = 0; p < this.componentNames.size(); ++p) {
            if (!this.componentNames.get(p).equals(componentName)) continue;
            this.addComponent(p, moles, phaseNumber);
            return;
        }
        if (moles < 0.0) {
            String msg = "Negative input number of moles.";
            throw new RuntimeException(new InvalidInputException(this, "addComponent", "moles", msg));
        }
        this.componentNames.add(componentName);
        double k = 1.0;
        this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() + moles);
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            k = phaseNumber == i ? 1.0 : 1.0E-30;
            this.getPhase(i).addComponent(componentName, moles, moles * k, this.numberOfComponents);
            this.getPhase(i).setAttractiveTerm(this.attractiveTermNumber);
        }
        ++this.numberOfComponents;
    }

    @Override
    public void addComponent(String componentName, double value, String unitName) {
        if (!NeqSimDataBase.hasComponent(componentName = ComponentInterface.getComponentNameFromAlias(componentName))) {
            throw new RuntimeException("No component with name: " + componentName + " in database");
        }
        double molarmass = 0.0;
        double stddens = 0.0;
        double boilp = 0.0;
        try (NeqSimDataBase database = new NeqSimDataBase();
             ResultSet dataSet = database.getResultSet("SELECT * FROM comp WHERE name='" + componentName + "'");){
            dataSet.next();
            molarmass = Double.parseDouble(dataSet.getString("molarmass")) / 1000.0;
            stddens = Double.parseDouble(dataSet.getString("stddens"));
            boilp = Double.parseDouble(dataSet.getString("normboil"));
        }
        catch (Exception ex) {
            logger.error("failed ", (Throwable)ex);
        }
        RateUnit unit = new RateUnit(value, unitName, molarmass, stddens, boilp);
        double SIval = unit.getSIvalue();
        this.addComponent(componentName, SIval);
    }

    @Override
    public void addComponent(String componentName, double value, String name, int phaseNum) {
        if (!NeqSimDataBase.hasComponent(componentName = ComponentInterface.getComponentNameFromAlias(componentName))) {
            throw new RuntimeException("No component with name: " + componentName + " in database");
        }
        double molarmass = 0.0;
        double stddens = 0.0;
        double boilp = 0.0;
        try (NeqSimDataBase database = new NeqSimDataBase();
             ResultSet dataSet = database.getResultSet("SELECT * FROM comp WHERE name='" + componentName + "'");){
            dataSet.next();
            molarmass = Double.parseDouble(dataSet.getString("molarmass")) / 1000.0;
            stddens = Double.parseDouble(dataSet.getString("stddens"));
            boilp = Double.parseDouble(dataSet.getString("normboil"));
        }
        catch (Exception ex) {
            logger.error("failed ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        RateUnit unit = new RateUnit(value, name, molarmass, stddens, boilp);
        double SIval = unit.getSIvalue();
        this.addComponent(componentName, SIval, phaseNum);
    }

    @Override
    public SystemInterface addFluid(SystemInterface addSystem) {
        boolean addedNewComponent = false;
        int index = -1;
        for (int i = 0; i < addSystem.getPhase(0).getNumberOfComponents(); ++i) {
            if (!this.getPhase(0).hasComponent(addSystem.getPhase(0).getComponent(i).getComponentName())) {
                index = -1;
                addedNewComponent = true;
            } else {
                index = this.getPhase(0).getComponent(addSystem.getPhase(0).getComponent(i).getComponentName()).getComponentNumber();
            }
            if (index != -1) {
                this.addComponent(index, addSystem.getPhase(0).getComponent(i).getNumberOfmoles());
                continue;
            }
            if (addSystem.getPhase(0).getComponent(i).isIsTBPfraction()) {
                this.addTBPfraction(addSystem.getPhase(0).getComponent(i).getComponentName().replaceFirst("_PC", ""), addSystem.getPhase(0).getComponent(i).getNumberOfmoles(), addSystem.getPhase(0).getComponent(i).getMolarMass(), addSystem.getPhase(0).getComponent(i).getNormalLiquidDensity());
                continue;
            }
            if (addSystem.getPhase(0).getComponent(i).isIsTBPfraction()) {
                this.addTBPfraction(addSystem.getPhase(0).getComponent(i).getComponentName().replaceFirst("_PC", ""), addSystem.getPhase(0).getComponent(i).getNumberOfmoles(), addSystem.getPhase(0).getComponent(i).getMolarMass(), addSystem.getPhase(0).getComponent(i).getNormalLiquidDensity());
                continue;
            }
            this.addComponent(addSystem.getComponent(i));
        }
        if (addedNewComponent) {
            this.createDatabase(true);
            this.setMixingRule(this.getMixingRule());
            this.init(0);
        }
        return this;
    }

    @Override
    public SystemInterface addFluid(SystemInterface addSystem, int phaseNum) {
        for (int i = 0; i < addSystem.getPhase(0).getNumberOfComponents(); ++i) {
            this.addComponent(addSystem.getPhase(0).getComponent(i).getComponentName(), addSystem.getPhase(0).getComponent(i).getNumberOfmoles(), phaseNum);
        }
        return this;
    }

    @Override
    public void addGasToLiquid(double fraction) {
        for (int i = 0; i < this.getPhase(0).getNumberOfComponents(); ++i) {
            double change = this.getPhase(0).getComponent(i).getNumberOfMolesInPhase() * fraction;
            this.addComponent(i, -change, 0);
            this.addComponent(i, change, 1);
        }
    }

    public void addHydratePhase() {
        int i;
        if (!this.multiPhaseCheck) {
            this.setMultiPhaseCheck(true);
        }
        if (!this.hasSolidPhase()) {
            this.phaseArray[3] = new PhasePureComponentSolid();
            this.phaseArray[3].setTemperature(this.phaseArray[0].getTemperature());
            this.phaseArray[3].setPressure(this.phaseArray[0].getPressure());
            this.phaseArray[3].setType(PhaseType.SOLID);
            for (i = 0; i < this.phaseArray[0].getNumberOfComponents(); ++i) {
                if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                    this.phaseArray[3].addComponent("default", this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
                    this.phaseArray[3].getComponent(i).setComponentName(this.getPhase(0).getComponent(i).getName());
                    this.phaseArray[3].getComponent(i).setIsTBPfraction(true);
                    continue;
                }
                this.phaseArray[3].addComponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
            }
            ((PhaseSolid)this.phaseArray[3]).setSolidRefFluidPhase(this.phaseArray[0]);
        }
        this.phaseArray[4] = new PhaseHydrate(this.getModelName());
        this.phaseArray[4].setTemperature(this.phaseArray[0].getTemperature());
        this.phaseArray[4].setPressure(this.phaseArray[0].getPressure());
        this.phaseArray[4].setType(PhaseType.HYDRATE);
        for (i = 0; i < this.phaseArray[0].getNumberOfComponents(); ++i) {
            if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                this.phaseArray[4].addComponent("default", this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
                this.phaseArray[4].getComponent(i).setComponentName(this.getPhase(0).getComponent(i).getName());
                this.phaseArray[4].getComponent(i).setIsTBPfraction(true);
                continue;
            }
            this.phaseArray[4].addComponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
        }
        ((PhaseHydrate)this.phaseArray[4]).setSolidRefFluidPhase(this.phaseArray[0]);
        this.setNumberOfPhases(5);
    }

    public void addHydratePhase2() {
        if (!this.multiPhaseCheck) {
            this.setMultiPhaseCheck(true);
        }
        this.phaseArray[3] = new PhaseHydrate();
        this.phaseArray[3].setTemperature(this.phaseArray[0].getTemperature());
        this.phaseArray[3].setPressure(this.phaseArray[0].getPressure());
        for (int i = 0; i < this.phaseArray[0].getNumberOfComponents(); ++i) {
            if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                this.phaseArray[3].addComponent("default", this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
                this.phaseArray[3].getComponent("default").setComponentName(this.getPhase(0).getComponent(i).getName());
                continue;
            }
            this.phaseArray[3].addComponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
        }
        this.setNumberOfPhases(4);
    }

    @Override
    public void addLiquidToGas(double fraction) {
        for (int i = 0; i < this.getPhase(0).getNumberOfComponents(); ++i) {
            double change = this.getPhase(1).getComponent(i).getNumberOfMolesInPhase() * fraction;
            this.addComponent(i, change, 0);
            this.addComponent(i, -change, 1);
        }
    }

    @Override
    public void addOilFractions(String[] charNames, double[] charFlowrate, double[] molarMass, double[] relativedensity, boolean lastIsPlusFraction) {
        this.addOilFractions(charNames, charFlowrate, molarMass, relativedensity, lastIsPlusFraction, true, 12);
    }

    @Override
    public void addOilFractions(String[] charNames, double[] charFlowrate, double[] molarMass, double[] relativedensity, boolean lastIsPlusFraction, boolean lumpComponents, int numberOfPseudoComponents) {
        int i;
        if (charNames.length != charFlowrate.length) {
            logger.error("component names and mole fractions need to be same length...");
        }
        for (i = 0; i < charNames.length - 1; ++i) {
            this.addTBPfraction(charNames[i], charFlowrate[i], molarMass[i], relativedensity[i]);
        }
        i = charNames.length - 1;
        if (lastIsPlusFraction) {
            this.addPlusFraction(charNames[i], charFlowrate[i], molarMass[i], relativedensity[i]);
        } else {
            this.addTBPfraction(charNames[i], charFlowrate[i], molarMass[i], relativedensity[i]);
        }
        this.createDatabase(true);
        if (lastIsPlusFraction) {
            this.getCharacterization().getLumpingModel().setNumberOfPseudoComponents(numberOfPseudoComponents);
            if (lumpComponents) {
                this.getCharacterization().setLumpingModel("PVTlumpingModel");
            } else {
                this.getCharacterization().setLumpingModel("no lumping");
            }
            this.getCharacterization().characterisePlusFraction();
        }
        this.setMixingRule(this.getMixingRule());
        this.setMultiPhaseCheck(true);
        this.init(0);
    }

    @Override
    public void addPhase() {
        ++this.numberOfPhases;
    }

    @Override
    public void addPhaseFractionToPhase(double fraction, String specification, String fromPhaseName, String toPhaseName) {
        if (!(this.hasPhaseType(fromPhaseName) && this.hasPhaseType(toPhaseName) || fraction < 1.0E-30)) {
            return;
        }
        int phaseNumbFrom = this.getPhaseNumberOfPhase(fromPhaseName);
        int phaseNumbTo = this.getPhaseNumberOfPhase(toPhaseName);
        for (int i = 0; i < this.getPhase(0).getNumberOfComponents(); ++i) {
            double change = this.getPhase(phaseNumbFrom).getComponent(i).getNumberOfMolesInPhase() * fraction;
            this.addComponent(i, change, phaseNumbTo);
            this.addComponent(i, -change, phaseNumbFrom);
        }
        this.init_x_y();
    }

    @Override
    public void addPhaseFractionToPhase(double fraction, String specification, String specifiedStream, String fromPhaseName, String toPhaseName) {
        double moleFraction = fraction;
        if (!this.hasPhaseType(fromPhaseName) || !this.hasPhaseType(toPhaseName) || fraction < 1.0E-30) {
            return;
        }
        int phaseNumbFrom = this.getPhaseNumberOfPhase(fromPhaseName);
        int phaseNumbTo = this.getPhaseNumberOfPhase(toPhaseName);
        if (specifiedStream.equals("feed")) {
            moleFraction = fraction;
        } else if (specifiedStream.equals("product")) {
            double test;
            double specFractionTo = this.getPhaseFraction(toPhaseName, specification);
            double moleFractionFrom = this.getMoleFraction(phaseNumbFrom);
            double moleFractionTo = this.getMoleFraction(phaseNumbTo);
            if (specification.equals("volume") || specification.equals("mass")) {
                test = fraction * specFractionTo / (fraction * specFractionTo + specFractionTo);
                moleFraction = test * moleFractionTo / specFractionTo;
            } else if (specification.equals("mole")) {
                moleFraction = test = fraction * moleFractionTo / (fraction * moleFractionTo + moleFractionTo);
            }
            moleFraction = moleFraction * moleFractionTo / moleFractionFrom;
            if (moleFraction > moleFractionFrom) {
                logger.debug("error in addPhaseFractionToPhase()...to low fraction in from phase");
                moleFraction = moleFractionFrom;
            }
        }
        for (int i = 0; i < this.getPhase(0).getNumberOfComponents(); ++i) {
            double change = 0.0;
            change = this.getPhase(phaseNumbFrom).getComponent(i).getNumberOfMolesInPhase() * moleFraction;
            this.addComponent(i, change, phaseNumbTo);
            this.addComponent(i, -change, phaseNumbFrom);
        }
        this.init_x_y();
    }

    @Override
    public void addPlusFraction(String componentName, double numberOfMoles, double molarMass, double density) {
        this.addTBPfraction(componentName, numberOfMoles, molarMass, density);
        componentName = componentName + "_PC";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.getPhase(i).getComponent(componentName).setIsPlusFraction(true);
            this.getPhase(i).getComponent(componentName).setCriticalViscosity(7.9483 * Math.sqrt(1000.0 * this.getPhase(i).getComponent(componentName).getMolarMass()) * Math.pow(this.getPhase(i).getComponent(componentName).getPC(), 0.6666666666666666) / Math.pow(this.getPhase(i).getComponent(componentName).getTC(), 0.16666666666666666) * 1.0E-7);
        }
    }

    @Override
    public void addSalt(String componentName, double value) {
        double val1 = 1.0E-20;
        double val2 = 1.0E-20;
        try (NeqSimDataBase database = new NeqSimDataBase();
             ResultSet dataSet = database.getResultSet("SELECT * FROM compsalt WHERE SaltName='" + componentName + "'");){
            dataSet.next();
            String name1 = dataSet.getString("ion1").trim();
            val1 = Double.parseDouble(dataSet.getString("stoc1")) * value;
            this.addComponent(name1, val1);
            String name2 = dataSet.getString("ion2").trim();
            val2 = Double.parseDouble(dataSet.getString("stoc2")) * value;
            this.addComponent(name2, val2);
            logger.info("ok adding salts. Ions: " + name1 + ", " + name2);
        }
        catch (Exception ex) {
            logger.error("failed ", (Throwable)ex);
        }
    }

    @Override
    public void addSolidComplexPhase(String type) {
        if (!this.multiPhaseCheck) {
            this.setMultiPhaseCheck(true);
        }
        this.addHydratePhase();
        this.phaseArray[5] = type.equalsIgnoreCase("wax") ? new PhaseWax() : new PhaseSolidComplex();
        this.phaseArray[5].setTemperature(this.phaseArray[0].getTemperature());
        this.phaseArray[5].setPressure(this.phaseArray[0].getPressure());
        this.phaseArray[5].setType(PhaseType.WAX);
        for (int i = 0; i < this.phaseArray[0].getNumberOfComponents(); ++i) {
            if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                this.phaseArray[5].addComponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
                this.phaseArray[5].getComponent(i).setIsPlusFraction(true);
                continue;
            }
            this.phaseArray[5].addComponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
        }
        ((PhaseSolid)this.phaseArray[5]).setSolidRefFluidPhase(this.phaseArray[0]);
        this.setNumberOfPhases(6);
    }

    public void addSolidPhase() {
        if (!this.multiPhaseCheck) {
            this.setMultiPhaseCheck(true);
        }
        this.phaseArray[3] = new PhasePureComponentSolid();
        this.phaseArray[3].setTemperature(this.phaseArray[0].getTemperature());
        this.phaseArray[3].setPressure(this.phaseArray[0].getPressure());
        for (int i = 0; i < this.phaseArray[0].getNumberOfComponents(); ++i) {
            if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                this.phaseArray[3].addComponent("default", this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
                this.phaseArray[3].getComponent(i).setComponentName(this.getPhase(0).getComponent(i).getName());
                this.phaseArray[3].getComponent(i).setIsPlusFraction(true);
                continue;
            }
            this.phaseArray[3].addComponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getNumberOfmoles(), i);
        }
        ((PhaseSolid)this.phaseArray[3]).setSolidRefFluidPhase(this.phaseArray[0]);
        if (this.getMaxNumberOfPhases() < 4) {
            this.setMaxNumberOfPhases(4);
        }
    }

    @Override
    public void addTBPfraction(String componentName, double numberOfMoles, double molarMass, double density) {
        if (density < 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "addTBPfraction", "density", "is negative."));
        }
        if (molarMass < 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "addTBPfraction", "molarMass", "is negative."));
        }
        SystemInterface refSystem = null;
        double TC = 0.0;
        double PC = 0.0;
        double m = 0.0;
        double TB = 0.0;
        double acs = 0.0;
        double racketZ = 0.0;
        componentName = componentName.split("_PC")[0] + "_PC";
        try {
            refSystem = (SystemInterface)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            refSystem.setTemperature(288.15);
            refSystem.setPressure(1.01325);
            refSystem.addComponent("default", 1.0, 273.15, 50.0, 0.1);
            refSystem.setMixingRule(1);
            refSystem.init(0);
            refSystem.setNumberOfPhases(1);
            refSystem.setPhaseType(0, PhaseType.LIQUID);
            molarMass = 1000.0 * molarMass;
            TC = this.characterization.getTBPModel().calcTC(molarMass, density);
            PC = this.characterization.getTBPModel().calcPC(molarMass, density);
            if (this.characterization.getTBPModel().isCalcm()) {
                m = this.characterization.getTBPModel().calcm(molarMass, density);
            }
            acs = this.characterization.getTBPModel().calcAcentricFactor(molarMass, density);
            TB = this.characterization.getTBPModel().calcTB(molarMass, density);
            molarMass /= 1000.0;
            for (int i = 0; i < refSystem.getNumberOfPhases(); ++i) {
                refSystem.getPhase(i).getComponent(0).setComponentName(componentName);
                refSystem.getPhase(i).getComponent(0).setMolarMass(molarMass);
                refSystem.getPhase(i).getComponent(0).setAcentricFactor(acs);
                refSystem.getPhase(i).getComponent(0).setTC(TC);
                refSystem.getPhase(i).getComponent(0).setPC(PC);
                refSystem.getPhase(i).getComponent(0).setComponentType("TBPfraction");
                refSystem.getPhase(i).getComponent(0).setIsTBPfraction(true);
                if (!this.characterization.getTBPModel().isCalcm()) continue;
                refSystem.getPhase(i).getComponent(0).getAttractiveTerm().setm(m);
                acs = refSystem.getPhase(i).getComponent(0).getAcentricFactor();
            }
            refSystem.setTemperature(288.15);
            refSystem.setPressure(1.01325);
            refSystem.init(1);
            racketZ = this.characterization.getTBPModel().calcRacketZ(refSystem, molarMass * 1000.0, density);
            refSystem.getPhase(0).getComponent(0).setRacketZ(racketZ);
        }
        catch (RuntimeException ex) {
            logger.error(ex.getMessage());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        double critVol = this.characterization.getTBPModel().calcCriticalVolume(molarMass * 1000.0, density);
        this.addComponent(componentName, numberOfMoles, TC, PC, acs);
        double Kwatson = Math.pow(TB * 1.8, 0.3333333333333333) / density;
        double CF = Math.pow((12.8 - Kwatson) * (10.0 - Kwatson) / (10.0 * acs), 2.0);
        double acsKeslerLee = acs;
        double cpa = (-0.33886 + 0.02827 * Kwatson - 0.26105 * CF + 0.59332 * acsKeslerLee * CF) * 4.18682 * molarMass * 1000.0;
        double cpb = (-(0.9291 - 1.1543 * Kwatson + 0.0368 * Kwatson * Kwatson) * 1.0E-4 + CF * (4.56 - 9.48 * acsKeslerLee) * 1.0E-4) * 4.18682 * molarMass * 1.8 * 1000.0;
        double cpc = (-1.6658E-7 + CF * (0.536 - 0.6828 * acsKeslerLee) * 1.0E-7) * 4.18682 * molarMass * 1.8 * 1.8 * 1000.0;
        double cpd = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.getPhase(i).setAttractiveTerm(this.attractiveTermNumber);
            this.getPhase(i).getComponent(componentName).setMolarMass(molarMass);
            this.getPhase(i).getComponent(componentName).setComponentType("TBPfraction");
            this.getPhase(i).getComponent(componentName).setNormalLiquidDensity(density);
            this.getPhase(i).getComponent(componentName).setNormalBoilingPoint(TB);
            this.getPhase(i).getComponent(componentName).setAcentricFactor(refSystem.getPhase(0).getComponent(0).getAcentricFactor());
            this.getPhase(i).getComponent(componentName).setCriticalVolume(critVol);
            this.getPhase(i).getComponent(componentName).setRacketZ(racketZ);
            this.getPhase(i).getComponent(componentName).setRacketZCPA(racketZ);
            this.getPhase(i).getComponent(componentName).setIsTBPfraction(true);
            this.getPhase(i).getComponent(componentName).setParachorParameter(this.characterization.getTBPModel().calcParachorParameter(molarMass, density));
            this.getPhase(i).getComponent(componentName).setCriticalViscosity(this.characterization.getTBPModel().calcCriticalViscosity(molarMass * 1000.0, density));
            this.getPhase(i).getComponent(componentName).setTriplePointTemperature(374.5 + 0.02617 * this.getPhase(i).getComponent(componentName).getMolarMass() * 1000.0 - 20172.0 / (this.getPhase(i).getComponent(componentName).getMolarMass() * 1000.0));
            this.getPhase(i).getComponent(componentName).setHeatOfFusion(0.5970399212878645 * this.getPhase(i).getComponent(componentName).getMolarMass() * 1000.0 * this.getPhase(i).getComponent(componentName).getTriplePointTemperature());
            this.getPhase(i).getComponent(componentName).setIdealGasEnthalpyOfFormation(-1462600.0 * molarMass - 47566.0);
            this.getPhase(i).getComponent(componentName).setCpA(cpa);
            this.getPhase(i).getComponent(componentName).setCpB(cpb);
            this.getPhase(i).getComponent(componentName).setCpC(cpc);
            this.getPhase(i).getComponent(componentName).setCpD(cpd);
        }
    }

    @Override
    public void addTBPfraction(String componentName, double numberOfMoles, double molarMass, double density, double criticalTemperature, double criticalPressure, double acentricFactor) {
        if (density < 0.0 || molarMass < 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "addTBPfraction", "density", "is negative."));
        }
        if (density < 0.0 || molarMass < 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "addTBPfraction", "molarMass", "is negative."));
        }
        SystemInterface refSystem = null;
        double TC = 0.0;
        double PC = 0.0;
        double m = 0.0;
        double TB = 0.0;
        double acs = 0.0;
        double racketZ = 0.0;
        componentName = componentName.split("_PC")[0] + "_PC";
        try {
            refSystem = (SystemInterface)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            refSystem.setTemperature(288.15);
            refSystem.setPressure(1.01325);
            refSystem.addComponent("default", 1.0, 273.15, 50.0, 0.1);
            refSystem.init(0);
            refSystem.setNumberOfPhases(1);
            refSystem.setPhaseType(0, PhaseType.LIQUID);
            molarMass = 1000.0 * molarMass;
            TC = criticalTemperature;
            PC = criticalPressure;
            m = this.characterization.getTBPModel().calcm(molarMass, density);
            acs = acentricFactor;
            TB = this.characterization.getTBPModel().calcTB(molarMass, density);
            molarMass /= 1000.0;
            for (int i = 0; i < refSystem.getNumberOfPhases(); ++i) {
                refSystem.getPhase(i).getComponent(0).setComponentName(componentName);
                refSystem.getPhase(i).getComponent(0).setMolarMass(molarMass);
                refSystem.getPhase(i).getComponent(0).setAcentricFactor(acs);
                refSystem.getPhase(i).getComponent(0).setTC(TC);
                refSystem.getPhase(i).getComponent(0).setPC(PC);
                refSystem.getPhase(i).getComponent(0).setComponentType("TBPfraction");
                refSystem.getPhase(i).getComponent(0).setIsTBPfraction(true);
                if (!this.characterization.getTBPModel().isCalcm()) continue;
                refSystem.getPhase(i).getComponent(0).getAttractiveTerm().setm(m);
                acs = refSystem.getPhase(i).getComponent(0).getAcentricFactor();
            }
            refSystem.setTemperature(288.15);
            refSystem.setPressure(1.01325);
            refSystem.init(1);
            racketZ = this.characterization.getTBPModel().calcRacketZ(refSystem, molarMass * 1000.0, density);
            refSystem.getPhase(0).getComponent(0).setRacketZ(racketZ);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        double critVol = this.characterization.getTBPModel().calcCriticalVolume(molarMass * 1000.0, density);
        this.addComponent(componentName, numberOfMoles, TC, PC, acs);
        double Kwatson = Math.pow(TB * 1.8, 0.3333333333333333) / density;
        double CF = Math.pow((12.8 - Kwatson) * (10.0 - Kwatson) / (10.0 * acs), 2.0);
        double acsKeslerLee = acs;
        double cpa = (-0.33886 + 0.02827 * Kwatson - 0.26105 * CF + 0.59332 * acsKeslerLee * CF) * 4.18682 * molarMass * 1000.0;
        double cpb = (-(0.9291 - 1.1543 * Kwatson + 0.0368 * Kwatson * Kwatson) * 1.0E-4 + CF * (4.56 - 9.48 * acsKeslerLee) * 1.0E-4) * 4.18682 * molarMass * 1.8 * 1000.0;
        double cpc = (-1.6658E-7 + CF * (0.536 - 0.6828 * acsKeslerLee) * 1.0E-7) * 4.18682 * molarMass * 1.8 * 1.8 * 1000.0;
        double cpd = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.getPhase(i).setAttractiveTerm(this.attractiveTermNumber);
            this.getPhase(i).getComponent(componentName).setMolarMass(molarMass);
            this.getPhase(i).getComponent(componentName).setComponentType("TBPfraction");
            this.getPhase(i).getComponent(componentName).setNormalLiquidDensity(density);
            this.getPhase(i).getComponent(componentName).setNormalBoilingPoint(TB);
            this.getPhase(i).getComponent(componentName).setAcentricFactor(refSystem.getPhase(0).getComponent(0).getAcentricFactor());
            this.getPhase(i).getComponent(componentName).setCriticalVolume(critVol);
            this.getPhase(i).getComponent(componentName).setRacketZ(racketZ);
            this.getPhase(i).getComponent(componentName).setRacketZCPA(racketZ);
            this.getPhase(i).getComponent(componentName).setIsTBPfraction(true);
            this.getPhase(i).getComponent(componentName).setParachorParameter(this.characterization.getTBPModel().calcParachorParameter(molarMass, density));
            this.getPhase(i).getComponent(componentName).setCriticalViscosity(this.characterization.getTBPModel().calcCriticalViscosity(molarMass * 1000.0, density));
            this.getPhase(i).getComponent(componentName).setTriplePointTemperature(374.5 + 0.02617 * this.getPhase(i).getComponent(componentName).getMolarMass() * 1000.0 - 20172.0 / (this.getPhase(i).getComponent(componentName).getMolarMass() * 1000.0));
            this.getPhase(i).getComponent(componentName).setHeatOfFusion(0.5970399212878645 * this.getPhase(i).getComponent(componentName).getMolarMass() * 1000.0 * this.getPhase(i).getComponent(componentName).getTriplePointTemperature());
            this.getPhase(i).getComponent(componentName).setIdealGasEnthalpyOfFormation(-1462600.0 * molarMass - 47566.0);
            this.getPhase(i).getComponent(componentName).setCpA(cpa);
            this.getPhase(i).getComponent(componentName).setCpB(cpb);
            this.getPhase(i).getComponent(componentName).setCpC(cpc);
            this.getPhase(i).getComponent(componentName).setCpD(cpd);
        }
    }

    @Override
    public void addToComponentNames(String postfix) {
        for (int j = 0; j < this.componentNames.size(); ++j) {
            this.componentNames.set(j, this.componentNames.get(j) + postfix);
        }
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            for (int j = 0; j < this.componentNames.size(); ++j) {
                this.getPhase(i).getComponent(j).setComponentName(this.getPhase(i).getComponent(j).getComponentName() + postfix);
            }
        }
    }

    @Override
    public boolean allowPhaseShift() {
        return this.allowPhaseShift;
    }

    @Override
    public void allowPhaseShift(boolean allowPhaseShift) {
        this.allowPhaseShift = allowPhaseShift;
    }

    @Override
    public void autoSelectMixingRule() {
        logger.info("setting mixing rule");
        if (this.modelName.equals("CPAs-SRK-EOS") || this.modelName.equals("CPA-SRK-EOS") || this.modelName.equals("Electrolyte-CPA-EOS-statoil") || this.modelName.equals("CPAs-SRK-EOS-statoil") || this.modelName.equals("Electrolyte-CPA-EOS")) {
            this.setMixingRule(10);
        } else if ((this.modelName.equals("ScRK-EOS-HV") || this.modelName.equals("SRK-EOS") || this.modelName.equals("ScRK-EOS")) && this.getPhase(0).hasComponent("water")) {
            this.setMixingRule(4);
        } else if (this.modelName.equals("PR-EOS")) {
            this.setMixingRule(2);
        } else if (this.modelName.equals("Electrolyte-ScRK-EOS")) {
            this.setMixingRule(4);
        } else if (this.modelName.equals("UMR-PRU-EoS") || this.modelName.equals("UMR-PRU-MC-EoS")) {
            this.setMixingRule("HV", "UNIFAC_UMRPRU");
        } else if (this.modelName.equals("GERG-water-EOS")) {
            this.setMixingRule(8);
        } else if (this.modelName.equals("GERG-2008-EOS")) {
            this.setMixingRule(2);
        } else if (this.modelName.equals("PC-SAFT")) {
            this.setMixingRule(8);
        } else {
            this.setMixingRule(2);
        }
    }

    @Override
    public SystemInterface autoSelectModel() {
        if (this.getPhase(0).hasComponent("MDEA") && this.getPhase(0).hasComponent("water") && this.getPhase(0).hasComponent("CO2")) {
            return this.setModel("Electrolyte-ScRK-EOS");
        }
        if (this.getPhase(0).hasComponent("water") || this.getPhase(0).hasComponent("methanol") || this.getPhase(0).hasComponent("MEG") || this.getPhase(0).hasComponent("TEG") || this.getPhase(0).hasComponent("ethanol") || this.getPhase(0).hasComponent("DEG")) {
            if (this.getPhase(0).hasComponent("Na+") || this.getPhase(0).hasComponent("K+") || this.getPhase(0).hasComponent("Br-") || this.getPhase(0).hasComponent("Mg++") || this.getPhase(0).hasComponent("Cl-") || this.getPhase(0).hasComponent("Ca++") || this.getPhase(0).hasComponent("Fe++") || this.getPhase(0).hasComponent("SO4--")) {
                logger.info("model elect");
                return this.setModel("Electrolyte-CPA-EOS-statoil");
            }
            return this.setModel("CPAs-SRK-EOS-statoil");
        }
        if (this.getPhase(0).hasComponent("water")) {
            return this.setModel("ScRK-EOS");
        }
        if (this.getPhase(0).hasComponent("mercury")) {
            return this.setModel("SRK-TwuCoon-Statoil-EOS");
        }
        logger.info("no model");
        return this.setModel("SRK-EOS");
    }

    @Override
    public final void calc_x_y() {
        for (int j = 0; j < this.numberOfPhases; ++j) {
            for (int i = 0; i < this.numberOfComponents; ++i) {
                if (j == 0) {
                    this.getPhase(j).getComponent(i).setx(this.getPhase(0).getComponent(i).getK() * this.getPhase(j).getComponent(i).getz() / (1.0 - this.beta[this.phaseIndex[0]] + this.beta[this.phaseIndex[0]] * this.getPhase(0).getComponent(i).getK()));
                    continue;
                }
                if (j != 1) continue;
                this.getPhase(j).getComponent(i).setx(this.getPhase(0).getComponent(i).getz() / (1.0 - this.beta[this.phaseIndex[0]] + this.beta[this.phaseIndex[0]] * this.getPhase(0).getComponent(i).getK()));
            }
            this.getPhase(j).normalize();
        }
    }

    @Override
    public final void calc_x_y_nonorm() {
        for (int j = 0; j < this.numberOfPhases; ++j) {
            for (int i = 0; i < this.numberOfComponents; ++i) {
                if (j == 0) {
                    this.getPhase(j).getComponent(i).setx(this.getPhase(j).getComponent(i).getK() * this.getPhase(j).getComponent(i).getz() / (1.0 - this.beta[this.phaseIndex[0]] + this.beta[this.phaseIndex[0]] * this.getPhase(0).getComponent(i).getK()));
                }
                if (j != 1) continue;
                this.getPhase(j).getComponent(i).setx(this.getPhase(0).getComponent(i).getz() / (1.0 - this.beta[this.phaseIndex[0]] + this.beta[this.phaseIndex[0]] * this.getPhase(0).getComponent(i).getK()));
            }
        }
    }

    @Override
    public double calcHenrysConstant(String component) {
        if (this.numberOfPhases != 2) {
            logger.error("Can't calculate Henrys constant - two phases must be present.");
            return 0.0;
        }
        int compNumb = this.getPhase(this.getPhaseIndex(0)).getComponent(component).getComponentNumber();
        double hc = this.getPhase(this.getPhaseIndex(0)).getFugacity(compNumb) / this.getPhase(this.getPhaseIndex(1)).getComponent(component).getx();
        return hc;
    }

    @Override
    public void calcInterfaceProperties() {
        this.interfaceProp.init();
    }

    @Override
    public void calcKIJ(boolean ok) {
        EosMixingRuleHandler.calcEOSInteractionParameters = ok;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            ((PhaseEosInterface)this.getPhase(i)).getEosMixingRule().setCalcEOSInteractionParameters(ok);
        }
    }

    @Override
    public void changeComponentName(String name, String newName) {
        int i;
        for (i = 0; i < this.numberOfComponents; ++i) {
            if (!this.componentNames.get(i).equals(name)) continue;
            this.componentNames.set(i, newName);
        }
        for (i = 0; i < this.maxNumberOfPhases; ++i) {
            this.getPhase(i).getComponent(name).setComponentName(newName);
        }
    }

    @Override
    public boolean checkStability() {
        return this.checkStability;
    }

    @Override
    public void checkStability(boolean val) {
        this.checkStability = val;
    }

    @Override
    public void chemicalReactionInit() {
        this.chemicalReactionOperations = new ChemicalReactionOperations(this);
        this.chemicalSystem = this.chemicalReactionOperations.hasReactions();
    }

    @Override
    public void clearAll() {
        this.setTotalNumberOfMoles(0.0);
        this.phaseType[0] = PhaseType.GAS;
        this.phaseType[1] = PhaseType.LIQUID;
        this.numberOfComponents = 0;
        this.setNumberOfPhases(2);
        this.beta[0] = 1.0;
        this.beta[1] = 1.0;
        this.beta[2] = 1.0;
        this.beta[3] = 1.0;
        this.beta[4] = 1.0;
        this.beta[5] = 1.0;
        this.chemicalSystem = false;
        double oldTemp = this.phaseArray[0].getTemperature();
        double oldPres = this.phaseArray[0].getPressure();
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            try {
                this.phaseArray[i] = (PhaseInterface)this.phaseArray[i].getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                logger.error("err ", (Throwable)ex);
            }
            this.phaseArray[i].setTemperature(oldTemp);
            this.phaseArray[i].setPressure(oldPres);
        }
    }

    @Override
    public SystemThermo clone() {
        SystemThermo clonedSystem = null;
        try {
            clonedSystem = (SystemThermo)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        clonedSystem.beta = (double[])this.beta.clone();
        clonedSystem.attractiveTermNumber = this.attractiveTermNumber;
        clonedSystem.phaseType = (PhaseType[])this.phaseType.clone();
        clonedSystem.phaseIndex = (int[])this.phaseIndex.clone();
        clonedSystem.componentNames = new ArrayList<String>(this.componentNames);
        if (this.interfaceProp != null) {
            // empty if block
        }
        clonedSystem.characterization = this.characterization.clone();
        if (clonedSystem.waxCharacterisation != null) {
            clonedSystem.waxCharacterisation = this.waxCharacterisation.clone();
        }
        System.arraycopy(this.beta, 0, clonedSystem.beta, 0, this.beta.length);
        System.arraycopy(this.phaseType, 0, clonedSystem.phaseType, 0, this.phaseType.length);
        System.arraycopy(this.phaseIndex, 0, clonedSystem.phaseIndex, 0, this.phaseIndex.length);
        clonedSystem.phaseArray = (PhaseInterface[])this.phaseArray.clone();
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            clonedSystem.phaseArray[i] = this.phaseArray[i].clone();
        }
        return clonedSystem;
    }

    @Override
    public void createDatabase(boolean reset) {
        if (reset) {
            this.resetDatabase();
        }
        try (NeqSimDataBase database = new NeqSimDataBase();){
            String names = new String();
            for (int k = 0; k < this.getPhase(0).getNumberOfComponents() - 1; ++k) {
                names = names + "'" + this.getComponentNames()[k] + "', ";
            }
            names = names + "'" + this.getComponentNames()[this.getPhase(0).getNumberOfComponents() - 1] + "'";
            if (NeqSimDataBase.createTemporaryTables()) {
                database.execute("insert into comptemp SELECT * FROM comp WHERE name IN (" + names + ")");
                database.execute("insert into intertemp SELECT DISTINCT * FROM inter WHERE comp1 IN (" + names + ") AND comp2 IN (" + names + ")");
                database.execute("delete FROM intertemp WHERE comp1=comp2");
            }
            for (int phaseNum = 0; phaseNum < this.maxNumberOfPhases; ++phaseNum) {
                this.getPhase(phaseNum).setMixingRule(null);
            }
            for (int i = 0; i < this.numberOfComponents; ++i) {
                if (!this.getPhase(0).getComponent(i).isIsTBPfraction() && !this.getPhase(0).getComponent(i).isIsPlusFraction()) continue;
                this.getPhase(0).getComponent(i).insertComponentIntoDatabase("");
            }
        }
        catch (Exception ex) {
            logger.error("error in SystemThermo Class...createDatabase() method", (Throwable)ex);
        }
    }

    @Override
    public String[][] createTable(String name) {
        int i;
        this.initProperties();
        DecimalFormat nf = new DecimalFormat();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        nf.setDecimalFormatSymbols(symbols);
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        String[][] table = new String[this.getPhases()[0].getNumberOfComponents() + 30][7];
        table[0][0] = "";
        for (i = 0; i < this.getPhases()[0].getNumberOfComponents() + 30; ++i) {
            for (int j = 0; j < 7; ++j) {
                table[i][j] = "";
            }
        }
        table[0][1] = "total";
        for (i = 0; i < this.numberOfPhases; ++i) {
            table[0][i + 2] = this.getPhase(i).getType().toString();
        }
        StringBuffer buf = new StringBuffer();
        FieldPosition test = new FieldPosition(0);
        for (int j = 0; j < this.getPhases()[0].getNumberOfComponents(); ++j) {
            buf = new StringBuffer();
            table[j + 1][1] = nf.format(this.getPhase(0).getComponent(j).getz(), buf, test).toString();
        }
        buf = new StringBuffer();
        table[this.getPhases()[0].getNumberOfComponents() + 4][1] = nf.format(this.getMolarMass(Units.getSymbol("Molar Mass")), buf, test).toString();
        buf = new StringBuffer();
        table[this.getPhases()[0].getNumberOfComponents() + 9][1] = nf.format(this.getEnthalpy(Units.getSymbol("enthalpy")), buf, test).toString();
        buf = new StringBuffer();
        table[this.getPhases()[0].getNumberOfComponents() + 10][1] = nf.format(this.getEntropy(Units.getSymbol("entropy")), buf, test).toString();
        for (int i2 = 0; i2 < this.numberOfPhases; ++i2) {
            for (int j = 0; j < this.getPhases()[0].getNumberOfComponents(); ++j) {
                table[j + 1][0] = this.getPhases()[0].getComponent(j).getName();
                buf = new StringBuffer();
                table[j + 1][i2 + 2] = nf.format(this.getPhase(i2).getComponent(j).getx(), buf, test).toString();
                table[j + 1][6] = "[mole fraction]";
            }
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 2][0] = "Density";
            table[this.getPhases()[0].getNumberOfComponents() + 2][i2 + 2] = nf.format(this.getPhase(i2).getDensity(Units.activeUnits.get((Object)"density").symbol), buf, test).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 2][6] = Units.activeUnits.get((Object)"density").symbol;
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 3][0] = "Phase Fraction";
            table[this.getPhases()[0].getNumberOfComponents() + 3][i2 + 2] = nf.format(this.getPhase(i2).getBeta(), buf, test).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 3][6] = "[mole fraction]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 4][0] = "Molar Mass";
            table[this.getPhases()[0].getNumberOfComponents() + 4][i2 + 2] = nf.format(this.getPhase(i2).getMolarMass(Units.activeUnits.get((Object)"Molar Mass").symbol), buf, test).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 4][6] = Units.activeUnits.get((Object)"Molar Mass").symbol;
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 5][0] = "Z factor";
            table[this.getPhases()[0].getNumberOfComponents() + 5][i2 + 2] = nf.format(this.getPhase(i2).getZvolcorr(), buf, test).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 5][6] = "[-]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 6][0] = "Heat Capacity (Cp)";
            table[this.getPhases()[0].getNumberOfComponents() + 6][i2 + 2] = nf.format(this.getPhase(i2).getCp(Units.activeUnits.get((Object)"Heat Capacity (Cp)").symbol), buf, test).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 6][6] = Units.activeUnits.get((Object)"Heat Capacity (Cp)").symbol;
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 7][0] = "Heat Capacity (Cv)";
            table[this.getPhases()[0].getNumberOfComponents() + 7][i2 + 2] = nf.format(this.getPhase(i2).getCv(Units.activeUnits.get((Object)"Heat Capacity (Cv)").symbol), buf, test).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 7][6] = Units.activeUnits.get((Object)"Heat Capacity (Cv)").symbol;
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 8][0] = "Speed of Sound";
            table[this.getPhases()[0].getNumberOfComponents() + 8][i2 + 2] = nf.format(this.getPhase(i2).getSoundSpeed(Units.getSymbol("speed of sound")), buf, test).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 8][6] = Units.getSymbol("speed of sound");
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 9][0] = "Enthalpy";
            table[this.getPhases()[0].getNumberOfComponents() + 9][i2 + 2] = nf.format(this.getPhase(i2).getEnthalpy(Units.getSymbol("enthalpy")), buf, test).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 9][6] = Units.getSymbol("enthalpy");
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 10][0] = "Entropy";
            table[this.getPhases()[0].getNumberOfComponents() + 10][i2 + 2] = nf.format(this.getPhase(i2).getEntropy(Units.getSymbol("entropy")), buf, test).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 10][6] = Units.getSymbol("entropy");
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 11][0] = "JT coefficient";
            table[this.getPhases()[0].getNumberOfComponents() + 11][i2 + 2] = nf.format(this.getPhase(i2).getJouleThomsonCoefficient(Units.getSymbol("JT coefficient")), buf, test).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 11][6] = Units.getSymbol("JT coefficient");
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 13][0] = "Viscosity";
            table[this.getPhases()[0].getNumberOfComponents() + 13][i2 + 2] = nf.format(this.getPhase(i2).getViscosity(Units.getSymbol("viscosity")), buf, test).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 13][6] = Units.getSymbol("viscosity");
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 14][0] = "Thermal Conductivity";
            table[this.getPhases()[0].getNumberOfComponents() + 14][i2 + 2] = nf.format(this.getPhase(i2).getThermalConductivity(Units.getSymbol("thermal conductivity")), buf, test).toString();
            table[this.getPhases()[0].getNumberOfComponents() + 14][6] = Units.getSymbol("thermal conductivity");
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 15][0] = "Surface Tension";
            try {
                if (i2 < this.numberOfPhases - 1) {
                    table[this.getPhases()[0].getNumberOfComponents() + 15][2] = nf.format(this.getInterphaseProperties().getSurfaceTension(0, 1), buf, test).toString();
                    buf = new StringBuffer();
                    table[this.getPhases()[0].getNumberOfComponents() + 15][3] = nf.format(this.getInterphaseProperties().getSurfaceTension(0, 1), buf, test).toString();
                    buf = new StringBuffer();
                    if (i2 == 1) {
                        table[this.getPhases()[0].getNumberOfComponents() + 17][2] = nf.format(this.getInterphaseProperties().getSurfaceTension(0, 2), buf, test).toString();
                        buf = new StringBuffer();
                        table[this.getPhases()[0].getNumberOfComponents() + 17][4] = nf.format(this.getInterphaseProperties().getSurfaceTension(0, 2), buf, test).toString();
                        table[this.getPhases()[0].getNumberOfComponents() + 17][6] = "[N/m]";
                    }
                    if (i2 == 1) {
                        buf = new StringBuffer();
                        table[this.getPhases()[0].getNumberOfComponents() + 16][3] = nf.format(this.getInterphaseProperties().getSurfaceTension(1, 2), buf, test).toString();
                        buf = new StringBuffer();
                        table[this.getPhases()[0].getNumberOfComponents() + 16][4] = nf.format(this.getInterphaseProperties().getSurfaceTension(1, 2), buf, test).toString();
                        table[this.getPhases()[0].getNumberOfComponents() + 16][6] = "[N/m]";
                    }
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            table[this.getPhases()[0].getNumberOfComponents() + 15][6] = "[N/m]";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 19][0] = "Pressure";
            table[this.getPhases()[0].getNumberOfComponents() + 19][i2 + 2] = Double.toString(this.getPhase(i2).getPressure(Units.getSymbol("pressure")));
            table[this.getPhases()[0].getNumberOfComponents() + 19][6] = Units.getSymbol("pressure");
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 20][0] = "Temperature";
            table[this.getPhases()[0].getNumberOfComponents() + 20][i2 + 2] = Double.toString(this.getPhase(i2).getTemperature(Units.getSymbol("temperature")));
            table[this.getPhases()[0].getNumberOfComponents() + 20][6] = Units.getSymbol("temperature");
            Double.toString(this.getPhase(i2).getTemperature());
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 22][0] = "Model";
            table[this.getPhases()[0].getNumberOfComponents() + 22][i2 + 2] = this.getModelName();
            table[this.getPhases()[0].getNumberOfComponents() + 22][6] = "-";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 23][0] = "Mixing Rule";
            try {
                table[this.getPhases()[0].getNumberOfComponents() + 23][i2 + 2] = ((PhaseEosInterface)this.getPhase(i2)).getMixingRuleName();
            }
            catch (Exception ex) {
                table[this.getPhases()[0].getNumberOfComponents() + 23][i2 + 2] = "?";
            }
            table[this.getPhases()[0].getNumberOfComponents() + 23][6] = "-";
            buf = new StringBuffer();
            table[this.getPhases()[0].getNumberOfComponents() + 25][0] = "Stream";
            table[this.getPhases()[0].getNumberOfComponents() + 25][i2 + 2] = name;
            table[this.getPhases()[0].getNumberOfComponents() + 25][6] = "-";
        }
        this.resultTable = table;
        return table;
    }

    @Override
    public void addTBPfraction2(String componentName, double numberOfMoles, double molarMass, double boilingPoint) {
        if (boilingPoint <= 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "addTBPfraction2", "boilingPoint", "must be positive."));
        }
        if (molarMass <= 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "addTBPfraction2", "molarMass", "must be positive."));
        }
        double density = this.calculateDensityFromBoilingPoint(molarMass, boilingPoint);
        this.addTBPfraction(componentName, numberOfMoles, molarMass, density);
    }

    @Override
    public double calculateDensityFromBoilingPoint(double molarMass, double boilingPoint) {
        double TB = boilingPoint;
        double lower = 0.5;
        double upper = 1.5;
        double tolerance = 1.0E-5;
        int maxIterations = 1000;
        double density = 0.8;
        double calculated_density = 0.0;
        double fmidOLD = 9999.0;
        double lowerOLD = 0.1;
        double upperOLD = 1.5;
        for (int i = 0; i < maxIterations; ++i) {
            density = 0.5 * (lower + upper);
            double calculated_TB = this.characterization.getTBPModel().calcTB(molarMass * 1000.0, density);
            double f_mid = calculated_TB - TB;
            if (Math.abs(f_mid) < tolerance) {
                return calculated_density;
            }
            if (Math.abs(lower - upper) < tolerance) {
                return calculated_density;
            }
            if (f_mid < 0.0) {
                lowerOLD = lower;
                lower = density;
            } else {
                upperOLD = upper;
                upper = density;
            }
            if (!(Math.abs(f_mid) < Math.abs(fmidOLD))) continue;
            fmidOLD = f_mid;
            calculated_density = density;
        }
        return calculated_density;
    }

    @Override
    public void addTBPfraction3(String componentName, double numberOfMoles, double density, double boilingPoint) {
        if (boilingPoint <= 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "addTBPfraction3", "boilingPoint", "must be positive."));
        }
        if (density <= 0.0) {
            throw new RuntimeException(new InvalidInputException(this, "addTBPfraction3", "density", "must be positive."));
        }
        double molarMass = this.calculateMolarMassFromDensityAndBoilingPoint(density, boilingPoint);
        this.addTBPfraction(componentName, numberOfMoles, molarMass, density);
    }

    @Override
    public double calculateMolarMassFromDensityAndBoilingPoint(double density, double boilingPoint) {
        double TB = boilingPoint;
        double lower = 0.01;
        double upper = 0.5;
        double tolerance = 1.0E-5;
        int maxIterations = 1000;
        double molarMass = 0.8;
        double calculatedMolarMass = 0.0;
        double fmidOLD = 9999.0;
        for (int i = 0; i < maxIterations; ++i) {
            molarMass = 0.5 * (lower + upper);
            double calculated_TB = this.characterization.getTBPModel().calcTB(molarMass * 1000.0, density);
            double f_mid = calculated_TB - TB;
            if (Math.abs(f_mid) < tolerance) {
                return calculatedMolarMass;
            }
            if (Math.abs(lower - upper) < tolerance) {
                return calculatedMolarMass;
            }
            if (f_mid < 0.0) {
                lower = molarMass;
            } else {
                upper = molarMass;
            }
            if (!(Math.abs(f_mid) < Math.abs(fmidOLD))) continue;
            fmidOLD = f_mid;
            calculatedMolarMass = molarMass;
        }
        return calculatedMolarMass;
    }

    @Override
    public void addTBPfraction4(String componentName, double numberOfMoles, double molarMass, double density, double boilingPoint) {
        this.characterization.getTBPModel().setBoilingPoint(boilingPoint);
        this.addTBPfraction(componentName, numberOfMoles, molarMass, density);
    }

    @Override
    public void deleteFluidPhase(int phaseNum) {
        for (int i = phaseNum; i < this.numberOfPhases; ++i) {
            this.phaseIndex[i] = this.phaseIndex[i + 1];
        }
        --this.numberOfPhases;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void display(String name) {
        if (this.getNumberOfComponents() == 0) {
            return;
        }
        JFrame dialog = new JFrame("System-Report");
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Object[] names = new String[]{"", "Feed", "Phase 1", "Phase 2", "Phase 3", "Phase 4", "Unit"};
        Object[][] table = this.createTable(name);
        JTable Jtab = new JTable(table, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.setSize(screenDimension.width / 2, screenDimension.height / 2);
        Jtab.setRowHeight(dialog.getHeight() / table.length);
        Jtab.setFont(new Font("Serif", 0, dialog.getHeight() / table.length - dialog.getHeight() / table.length / 10));
        dialog.setVisible(true);
    }

    @Override
    public boolean doMultiPhaseCheck() {
        return this.multiPhaseCheck;
    }

    @Override
    public final boolean doSolidPhaseCheck() {
        return this.solidPhaseCheck;
    }

    public double getAntoineVaporPressure(double temp) {
        return this.phaseArray[0].getAntoineVaporPressure(temp);
    }

    @Override
    public final double getBeta() {
        return this.beta[0];
    }

    @Override
    public final double getBeta(int phaseNum) {
        return this.beta[this.phaseIndex[phaseNum]];
    }

    @Override
    public String[] getCapeOpenProperties10() {
        return this.CapeOpenProperties10;
    }

    @Override
    public String[] getCapeOpenProperties11() {
        return this.CapeOpenProperties11;
    }

    @Override
    public String[] getCASNumbers() {
        String[] names = new String[this.numberOfComponents];
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            names[compNumb] = this.getPhase(0).getComponent(compNumb).getCASnumber();
        }
        return names;
    }

    @Override
    public Characterise getCharacterization() {
        return this.characterization;
    }

    @Override
    public ChemicalReactionOperations getChemicalReactionOperations() {
        return this.chemicalReactionOperations;
    }

    @Override
    public String[] getCompFormulaes() {
        String[] formula = new String[this.numberOfComponents];
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            formula[compNumb] = this.getPhase(0).getComponent(compNumb).getFormulae();
        }
        return formula;
    }

    @Override
    public String[] getCompIDs() {
        String[] ids = new String[this.numberOfComponents];
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            ids[compNumb] = Integer.toString(this.getPhase(0).getComponent(compNumb).getIndex());
        }
        return ids;
    }

    @Override
    public String[] getCompNames() {
        String[] names = new String[this.numberOfComponents];
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            names[compNumb] = this.getPhase(0).getComponent(compNumb).getComponentName();
        }
        return names;
    }

    @Override
    public String getComponentNameTag() {
        return this.componentNameTag;
    }

    @Override
    public double getCorrectedVolume() {
        double volume = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            volume += this.getPhase(i).getMolarMass() / this.getPhase(i).getPhysicalProperties().getDensity() * this.getPhase(i).getNumberOfMolesInPhase();
        }
        return volume;
    }

    @Override
    public double getCorrectedVolumeFraction(int phaseNumber) {
        return this.getPhase(phaseNumber).getCorrectedVolume() / this.getCorrectedVolume();
    }

    @Override
    public double getCp() {
        double cP = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            cP += this.getPhase(i).getCp();
        }
        return cP;
    }

    @Override
    public double getCp(String unit) {
        double refCp = this.getCp();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0;
                break;
            }
            case "btu/lbmole-F": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0 * 0.2388;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refCp * conversionFactor;
    }

    @Override
    public double getCv() {
        double cv = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            cv += this.getPhase(i).getCv();
        }
        return cv;
    }

    @Override
    public double getCv(String unit) {
        double refCv = this.getCv();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0;
                break;
            }
            case "btu/lbmole-F": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0 * 0.2388;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refCv * conversionFactor;
    }

    @Override
    public double getDensity() {
        double density = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            density += 100000.0 * (this.getPhase(i).getMolarMass() * this.beta[this.phaseIndex[i]] / this.getPhase(i).getMolarVolume());
        }
        return density;
    }

    @Override
    public double getDensity(String unit) {
        double density = 0.0;
        for (int i = 0; i < this.getNumberOfPhases(); ++i) {
            density += this.getPhase(i).getVolume() / this.getVolume() * this.getPhase(i).getPhysicalProperties().getDensity();
        }
        double refDensity = density;
        double conversionFactor = 1.0;
        switch (unit) {
            case "kg/m3": {
                conversionFactor = 1.0;
                break;
            }
            case "lb/ft3": {
                conversionFactor = 0.0624279606;
                break;
            }
            case "kg/Sm3": {
                return this.getMolarMass() * 101325.0 / 8.3144621 / 288.15;
            }
            case "mol/m3": {
                conversionFactor = 1.0 / this.getMolarMass();
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refDensity * conversionFactor;
    }

    public double getdPdVtn() {
        double dPdV = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            if (!this.isPhase(i)) continue;
            dPdV += this.getPhase(i).getdPdVTn();
        }
        return dPdV;
    }

    @Override
    public double getdVdPtn() {
        double dVdP = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            if (!this.isPhase(i)) continue;
            dVdP += 1.0 / this.getPhase(i).getdPdVTn();
        }
        return dVdP;
    }

    @Override
    public double getdVdTpn() {
        double dVdT = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            if (!this.isPhase(i)) continue;
            dVdT += -this.getPhase(i).getdPdTVn() / this.getPhase(i).getdPdVTn();
        }
        return dVdT;
    }

    @Override
    public SystemInterface getEmptySystemClone() {
        int phaseNumber = 0;
        SystemThermo newSystem = this.clone();
        for (int j = 0; j < this.getMaxNumberOfPhases(); ++j) {
            phaseNumber = j;
            for (int i = 0; i < this.getPhase(j).getNumberOfComponents(); ++i) {
                newSystem.getPhase(j).getComponent(i).setNumberOfmoles(this.getPhase(phaseNumber).getComponent(i).getNumberOfMolesInPhase() / 1.0E30);
                newSystem.getPhase(j).getComponent(i).setNumberOfMolesInPhase(this.getPhase(phaseNumber).getComponent(i).getNumberOfMolesInPhase() / 1.0E30);
            }
        }
        newSystem.setTotalNumberOfMoles(this.getPhase(phaseNumber).getNumberOfMolesInPhase() / 1.0E30);
        newSystem.init(0);
        return newSystem;
    }

    @Override
    public double getEnthalpy() {
        double enthalpy = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            enthalpy += this.getPhase(i).getEnthalpy();
        }
        return enthalpy;
    }

    @Override
    public double getEnthalpy(String unit) {
        double refEnthalpy = this.getEnthalpy();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J": {
                conversionFactor = 1.0;
                break;
            }
            case "Btu": {
                conversionFactor = 9.4781712E-4;
                break;
            }
            case "kJ/kmol": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / 1000.0;
                break;
            }
            case "J/mol": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0;
                break;
            }
            case "Btu/lbmol": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() * 0.429923;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refEnthalpy * conversionFactor;
    }

    @Override
    public double getEntropy() {
        double entropy = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            entropy += this.getPhase(i).getEntropy();
        }
        return entropy;
    }

    @Override
    public double getEntropy(String unit) {
        double refEntropy = this.getEntropy();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            case "kJ/molK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / 1000.0;
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0;
                break;
            }
            case "btu/lb-F": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0 * 0.2388;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refEntropy * conversionFactor;
    }

    @Override
    public double getExergy(double temperatureOfSurroundings) {
        double getExergy = this.getEnthalpy() - temperatureOfSurroundings * this.getEntropy();
        return getExergy;
    }

    @Override
    public double getExergy(double temperatureOfSurroundings, String exergyUnit) {
        double refExergy = this.getExergy(temperatureOfSurroundings);
        double conversionFactor = 1.0;
        switch (exergyUnit) {
            case "J": {
                conversionFactor = 1.0;
                break;
            }
            case "J/mol": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0;
                break;
            }
        }
        return refExergy * conversionFactor;
    }

    @Override
    public double getFlowRate(String flowunit) {
        if (flowunit.equals("kg/sec")) {
            return this.totalNumberOfMoles * this.getMolarMass();
        }
        if (flowunit.equals("kg/min")) {
            return this.totalNumberOfMoles * this.getMolarMass() * 60.0;
        }
        if (flowunit.equals("kg/hr")) {
            return this.totalNumberOfMoles * this.getMolarMass() * 3600.0;
        }
        if (flowunit.equals("kg/day")) {
            return this.totalNumberOfMoles * this.getMolarMass() * 3600.0 * 24.0;
        }
        if (flowunit.equals("m3/sec")) {
            this.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            return this.totalNumberOfMoles * this.getMolarMass() / this.getDensity("kg/m3");
        }
        if (flowunit.equals("m3/min")) {
            this.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            return this.totalNumberOfMoles * this.getMolarMass() * 60.0 / this.getDensity("kg/m3");
        }
        if (flowunit.equals("m3/hr")) {
            this.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            return this.totalNumberOfMoles * this.getMolarMass() * 3600.0 / this.getDensity("kg/m3");
        }
        if (flowunit.equals("idSm3/hr")) {
            return this.totalNumberOfMoles * this.getMolarMass() * 3600.0 / this.getIdealLiquidDensity("kg/m3");
        }
        if (flowunit.equals("gallons/min")) {
            this.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            return this.totalNumberOfMoles * this.getMolarMass() * 60.0 / this.getDensity("kg/m3") * 1000.0 / 3.78541178;
        }
        if (flowunit.equals("Sm3/sec")) {
            return this.totalNumberOfMoles * 8.3144621 * 288.15 / 101325.0;
        }
        if (flowunit.equals("Sm3/hr")) {
            return this.totalNumberOfMoles * 3600.0 * 8.3144621 * 288.15 / 101325.0;
        }
        if (flowunit.equals("Sm3/day")) {
            return this.totalNumberOfMoles * 3600.0 * 24.0 * 8.3144621 * 288.15 / 101325.0;
        }
        if (flowunit.equals("MSm3/day")) {
            return this.totalNumberOfMoles * 3600.0 * 24.0 * 8.3144621 * 288.15 / 101325.0 / 1000000.0;
        }
        if (flowunit.equals("MSm3/hr")) {
            return this.totalNumberOfMoles * 3600.0 * 8.3144621 * 288.15 / 101325.0 / 1000000.0;
        }
        if (flowunit.equals("mole/sec")) {
            return this.totalNumberOfMoles;
        }
        if (flowunit.equals("mole/min")) {
            return this.totalNumberOfMoles * 60.0;
        }
        if (flowunit.equals("mole/hr")) {
            return this.totalNumberOfMoles * 3600.0;
        }
        if (flowunit.equals("lbmole/hr")) {
            return this.totalNumberOfMoles * 3600.0 / 1000.0 * 2.205;
        }
        if (flowunit.equals("lb/hr")) {
            return this.totalNumberOfMoles * this.getMolarMass() * 60.0 * 2.20462262;
        }
        if (flowunit.equals("barrel/day")) {
            return this.totalNumberOfMoles * this.getMolarMass() * 60.0 * 2.20462262 * 0.068;
        }
        throw new RuntimeException("failed.. unit: " + flowunit + " not supported");
    }

    @Override
    public String getFluidInfo() {
        return this.fluidInfo;
    }

    @Override
    public String getFluidName() {
        return this.fluidName;
    }

    @Override
    public double getGamma() {
        return this.getCp() / this.getCv();
    }

    @Override
    public final PhaseInterface getGasPhase() {
        for (int phaseNum = 0; phaseNum < this.numberOfPhases; ++phaseNum) {
            if (this.phaseArray[this.phaseIndex[phaseNum]].getType() != PhaseType.GAS) continue;
            return this.phaseArray[phaseNum];
        }
        logger.info("No gas phase at current state.");
        return null;
    }

    @Override
    public double getGibbsEnergy() {
        double gibbsEnergy = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            gibbsEnergy += this.getPhase(i).getGibbsEnergy();
        }
        return gibbsEnergy;
    }

    @Override
    public double getHeatOfVaporization() {
        if (this.numberOfPhases < 2) {
            return 0.0;
        }
        return this.getPhase(0).getEnthalpy() / this.getPhase(0).getNumberOfMolesInPhase() - this.getPhase(1).getEnthalpy() / this.getPhase(1).getNumberOfMolesInPhase();
    }

    @Override
    public double getHelmholtzEnergy() {
        double helmholtzEnergy = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            helmholtzEnergy += this.getPhase(i).getHelmholtzEnergy();
        }
        return helmholtzEnergy;
    }

    @Override
    public boolean getHydrateCheck() {
        return this.hydrateCheck;
    }

    @Override
    public double getIdealLiquidDensity(String unit) {
        double normalLiquidDensity = 0.0;
        double molarMass = this.getMolarMass();
        for (int i = 0; i < this.getNumberOfComponents(); ++i) {
            normalLiquidDensity += this.getComponent(i).getNormalLiquidDensity() * this.getComponent(i).getz() * this.getComponent(i).getMolarMass() / molarMass;
        }
        switch (unit) {
            case "gr/cm3": {
                return normalLiquidDensity;
            }
            case "kg/m3": {
                return normalLiquidDensity * 1000.0;
            }
        }
        throw new RuntimeException("unit not supported " + unit);
    }

    @Override
    public double getInterfacialTension(int phase1, int phase2) {
        return this.interfaceProp.getSurfaceTension(phase1, phase2);
    }

    @Override
    public double getInterfacialTension(int phase1, int phase2, String unit) {
        return this.interfaceProp.getSurfaceTension(phase1, phase2, unit);
    }

    @Override
    public double getInterfacialTension(String phase1, String phase2) {
        if (this.hasPhaseType(phase1) && this.hasPhaseType(phase2)) {
            return this.interfaceProp.getSurfaceTension(this.getPhaseNumberOfPhase(phase1), this.getPhaseNumberOfPhase(phase2));
        }
        return Double.NaN;
    }

    @Override
    public double getInternalEnergy() {
        double internalEnergy = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            internalEnergy += this.getPhase(i).getInternalEnergy();
        }
        return internalEnergy;
    }

    @Override
    public double getInternalEnergy(String unit) {
        double refEnthalpy = this.getInternalEnergy();
        double conversionFactor = 1.0;
        switch (unit) {
            case "J": {
                conversionFactor = 1.0;
                break;
            }
            case "J/mole": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles() / this.getMolarMass() / 1000.0;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refEnthalpy * conversionFactor;
    }

    @Override
    public InterphasePropertiesInterface getInterphaseProperties() {
        return this.interfaceProp;
    }

    @Override
    public double getJouleThomsonCoefficient() {
        double JTcoef = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            JTcoef += this.getBeta(i) * this.getPhase(i).getJouleThomsonCoefficient();
        }
        return JTcoef;
    }

    @Override
    public double getJouleThomsonCoefficient(String unit) {
        double JTcoef = this.getJouleThomsonCoefficient();
        double conversionFactor = 1.0;
        switch (unit) {
            case "K/bar": {
                conversionFactor = 1.0;
                break;
            }
            case "C/bar": {
                conversionFactor = 1.0;
                break;
            }
            case "K/Pa": {
                conversionFactor = 1.0E-5;
                break;
            }
            case "F/psi": {
                conversionFactor = 0.12410563127720953;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return JTcoef * conversionFactor;
    }

    @Override
    public double getKappa() {
        return -this.getCp() / this.getCv() * this.getVolume() / this.getPressure() * this.getdPdVtn();
    }

    @Override
    public double getKinematicViscosity() {
        return this.getViscosity() / this.getDensity();
    }

    @Override
    public double getKinematicViscosity(String unit) {
        double refViscosity = this.getViscosity("kg/msec") / this.getDensity("kg/m3");
        double conversionFactor = 1.0;
        switch (unit) {
            case "m2/sec": {
                conversionFactor = 1.0;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refViscosity * conversionFactor;
    }

    @Override
    public final PhaseInterface getLiquidPhase() {
        for (int phaseNum = 0; phaseNum < this.numberOfPhases; ++phaseNum) {
            if (this.phaseArray[this.phaseIndex[phaseNum]].getType() != PhaseType.LIQUID) continue;
            return this.phaseArray[phaseNum];
        }
        logger.info("No liquid phase at current state.");
        return null;
    }

    @Override
    public double getLiquidVolume() {
        double totFlow = 0.0;
        for (int kj = 0; kj < this.numberOfPhases; ++kj) {
            if (this.getPhase(kj).getType() == PhaseType.GAS) continue;
            totFlow += this.getPhase(kj).getVolume();
        }
        return totFlow;
    }

    @Override
    public PhaseInterface getLowestGibbsEnergyPhase() {
        if (this.getPhase(0).getGibbsEnergy() < this.getPhase(1).getGibbsEnergy()) {
            return this.getPhase(0);
        }
        return this.getPhase(1);
    }

    @Override
    public double getMass(String unit) {
        double conversionFactor = 1.0;
        switch (unit) {
            case "kg": {
                conversionFactor = 1.0;
                break;
            }
            case "gr": {
                conversionFactor = 1000.0;
                break;
            }
            case "tons": {
                conversionFactor = 0.001;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return conversionFactor * this.getTotalNumberOfMoles() * this.getMolarMass();
    }

    @Override
    public int getMaxNumberOfPhases() {
        return this.maxNumberOfPhases;
    }

    @Override
    public MixingRuleTypeInterface getMixingRule() {
        return this.mixingRuleType;
    }

    @Override
    public String getMixingRuleName() {
        return ((PhaseEosInterface)this.getPhase(0)).getEosMixingRule().getName();
    }

    @Override
    public String getModelName() {
        return this.modelName;
    }

    @Override
    public double[] getMolarComposition() {
        PhaseInterface phase = this.getPhase(0);
        double[] comp = new double[phase.getNumberOfComponents()];
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            comp[compNumb] = phase.getComponent(compNumb).getz();
        }
        return comp;
    }

    @Override
    public double getMolarMass() {
        double tempVar = 0.0;
        for (int i = 0; i < this.phaseArray[0].getNumberOfComponents(); ++i) {
            tempVar += this.phaseArray[0].getComponent(i).getz() * this.phaseArray[0].getComponent(i).getMolarMass();
        }
        return tempVar;
    }

    @Override
    public double getMolarMass(String unit) {
        double refMolarMass = this.getMolarMass();
        double conversionFactor = 1.0;
        switch (unit) {
            case "kg/mol": {
                conversionFactor = 1.0;
                break;
            }
            case "gr/mol": {
                conversionFactor = 1000.0;
                break;
            }
            case "lbm/lbmol": {
                conversionFactor = 1000.0;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refMolarMass * conversionFactor;
    }

    @Override
    public double[] getMolarRate() {
        double[] comp = new double[this.getPhase(0).getNumberOfComponents()];
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            comp[compNumb] = this.getPhase(0).getComponent(compNumb).getNumberOfmoles();
        }
        return comp;
    }

    @Override
    public double getMolarVolume() {
        if (!this.isInitialized) {
            this.init(0);
        }
        if (!this.isBetaValid()) {
            logger.warn("getMolarVolume", (Object)"Calculation is wrong, as beta is not valid. Perform flash");
        }
        double volume = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            volume += this.beta[this.phaseIndex[i]] * this.getPhase(i).getMolarVolume();
        }
        return volume;
    }

    @Override
    public double getMolarVolume(String unit) {
        if (!this.isInitialized) {
            this.init(0);
        }
        if (!this.isBetaValid()) {
            logger.warn("getMolarVolume", (Object)"Calculation is wrong, as beta is not valid. Perform flash");
        }
        double volume = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            volume += this.beta[this.phaseIndex[i]] * this.getPhase(i).getMolarVolume(unit);
        }
        return volume;
    }

    @Override
    public double[] getMolecularWeights() {
        double[] mm = new double[this.numberOfComponents];
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            mm[compNumb] = this.getPhase(0).getComponent(compNumb).getMolarMass() * 1000.0;
        }
        return mm;
    }

    @Override
    public double getMoleFraction(int phaseNumber) {
        return this.getPhase(phaseNumber).getBeta();
    }

    @Override
    public double getMoleFractionsSum() {
        double sumz = 0.0;
        for (int i = 0; i < this.phaseArray[0].getNumberOfComponents(); ++i) {
            sumz += this.phaseArray[0].getComponent(i).getz();
        }
        return sumz;
    }

    @Override
    public double[] getNormalBoilingPointTemperatures() {
        double[] bt = new double[this.numberOfComponents];
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            bt[compNumb] = this.getPhase(0).getComponent(compNumb).getNormalBoilingPoint();
        }
        return bt;
    }

    @Override
    public int getNumberOfComponents() {
        return this.getComponentNames().length;
    }

    @Override
    public int getNumberOfOilFractionComponents() {
        int number = 0;
        for (int i = 0; i < this.getPhase(0).getNumberOfComponents(); ++i) {
            if (!this.getPhase(0).getComponent(i).isIsTBPfraction() && !this.getPhase(0).getComponent(i).isIsPlusFraction()) continue;
            ++number;
        }
        return number;
    }

    @Override
    public final int getNumberOfPhases() {
        return this.numberOfPhases;
    }

    @Override
    public int[] getOilFractionIDs() {
        int numb = this.getNumberOfOilFractionComponents();
        int[] IDs = new int[numb];
        for (int i = 0; i < numb; ++i) {
            if (!this.getPhase(0).getComponent(i).isIsTBPfraction() && !this.getPhase(0).getComponent(i).isIsPlusFraction()) continue;
            IDs[i] = this.getPhase(0).getComponent(i).getIndex();
        }
        return IDs;
    }

    @Override
    public double[] getOilFractionLiquidDensityAt25C() {
        int numb = this.getNumberOfOilFractionComponents();
        int[] indexes = this.getOilFractionIDs();
        double[] temp = new double[numb];
        for (int i = 0; i < numb; ++i) {
            temp[i] = this.getPhase(0).getComponentWithIndex(indexes[i]).getNormalLiquidDensity();
        }
        return temp;
    }

    @Override
    public double[] getOilFractionMolecularMass() {
        int numb = this.getNumberOfOilFractionComponents();
        int[] indexes = this.getOilFractionIDs();
        double[] temp = new double[numb];
        for (int i = 0; i < numb; ++i) {
            temp[i] = this.getPhase(0).getComponentWithIndex(indexes[i]).getMolarMass();
        }
        return temp;
    }

    @Override
    public double[] getOilFractionNormalBoilingPoints() {
        int numb = this.getNumberOfOilFractionComponents();
        int[] indexes = this.getOilFractionIDs();
        double[] temp = new double[numb];
        for (int i = 0; i < numb; ++i) {
            temp[i] = this.getPhase(0).getComponentWithIndex(indexes[i]).getNormalBoilingPoint();
        }
        return temp;
    }

    @Override
    public final double getPC() {
        return this.criticalPressure;
    }

    @Override
    public final PhaseInterface getPhase(int i) {
        if (i < 0) {
            throw new RuntimeException(new InvalidInputException(this, "getPhase", "i", i + " is not valid, must be in the range 0-" + this.getNumberOfPhases()));
        }
        if (i >= this.getNumberOfPhases() - 1 && this.phaseArray[this.phaseIndex[i]] == null) {
            throw new RuntimeException(new InvalidInputException(this, "getPhase", "i", " - Can not return phase number " + i + ". Current number of phases are " + this.getNumberOfPhases()));
        }
        return this.phaseArray[this.phaseIndex[i]];
    }

    @Override
    public PhaseInterface getPhase(PhaseType pt) {
        if (!this.hasPhaseType(pt)) {
            throw new RuntimeException("Phase with phase type " + (Object)((Object)pt) + " not found.");
        }
        int phaseNum = this.getPhaseNumberOfPhase(pt);
        if (phaseNum >= 0) {
            return this.getPhase(phaseNum);
        }
        return null;
    }

    @Override
    public PhaseInterface getPhase(String phaseTypeName) {
        PhaseType pt = PhaseType.byDesc(phaseTypeName);
        return this.getPhase(pt);
    }

    @Override
    public final double getPhaseFraction(String phaseTypeName, String unit) {
        int phaseNumber = this.getPhaseNumberOfPhase(phaseTypeName);
        switch (unit) {
            case "mole": {
                return this.getBeta(phaseNumber);
            }
            case "volume": {
                return this.getVolumeFraction(phaseNumber);
            }
            case "mass": {
                this.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
                return this.getVolumeFraction(phaseNumber) * this.getPhase(phaseNumber).getDensity("kg/m3") / this.getDensity("kg/m3");
            }
        }
        throw new RuntimeException("unit not supported " + unit);
    }

    @Override
    public final int getPhaseIndex(int index) {
        return this.phaseIndex[index];
    }

    @Override
    public int getPhaseIndex(PhaseInterface phase) {
        for (int i = 0; i < this.numberOfPhases; ++i) {
            if (this.getPhase(i) != phase) continue;
            return this.phaseIndex[i];
        }
        throw new RuntimeException(new InvalidInputException(this, "getPhaseIndex", "phase", "is not found in phaseArray."));
    }

    @Override
    public int getPhaseIndex(String phaseTypeName) {
        for (int i = 0; i < this.numberOfPhases; ++i) {
            if (!this.getPhase(i).getPhaseTypeName().equals(phaseTypeName)) continue;
            return this.phaseIndex[i];
        }
        return this.phaseIndex[0];
    }

    @Override
    public int getPhaseNumberOfPhase(PhaseType pt) {
        for (int i = 0; i < this.numberOfPhases; ++i) {
            if (this.getPhase(i).getType() != pt) continue;
            return i;
        }
        return 0;
    }

    @Override
    public PhaseInterface getPhaseOfType(String phaseTypeName) {
        for (int i = 0; i < this.numberOfPhases; ++i) {
            if (!this.getPhase(i).getPhaseTypeName().equals(phaseTypeName)) continue;
            return this.getPhase(i);
        }
        return null;
    }

    @Override
    public final PhaseInterface[] getPhases() {
        return this.phaseArray;
    }

    @Override
    public final double getPressure() {
        return this.phaseArray[0].getPressure();
    }

    @Override
    public final double getPressure(int phaseNumber) {
        return this.getPhase(this.phaseIndex[phaseNumber]).getPressure();
    }

    @Override
    public final double getPressure(String unit) {
        PressureUnit presConversion = new PressureUnit(this.getPressure(), "bara");
        return presConversion.getValue(unit);
    }

    @Override
    public SystemProperties getProperties() {
        return new SystemProperties(this);
    }

    @Override
    public double getProperty(String prop) {
        if (prop.equals("numberOfPhases")) {
            return this.numberOfPhases;
        }
        if (prop.equals("numberOfComponents")) {
            return this.numberOfComponents;
        }
        if (prop.equals("enthalpy")) {
            return this.getEnthalpy();
        }
        if (prop.equals("entropy")) {
            return this.getEntropy();
        }
        if (prop.equals("temperature")) {
            return this.getTemperature();
        }
        if (prop.equals("pressure")) {
            return this.getPressure();
        }
        return 1.0;
    }

    @Override
    public double getProperty(String prop, int phaseNum) {
        this.initPhysicalProperties();
        if (prop.equals("temperature")) {
            return this.getPhase(phaseNum).getTemperature();
        }
        if (prop.equals("pressure")) {
            return this.getPhase(phaseNum).getPressure();
        }
        if (prop.equals("compressibility")) {
            return this.getPhase(phaseNum).getZ();
        }
        if (prop.equals("density")) {
            return this.getPhase(phaseNum).getPhysicalProperties().getDensity();
        }
        if (prop.equals("beta")) {
            return this.getPhase(phaseNum).getBeta();
        }
        if (prop.equals("enthalpy")) {
            return this.getPhase(phaseNum).getEnthalpy();
        }
        if (prop.equals("entropy")) {
            return this.getPhase(phaseNum).getEntropy();
        }
        if (prop.equals("viscosity")) {
            return this.getPhase(phaseNum).getPhysicalProperties().getViscosity();
        }
        if (prop.equals("conductivity")) {
            return this.getPhase(phaseNum).getPhysicalProperties().getConductivity();
        }
        return 1.0;
    }

    @Override
    public double getProperty(String prop, String compName, int phaseNum) {
        if (prop.equals("molefraction")) {
            return this.getPhase(phaseNum).getComponent(compName).getx();
        }
        if (prop.equals("fugacitycoefficient")) {
            return this.getPhase(phaseNum).getComponent(compName).getFugacityCoefficient();
        }
        if (prop.equals("logfugdT")) {
            return this.getPhase(phaseNum).getComponent(compName).getdfugdt();
        }
        if (prop.equals("logfugdP")) {
            return this.getPhase(phaseNum).getComponent(compName).getdfugdp();
        }
        return 1.0;
    }

    @Override
    public String[][] getResultTable() {
        return this.resultTable;
    }

    @Override
    public double getSoundSpeed() {
        double soundspeed = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            soundspeed += this.getBeta(i) * this.getPhase(i).getSoundSpeed();
        }
        return soundspeed;
    }

    @Override
    public double getSoundSpeed(String unit) {
        double refVel = this.getSoundSpeed();
        double conversionFactor = 1.0;
        switch (unit) {
            case "m/s": {
                conversionFactor = 1.0;
                break;
            }
            case "km/hr": {
                conversionFactor = 3.6;
                break;
            }
            case "ft/sec": {
                conversionFactor = 3.280839895;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refVel * conversionFactor;
    }

    @Override
    public StandardInterface getStandard() {
        return this.standard;
    }

    @Override
    public StandardInterface getStandard(String standardName) {
        this.setStandard(standardName);
        return this.standard;
    }

    public final double getSumBeta() {
        double sum = 0.0;
        for (int k = 0; k < this.numberOfPhases; ++k) {
            sum += this.getBeta(k);
        }
        return sum;
    }

    public boolean isBetaValid() {
        return this.getSumBeta() > 0.999999999999 && this.getSumBeta() < 1.000000000001;
    }

    @Override
    public final double getTC() {
        return this.criticalTemperature;
    }

    @Override
    public final double getTemperature() {
        return this.phaseArray[0].getTemperature();
    }

    @Override
    public double getTemperature(int phaseNumber) {
        return this.getPhase(this.phaseIndex[phaseNumber]).getTemperature();
    }

    @Override
    public final double getTemperature(String unit) {
        TemperatureUnit tempConversion = new TemperatureUnit(this.getTemperature(), "K");
        return tempConversion.getValue(unit);
    }

    @Override
    public double getThermalConductivity() {
        double cond = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            cond += this.beta[this.phaseIndex[i]] * this.getPhase(i).getPhysicalProperties().getConductivity();
        }
        return cond;
    }

    @Override
    public double getThermalConductivity(String unit) {
        double refConductivity = this.getThermalConductivity();
        double conversionFactor = 1.0;
        switch (unit) {
            case "W/mK": 
            case "J/sec-m-K": {
                conversionFactor = 1.0;
                break;
            }
            case "W/cmK": {
                conversionFactor = 0.01;
                break;
            }
            case "Btu/hr-ft-F": {
                conversionFactor = 0.5781759824;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refConductivity * conversionFactor;
    }

    @Override
    public double getTotalNumberOfMoles() {
        return this.totalNumberOfMoles;
    }

    @Override
    public double getViscosity() {
        double visc = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            visc += this.beta[this.phaseIndex[i]] * this.getPhase(i).getPhysicalProperties().getViscosity();
        }
        return visc;
    }

    @Override
    public double getViscosity(String unit) {
        double refViscosity = this.getViscosity();
        double conversionFactor = 1.0;
        switch (unit) {
            case "kg/msec": {
                conversionFactor = 1.0;
                break;
            }
            case "cP": {
                conversionFactor = 1000.0;
                break;
            }
            case "Pas": {
                conversionFactor = 1.0;
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return refViscosity * conversionFactor;
    }

    @Override
    public final double getVolume() {
        double volume = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            volume += this.getPhase(i).getMolarVolume() * this.getPhase(i).getNumberOfMolesInPhase();
        }
        return volume;
    }

    @Override
    public double getVolume(String unit) {
        double conversionFactor = 1.0;
        switch (unit) {
            case "m3": {
                conversionFactor = 1.0;
                break;
            }
            case "m3/kg": {
                conversionFactor = 1.0 / this.getMass("kg");
                break;
            }
            case "litre": {
                conversionFactor = 1000.0;
                break;
            }
            case "m3/mol": {
                conversionFactor = 1.0 / this.getTotalNumberOfMoles();
                break;
            }
            default: {
                throw new RuntimeException("unit not supported " + unit);
            }
        }
        return conversionFactor * this.getVolume() / 100000.0;
    }

    @Override
    public double getVolumeFraction(int phaseNumber) {
        return this.getPhase(phaseNumber).getVolume() / this.getVolume();
    }

    @Override
    public WaxCharacterise getWaxCharacterisation() {
        return this.waxCharacterisation;
    }

    @Override
    public WaxModelInterface getWaxModel() {
        if (this.waxCharacterisation == null) {
            this.waxCharacterisation = new WaxCharacterise(this);
        }
        return this.waxCharacterisation.getModel();
    }

    @Override
    public double getWtFraction(int phaseNumber) {
        return this.getPhase(phaseNumber).getWtFraction(this);
    }

    @Override
    public double getZ() {
        double Z = 0.0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            Z += this.beta[this.phaseIndex[i]] * this.getPhase(i).getZ();
        }
        return Z;
    }

    @Override
    public double getZvolcorr() {
        return this.getPressure("Pa") * this.getMolarMass() / 8.3144621 / this.getTemperature() / this.getDensity("kg/m3");
    }

    @Override
    public boolean hasPhaseType(PhaseType pt) {
        for (int i = 0; i < this.numberOfPhases; ++i) {
            if (this.getPhase(i) == null) continue;
            if (this.getPhase(i).getType() == pt) {
                return true;
            }
            if (!this.getPhase(i).getPhaseTypeName().equals(pt.getDesc())) continue;
            logger.error("Bug in setting phasetype somewhere. Phasetype and phasetypename should be the same.");
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPlusFraction() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.getPhase(0).getComponent(i).isIsPlusFraction()) continue;
            return true;
        }
        return false;
    }

    public boolean hasTBPFraction() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.getPhase(0).getComponent(i).isIsTBPfraction()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void init(int initType) {
        if (!this.isInitialized) {
            this.initBeta();
            this.init_x_y();
        }
        if (this.numericDerivatives) {
            this.initNumeric(initType);
        } else {
            this.initAnalytic(initType);
        }
        this.isInitialized = true;
    }

    @Override
    public void init(int type, int phaseNum) {
        if (this.numericDerivatives) {
            this.initNumeric(type, phaseNum);
        } else {
            this.initAnalytic(type, phaseNum);
        }
    }

    @Override
    public final void init_x_y() {
        for (int j = 0; j < this.numberOfPhases; ++j) {
            for (int i = 0; i < this.numberOfComponents; ++i) {
                this.getPhase(j).getComponent(i).setz(this.getPhase(j).getComponent(i).getNumberOfmoles() / this.getTotalNumberOfMoles());
                this.getPhase(j).getComponent(i).setx(this.getPhase(j).getComponent(i).getNumberOfMolesInPhase() / this.getPhase(j).getNumberOfMolesInPhase());
            }
            this.getPhase(j).normalize();
        }
    }

    public void initAnalytic(int type) {
        int j;
        int i;
        if (type == 0) {
            this.reInitPhaseInformation();
            for (i = 0; i < this.getMaxNumberOfPhases(); ++i) {
                if (!this.isPhase(i)) continue;
                this.getPhase(i).init(this.getTotalNumberOfMoles(), this.numberOfComponents, type, this.phaseType[this.phaseIndex[i]], this.beta[this.phaseIndex[i]]);
            }
            this.setNumberOfPhases(2);
        }
        if (type > 0) {
            for (i = 0; i < this.numberOfPhases; ++i) {
                if (!this.isPhase(i)) continue;
                this.getPhase(i).init(this.getTotalNumberOfMoles(), this.numberOfComponents, Math.min(3, type), this.phaseType[this.phaseIndex[i]], this.beta[this.phaseIndex[i]]);
            }
            for (i = 0; i < this.numberOfPhases; ++i) {
                if (!this.isPhase(i)) continue;
                for (j = 0; j < this.numberOfComponents; ++j) {
                    this.getPhase(i).getComponent(j).fugcoef(this.getPhase(i));
                }
            }
        }
        if (type == 4) {
            for (i = 0; i < this.numberOfPhases; ++i) {
                if (!this.isPhase(i)) continue;
                for (j = 0; j < this.numberOfComponents; ++j) {
                    this.getPhase(i).getComponent(j).fugcoefDiffTempNumeric(this.getPhase(i), this.numberOfComponents, this.getPhase(i).getTemperature(), this.getPhase(i).getPressure());
                    this.getPhase(i).getComponent(j).fugcoefDiffPresNumeric(this.getPhase(i), this.numberOfComponents, this.getPhase(i).getTemperature(), this.getPhase(i).getPressure());
                }
            }
        } else {
            if (type > 1) {
                for (i = 0; i < this.numberOfPhases; ++i) {
                    if (!this.isPhase(i)) continue;
                    for (j = 0; j < this.numberOfComponents; ++j) {
                        this.getPhase(i).getComponent(j).logfugcoefdT(this.getPhase(i));
                        this.getPhase(i).getComponent(j).logfugcoefdP(this.getPhase(i));
                    }
                }
            }
            if (type == 3) {
                for (i = 0; i < this.numberOfPhases; ++i) {
                    if (!this.isPhase(i)) continue;
                    for (j = 0; j < this.numberOfComponents; ++j) {
                        this.getPhase(i).getComponent(j).logfugcoefdN(this.getPhase(i));
                    }
                }
            }
        }
        for (i = 1; i < this.numberOfPhases; ++i) {
            if (!this.isPhase(i) || this.getPhase(i).getType() != PhaseType.GAS) continue;
            this.getPhase(i).setType(PhaseType.OIL);
        }
        this.isInitialized = true;
    }

    public void initAnalytic(int type, int phaseNum) {
        if (type == 0) {
            this.beta[0] = 1.0;
            this.phaseIndex[phaseNum] = phaseNum;
        }
        if (this.isPhase(phaseNum)) {
            int j;
            this.getPhase(phaseNum).init(this.getTotalNumberOfMoles(), this.numberOfComponents, type, this.phaseType[this.phaseIndex[phaseNum]], this.beta[this.phaseIndex[phaseNum]]);
            if (type > 0) {
                for (j = 0; j < this.numberOfComponents; ++j) {
                    this.getPhase(phaseNum).getComponent(j).fugcoef(this.getPhase(phaseNum));
                }
            }
            if (type > 1) {
                for (j = 0; j < this.numberOfComponents; ++j) {
                    this.getPhase(phaseNum).getComponent(j).logfugcoefdT(this.getPhase(phaseNum));
                    this.getPhase(phaseNum).getComponent(j).logfugcoefdP(this.getPhase(phaseNum));
                }
            }
            if (type > 2) {
                for (j = 0; j < this.numberOfComponents; ++j) {
                    this.getPhase(phaseNum).getComponent(j).logfugcoefdT(this.getPhase(phaseNum));
                    this.getPhase(phaseNum).getComponent(j).logfugcoefdP(this.getPhase(phaseNum));
                    this.getPhase(phaseNum).getComponent(j).logfugcoefdN(this.getPhase(phaseNum));
                }
            }
        }
        for (PhaseInterface tmpPhase : this.phaseArray) {
            if (tmpPhase == null || tmpPhase.getType() != PhaseType.GAS) continue;
            tmpPhase.setType(PhaseType.OIL);
        }
        this.isInitialized = true;
    }

    @Override
    public final void initBeta() {
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.beta[this.phaseIndex[i]] = this.getPhase(i).getNumberOfMolesInPhase() / this.getTotalNumberOfMoles();
        }
        if (!this.isInitialized && this.getSumBeta() < 0.999999999999 || this.getSumBeta() > 1.000000000001) {
            // empty if block
        }
    }

    @Override
    public void initNumeric() {
        int i;
        int i2;
        double[][] gasfug = new double[2][this.getPhases()[0].getNumberOfComponents()];
        double[][] liqfug = new double[2][this.getPhases()[0].getNumberOfComponents()];
        double[][] gasnumericDfugdt = new double[2][this.getPhases()[0].getNumberOfComponents()];
        double[][] liqnumericDfugdt = new double[2][this.getPhases()[0].getNumberOfComponents()];
        double[][] gasnumericDfugdp = new double[2][this.getPhases()[0].getNumberOfComponents()];
        double[][] liqnumericDfugdp = new double[2][this.getPhases()[0].getNumberOfComponents()];
        double[][][] gasnumericDfugdn = new double[2][this.getPhases()[0].getNumberOfComponents()][this.getPhases()[0].getNumberOfComponents()];
        double[][][] liqnumericDfugdn = new double[2][this.getPhases()[0].getNumberOfComponents()][this.getPhases()[0].getNumberOfComponents()];
        double dt = this.getTemperature() / 100000.0;
        this.setTemperature(this.getTemperature() + dt);
        this.init(1);
        for (i2 = 0; i2 < this.getPhases()[0].getNumberOfComponents(); ++i2) {
            gasfug[0][i2] = Math.log(this.getPhases()[0].getComponent(i2).getFugacityCoefficient());
            liqfug[0][i2] = Math.log(this.getPhases()[1].getComponent(i2).getFugacityCoefficient());
        }
        this.setTemperature(this.getTemperature() - 2.0 * dt);
        this.init(1);
        for (i2 = 0; i2 < this.getPhases()[0].getNumberOfComponents(); ++i2) {
            gasfug[1][i2] = Math.log(this.getPhases()[0].getComponent(i2).getFugacityCoefficient());
            liqfug[1][i2] = Math.log(this.getPhases()[1].getComponent(i2).getFugacityCoefficient());
            gasnumericDfugdt[0][i2] = (gasfug[0][i2] - gasfug[1][i2]) / (2.0 * dt);
            liqnumericDfugdt[0][i2] = (liqfug[0][i2] - liqfug[1][i2]) / (2.0 * dt);
            this.phaseArray[0].getComponent(i2).setdfugdt(gasnumericDfugdt[0][i2]);
            this.phaseArray[1].getComponent(i2).setdfugdt(liqnumericDfugdt[0][i2]);
        }
        this.setTemperature(this.getTemperature() + dt);
        double dp = this.getPressure() / 100000.0;
        this.setPressure(this.getPressure() + dp);
        this.init(1);
        for (i = 0; i < this.getPhases()[0].getNumberOfComponents(); ++i) {
            gasfug[0][i] = Math.log(this.getPhases()[0].getComponent(i).getFugacityCoefficient());
            liqfug[0][i] = Math.log(this.getPhases()[1].getComponent(i).getFugacityCoefficient());
        }
        this.setPressure(this.getPressure() - 2.0 * dp);
        this.init(1);
        for (i = 0; i < this.getPhases()[0].getNumberOfComponents(); ++i) {
            gasfug[1][i] = Math.log(this.getPhases()[0].getComponent(i).getFugacityCoefficient());
            liqfug[1][i] = Math.log(this.getPhases()[1].getComponent(i).getFugacityCoefficient());
            gasnumericDfugdp[0][i] = (gasfug[0][i] - gasfug[1][i]) / (2.0 * dp);
            liqnumericDfugdp[0][i] = (liqfug[0][i] - liqfug[1][i]) / (2.0 * dp);
            this.phaseArray[0].getComponent(i).setdfugdp(gasnumericDfugdp[0][i]);
            this.phaseArray[1].getComponent(i).setdfugdp(liqnumericDfugdp[0][i]);
        }
        this.setPressure(this.getPressure() + dp);
        this.init(1);
        for (int phaseNum = 0; phaseNum < 2; ++phaseNum) {
            for (int k = 0; k < this.getPhases()[0].getNumberOfComponents(); ++k) {
                int i3;
                double dn = this.getPhase(phaseNum).getComponent(k).getNumberOfMolesInPhase() / 1000000.0;
                if (dn < 1.0E-12) {
                    dn = 1.0E-12;
                }
                this.addComponent(k, dn, phaseNum);
                this.init_x_y();
                this.init(1);
                for (i3 = 0; i3 < this.getPhases()[0].getNumberOfComponents(); ++i3) {
                    liqfug[0][i3] = Math.log(this.getPhase(phaseNum).getComponent(i3).getFugacityCoefficient());
                }
                this.addComponent(k, -2.0 * dn, phaseNum);
                this.init_x_y();
                this.init(1);
                for (i3 = 0; i3 < this.getPhases()[0].getNumberOfComponents(); ++i3) {
                    liqfug[1][i3] = Math.log(this.getPhase(phaseNum).getComponent(i3).getFugacityCoefficient());
                }
                for (i3 = 0; i3 < this.getPhases()[0].getNumberOfComponents(); ++i3) {
                    if (phaseNum == 0) {
                        gasnumericDfugdn[0][k][i3] = (liqfug[0][i3] - liqfug[1][i3]) / (2.0 * dn);
                        this.phaseArray[0].getComponent(i3).setdfugdn(k, gasnumericDfugdn[0][k][i3]);
                        this.phaseArray[0].getComponent(i3).setdfugdx(k, gasnumericDfugdn[0][k][i3] * this.phaseArray[0].getNumberOfMolesInPhase());
                    }
                    if (phaseNum != 1) continue;
                    liqnumericDfugdn[0][k][i3] = (liqfug[0][i3] - liqfug[1][i3]) / (2.0 * dn);
                    this.phaseArray[1].getComponent(i3).setdfugdn(k, liqnumericDfugdn[0][k][i3]);
                    this.phaseArray[1].getComponent(i3).setdfugdx(k, liqnumericDfugdn[0][k][i3] * this.phaseArray[1].getNumberOfMolesInPhase());
                }
                this.addComponent(k, dn, phaseNum);
                this.init_x_y();
                this.init(1);
            }
        }
    }

    public void initNumeric(int type) {
        this.initNumeric(type, 1);
    }

    public void initNumeric(int initType, int phasen) {
        if (initType < 2) {
            this.initAnalytic(initType);
        } else {
            int i;
            int i2;
            double[][] gasfug = new double[2][this.getPhases()[0].getNumberOfComponents()];
            double[][] liqfug = new double[2][this.getPhases()[0].getNumberOfComponents()];
            double dt = this.getTemperature() / 1000000.0;
            this.setTemperature(this.getTemperature() + dt);
            this.init(1);
            for (i2 = 0; i2 < this.getPhases()[0].getNumberOfComponents(); ++i2) {
                gasfug[0][i2] = Math.log(this.getPhases()[0].getComponent(i2).getFugacityCoefficient());
                liqfug[0][i2] = Math.log(this.getPhases()[1].getComponent(i2).getFugacityCoefficient());
            }
            this.setTemperature(this.getTemperature() - 2.0 * dt);
            this.init(1);
            for (i2 = 0; i2 < this.getPhases()[0].getNumberOfComponents(); ++i2) {
                gasfug[1][i2] = Math.log(this.getPhases()[0].getComponent(i2).getFugacityCoefficient());
                liqfug[1][i2] = Math.log(this.getPhases()[1].getComponent(i2).getFugacityCoefficient());
            }
            for (i2 = 0; i2 < this.getPhases()[0].getNumberOfComponents(); ++i2) {
                this.getPhase(0).getComponent(i2).setdfugdt((gasfug[0][i2] - gasfug[1][i2]) / (2.0 * dt));
                this.getPhase(1).getComponent(i2).setdfugdt((liqfug[0][i2] - liqfug[1][i2]) / (2.0 * dt));
            }
            this.setTemperature(this.getTemperature() + dt);
            double dp = this.getPressure() / 1000000.0;
            this.setPressure(this.getPressure() + dp);
            this.init(1);
            for (i = 0; i < this.getPhases()[0].getNumberOfComponents(); ++i) {
                gasfug[0][i] = Math.log(this.getPhases()[0].getComponent(i).getFugacityCoefficient());
                liqfug[0][i] = Math.log(this.getPhases()[1].getComponent(i).getFugacityCoefficient());
            }
            this.setPressure(this.getPressure() - 2.0 * dp);
            this.init(1);
            for (i = 0; i < this.getPhases()[0].getNumberOfComponents(); ++i) {
                gasfug[1][i] = Math.log(this.getPhases()[0].getComponent(i).getFugacityCoefficient());
                liqfug[1][i] = Math.log(this.getPhases()[1].getComponent(i).getFugacityCoefficient());
            }
            for (i = 0; i < this.getPhases()[0].getNumberOfComponents(); ++i) {
                this.getPhase(0).getComponent(i).setdfugdp((gasfug[0][i] - gasfug[1][i]) / (2.0 * dp));
                this.getPhase(1).getComponent(i).setdfugdp((liqfug[0][i] - liqfug[1][i]) / (2.0 * dp));
            }
            this.setPressure(this.getPressure() + dp);
            this.init(1);
            if (initType == 3) {
                for (int phaseNum = 0; phaseNum < 2; ++phaseNum) {
                    for (int k = 0; k < this.getPhases()[0].getNumberOfComponents(); ++k) {
                        int i3;
                        double dn = this.getPhase(phaseNum).getComponent(k).getNumberOfMolesInPhase() / 1000000.0;
                        this.addComponent(k, dn, phaseNum);
                        this.init_x_y();
                        this.init(1);
                        for (i3 = 0; i3 < this.getPhases()[0].getNumberOfComponents(); ++i3) {
                            liqfug[0][i3] = Math.log(this.getPhase(phaseNum).getComponent(i3).getFugacityCoefficient());
                        }
                        this.addComponent(k, -2.0 * dn, phaseNum);
                        this.init_x_y();
                        this.init(1);
                        for (i3 = 0; i3 < this.getPhases()[0].getNumberOfComponents(); ++i3) {
                            liqfug[1][i3] = Math.log(this.getPhase(phaseNum).getComponent(i3).getFugacityCoefficient());
                        }
                        this.addComponent(k, dn, phaseNum);
                        this.init_x_y();
                        this.init(1);
                        for (i3 = 0; i3 < this.getPhases()[0].getNumberOfComponents(); ++i3) {
                            this.getPhase(phaseNum).getComponent(k).setdfugdn(i3, (liqfug[0][i3] - liqfug[1][i3]) / (2.0 * dn));
                            this.getPhase(phaseNum).getComponent(k).setdfugdx(i3, (liqfug[0][i3] - liqfug[1][i3]) / (2.0 * dn) * this.getPhase(phaseNum).getNumberOfMolesInPhase());
                        }
                    }
                }
            }
        }
        this.isInitialized = true;
    }

    @Override
    public void initPhysicalProperties() {
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.getPhase(i).initPhysicalProperties();
        }
        this.calcInterfaceProperties();
    }

    @Override
    public void initPhysicalProperties(PhysicalPropertyType ppt) {
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.getPhase(i).initPhysicalProperties(ppt);
        }
    }

    @Override
    public void initRefPhases() {
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.getPhase(i).initRefPhases(false);
        }
    }

    @Override
    public final void initTotalNumberOfMoles(double change) {
        this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() + change);
        for (int j = 0; j < this.numberOfPhases; ++j) {
            for (int i = 0; i < this.numberOfComponents; ++i) {
                this.getPhase(j).getComponent(i).setNumberOfmoles(this.phaseArray[this.phaseIndex[0]].getComponent(i).getNumberOfmoles());
            }
        }
    }

    @Override
    public final boolean isChemicalSystem() {
        return this.chemicalSystem;
    }

    @Override
    public final void isChemicalSystem(boolean temp) {
        this.chemicalSystem = temp;
    }

    @Override
    public boolean isForcePhaseTypes() {
        return this.forcePhaseTypes;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public boolean isImplementedCompositionDeriativesofFugacity() {
        return this.implementedCompositionDeriativesofFugacity;
    }

    @Override
    public void isImplementedCompositionDeriativesofFugacity(boolean isImpl) {
        this.implementedCompositionDeriativesofFugacity = isImpl;
    }

    @Override
    public boolean isImplementedPressureDeriativesofFugacity() {
        return this.implementedPressureDeriativesofFugacity;
    }

    @Override
    public boolean isImplementedTemperatureDeriativesofFugacity() {
        return this.implementedTemperatureDeriativesofFugacity;
    }

    @Override
    public boolean isMultiphaseWaxCheck() {
        return this.multiphaseWaxCheck;
    }

    @Override
    public boolean isNumericDerivatives() {
        return this.numericDerivatives;
    }

    @Override
    public boolean isPhase(int i) {
        if (i > this.phaseArray.length) {
            return false;
        }
        return this.phaseArray[this.phaseIndex[i]] != null;
    }

    @Override
    public void normalizeBeta() {
        int i;
        double tot = 0.0;
        for (i = 0; i < this.numberOfPhases; ++i) {
            tot += this.beta[this.phaseIndex[i]];
        }
        for (i = 0; i < this.numberOfPhases; ++i) {
            int n = this.phaseIndex[i];
            this.beta[n] = this.beta[n] / tot;
        }
    }

    @Override
    public void orderByDensity() {
        int i;
        boolean change = false;
        for (i = 0; i < this.getNumberOfPhases(); ++i) {
            if (this.getPhase(i).getPhysicalProperties() == null) {
                this.getPhase(i).initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
            }
            this.getPhase(i).getPhysicalProperties().setPhase(this.getPhase(i));
        }
        do {
            change = false;
            for (i = 1; i < this.getNumberOfPhases() && i != 4; ++i) {
                try {
                    if (change || this.getPhase(i).getPhysicalProperties() == null) {
                        this.getPhase(i).initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
                    }
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage());
                }
                if (!(this.getPhase(i).getPhysicalProperties().calcDensity() < this.getPhase(i - 1).getPhysicalProperties().calcDensity())) continue;
                int tempIndex1 = this.getPhaseIndex(i - 1);
                int tempIndex2 = this.getPhaseIndex(i);
                this.setPhaseIndex(i, tempIndex1);
                this.setPhaseIndex(i - 1, tempIndex2);
                change = true;
            }
        } while (change);
    }

    @Override
    public SystemInterface phaseToSystem(int phaseNumber) {
        SystemThermo newSystem = this.clone();
        for (int j = 0; j < this.getMaxNumberOfPhases(); ++j) {
            for (int i = 0; i < this.getPhase(j).getNumberOfComponents(); ++i) {
                newSystem.getPhase(j).getComponent(i).setNumberOfmoles(this.getPhase(phaseNumber).getComponent(i).getNumberOfMolesInPhase());
                newSystem.getPhase(j).getComponent(i).setNumberOfMolesInPhase(this.getPhase(phaseNumber).getComponent(i).getNumberOfMolesInPhase());
            }
        }
        newSystem.setTotalNumberOfMoles(this.getPhase(phaseNumber).getNumberOfMolesInPhase());
        newSystem.init(0);
        newSystem.setNumberOfPhases(1);
        newSystem.setPhaseType(0, this.getPhase(phaseNumber).getType());
        newSystem.init(1);
        return newSystem;
    }

    @Override
    public SystemInterface phaseToSystem(int phaseNumber1, int phaseNumber2) {
        SystemThermo newSystem = this.clone();
        for (int j = 0; j < this.getMaxNumberOfPhases(); ++j) {
            for (int i = 0; i < this.getPhase(j).getNumberOfComponents(); ++i) {
                newSystem.getPhases()[j].getComponent(i).setNumberOfmoles(this.getPhase(phaseNumber1).getComponent(i).getNumberOfMolesInPhase() + this.getPhase(phaseNumber2).getComponent(i).getNumberOfMolesInPhase());
                newSystem.getPhases()[j].getComponent(i).setNumberOfMolesInPhase(this.getPhase(phaseNumber1).getComponent(i).getNumberOfMolesInPhase() + this.getPhase(phaseNumber2).getComponent(i).getNumberOfMolesInPhase());
            }
        }
        newSystem.setTotalNumberOfMoles(this.getPhase(phaseNumber1).getNumberOfMolesInPhase() + this.getPhase(phaseNumber2).getNumberOfMolesInPhase());
        newSystem.init(0);
        newSystem.setNumberOfPhases(1);
        newSystem.init(1);
        return newSystem;
    }

    @Override
    public SystemInterface phaseToSystem(PhaseInterface newPhase) {
        int i;
        for (i = 0; i < newPhase.getNumberOfComponents(); ++i) {
            newPhase.getComponent(i).setNumberOfmoles(newPhase.getComponent(i).getNumberOfMolesInPhase());
        }
        for (i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            this.phaseArray[i] = newPhase.clone();
        }
        this.setTotalNumberOfMoles(newPhase.getNumberOfMolesInPhase());
        this.init(0);
        this.setNumberOfPhases(1);
        this.setPhaseType(0, newPhase.getType());
        this.initBeta();
        this.init_x_y();
        this.init(1);
        return this;
    }

    @Override
    public SystemInterface phaseToSystem(String phaseName) {
        try {
            for (int j = 0; j < this.getMaxNumberOfPhases(); ++j) {
                if (!this.getPhase(j).getPhaseTypeName().equals(phaseName)) continue;
                return this.phaseToSystem(j);
            }
        }
        catch (Exception ex) {
            logger.error("error....." + this.fluidName + " has no phase .... " + phaseName + " ..... returning phase number 0");
        }
        return this.phaseToSystem(0);
    }

    @Override
    public void readFluid(String fluidName) {
        this.fluidName = fluidName;
        try {
            NeqSimFluidDataBase database = new NeqSimFluidDataBase();
            ResultSet dataSet = null;
            dataSet = database.getResultSet("SELECT * FROM " + fluidName);
            while (dataSet.next()) {
                String componentType = dataSet.getString("ComponentType");
                if (componentType.equalsIgnoreCase("normal")) {
                    this.addComponent(dataSet.getString("ComponentName"), Double.parseDouble(dataSet.getString("Rate")));
                    continue;
                }
                if (componentType.equalsIgnoreCase("TBP")) {
                    this.addTBPfraction(dataSet.getString("ComponentName"), Double.parseDouble(dataSet.getString("Rate")), Double.parseDouble(dataSet.getString("MolarMass")) / 1000.0, Double.parseDouble(dataSet.getString("Density")));
                    continue;
                }
                if (componentType.equalsIgnoreCase("plus")) {
                    this.addPlusFraction(dataSet.getString("ComponentName"), Double.parseDouble(dataSet.getString("Rate")), Double.parseDouble(dataSet.getString("MolarMass")) / 1000.0, Double.parseDouble(dataSet.getString("Density")));
                    continue;
                }
                logger.error("component type need to be specified for ... " + dataSet.getString("ComponentName"));
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemInterface readObject(int ID2) {
        SystemThermo tempSystem;
        block25: {
            ResultSet rs = null;
            tempSystem = null;
            NeqSimBlobDatabase database = new NeqSimBlobDatabase();
            try {
                Connection con = database.openConnection();
                String sqlStr = "SELECT FLUID FROM fluid_blobdb WHERE ID=" + Integer.toString(ID2);
                PreparedStatement ps = con.prepareStatement(sqlStr);
                rs = ps.executeQuery();
                if (!rs.next()) break block25;
                try (ObjectInputStream ins = new ObjectInputStream(new ByteArrayInputStream(rs.getBytes("FLUID")));){
                    tempSystem = (SystemThermo)ins.readObject();
                }
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            finally {
                try {
                    if (database.getStatement() != null) {
                        database.getStatement().close();
                    }
                    if (database.getConnection() != null) {
                        database.getConnection().close();
                    }
                }
                catch (Exception ex) {
                    logger.error("err closing database IN MIX...", (Throwable)ex);
                }
            }
        }
        return tempSystem;
    }

    @Override
    public SystemInterface readObjectFromFile(String filePath, String fluidName) {
        SystemThermo tempSystem = null;
        try (ObjectInputStream objectinputstream = new ObjectInputStream(new FileInputStream(filePath));){
            tempSystem = (SystemThermo)objectinputstream.readObject();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return tempSystem;
    }

    public void reInitPhaseInformation() {
        this.reInitPhaseType();
        this.phaseType[4] = this.phaseType[3];
        this.phaseType[5] = this.phaseType[3];
        for (int i = 0; i < 6; ++i) {
            this.beta[i] = 1.0;
        }
        this.phaseIndex = new int[]{0, 1, 2, 3, 4, 5};
    }

    @Override
    public void reInitPhaseType() {
        this.phaseType[0] = PhaseType.GAS;
        this.phaseType[1] = PhaseType.LIQUID;
        this.phaseType[2] = PhaseType.LIQUID;
        this.phaseType[3] = PhaseType.LIQUID;
    }

    @Override
    public void removeComponent(String name) {
        name = ComponentInterface.getComponentNameFromAlias(name);
        this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() - this.phaseArray[0].getComponent(name).getNumberOfmoles());
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            this.getPhase(i).removeComponent(name, this.getTotalNumberOfMoles(), this.getPhase(i).getComponent(name).getNumberOfMolesInPhase());
        }
        this.componentNames.remove(name);
        --this.numberOfComponents;
    }

    @Override
    public void removePhase(int specPhase) {
        int i;
        this.setTotalNumberOfMoles(this.getTotalNumberOfMoles() - this.getPhase(specPhase).getNumberOfMolesInPhase());
        for (int j = 0; j < this.numberOfPhases; ++j) {
            for (i = 0; i < this.numberOfComponents; ++i) {
                this.getPhase(j).getComponent(i).setNumberOfmoles(this.getPhase(j).getComponent(i).getNumberOfmoles() - this.getPhase(specPhase).getComponent(i).getNumberOfMolesInPhase());
            }
        }
        ArrayList<PhaseInterface> phaseList = new ArrayList<PhaseInterface>(0);
        for (i = 0; i < this.numberOfPhases; ++i) {
            if (specPhase == i) continue;
            phaseList.add(this.phaseArray[this.phaseIndex[i]]);
        }
        for (i = 0; i < this.numberOfPhases - 1; ++i) {
            if (i < specPhase) continue;
            this.phaseIndex[i] = this.phaseIndex[i + 1];
            this.phaseType[i] = this.phaseType[i + 1];
        }
        --this.numberOfPhases;
    }

    @Override
    public void removePhaseKeepTotalComposition(int specPhase) {
        int i;
        ArrayList<PhaseInterface> phaseList = new ArrayList<PhaseInterface>(0);
        for (i = 0; i < this.numberOfPhases; ++i) {
            if (specPhase == i) continue;
            phaseList.add(this.phaseArray[this.phaseIndex[i]]);
        }
        for (i = 0; i < this.numberOfPhases - 1; ++i) {
            if (i < specPhase) continue;
            this.phaseIndex[i] = this.phaseIndex[i + 1];
            this.phaseType[i] = this.phaseType[i + 1];
        }
        --this.numberOfPhases;
    }

    @Override
    public void renameComponent(String oldName, String newName) {
        this.componentNames.set(this.getPhase(0).getComponent(oldName).getComponentNumber(), newName);
        for (int i = 0; i < this.maxNumberOfPhases; ++i) {
            this.getPhase(i).getComponent(oldName).setComponentName(newName);
        }
    }

    @Override
    public void replacePhase(int repPhase, PhaseInterface newPhase) {
        for (int i = 0; i < 2; ++i) {
            this.phaseArray[i] = newPhase.clone();
        }
        this.setTotalNumberOfMoles(newPhase.getNumberOfMolesInPhase());
    }

    @Override
    public void reset() {
        this.init(0);
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.addComponent(this.getPhase(0).getComponent(i).getComponentName(), -this.getPhase(0).getComponent(i).getNumberOfMolesInPhase());
        }
    }

    @Override
    public void reset_x_y() {
        for (int j = 0; j < this.numberOfPhases; ++j) {
            for (int i = 0; i < this.numberOfComponents; ++i) {
                this.getPhase(j).getComponent(i).setx(this.phaseArray[this.phaseIndex[0]].getComponent(i).getz());
            }
        }
    }

    @Override
    public void resetCharacterisation() {
        int numberOfLumpedComps = this.characterization.getLumpingModel().getNumberOfLumpedComponents();
        this.characterization = new Characterise(this);
        this.characterization.getLumpingModel().setNumberOfLumpedComponents(numberOfLumpedComps);
    }

    @Override
    public void resetDatabase() {
        try (NeqSimDataBase database = new NeqSimDataBase();){
            if (NeqSimDataBase.createTemporaryTables()) {
                database.execute("delete FROM comptemp");
                database.execute("delete FROM intertemp");
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void resetPhysicalProperties() {
        for (PhaseInterface tmpPhase : this.phaseArray) {
            if (tmpPhase == null) continue;
            tmpPhase.resetPhysicalProperties();
        }
    }

    @Override
    public void save(String name) {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(name));){
            out.writeObject(this);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void saveFluid(int ID2) {
        this.saveObject(ID2, "");
    }

    @Override
    public void saveFluid(int ID2, String text) {
        this.saveObject(ID2, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveObject(int ID2, String text) {
        ByteArrayOutputStream fout = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(fout);){
            out.writeObject(this);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        byte[] byteObject = fout.toByteArray();
        ByteArrayInputStream inpStream = new ByteArrayInputStream(byteObject);
        NeqSimBlobDatabase database = new NeqSimBlobDatabase();
        try {
            Connection con = database.openConnection();
            PreparedStatement ps = con.prepareStatement("REPLACE INTO fluid_blobdb (ID, FLUID) VALUES (?,?)");
            ps.setInt(1, ID2);
            ps.setBlob(2, inpStream);
            ps.executeUpdate();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                if (database.getStatement() != null) {
                    database.getStatement().close();
                }
                if (database.getConnection() != null) {
                    database.getConnection().close();
                }
            }
            catch (Exception ex) {
                logger.error("err closing database IN MIX...", (Throwable)ex);
            }
        }
    }

    @Override
    public void saveObjectToFile(String filePath, String fluidName) {
        try (ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filePath, false));){
            out.writeObject(this);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void saveToDataBase() {
        try (NeqSimDataBase database = new NeqSimDataBase();){
            int j;
            String sqlString;
            int i;
            database.execute("delete FROM systemreport");
            for (i = 0; i < this.numberOfComponents; ++i) {
                sqlString = "'" + Integer.toString(i + 1) + "', '" + this.getPhase(0).getComponent(i).getName() + "', 'molfrac[-] ', '" + Double.toString(this.getPhase(0).getComponent(i).getz()) + "'";
                for (j = 0; j < this.numberOfPhases; ++j) {
                    sqlString = sqlString + ", '" + Double.toString(this.getPhase(j).getComponent(i).getx()) + "'";
                }
                while (j < 3) {
                    ++j;
                    sqlString = sqlString + ", '0'";
                }
                logger.error(sqlString);
                database.execute("INSERT INTO systemreport VALUES (" + sqlString + ")");
            }
            sqlString = "'" + Integer.toString(++i + 1) + "', 'PhaseFraction', '[-]', '1'";
            for (j = 0; j < this.numberOfPhases; ++j) {
                sqlString = sqlString + ", '" + Double.toString(this.getPhase(j).getBeta()) + "'";
            }
            while (j < 3) {
                ++j;
                sqlString = sqlString + ", '0'";
            }
            logger.error(sqlString);
            database.execute("INSERT INTO systemreport VALUES (" + sqlString + ")");
            sqlString = "'" + Integer.toString(++i + 1) + "', 'MolarMass', 'kg/mol ', '" + Double.toString(this.getMolarMass()) + "'";
            for (j = 0; j < this.numberOfPhases; ++j) {
                sqlString = sqlString + ", '" + Double.toString(this.getPhase(j).getMolarMass()) + "'";
            }
            while (j < 3) {
                ++j;
                sqlString = sqlString + ", '0'";
            }
            database.execute("INSERT INTO systemreport VALUES (" + sqlString + ")");
        }
        catch (Exception ex) {
            logger.error("failed ", (Throwable)ex);
        }
    }

    @Override
    public void setAllComponentsInPhase(int phaseNum) {
        for (int k = 0; k < this.numberOfPhases; ++k) {
            for (int i = 0; i < this.numberOfComponents; ++i) {
                if (phaseNum == k) continue;
                this.phaseArray[phaseNum].addMoles(i, this.phaseArray[k].getComponent(i).getNumberOfMolesInPhase() * 0.99);
                this.phaseArray[k].addMoles(i, -(this.phaseArray[k].getComponent(i).getNumberOfMolesInPhase() * 0.99));
                this.phaseArray[k].getComponent(i).setx(this.phaseArray[k].getComponent(i).getNumberOfMolesInPhase() / this.phaseArray[k].getNumberOfMolesInPhase());
            }
        }
        this.initBeta();
        this.init(1);
    }

    @Override
    public void setAttractiveTerm(int i) {
        for (int k = 0; k < this.getMaxNumberOfPhases(); ++k) {
            this.phaseArray[k].setAttractiveTerm(i);
        }
    }

    @Override
    public final void setBeta(double b) {
        if (b < 0.0) {
            logger.warn("setBeta - Tried to set beta < 0: " + this.beta);
            b = 1.0E-12;
        }
        if (b > 1.0) {
            logger.warn("setBeta - Tried to set beta > 1: " + this.beta);
            b = 0.999999999999;
        }
        this.beta[0] = b;
        this.beta[1] = 1.0 - b;
    }

    @Override
    public final void setBeta(int phaseNum, double b) {
        if (b < 0.0) {
            logger.warn("setBeta - Tried to set beta < 0: " + this.beta);
            b = 1.0E-12;
        }
        if (b > 1.0) {
            logger.warn("setBeta - Tried to set beta > 1: " + this.beta);
            b = 0.999999999999;
        }
        this.beta[this.phaseIndex[phaseNum]] = b;
    }

    @Override
    public void setBmixType(int bmixType) {
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            ((PhaseEosInterface)this.getPhase(i)).getEosMixingRule().setBmixType(bmixType);
        }
    }

    @Override
    public void setComponentNames(String[] componentNames) {
        for (int i = 0; i < componentNames.length; ++i) {
            this.componentNames.set(i, componentNames[i]);
        }
    }

    @Override
    public void setComponentNameTag(String nameTag) {
        this.componentNameTag = nameTag;
        for (int i = 0; i < this.getPhase(0).getNumberOfComponents(); ++i) {
            this.renameComponent(this.componentNames.get(i), this.componentNames.get(i) + nameTag);
        }
    }

    @Override
    public void setComponentNameTagOnNormalComponents(String nameTag) {
        this.componentNameTag = nameTag;
        for (int i = 0; i < this.getPhase(0).getNumberOfComponents(); ++i) {
            if (this.getPhase(0).getComponent(i).isIsTBPfraction() || this.getPhase(0).getComponent(i).isIsPlusFraction()) continue;
            this.renameComponent(this.componentNames.get(i), this.componentNames.get(i) + nameTag);
        }
    }

    @Override
    public void setEmptyFluid() {
        for (PhaseInterface tmpPhase : this.phaseArray) {
            if (tmpPhase == null) continue;
            tmpPhase.setEmptyFluid();
        }
        this.totalNumberOfMoles = 0.0;
    }

    @Override
    public void setFluidInfo(String info) {
        this.fluidInfo = info;
    }

    @Override
    public void setFluidName(String fluidName) {
        this.fluidName = fluidName;
    }

    @Override
    public void setForcePhaseTypes(boolean forcePhaseTypes) {
        this.forcePhaseTypes = forcePhaseTypes;
    }

    @Override
    public boolean setHeavyTBPfractionAsPlusFraction() {
        int i;
        int compNumber = 0;
        double molarMass = 0.0;
        boolean foundTBP = false;
        for (i = 0; i < this.numberOfComponents; ++i) {
            if (!this.getPhase(0).getComponent(i).isIsTBPfraction() && !this.getPhase(0).getComponent(i).isIsPlusFraction() || !(this.getPhase(0).getComponent(i).getMolarMass() > molarMass)) continue;
            molarMass = this.getPhase(0).getComponent(i).getMolarMass();
            compNumber = i;
            foundTBP = true;
        }
        if (foundTBP) {
            for (i = 0; i < this.maxNumberOfPhases; ++i) {
                this.getPhase(0).getComponent(compNumber).setIsPlusFraction(true);
            }
        }
        return foundTBP;
    }

    @Override
    public void setHydrateCheck(boolean hydrateCheck) {
        this.init(0);
        if (hydrateCheck) {
            this.addHydratePhase();
        }
        this.hydrateCheck = hydrateCheck;
        this.init(0);
    }

    @Override
    public void setImplementedCompositionDeriativesofFugacity(boolean implementedCompositionDeriativesofFugacity) {
        this.implementedCompositionDeriativesofFugacity = implementedCompositionDeriativesofFugacity;
    }

    @Override
    public void setImplementedPressureDeriativesofFugacity(boolean implementedPressureDeriativesofFugacity) {
        this.implementedPressureDeriativesofFugacity = implementedPressureDeriativesofFugacity;
    }

    @Override
    public void setImplementedTemperatureDeriativesofFugacity(boolean implementedTemperatureDeriativesofFugacity) {
        this.implementedTemperatureDeriativesofFugacity = implementedTemperatureDeriativesofFugacity;
    }

    public boolean setLastTBPasPlus() {
        PlusCharacterize temp = new PlusCharacterize(this);
        if (temp.hasPlusFraction()) {
            return false;
        }
        temp.setHeavyTBPtoPlus();
        return true;
    }

    @Override
    public void setMaxNumberOfPhases(int maxNumberOfPhases) {
        this.maxNumberOfPhases = maxNumberOfPhases;
    }

    @Override
    public final void setMixingRule(MixingRuleTypeInterface mr) {
        this.mixingRuleType = mr;
        if (this.numberOfPhases < 4) {
            this.resetPhysicalProperties();
        }
        for (int i = 0; i < this.maxNumberOfPhases; ++i) {
            if (!this.isPhase(i)) continue;
            this.getPhase(i).setMixingRule(mr);
            this.getPhase(i).initPhysicalProperties();
        }
    }

    @Override
    public void setMixingRule(String typename, String GEmodel) {
        this.setMixingRuleGEmodel(GEmodel);
        this.setMixingRule(typename);
    }

    public void setMixingRuleGEmodel(String name) {
        for (PhaseInterface tmpPhase : this.phaseArray) {
            if (tmpPhase == null) continue;
            tmpPhase.setMixingRuleGEModel(name);
        }
    }

    @Override
    public SystemInterface setModel(String model) {
        SystemEos tempModel = null;
        try {
            if (model.equals("SRK-EOS")) {
                tempModel = new SystemSrkEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("GERG2004-EOS")) {
                tempModel = new SystemGERG2004Eos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("PrEos") || model.equals("PR-EOS")) {
                tempModel = new SystemPrEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("ScRK-EOS") || model.equals("ScRK-EOS-HV")) {
                tempModel = new SystemSrkSchwartzentruberEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("Electrolyte-ScRK-EOS")) {
                tempModel = new SystemFurstElectrolyteEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("GERG-water-EOS")) {
                tempModel = new SystemGERGwaterEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("CPAs-SRK-EOS")) {
                tempModel = new SystemSrkCPAs(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("CPAs-SRK-EOS-statoil")) {
                tempModel = new SystemSrkCPAstatoil(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("Electrolyte-CPA-EOS-statoil") || model.equals("Electrolyte-CPA-EOS")) {
                tempModel = new SystemElectrolyteCPAstatoil(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("UMR-PRU-EoS")) {
                tempModel = new SystemUMRPRUMCEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("PC-SAFT")) {
                tempModel = new SystemPCSAFT(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("GERG-2008-EoS")) {
                tempModel = new SystemGERG2004Eos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("SRK-TwuCoon-Statoil-EOS") || model.equals("SRK-TwuCoon-EOS")) {
                tempModel = new SystemSrkTwuCoonStatoilEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("SRK-TwuCoon-Param-EOS")) {
                tempModel = new SystemSrkTwuCoonParamEos(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else if (model.equals("Duan-Sun")) {
                tempModel = new SystemDuanSun(this.getPhase(0).getTemperature(), this.getPhase(0).getPressure());
            } else {
                logger.error("model : " + model + " not defined.....");
            }
            tempModel.useVolumeCorrection(true);
            logger.info("created class " + tempModel);
            for (int i = 0; i < this.getPhase(0).getNumberOfComponents(); ++i) {
                logger.info("adding " + this.getPhase(0).getComponent(i).getName() + " moles " + this.getPhase(0).getComponent(i).getNumberOfmoles() + " isPlus " + this.getPhase(0).getComponent(i).isIsPlusFraction() + " isTBP " + this.getPhase(0).getComponent(i).isIsTBPfraction());
                if (this.getPhase(0).getComponent(i).isIsTBPfraction()) {
                    tempModel.addTBPfraction(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getMolarMass(), this.getPhase(0).getComponent(i).getNormalLiquidDensity());
                    continue;
                }
                if (this.getPhase(0).getComponent(i).isIsPlusFraction()) {
                    tempModel.addPlusFraction(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles(), this.getPhase(0).getComponent(i).getMolarMass(), this.getPhase(0).getComponent(i).getNormalLiquidDensity());
                    continue;
                }
                tempModel.addComponent(this.getPhase(0).getComponent(i).getName(), this.getPhase(0).getComponent(i).getNumberOfmoles());
            }
            if (NeqSimDataBase.createTemporaryTables()) {
                logger.info("done ... create database ......");
                tempModel.createDatabase(true);
            }
            logger.info("done ... set mixing rule ......");
            tempModel.autoSelectMixingRule();
            if (model.equals("Electrolyte-ScRK-EOS")) {
                logger.info("chemical reaction init......");
                tempModel.setMultiPhaseCheck(false);
                tempModel.chemicalReactionInit();
            } else {
                tempModel.setMultiPhaseCheck(true);
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return tempModel;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Override
    public void setMolarComposition(double[] molefractions) {
        this.setMolarFractions(molefractions, "");
    }

    @Override
    public void setMolarCompositionOfPlusFluid(double[] molefractions) {
        this.setMolarFractions(molefractions, "PlusFluid");
    }

    @Override
    public void setMolarCompositionPlus(double[] molefractions) {
        this.setMolarFractions(molefractions, "Plus");
    }

    @Override
    public void setMolarFlowRates(double[] moles) {
        this.setEmptyFluid();
        for (int compNumb = 0; compNumb < this.numberOfComponents; ++compNumb) {
            this.addComponent(compNumb, moles[compNumb]);
        }
        for (int i = 0; i < this.getNumberOfPhases(); ++i) {
            this.init(0, i);
        }
    }

    @Override
    public void setComponentFlowRates(double[] componentFlowRates, String unit) {
        String u;
        if (componentFlowRates == null || componentFlowRates.length != this.getNumberOfComponents()) {
            throw new IllegalArgumentException("Component flow rates array must have length equal to number of components.");
        }
        double[] molarFlows = new double[componentFlowRates.length];
        switch (u = unit == null ? "" : unit.trim().toLowerCase()) {
            case "mol/sec": {
                System.arraycopy(componentFlowRates, 0, molarFlows, 0, componentFlowRates.length);
                break;
            }
            case "kmol/sec": {
                int i;
                for (i = 0; i < componentFlowRates.length; ++i) {
                    molarFlows[i] = componentFlowRates[i] * 1000.0;
                }
                break;
            }
            case "kmol/hr": {
                int i;
                for (i = 0; i < componentFlowRates.length; ++i) {
                    molarFlows[i] = componentFlowRates[i] * 1000.0 / 3600.0;
                }
                break;
            }
            case "mol/hr": {
                int i;
                for (i = 0; i < componentFlowRates.length; ++i) {
                    molarFlows[i] = componentFlowRates[i] / 3600.0;
                }
                break;
            }
            case "kg/hr": {
                int i;
                for (i = 0; i < componentFlowRates.length; ++i) {
                    molarFlows[i] = componentFlowRates[i] / this.getComponent(i).getMolarMass() / 3600.0;
                }
                break;
            }
            case "kg/sec": {
                int i;
                for (i = 0; i < componentFlowRates.length; ++i) {
                    molarFlows[i] = componentFlowRates[i] / this.getComponent(i).getMolarMass();
                }
                break;
            }
            case "kmol/day": {
                int i;
                for (i = 0; i < componentFlowRates.length; ++i) {
                    molarFlows[i] = componentFlowRates[i] * 1000.0 / 86400.0;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported unit: " + unit);
            }
        }
        this.setEmptyFluid();
        for (int compNumb = 0; compNumb < this.getNumberOfComponents(); ++compNumb) {
            this.addComponent(compNumb, molarFlows[compNumb]);
        }
        for (int i = 0; i < this.getNumberOfPhases(); ++i) {
            this.init(0, i);
        }
    }

    private void setMolarFractions(double[] molefractions, String type) {
        double totalFlow = this.getTotalNumberOfMoles();
        if (totalFlow < 1.0E-100) {
            String msg = "must be larger than 0 (1e-100) when setting molar composition";
            throw new RuntimeException(new InvalidInputException(this, "setMolarComposition", "totalFlow", msg));
        }
        double sum = 0.0;
        for (double value : molefractions) {
            sum += value;
        }
        this.setEmptyFluid();
        switch (type) {
            case "PlusFluid": {
                int compNumb;
                for (compNumb = 0; compNumb < molefractions.length - 1; ++compNumb) {
                    this.addComponent(compNumb, totalFlow * molefractions[compNumb] / sum);
                }
                for (int j = 0; j < this.getCharacterization().getLumpingModel().getNumberOfLumpedComponents() - 1; ++j) {
                }
                break;
            }
            case "Plus": {
                int compNumb;
                for (compNumb = 0; compNumb < this.numberOfComponents - this.getCharacterization().getLumpingModel().getNumberOfLumpedComponents(); ++compNumb) {
                    this.addComponent(compNumb, totalFlow * molefractions[compNumb] / sum);
                }
                int ii = 0;
                for (int compNumb2 = this.numberOfComponents - this.getCharacterization().getLumpingModel().getNumberOfLumpedComponents(); compNumb2 < this.numberOfComponents; ++compNumb2) {
                    this.addComponent(compNumb2, totalFlow * this.getCharacterization().getLumpingModel().getFractionOfHeavyEnd(ii++) * molefractions[this.numberOfComponents - this.getCharacterization().getLumpingModel().getNumberOfLumpedComponents()] / sum);
                }
                break;
            }
            default: {
                for (int compNumb = 0; compNumb <= this.numberOfComponents - 1; ++compNumb) {
                    this.addComponent(compNumb, totalFlow * molefractions[compNumb] / sum);
                }
            }
        }
        for (int i = 0; i < this.getNumberOfPhases(); ++i) {
            this.init(0, i);
        }
    }

    @Override
    public void setMultiPhaseCheck(boolean multiPhaseCheck) {
        if (this.getMaxNumberOfPhases() < 3) {
            if (multiPhaseCheck) {
                this.setMaxNumberOfPhases(3);
                if (this.phaseArray[1] != null) {
                    this.phaseArray[2] = this.phaseArray[1].clone();
                    this.phaseArray[2].resetMixingRule(this.phaseArray[0].getMixingRuleType());
                    this.phaseArray[2].resetPhysicalProperties();
                    this.phaseArray[2].initPhysicalProperties();
                }
            } else {
                this.setMaxNumberOfPhases(2);
            }
        }
        this.multiPhaseCheck = multiPhaseCheck;
    }

    @Override
    public void setMultiphaseWaxCheck(boolean multiphaseWaxCheck) {
        this.multiphaseWaxCheck = multiphaseWaxCheck;
    }

    @Override
    public void setNumberOfPhases(int number) {
        this.numberOfPhases = number;
        if (this.numberOfPhases > this.getMaxNumberOfPhases()) {
            this.setMaxNumberOfPhases(number);
        }
    }

    @Override
    public void setNumericDerivatives(boolean numericDerivatives) {
        this.numericDerivatives = numericDerivatives;
    }

    @Override
    public final void setPC(double PC) {
        this.criticalPressure = PC;
    }

    @Override
    public void setPhase(PhaseInterface phase, int index) {
        double temp = this.phaseArray[index].getTemperature();
        double pres = this.phaseArray[index].getPressure();
        this.phaseArray[index] = phase;
        this.phaseArray[index].setTemperature(temp);
        this.phaseArray[index].setPressure(pres);
    }

    @Override
    public final void setPhaseIndex(int index, int phaseIndex) {
        this.phaseIndex[index] = phaseIndex;
    }

    @Override
    public void setPhaseType(int phaseToChange, PhaseType pt) {
        if (this.allowPhaseShift) {
            this.phaseType[this.phaseIndex[phaseToChange]] = pt;
        }
    }

    @Override
    public void setPhaseType(int phaseToChange, String phaseName) {
        if (this.allowPhaseShift) {
            this.phaseType[this.phaseIndex[phaseToChange]] = PhaseType.byName(phaseName);
        }
    }

    @Override
    public void setAllPhaseType(PhaseType pt) {
        if (this.allowPhaseShift) {
            for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
                this.setPhaseType(i, pt);
            }
        }
    }

    @Override
    public void invertPhaseTypes() {
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            this.phaseType[i] = this.phaseType[i] == PhaseType.LIQUID ? PhaseType.GAS : PhaseType.LIQUID;
        }
    }

    @Override
    public final void setPressure(double newPressure) {
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            this.phaseArray[i].setPressure(newPressure);
        }
    }

    @Override
    public final void setPressure(double newPressure, String unit) {
        PressureUnit presConversion = new PressureUnit(newPressure, unit);
        this.setPressure(presConversion.getValue("bara"));
    }

    @Override
    public void setSolidPhaseCheck(boolean solidPhaseCheck) {
        this.solidPhaseCheck = solidPhaseCheck;
        int oldphase = this.numberOfPhases;
        if (solidPhaseCheck && !this.hasSolidPhase()) {
            this.addSolidPhase();
        }
        for (int phaseNum = 0; phaseNum < this.numberOfPhases; ++phaseNum) {
            for (int k = 0; k < this.getPhases()[0].getNumberOfComponents(); ++k) {
                this.getPhase(phaseNum).getComponent(k).setSolidCheck(solidPhaseCheck);
                this.getPhase(3).getComponent(k).setSolidCheck(solidPhaseCheck);
            }
        }
        this.setNumberOfPhases(oldphase);
    }

    @Override
    public void setSolidPhaseCheck(String solidComponent) {
        this.init(0);
        int oldphase = this.numberOfPhases;
        if (!this.solidPhaseCheck) {
            this.addSolidPhase();
        }
        this.solidPhaseCheck = true;
        this.init(0);
        for (int phaseNum = 0; phaseNum < this.getMaxNumberOfPhases(); ++phaseNum) {
            try {
                this.getPhase(phaseNum).getComponent(solidComponent).setSolidCheck(true);
                this.getPhase(3).getComponent(solidComponent).setSolidCheck(true);
                continue;
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        this.setNumberOfPhases(oldphase);
    }

    @Override
    public void setStandard(String standardName) {
        this.standard = standardName.equals("ISO1992") ? new Standard_ISO6976(this) : (standardName.equals("Draft_ISO18453") ? new Draft_ISO18453(this) : new Standard_ISO6976(this));
    }

    @Override
    public final void setTC(double TC) {
        this.criticalTemperature = TC;
    }

    @Override
    public void setTemperature(double newTemperature) {
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            this.getPhases()[i].setTemperature(newTemperature);
        }
    }

    @Override
    public final void setTemperature(double newTemperature, int phaseNum) {
        this.getPhase(this.phaseIndex[phaseNum]).setTemperature(newTemperature);
    }

    @Override
    public void setTemperature(double newTemperature, String unit) {
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
            if (unit.equals("K")) {
                this.getPhases()[i].setTemperature(newTemperature);
                continue;
            }
            if (unit.equals("C")) {
                this.getPhases()[i].setTemperature(newTemperature + 273.15);
                continue;
            }
            if (unit.equals("F")) {
                this.getPhases()[i].setTemperature((newTemperature - 32.0) * 5.0 / 9.0 + 273.15);
                continue;
            }
            if (unit.equals("R")) {
                this.getPhases()[i].setTemperature(newTemperature * 5.0 / 9.0);
                continue;
            }
            throw new RuntimeException("Unit not supported: " + unit);
        }
    }

    @Override
    public void setTotalFlowRate(double flowRate, String flowunit) {
        this.init(0);
        try {
            this.init(1);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        double density = 0.0;
        if (flowunit.equals("Am3/hr") || flowunit.equals("Am3/min") || flowunit.equals("gallons/min") || flowunit.equals("Am3/sec")) {
            this.initPhysicalProperties(PhysicalPropertyType.MASS_DENSITY);
        }
        density = this.getPhase(0).getDensity("kg/m3");
        if (flowunit.equals("idSm3/hr") || flowunit.equals("idSm3/min") || flowunit.equals("idSm3/sec") || flowunit.equals("gallons/min")) {
            density = this.getIdealLiquidDensity("kg/m3");
        }
        RateUnit unit = new RateUnit(flowRate, flowunit, this.getMolarMass(), density, 0.0);
        double SIval = unit.getSIvalue();
        double totalNumberOfMolesLocal = this.totalNumberOfMoles;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (flowRate < 1.0E-100) {
                this.setEmptyFluid();
                continue;
            }
            if (totalNumberOfMolesLocal > 1.0E-100) {
                double change = SIval / totalNumberOfMolesLocal * this.getPhase(0).getComponent(i).getNumberOfmoles() - this.getPhase(0).getComponent(i).getNumberOfmoles();
                if (!(Math.abs(change) > 1.0E-12)) continue;
                this.addComponent(i, change);
                continue;
            }
            this.addComponent(i, SIval);
        }
    }

    @Override
    public void setTotalNumberOfMoles(double totalNumberOfMoles) {
        if (totalNumberOfMoles < 0.0) {
            totalNumberOfMoles = 0.0;
        }
        this.totalNumberOfMoles = totalNumberOfMoles;
    }

    @Override
    public void setUseTVasIndependentVariables(boolean useTVasIndependentVariables) {
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.getPhase(i).setTotalVolume(this.getPhase(i).getVolume());
            this.getPhase(i).setConstantPhaseVolume(useTVasIndependentVariables);
            this.getPhase(i).calcMolarVolume(!useTVasIndependentVariables);
        }
        this.useTVasIndependentVariables = useTVasIndependentVariables;
    }

    @Override
    public void tuneModel(String model, double val, int phaseNum) {
        if (model.equals("viscosity")) {
            this.getPhase(phaseNum).getPhysicalProperties().getViscosityModel().tuneModel(val, this.getPhase(phaseNum).getTemperature(), this.getPhase(phaseNum).getPressure());
            for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
                for (int j = 0; j < this.numberOfPhases; ++j) {
                    this.getPhase(i).getComponent(j).setCriticalViscosity(this.getPhase(phaseNum).getComponent(j).getCriticalViscosity());
                }
            }
        }
        this.initPhysicalProperties();
    }

    public boolean useTVasIndependentVariables() {
        return this.useTVasIndependentVariables;
    }

    @Override
    public void useVolumeCorrection(boolean volcor) {
        for (PhaseInterface tmpPhase : this.phaseArray) {
            if (tmpPhase == null) continue;
            tmpPhase.useVolumeCorrection(volcor);
        }
    }

    public String write() {
        return "";
    }

    @Override
    public void write(String name, String filename, boolean newfile) {
        String[][] table = this.createTable(name);
        TextFile file = new TextFile();
        if (newfile) {
            file.newFile(filename);
        }
        file.setOutputFileName(filename);
        file.setValues(table);
        file.createFile();
    }

    @Override
    public double[] getKvector() {
        double[] K = new double[this.getNumberOfComponents()];
        for (int i = 0; i < this.getNumberOfComponents(); ++i) {
            K[i] = this.getPhase(0).getComponent(i).getK();
        }
        return K;
    }

    @Override
    public double[] getzvector() {
        double[] z = new double[this.getNumberOfComponents()];
        for (int i = 0; i < this.getNumberOfComponents(); ++i) {
            z[i] = this.getPhase(0).getComponent(i).getz();
        }
        return z;
    }

    @Override
    public String toJson() {
        return new GsonBuilder().create().toJson(new FluidResponse(this));
    }

    @Override
    public String toCompJson() {
        return new GsonBuilder().create().toJson(new FluidComponentResponse(this));
    }

    @Override
    public void setForceSinglePhase(PhaseType phasetype) {
        this.init(0);
        this.setNumberOfPhases(1);
        this.setMaxNumberOfPhases(1);
        this.setForcePhaseTypes(true);
        this.setPhaseType(0, phasetype);
    }

    @Override
    public void setForceSinglePhase(String phasetype) {
        this.setForceSinglePhase(PhaseType.byName(phasetype));
    }

    @Override
    public void setMolarCompositionOfNamedComponents(String nameDef, double[] molarComposition) {
        int place = 0;
        double[] comp = new double[this.getNumberOfComponents()];
        for (int i = 0; i < this.getNumberOfComponents(); ++i) {
            comp[i] = 0.0;
            if (!this.getPhase(0).getComponent(i).getName().contains(nameDef)) continue;
            comp[i] = molarComposition[place];
            ++place;
        }
        this.setMolarComposition(comp);
    }

    public void setMixingRuleParametersForComponent(String compName) {
        for (int i = 0; i < this.getMaxNumberOfPhases(); ++i) {
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SystemThermo other = (SystemThermo)obj;
        if (this.numberOfComponents != other.numberOfComponents) {
            return false;
        }
        if (this.numberOfPhases != other.numberOfPhases) {
            return false;
        }
        if (Double.compare(this.totalNumberOfMoles, other.totalNumberOfMoles) != 0) {
            return false;
        }
        if (!this.fluidName.equals(other.fluidName)) {
            return false;
        }
        for (int i = 0; i < this.numberOfPhases; ++i) {
            if (this.getPhase(i).equals(other.getPhase(i))) continue;
            return false;
        }
        return true;
    }
}

