/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.Vega;

import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.netlib.util.StringW;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class Vega {
    double R;
    double M;
    double Tc;
    double Dc;
    double dPdDsave;
    double a1;
    double a2;
    int N = 23;
    int I_pol = 6;
    int I_Exp = 6;
    int I_GBS = 11;
    double[] n_i = new double[this.N + 1];
    double[] t_i = new double[this.N + 1];
    double[] d_i = new double[this.N + 1];
    double[] l_i = new double[this.N + 1];
    double[] eta_i = new double[this.N + 1];
    double[] beta_i = new double[this.N + 1];
    double[] gamma_i = new double[this.N + 1];
    double[] epsilon_i = new double[this.N + 1];
    double epsilon = 1.0E-15;

    public void DensityVega(int iFlag, double T, double P, doubleW D, intW ierr, StringW herr) {
        doubleW Tcx = new doubleW(0.0);
        doubleW Dcx = new doubleW(0.0);
        doubleW dPdD = new doubleW(0.0);
        doubleW d2PdD2 = new doubleW(0.0);
        doubleW d2PdTD = new doubleW(0.0);
        doubleW dPdT = new doubleW(0.0);
        doubleW U = new doubleW(0.0);
        doubleW H = new doubleW(0.0);
        doubleW S = new doubleW(0.0);
        doubleW A = new doubleW(0.0);
        doubleW P2 = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        doubleW Cv = new doubleW(0.0);
        doubleW Cp = new doubleW(0.0);
        doubleW W = new doubleW(0.0);
        doubleW G = new doubleW(0.0);
        doubleW JT = new doubleW(0.0);
        doubleW Kappa = new doubleW(0.0);
        doubleW PP = new doubleW(0.0);
        ierr.val = 0;
        herr.val = "";
        int nFail = 0;
        boolean iFail = false;
        if (P < this.epsilon) {
            D.val = 0.0;
            return;
        }
        double tolr = 1.0E-12;
        this.PseudoCriticalPointVega(Tcx, Dcx);
        if (D.val > -this.epsilon) {
            D.val = P / this.R / T;
            if (iFlag == 2) {
                D.val = Dcx.val * 3.0;
            }
        } else {
            D.val = Math.abs(D.val);
        }
        double plog = Math.log(P);
        double vlog = -Math.log(D.val);
        for (int it = 1; it <= 50; ++it) {
            if (vlog < -7.0 || vlog > 100.0 || it == 20 || it == 30 || it == 40 || iFail) {
                iFail = false;
                if (nFail > 2) {
                    ierr.val = 1;
                    herr.val = "Calculation failed to converge in Vega method, ideal gas density returned.";
                    D.val = P / this.R / T;
                }
                if (++nFail == 1) {
                    D.val = Dcx.val * 3.0;
                } else if (nFail == 2) {
                    D.val = Dcx.val * 2.5;
                } else if (nFail == 3) {
                    D.val = Dcx.val * 2.0;
                }
                vlog = -Math.log(D.val);
            }
            D.val = Math.exp(-vlog);
            this.PressureVega(T, D.val, P2, Z);
            if (this.dPdDsave < this.epsilon || P2.val < this.epsilon) {
                double vinc = 0.1;
                if (D.val > Dcx.val) {
                    vinc = -0.1;
                }
                if (it > 5) {
                    vinc /= 2.0;
                }
                if (it > 10 && it < 20) {
                    vinc /= 5.0;
                }
                vlog += vinc;
                continue;
            }
            double dpdlv = -D.val * this.dPdDsave;
            double vdiff = (Math.log(P2.val) - plog) * P2.val / dpdlv;
            vlog += -vdiff;
            if (!(Math.abs(vdiff) < tolr)) continue;
            if (this.dPdDsave < 0.0) {
                iFail = true;
                continue;
            }
            D.val = Math.exp(-vlog);
            if (iFlag > 0) {
                this.propertiesVega(T, D.val, PP, Z, dPdD, d2PdD2, d2PdTD, dPdT, U, H, S, Cv, Cp, W, G, JT, Kappa, A);
                if (PP.val <= 0.0 || dPdD.val <= 0.0 || d2PdTD.val <= 0.0 || Cv.val <= 0.0 || Cp.val <= 0.0 || W.val <= 0.0) {
                    ierr.val = 1;
                    herr.val = "Calculation failed to converge in Vega method, ideal gas density returned.";
                    D.val = P / this.R / T;
                }
            }
            return;
        }
        ierr.val = 1;
        herr.val = "Calculation failed to converge in Vega method, ideal gas density returned.";
        D.val = P / this.R / T;
    }

    public void PressureVega(double T, double D, doubleW P, doubleW Z) {
        doubleW[][] ar = new doubleW[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ar[i][j] = new doubleW(0.0);
            }
        }
        this.AlpharVega(0, 0, T, D, ar);
        Z.val = 1.0 + ar[0][1].val;
        P.val = D * this.R * T * Z.val;
        this.dPdDsave = this.R * T * (1.0 + 2.0 * ar[0][1].val + ar[0][2].val);
    }

    void AlpharVega(int itau, int idelta, double T, double D, doubleW[][] ar) {
        double dGddelta;
        double G;
        double d2edeltadtau;
        double d2Bddeltadtau;
        double d2edtau2;
        double dedtau;
        double d2Bdtau2;
        double dBdtau;
        double d3eddelta3;
        double d2eddelta2;
        double deddelta;
        double d3Bddelta3;
        double d2Bddelta2;
        double dBddelta;
        double E;
        double e;
        double B;
        int k;
        for (int i = 0; i <= 3; ++i) {
            for (int j = 0; j <= 3; ++j) {
                ar[i][j].val = 0.0;
            }
        }
        double tau = this.Tc / T;
        double delta = D / this.Dc;
        for (k = 0; k < this.I_pol; ++k) {
            B = this.n_i[k] * Math.pow(delta, this.d_i[k]) * Math.pow(tau, this.t_i[k]);
            double dBddelta2 = this.n_i[k] * this.d_i[k] * Math.pow(delta, this.d_i[k] - 1.0) * Math.pow(tau, this.t_i[k]);
            double d2Bddelta22 = this.n_i[k] * this.d_i[k] * (this.d_i[k] - 1.0) * Math.pow(delta, this.d_i[k] - 2.0) * Math.pow(tau, this.t_i[k]);
            double d3Bddelta32 = this.n_i[k] * this.d_i[k] * (this.d_i[k] - 1.0) * (this.d_i[k] - 2.0) * Math.pow(delta, this.d_i[k] - 3.0) * Math.pow(tau, this.t_i[k]);
            double dBdtau2 = this.n_i[k] * Math.pow(delta, this.d_i[k]) * this.t_i[k] * Math.pow(tau, this.t_i[k] - 1.0);
            double d2Bdtau22 = this.n_i[k] * Math.pow(delta, this.d_i[k]) * this.t_i[k] * (this.t_i[k] - 1.0) * Math.pow(tau, this.t_i[k] - 2.0);
            double d2Bddeltadtau2 = this.n_i[k] * this.d_i[k] * Math.pow(delta, this.d_i[k] - 1.0) * this.t_i[k] * Math.pow(tau, this.t_i[k] - 1.0);
            ar[0][0].val += B;
            ar[0][1].val += dBddelta2;
            ar[0][2].val += d2Bddelta22;
            ar[0][3].val += d3Bddelta32;
            ar[1][0].val += dBdtau2;
            ar[2][0].val += d2Bdtau22;
            ar[1][1].val += d2Bddeltadtau2;
        }
        for (k = this.I_pol; k < this.I_pol + this.I_Exp; ++k) {
            B = this.n_i[k] * Math.pow(delta, this.d_i[k]) * Math.pow(tau, this.t_i[k]);
            e = -Math.pow(delta, this.l_i[k]);
            E = Math.exp(e);
            dBddelta = B * this.d_i[k] / delta;
            d2Bddelta2 = B * this.d_i[k] * (this.d_i[k] - 1.0) / Math.pow(delta, 2.0);
            d3Bddelta3 = B * this.d_i[k] * (this.d_i[k] - 1.0) * (this.d_i[k] - 2.0) / Math.pow(delta, 3.0);
            deddelta = -this.l_i[k] * Math.pow(delta, this.l_i[k] - 1.0);
            d2eddelta2 = this.l_i[k] * (this.l_i[k] - 1.0) * Math.pow(delta, this.l_i[k] - 2.0);
            d3eddelta3 = this.l_i[k] * (this.l_i[k] - 1.0) * (this.l_i[k] - 2.0) * Math.pow(delta, this.l_i[k] - 3.0);
            dBdtau = B * this.t_i[k] / tau;
            d2Bdtau2 = B * this.t_i[k] * (this.t_i[k] - 1.0) / Math.pow(tau, 2.0);
            dedtau = 0.0;
            d2edtau2 = 0.0;
            d2Bddeltadtau = B * this.d_i[k] * this.t_i[k] / (delta * tau);
            d2edeltadtau = 0.0;
            ar[0][0].val += B * E;
            ar[0][1].val += dBddelta * E + B * deddelta * E;
            G = d2Bddelta2 + 2.0 * dBddelta * deddelta + B * d2eddelta2 + B * deddelta * deddelta;
            ar[0][2].val += G * E;
            dGddelta = d3Bddelta3 + 2.0 * (d2Bddelta2 * deddelta + dBddelta * d2eddelta2) + dBddelta * d2Bddelta2 + B * d3eddelta3 + dBddelta * deddelta * deddelta + 2.0 * B * deddelta * d2eddelta2;
            ar[0][3].val += dGddelta * E;
            ar[1][0].val += dBdtau * E + B * E * dedtau;
            ar[2][0].val += d2Bdtau2 * E + 2.0 * dBdtau * dedtau * E + B * E * d2edtau2;
            ar[1][1].val += d2Bddeltadtau * E + dBddelta * dedtau * E + dBdtau * deddelta * E + B * d2edeltadtau * E;
        }
        for (k = this.I_pol + this.I_Exp; k < this.I_pol + this.I_Exp + this.I_GBS; ++k) {
            B = this.n_i[k] * Math.pow(delta, this.d_i[k]) * Math.pow(tau, this.t_i[k]);
            e = -this.eta_i[k] * Math.pow(delta - this.epsilon_i[k], 2.0) - this.beta_i[k] * Math.pow(tau - this.gamma_i[k], 2.0);
            E = Math.exp(e);
            dBddelta = B * this.d_i[k] / delta;
            d2Bddelta2 = B * this.d_i[k] * (this.d_i[k] - 1.0) / Math.pow(delta, 2.0);
            d3Bddelta3 = B * this.d_i[k] * (this.d_i[k] - 1.0) * (this.d_i[k] - 2.0) / Math.pow(delta, 3.0);
            deddelta = -2.0 * this.eta_i[k] * (delta - this.epsilon_i[k]);
            d2eddelta2 = -2.0 * this.eta_i[k];
            d3eddelta3 = 0.0;
            dBdtau = B * this.t_i[k] / tau;
            d2Bdtau2 = B * this.t_i[k] * (this.t_i[k] - 1.0) / Math.pow(tau, 2.0);
            dedtau = -2.0 * this.beta_i[k] * (tau - this.gamma_i[k]);
            d2edtau2 = -2.0 * this.beta_i[k];
            d2Bddeltadtau = B * this.d_i[k] * this.t_i[k] / (delta * tau);
            d2edeltadtau = 0.0;
            ar[0][0].val += B * E;
            ar[0][1].val += dBddelta * E + B * deddelta * E;
            G = d2Bddelta2 + 2.0 * dBddelta * deddelta + B * d2eddelta2 + B * deddelta * deddelta;
            ar[0][2].val += G * E;
            dGddelta = d3Bddelta3 + 2.0 * (d2Bddelta2 * deddelta + dBddelta * d2eddelta2) + dBddelta * d2eddelta2 + B * d3eddelta3 + dBddelta * deddelta * deddelta + 2.0 * B * deddelta * d2eddelta2;
            ar[0][3].val += E * (dGddelta + G * deddelta);
            ar[1][0].val += dBdtau * E + B * E * dedtau;
            ar[2][0].val += d2Bdtau2 * E + 2.0 * dBdtau * dedtau * E + B * E * d2edtau2;
            ar[1][1].val += d2Bddeltadtau * E + dBddelta * dedtau * E + dBdtau * deddelta * E + B * d2edeltadtau * E + B * deddelta * dedtau * E;
        }
        ar[0][1].val = delta * ar[0][1].val;
        ar[0][2].val = delta * delta * ar[0][2].val;
        ar[0][3].val = delta * delta * delta * ar[0][3].val;
        ar[1][0].val = tau * ar[1][0].val;
        ar[2][0].val = tau * tau * ar[2][0].val;
        ar[1][1].val = tau * delta * ar[1][1].val;
    }

    void Alpha0Vega(double T, double D, doubleW[] a0) {
        double tau = this.Tc / T;
        double delta = D / this.Dc;
        double lntau = Math.log(tau);
        a0[0].val = this.a1 + this.a2 * tau + Math.log(delta) + 1.5 * Math.log(tau);
        a0[1].val = this.a2 + 1.5 / tau;
        a0[2].val = -1.5 / (tau * tau);
        a0[1].val = tau * a0[1].val;
        a0[2].val = tau * tau * a0[2].val;
    }

    public void propertiesVega(double T, double D, doubleW P, doubleW Z, doubleW dPdD, doubleW d2PdD2, doubleW d2PdTD, doubleW dPdT, doubleW U, doubleW H, doubleW S, doubleW Cv, doubleW Cp, doubleW W, doubleW G, doubleW JT, doubleW Kappa, doubleW A) {
        doubleW[] a0 = new doubleW[3];
        for (int i = 0; i < 3; ++i) {
            a0[i] = new doubleW(0.0);
        }
        doubleW[][] ar = new doubleW[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ar[i][j] = new doubleW(0.0);
            }
        }
        this.Alpha0Vega(T, D, a0);
        this.AlpharVega(1, 0, T, D, ar);
        double RT = this.R * T;
        Z.val = 1.0 + ar[0][1].val;
        P.val = D * RT * Z.val;
        dPdD.val = RT * (1.0 + 2.0 * ar[0][1].val + ar[0][2].val);
        dPdT.val = D * this.R * (1.0 + ar[0][1].val - ar[1][1].val);
        d2PdTD.val = this.R * (1.0 + 2.0 * ar[0][1].val + ar[0][2].val - 2.0 * ar[1][1].val - ar[1][2].val);
        A.val = RT * (a0[0].val + ar[0][0].val);
        G.val = RT * (1.0 + ar[0][1].val + a0[0].val + ar[0][0].val);
        U.val = RT * (a0[1].val + ar[1][0].val);
        H.val = RT * (1.0 + ar[0][1].val + a0[1].val + ar[1][0].val);
        S.val = this.R * (a0[1].val + ar[1][0].val - a0[0].val - ar[0][0].val);
        Cv.val = -this.R * (a0[2].val + ar[2][0].val);
        if (D > this.epsilon) {
            Cp.val = Cv.val + T * (dPdT.val / D) * (dPdT.val / D) / dPdD.val;
            d2PdD2.val = RT * (2.0 * ar[0][1].val + 4.0 * ar[0][2].val + ar[0][3].val) / D;
            JT.val = (T / D * dPdT.val / dPdD.val - 1.0) / Cp.val / D;
        } else {
            Cp.val = Cv.val + this.R;
            d2PdD2.val = 0.0;
            JT.val = 1.0E20;
        }
        W.val = 1000.0 * Cp.val / Cv.val * dPdD.val / this.M;
        if (W.val < 0.0) {
            W.val = 0.0;
        }
        W.val = Math.sqrt(W.val);
        Kappa.val = Math.pow(W.val, 2.0) * this.M / (RT * 1000.0 * Z.val);
    }

    void PseudoCriticalPointVega(doubleW Tcx, doubleW Dcx) {
        if (this.Tc == 0.0 || this.Dc == 0.0) {
            throw new IllegalStateException("Critical point parameters not set. Please call SetupVega() first.");
        }
        Tcx.val = this.Tc;
        Dcx.val = this.Dc;
        double Vcx = 1.0 / Dcx.val;
    }

    public void SetupVega() {
        this.R = 8.314472;
        this.M = 4.002602;
        this.Tc = 5.1953;
        this.Dc = 17.3837;
        this.a1 = 0.1733487932835764;
        this.a2 = 0.4674522201550815;
        this.n_i = new double[]{0.015559018, 3.0638932, -4.2420844, 0.054418088, -0.18971904, 0.087856262, 2.2833566, -0.53331595, -0.53296502, 0.99444915, -0.30078896, -1.6432563, 0.8029102, 0.026838669, 0.04687678, -0.14832766, 0.03016211, -0.019986041, 0.14283514, 0.007418269, -0.22989793, 0.79224829, -0.049386338};
        this.t_i = new double[]{1.0, 0.425, 0.63, 0.69, 1.83, 0.575, 0.925, 1.585, 1.69, 1.51, 2.9, 0.8, 1.26, 3.51, 2.785, 1.0, 4.22, 0.83, 1.575, 3.447, 0.73, 1.634, 6.13};
        this.d_i = new double[]{4.0, 1.0, 1.0, 2.0, 2.0, 3.0, 1.0, 1.0, 3.0, 2.0, 2.0, 1.0, 2.0, 1.0, 2.0, 1.0, 1.0, 3.0, 2.0, 2.0, 3.0, 2.0, 2.0};
        this.l_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, 2.0, 1.0, 2.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        this.eta_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.5497, 9.245, 4.76323, 6.3826, 8.7023, 0.255, 0.3523, 0.1492, 0.05, 0.1668, 42.2358};
        this.beta_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.2471, 0.0983, 0.1556, 2.6782, 2.7077, 0.6621, 0.1775, 0.4821, 0.3069, 0.1758, 1357.6577};
        this.gamma_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.15, 2.54505, 1.2513, 1.9416, 0.5984, 2.2282, 1.606, 3.815, 1.61958, 0.6407, 1.076};
        this.epsilon_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.596, 0.3423, 0.761, 0.9747, 0.5868, 0.5627, 2.5346, 3.6763, 4.5245, 5.039, 0.959};
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        Vega test = new Vega();
        test.SetupVega();
        double T = 273.15;
        doubleW D = new doubleW(30.0);
        doubleW P = new doubleW(10000.0);
        intW ierr = new intW(0);
        doubleW Z = new doubleW(0.0);
        int iFlag = 0;
        StringW herr = new StringW("");
        test.DensityVega(iFlag, T, P.val, D, ierr, herr);
        System.out.println("density " + D.val);
        doubleW dPdD = new doubleW(0.0);
        doubleW d2PdD2 = new doubleW(0.0);
        doubleW d2PdTD = new doubleW(0.0);
        doubleW dPdT = new doubleW(0.0);
        doubleW U = new doubleW(0.0);
        doubleW H = new doubleW(0.0);
        doubleW S = new doubleW(0.0);
        doubleW A = new doubleW(0.0);
        doubleW P2 = new doubleW(0.0);
        doubleW Cv = new doubleW(0.0);
        doubleW Cp = new doubleW(0.0);
        doubleW W = new doubleW(0.0);
        doubleW G = new doubleW(0.0);
        doubleW JT = new doubleW(0.0);
        doubleW Kappa = new doubleW(0.0);
        doubleW PP = new doubleW(0.0);
        test.propertiesVega(T, D.val, P, Z, dPdD, d2PdD2, d2PdTD, dPdT, U, H, S, Cv, Cp, W, G, JT, Kappa, A);
        System.out.println("Outputs-----\n");
        System.out.println("Outputs-----\n");
        System.out.println("Molar mass [g/mol]:                 " + test.M);
        System.out.println("Molar density [mol/l]:              " + D.val);
        System.out.println("Pressure [kPa]:                     " + P.val);
        System.out.println("Compressibility factor:             " + Z.val);
        System.out.println("d(P)/d(rho) [kPa/(mol/l)]:          " + dPdD.val);
        System.out.println("d^2(P)/d(rho)^2 [kPa/(mol/l)^2]:    " + d2PdD2.val);
        System.out.println("d(P)/d(T) [kPa/K]:                  " + dPdT.val);
        System.out.println("Energy [J/mol]:                     " + U.val);
        System.out.println("Enthalpy [J/mol]:                   " + H.val);
        System.out.println("Entropy [J/mol-K]:                  " + S.val);
        System.out.println("Isochoric heat capacity [J/mol-K]:  " + Cv.val);
        System.out.println("Isobaric heat capacity [J/mol-K]:   " + Cp.val);
        System.out.println("Speed of sound [m/s]:               " + W.val);
        System.out.println("Gibbs energy [J/mol]:               " + G.val);
        System.out.println("Joule-Thomson coefficient [K/kPa]:  " + JT.val);
        System.out.println("Isentropic exponent:                " + Kappa.val);
    }
}

