/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.humidair;

public final class HumidAir {
    private static final double EPSILON = 0.621945;

    private HumidAir() {
    }

    public static double saturationPressureWater(double temperature) {
        if (temperature >= 273.16) {
            double Tc = 647.096;
            double Pc = 2.2064E7;
            double theta = 1.0 - temperature / Tc;
            double a1 = -7.85951783;
            double a2 = 1.84408259;
            double a3 = -11.7866497;
            double a4 = 22.6807411;
            double a5 = -15.9618719;
            double a6 = 1.80122502;
            double lnP = Tc / temperature * (a1 * theta + a2 * Math.pow(theta, 1.5) + a3 * Math.pow(theta, 3.0) + a4 * Math.pow(theta, 3.5) + a5 * Math.pow(theta, 4.0) + a6 * Math.pow(theta, 7.5));
            return Pc * Math.exp(lnP);
        }
        double theta = temperature / 273.16;
        double lnP = -13.928169 * (1.0 - Math.pow(theta, -1.5)) - 34.7078238 * (1.0 - Math.pow(theta, 1.5)) + Math.log(611.657);
        return Math.exp(lnP);
    }

    public static double humidityRatioFromRH(double temperature, double pressure, double relativeHumidity) {
        double pws = HumidAir.saturationPressureWater(temperature);
        double pw = relativeHumidity * pws;
        return 0.621945 * pw / (pressure - pw);
    }

    public static double relativeHumidity(double temperature, double pressure, double humidityRatio) {
        double pws = HumidAir.saturationPressureWater(temperature);
        double pw = humidityRatio * pressure / (0.621945 + humidityRatio);
        return pw / pws;
    }

    public static double dewPointTemperature(double humidityRatio, double pressure) {
        double pw = humidityRatio * pressure / (0.621945 + humidityRatio);
        double T = 273.15;
        for (int i = 0; i < 50; ++i) {
            double f = HumidAir.saturationPressureWater(T) - pw;
            if (Math.abs(f / pw) < 1.0E-6) {
                return T;
            }
            double dP = (HumidAir.saturationPressureWater(T + 0.01) - HumidAir.saturationPressureWater(T - 0.01)) / 0.02;
            T -= f / dP;
        }
        return T;
    }

    public static double enthalpy(double temperature, double humidityRatio) {
        double tC = temperature - 273.15;
        return 1.006 * tC + humidityRatio * (2501.0 + 1.86 * tC);
    }

    public static double cairSat(double temperature) {
        double T = temperature;
        return 2146.27073 - 32.8917768 * T + 0.189471075 * T * T - 4.86290986E-4 * T * T * T + 4.69540143E-7 * T * T * T * T;
    }
}

