/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.leachman;

import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.netlib.util.StringW;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class Leachman {
    private String hydrogenType;
    double R_L;
    double M_L;
    double Tc;
    double Dc;
    double dPdDsave;
    int K;
    double[] a0k;
    double[] b0k;
    int K_normal = 7;
    double[] a0k_normal = new double[this.K_normal + 1];
    double[] b0k_normal = new double[this.K_normal + 1];
    int K_para = 9;
    double[] a0k_para = new double[this.K_para + 1];
    double[] b0k_para = new double[this.K_para + 1];
    int K_ortho = 6;
    double[] a0k_ortho = new double[this.K_ortho + 1];
    double[] b0k_ortho = new double[this.K_ortho + 1];
    int l = 7;
    int m = 9;
    int n = 14;
    double[] N_i;
    double[] t_i;
    double[] d_i;
    double[] p_i;
    double[] phi_i;
    double[] beta_i;
    double[] gamma_i;
    double[] D_i;
    double[] N_i_normal = new double[this.n + 1];
    double[] t_i_normal = new double[this.n + 1];
    double[] d_i_normal = new double[this.n + 1];
    double[] p_i_normal = new double[this.n + 1];
    double[] phi_i_normal = new double[this.n + 1];
    double[] beta_i_normal = new double[this.n + 1];
    double[] gamma_i_normal = new double[this.n + 1];
    double[] D_i_normal = new double[this.n + 1];
    double[] N_i_para = new double[this.n + 1];
    double[] t_i_para = new double[this.n + 1];
    double[] d_i_para = new double[this.n + 1];
    double[] p_i_para = new double[this.n + 1];
    double[] phi_i_para = new double[this.n + 1];
    double[] beta_i_para = new double[this.n + 1];
    double[] gamma_i_para = new double[this.n + 1];
    double[] D_i_para = new double[this.n + 1];
    double[] N_i_ortho = new double[this.n + 1];
    double[] t_i_ortho = new double[this.n + 1];
    double[] d_i_ortho = new double[this.n + 1];
    double[] p_i_ortho = new double[this.n + 1];
    double[] phi_i_ortho = new double[this.n + 1];
    double[] beta_i_ortho = new double[this.n + 1];
    double[] gamma_i_ortho = new double[this.n + 1];
    double[] D_i_ortho = new double[this.n + 1];
    double epsilon = 1.0E-15;

    public void DensityLeachman(int iFlag, double T, double P, doubleW D, intW ierr, StringW herr) {
        doubleW Tcx = new doubleW(0.0);
        doubleW Dcx = new doubleW(0.0);
        doubleW dPdD = new doubleW(0.0);
        doubleW d2PdD2 = new doubleW(0.0);
        doubleW d2PdTD = new doubleW(0.0);
        doubleW dPdT = new doubleW(0.0);
        doubleW U = new doubleW(0.0);
        doubleW H = new doubleW(0.0);
        doubleW S = new doubleW(0.0);
        doubleW A = new doubleW(0.0);
        doubleW P2 = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        doubleW Cv = new doubleW(0.0);
        doubleW Cp = new doubleW(0.0);
        doubleW W = new doubleW(0.0);
        doubleW G = new doubleW(0.0);
        doubleW JT = new doubleW(0.0);
        doubleW Kappa = new doubleW(0.0);
        doubleW PP = new doubleW(0.0);
        ierr.val = 0;
        herr.val = "";
        int nFail = 0;
        boolean iFail = false;
        if (P < this.epsilon) {
            D.val = 0.0;
            return;
        }
        double tolr = 1.0E-7;
        this.PseudoCriticalPointLeachman(Tcx, Dcx);
        if (D.val > -this.epsilon) {
            D.val = P / this.R_L / T;
            if (iFlag == 2) {
                D.val = Dcx.val * 3.0;
            }
        } else {
            D.val = Math.abs(D.val);
        }
        double plog = Math.log(P);
        double vlog = -Math.log(D.val);
        for (int it = 1; it <= 50; ++it) {
            if (vlog < -7.0 || vlog > 100.0 || it == 20 || it == 30 || it == 40 || iFail) {
                iFail = false;
                if (nFail > 2) {
                    ierr.val = 1;
                    herr.val = "Calculation failed to converge in Leachman method, ideal gas density returned.";
                    D.val = P / this.R_L / T;
                }
                if (++nFail == 1) {
                    D.val = Dcx.val * 3.0;
                } else if (nFail == 2) {
                    D.val = Dcx.val * 2.5;
                } else if (nFail == 3) {
                    D.val = Dcx.val * 2.0;
                }
                vlog = -Math.log(D.val);
            }
            D.val = Math.exp(-vlog);
            this.PressureLeachman(T, D.val, P2, Z);
            if (this.dPdDsave < this.epsilon || P2.val < this.epsilon) {
                double vinc = 0.1;
                if (D.val > Dcx.val) {
                    vinc = -0.1;
                }
                if (it > 5) {
                    vinc /= 2.0;
                }
                if (it > 10 && it < 20) {
                    vinc /= 5.0;
                }
                vlog += vinc;
                continue;
            }
            double dpdlv = -D.val * this.dPdDsave;
            double vdiff = (Math.log(P2.val) - plog) * P2.val / dpdlv;
            vlog += -vdiff;
            if (!(Math.abs(vdiff) < tolr)) continue;
            if (this.dPdDsave < 0.0) {
                iFail = true;
                continue;
            }
            D.val = Math.exp(-vlog);
            if (iFlag > 0) {
                this.propertiesLeachman(T, D.val, PP, Z, dPdD, d2PdD2, d2PdTD, dPdT, U, H, S, Cv, Cp, W, G, JT, Kappa, A);
                if (PP.val <= 0.0 || dPdD.val <= 0.0 || d2PdTD.val <= 0.0 || Cv.val <= 0.0 || Cp.val <= 0.0 || W.val <= 0.0) {
                    ierr.val = 1;
                    herr.val = "Calculation failed to converge in Leachman method, ideal gas density returned.";
                    D.val = P / this.R_L / T;
                }
            }
            return;
        }
        ierr.val = 1;
        herr.val = "Calculation failed to converge in Leachman method, ideal gas density returned.";
        D.val = P / this.R_L / T;
    }

    public void PressureLeachman(double T, double D, doubleW P, doubleW Z) {
        doubleW[][] ar = new doubleW[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ar[i][j] = new doubleW(0.0);
            }
        }
        this.AlpharLeachman(0, 0, T, D, ar);
        Z.val = 1.0 + ar[0][1].val;
        P.val = D * this.R_L * T * Z.val;
        this.dPdDsave = this.R_L * T * (1.0 + 2.0 * ar[0][1].val + ar[0][2].val);
    }

    void AlpharLeachman(int itau, int idelta, double T, double D, doubleW[][] ar) {
        double ti;
        double di;
        double Ni;
        int k;
        for (int i = 0; i <= 3; ++i) {
            for (int j = 0; j <= 3; ++j) {
                ar[i][j].val = 0.0;
            }
        }
        double tau = this.Tc / T;
        double delta = D / this.Dc;
        for (k = 0; k < this.l; ++k) {
            Ni = this.N_i[k];
            di = this.d_i[k];
            ti = this.t_i[k];
            double B = Ni * Math.pow(delta, di) * Math.pow(tau, ti);
            double dBddelta = B * di * Math.pow(delta, -1.0);
            double d2Bddelta2 = B * di * (di - 1.0) * Math.pow(delta, -2.0);
            double d3Bddelta3 = B * di * (di - 1.0) * (di - 2.0) * Math.pow(delta, -3.0);
            double dBdtau = B * ti * Math.pow(tau, -1.0);
            double d2Bdtau2 = B * ti * (ti - 1.0) * Math.pow(tau, -2.0);
            double d2Bddeltadtau = B * di * ti * Math.pow(delta, -1.0) * Math.pow(tau, -1.0);
            ar[0][0].val += B;
            ar[0][1].val += dBddelta;
            ar[0][2].val += d2Bddelta2;
            ar[0][3].val += d3Bddelta3;
            ar[1][0].val += dBdtau;
            ar[2][0].val += d2Bdtau2;
            ar[1][1].val += d2Bddeltadtau;
        }
        for (k = this.l; k < this.m; ++k) {
            Ni = this.N_i[k];
            di = this.d_i[k];
            ti = this.t_i[k];
            double pi = this.p_i[k];
            double B = Ni * Math.pow(delta, di) * Math.pow(tau, ti);
            double e = -Math.pow(delta, pi);
            double E = Math.exp(e);
            double dBddelta = B * di * Math.pow(delta, -1.0);
            double d2Bddelta2 = B * di * (di - 1.0) * Math.pow(delta, -2.0);
            double d3Bddelta3 = B * di * (di - 1.0) * (di - 2.0) * Math.pow(delta, -3.0);
            double deddelta = -pi * Math.pow(delta, pi - 1.0);
            double d2edDelta2 = -pi * (pi - 1.0) * Math.pow(delta, pi - 2.0);
            double d3edDelta3 = -pi * (pi - 1.0) * (pi - 2.0) * Math.pow(delta, pi - 3.0);
            double dBdTau = B * ti * Math.pow(tau, -1.0);
            double d2BdTau2 = B * ti * (ti - 1.0) * Math.pow(tau, -2.0);
            double d3BdTau3 = B * ti * (ti - 1.0) * (ti - 2.0) * Math.pow(tau, -3.0);
            double dedTau = 0.0;
            double d2Bddeltadtau = B * di * ti * Math.pow(delta, -1.0) * Math.pow(tau, -1.0);
            double d2edDeltadTau = 0.0;
            ar[0][0].val += B * E;
            ar[0][1].val += dBddelta * E + B * E * deddelta;
            double G = d2Bddelta2 + 2.0 * dBddelta * deddelta + B * deddelta * deddelta + B * d2edDelta2;
            ar[0][2].val += G * E;
            double dGddelta = d3Bddelta3 + 2.0 * (d2Bddelta2 * deddelta + dBddelta * d2edDelta2) + dBddelta * d2edDelta2 + B * d3edDelta3 + dBddelta * deddelta * deddelta + 2.0 * B * deddelta * d2edDelta2;
            ar[0][3].val += E * (dGddelta + G * deddelta);
            ar[1][0].val += dBdTau * E + B * E * dedTau;
            ar[2][0].val += d2BdTau2 * E;
            ar[1][1].val += d2Bddeltadtau * E + dBdTau * E * deddelta;
        }
        for (k = this.m; k < this.n; ++k) {
            Ni = this.N_i[k];
            di = this.d_i[k];
            ti = this.t_i[k];
            double phi = this.phi_i[k];
            double Di = this.D_i[k];
            double betai = this.beta_i[k];
            double gammai = this.gamma_i[k];
            double B = Ni * Math.pow(delta, di) * Math.pow(tau, ti);
            double e = phi * (delta - Di) * (delta - Di) + betai * (tau - gammai) * (tau - gammai);
            double E = Math.exp(e);
            ar[0][0].val += B * E;
            double dBddelta = B * di * Math.pow(delta, -1.0);
            double d2Bddelta2 = B * di * (di - 1.0) * Math.pow(delta, -2.0);
            double d3Bddelta3 = B * di * (di - 1.0) * (di - 2.0) * Math.pow(delta, -3.0);
            double dedDelta = 2.0 * phi * (delta - Di);
            double d2edDelta2 = 2.0 * phi;
            double d3edDelta3 = 0.0;
            double dBdTau = B * ti * Math.pow(tau, -1.0);
            double d2BdTau2 = B * ti * (ti - 1.0) * Math.pow(tau, -2.0);
            double d3BdTau3 = B * ti * (ti - 1.0) * (ti - 2.0) * Math.pow(tau, -3.0);
            double dedTau = 2.0 * betai * (tau - gammai);
            double d2edTau2 = 2.0 * betai;
            double d2Bddeltadtau = B * di * ti * Math.pow(delta, -1.0) * Math.pow(tau, -1.0);
            double d2edDeltadTau = 0.0;
            ar[0][1].val += dBddelta * E + B * E * dedDelta;
            double G = d2Bddelta2 + 2.0 * dBddelta * dedDelta + B * dedDelta * dedDelta + B * d2edDelta2;
            ar[0][2].val += G * E;
            double dGddelta = d3Bddelta3 + 2.0 * (d2Bddelta2 * dedDelta + dBddelta * d2edDelta2) + dBddelta * d2edDelta2 + B * d3edDelta3 + dBddelta * dedDelta * dedDelta + 2.0 * B * dedDelta * d2edDelta2;
            ar[0][3].val += E * (dGddelta + G * dedDelta);
            ar[1][0].val += dBdTau * E + B * E * dedTau;
            ar[2][0].val += d2BdTau2 * E + 2.0 * dBdTau * E * dedTau + B * E * dedTau * dedTau + B * E * d2edTau2;
            ar[1][1].val += d2Bddeltadtau * E + dBdTau * E * dedDelta + dBddelta * E * dedTau + B * E * dedDelta * dedTau + B * E * d2edDeltadTau;
        }
        ar[0][1].val = delta * ar[0][1].val;
        ar[0][2].val = delta * delta * ar[0][2].val;
        ar[0][3].val = delta * delta * delta * ar[0][3].val;
        ar[1][0].val = tau * ar[1][0].val;
        ar[2][0].val = tau * tau * ar[2][0].val;
        ar[1][1].val = tau * delta * ar[1][1].val;
    }

    void Alpha0Leachman(double T, double D, doubleW[] a0) {
        int k;
        double tau = this.Tc / T;
        double delta = D / this.Dc;
        double lntau = Math.log(tau);
        a0[0].val = Math.log(delta) + 1.5 * Math.log(tau) + this.a0k[0] + this.a0k[1] * tau;
        for (k = 2; k < this.K; ++k) {
            double d = this.a0k[k];
            a0[0].val += this.a0k[k] * Math.log(1.0 - Math.exp(this.b0k[k] * tau));
        }
        a0[1].val = 1.5 / tau + this.a0k[1];
        for (k = 2; k < this.K; ++k) {
            a0[1].val += -this.a0k[k] * this.b0k[k] * Math.exp(this.b0k[k] * tau) / (1.0 - Math.exp(this.b0k[k] * tau));
        }
        a0[2].val = -1.5 / (tau * tau);
        for (k = 2; k < this.K; ++k) {
            a0[2].val += -this.a0k[k] * this.b0k[k] * this.b0k[k] * Math.exp(this.b0k[k] * tau) * (1.0 / (1.0 - Math.exp(this.b0k[k] * tau)) + Math.exp(this.b0k[k] * tau) / Math.pow(1.0 - Math.exp(this.b0k[k] * tau), 2.0));
        }
        a0[1].val = tau * a0[1].val;
        a0[2].val = tau * tau * a0[2].val;
    }

    public void propertiesLeachman(double T, double D, doubleW P, doubleW Z, doubleW dPdD, doubleW d2PdD2, doubleW d2PdTD, doubleW dPdT, doubleW U, doubleW H, doubleW S, doubleW Cv, doubleW Cp, doubleW W, doubleW G, doubleW JT, doubleW Kappa, doubleW A) {
        doubleW[] a0 = new doubleW[3];
        for (int i = 0; i < 3; ++i) {
            a0[i] = new doubleW(0.0);
        }
        doubleW[][] ar = new doubleW[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ar[i][j] = new doubleW(0.0);
            }
        }
        this.Alpha0Leachman(T, D, a0);
        this.AlpharLeachman(1, 0, T, D, ar);
        double R = this.R_L;
        double RT = R * T;
        Z.val = 1.0 + ar[0][1].val;
        P.val = D * RT * Z.val;
        dPdD.val = RT * (1.0 + 2.0 * ar[0][1].val + ar[0][2].val);
        dPdT.val = D * R * (1.0 + ar[0][1].val - ar[1][1].val);
        d2PdTD.val = R * (1.0 + 2.0 * ar[0][1].val + ar[0][2].val - 2.0 * ar[1][1].val - ar[1][2].val);
        A.val = RT * (a0[0].val + ar[0][0].val);
        G.val = RT * (1.0 + ar[0][1].val + a0[0].val + ar[0][0].val);
        U.val = RT * (a0[1].val + ar[1][0].val);
        H.val = RT * (1.0 + ar[0][1].val + a0[1].val + ar[1][0].val);
        S.val = R * (a0[1].val + ar[1][0].val - a0[0].val - ar[0][0].val);
        Cv.val = -R * (a0[2].val + ar[2][0].val);
        if (D > this.epsilon) {
            Cp.val = Cv.val + T * (dPdT.val / D) * (dPdT.val / D) / dPdD.val;
            d2PdD2.val = RT * (2.0 * ar[0][1].val + 4.0 * ar[0][2].val + ar[0][3].val) / D;
            JT.val = (T / D * dPdT.val / dPdD.val - 1.0) / Cp.val / D;
        } else {
            Cp.val = Cv.val + R;
            d2PdD2.val = 0.0;
            JT.val = 1.0E20;
        }
        W.val = 1000.0 * Cp.val / Cv.val * dPdD.val / this.M_L;
        if (W.val < 0.0) {
            W.val = 0.0;
        }
        W.val = Math.sqrt(W.val);
        Kappa.val = Math.pow(W.val, 2.0) * this.M_L / (RT * 1000.0 * Z.val);
    }

    void PseudoCriticalPointLeachman(doubleW Tcx, doubleW Dcx) {
        if (this.Tc == 0.0 || this.Dc == 0.0) {
            throw new IllegalStateException("Critical point parameters not set. Please call SetupLeachman() first.");
        }
        Tcx.val = this.Tc;
        Dcx.val = this.Dc;
        double Vcx = 1.0 / Dcx.val;
    }

    public void SetupLeachman(String hydrogenType) {
        this.R_L = 8.31451;
        this.M_L = 2.01588;
        switch (hydrogenType.toLowerCase()) {
            case "normal": {
                this.a0k = new double[]{-1.4579856475, 1.888076782, 1.616, -0.4117, -0.792, 0.758, 1.217};
                this.b0k = new double[]{0.0, 0.0, -16.0205159149, -22.6580178006, -60.0090511389, -74.9434303817, -206.9392065168};
                this.K = 7;
                this.N_i = new double[]{-6.93643, 0.01, 2.1101, 4.52059, 0.732564, -1.34086, 0.130985, -0.777414, 0.351944, -0.0211716, 0.0226312, 0.032187, -0.0231752, 0.0557346};
                this.t_i = new double[]{0.6844, 1.0, 0.989, 0.489, 0.803, 1.1444, 1.409, 1.754, 1.311, 4.187, 5.646, 0.791, 7.249, 2.986};
                this.d_i = new double[]{1.0, 4.0, 1.0, 1.0, 2.0, 2.0, 3.0, 1.0, 3.0, 2.0, 1.0, 3.0, 1.0, 1.0};
                this.p_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0};
                this.phi_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.685, -0.489, -0.103, -2.506, -1.607};
                this.beta_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.171, -0.2245, -0.1304, -0.2785, -0.3967};
                this.gamma_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.7164, 1.3444, 1.4517, 0.7204, 1.5445};
                this.D_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.506, 0.156, 1.736, 0.67, 1.662};
                this.Tc = 33.145;
                this.Dc = 15.508;
                break;
            }
            case "para": {
                this.a0k = new double[]{-1.4485891134, 1.884521239, 4.30256, 13.0289, -47.7365, 50.0013, -18.6261, 0.993973, 0.536078};
                this.b0k = new double[]{0.0, 0.0, -15.1496751472, -25.0925982148, -29.4735563787, -35.4059141417, -40.724998482, -163.7925799988, -309.2173173842};
                this.K = 9;
                this.N_i = new double[]{-7.33375, 0.01, 2.60375, 4.66279, 0.68239, -1.47078, 0.135801, -1.05327, 0.328239, -0.057783, 0.044974, 0.070346, -0.040176, 0.11951};
                this.t_i = new double[]{0.6855, 1.0, 1.0, 0.489, 0.774, 1.133, 1.386, 1.619, 1.162, 3.96, 5.276, 0.99, 6.791, 3.19};
                this.d_i = new double[]{1.0, 4.0, 1.0, 1.0, 2.0, 2.0, 3.0, 1.0, 3.0, 2.0, 1.0, 3.0, 1.0, 1.0};
                this.p_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0};
                this.phi_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.7437, -0.5516, -0.0634, -2.1341, -1.777};
                this.beta_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.194, -0.2019, -0.0301, -0.2383, -0.3253};
                this.gamma_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.8048, 1.5248, 0.6648, 0.6832, 1.493};
                this.D_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.5487, 0.1785, 1.28, 0.6319, 1.7104};
                this.Tc = 32.938;
                this.Dc = 15.538;
                break;
            }
            case "ortho": {
                this.a0k = new double[]{-1.4675442336, 1.8845068862, 2.54151, -2.3661, 1.00365, 1.22447};
                this.b0k = new double[]{0.0, 0.0, -25.7676098736, -43.4677904877, -66.044551475, -209.7531607465};
                this.K = 6;
                this.N_i = new double[]{-6.83148, 0.01, 2.11505, 4.38353, 0.211292, -1.00939, 0.142086, -0.87696, 0.804927, -0.710775, 0.0639688, 0.0710858, -0.087654, 0.647088};
                this.t_i = new double[]{0.7333, 1.0, 1.1372, 0.5136, 0.5638, 1.6248, 1.829, 2.404, 2.105, 4.1, 7.658, 1.259, 7.589, 3.946};
                this.d_i = new double[]{1.0, 4.0, 1.0, 1.0, 2.0, 2.0, 3.0, 1.0, 3.0, 2.0, 1.0, 3.0, 1.0, 1.0};
                this.p_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0};
                this.phi_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.169, -0.894, -0.04, -2.072, -1.306};
                this.beta_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.4555, -0.4046, -0.0869, -0.4415, -0.5743};
                this.gamma_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.5444, 0.6627, 0.763, 0.6587, 1.4327};
                this.D_i = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.6366, 0.3876, 0.9437, 0.3976, 0.9626};
                this.Tc = 33.22;
                this.Dc = 15.445;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid hydrogen type: " + hydrogenType);
            }
        }
    }

    public void SetupLeachman() {
        System.out.println("No hydrogen type specified. Using default type: 'Normal'.");
        this.SetupLeachman("normal");
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        Leachman test = new Leachman();
        test.SetupLeachman();
        double T = 500.0;
        doubleW D = new doubleW(30.0);
        doubleW P = new doubleW(500.0);
        intW ierr = new intW(0);
        doubleW Z = new doubleW(0.0);
        int iFlag = 0;
        StringW herr = new StringW("");
        test.DensityLeachman(iFlag, T, P.val, D, ierr, herr);
        System.out.println("density " + D.val);
        doubleW dPdD = new doubleW(0.0);
        doubleW d2PdD2 = new doubleW(0.0);
        doubleW d2PdTD = new doubleW(0.0);
        doubleW dPdT = new doubleW(0.0);
        doubleW U = new doubleW(0.0);
        doubleW H = new doubleW(0.0);
        doubleW S = new doubleW(0.0);
        doubleW A = new doubleW(0.0);
        doubleW P2 = new doubleW(0.0);
        doubleW Cv = new doubleW(0.0);
        doubleW Cp = new doubleW(0.0);
        doubleW W = new doubleW(0.0);
        doubleW G = new doubleW(0.0);
        doubleW JT = new doubleW(0.0);
        doubleW Kappa = new doubleW(0.0);
        doubleW PP = new doubleW(0.0);
        test.propertiesLeachman(T, D.val, P, Z, dPdD, d2PdD2, d2PdTD, dPdT, U, H, S, Cv, Cp, W, G, JT, Kappa, A);
        System.out.println("Outputs-----\n");
        System.out.println("Outputs-----\n");
        System.out.println("Molar mass [g/mol]:                 " + test.M_L);
        System.out.println("Molar density [mol/l]:              " + D.val);
        System.out.println("Pressure [kPa]:                     " + P.val);
        System.out.println("Compressibility factor:             " + Z.val);
        System.out.println("d(P)/d(rho) [kPa/(mol/l)]:          " + dPdD.val);
        System.out.println("d^2(P)/d(rho)^2 [kPa/(mol/l)^2]:    " + d2PdD2.val);
        System.out.println("d(P)/d(T) [kPa/K]:                  " + dPdT.val);
        System.out.println("Energy [J/mol]:                     " + U.val);
        System.out.println("Enthalpy [J/mol]:                   " + H.val);
        System.out.println("Entropy [J/mol-K]:                  " + S.val);
        System.out.println("Isochoric heat capacity [J/mol-K]:  " + Cv.val);
        System.out.println("Isobaric heat capacity [J/mol-K]:   " + Cp.val);
        System.out.println("Speed of sound [m/s]:               " + W.val);
        System.out.println("Gibbs energy [J/mol]:               " + G.val);
        System.out.println("Joule-Thomson coefficient [K/kPa]:  " + JT.val);
        System.out.println("Isentropic exponent:                " + Kappa.val);
    }
}

