/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.leachman;

import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.util.leachman.Leachman;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.netlib.util.StringW;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class NeqSimLeachman {
    PhaseInterface phase = null;
    Leachman Leachman = new Leachman();

    public NeqSimLeachman() {
    }

    public NeqSimLeachman(PhaseInterface phase, String hydrogenType) {
        this.setPhase(phase);
        if (hydrogenType == null || hydrogenType.trim().isEmpty()) {
            String componentName = phase.getComponent(0).getComponentName().toLowerCase();
            hydrogenType = componentName.equals("para-hydrogen") ? "para" : (componentName.equals("ortho-hydrogen") ? "ortho" : "normal");
        }
        this.Leachman.SetupLeachman(hydrogenType);
    }

    public double getMolarDensity(PhaseInterface phase) {
        return this.getMolarDensity();
    }

    public double getDensity(PhaseInterface phase) {
        return this.getMolarDensity() * this.Leachman.M_L;
    }

    public double getDensity() {
        return this.getMolarDensity() * this.Leachman.M_L;
    }

    public double getPressure() {
        double moldens = this.getMolarDensity();
        doubleW P = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        this.Leachman.PressureLeachman(this.phase.getTemperature(), moldens, P, Z);
        return P.val;
    }

    public double getMolarDensity() {
        int flag = 0;
        intW ierr = new intW(0);
        StringW herr = new StringW("");
        doubleW D = new doubleW(0.0);
        double pressure = this.phase.getPressure() * 100.0;
        this.Leachman.DensityLeachman(flag, this.phase.getTemperature(), pressure, D, ierr, herr);
        return D.val;
    }

    public double[] propertiesLeachman(PhaseInterface phase) {
        return this.propertiesLeachman();
    }

    public double[] getProperties(PhaseInterface phase, String[] properties) {
        double[] allProperties = this.propertiesLeachman();
        double[] returnProperties = new double[properties.length];
        block12: for (int i = 0; i < properties.length; ++i) {
            switch (properties[i]) {
                case "density": {
                    returnProperties[i] = allProperties[0];
                    continue block12;
                }
                case "Cp": {
                    returnProperties[i] = allProperties[1];
                    continue block12;
                }
                case "Cv": {
                    returnProperties[i] = allProperties[2];
                    continue block12;
                }
                case "soundSpeed": {
                    returnProperties[i] = allProperties[3];
                    continue block12;
                }
            }
        }
        return returnProperties;
    }

    public double[] propertiesLeachman() {
        doubleW p = new doubleW(0.0);
        doubleW z = new doubleW(0.0);
        doubleW dpdd = new doubleW(0.0);
        doubleW d2pdd2 = new doubleW(0.0);
        doubleW d2pdtd = new doubleW(0.0);
        doubleW dpdt = new doubleW(0.0);
        doubleW u = new doubleW(0.0);
        doubleW h = new doubleW(0.0);
        doubleW s = new doubleW(0.0);
        doubleW cv = new doubleW(0.0);
        doubleW cp = new doubleW(0.0);
        doubleW w = new doubleW(0.0);
        doubleW g = new doubleW(0.0);
        doubleW jt = new doubleW(0.0);
        doubleW kappa = new doubleW(0.0);
        doubleW A = new doubleW(0.0);
        double dens = this.getMolarDensity();
        this.Leachman.propertiesLeachman(this.phase.getTemperature(), dens, p, z, dpdd, d2pdd2, d2pdtd, dpdt, u, h, s, cv, cp, w, g, jt, kappa, A);
        double[] properties = new double[]{p.val, z.val, dpdd.val, d2pdd2.val, d2pdtd.val, dpdt.val, u.val, h.val, s.val, cv.val, cp.val, w.val, g.val, jt.val, kappa.val};
        return properties;
    }

    public void setPhase(PhaseInterface phase) {
        if (phase.getNumberOfComponents() != 1) {
            throw new IllegalArgumentException("Leachman model requires exactly one component (hydrogen). Found " + phase.getNumberOfComponents() + " components.");
        }
        String componentName = phase.getComponent(0).getComponentName();
        if (!("hydrogen".equalsIgnoreCase(componentName) || "para-hydrogen".equalsIgnoreCase(componentName) || "ortho-hydrogen".equalsIgnoreCase(componentName))) {
            throw new IllegalArgumentException("Leachman model requires 'hydrogen'. Found: " + componentName);
        }
        this.phase = phase;
    }

    public doubleW[] getAlpha0_Leachman() {
        double temperature = this.phase.getTemperature();
        double molarDensity = this.getMolarDensity(this.phase);
        int rows = 4;
        int cols = 4;
        doubleW[] a0 = new doubleW[rows];
        for (int i = 0; i < rows; ++i) {
            a0[i] = new doubleW(0.0);
        }
        this.Leachman.Alpha0Leachman(temperature, molarDensity, a0);
        return a0;
    }

    public doubleW[][] getAlphares_Leachman() {
        double temperature = this.phase.getTemperature();
        double molarDensity = this.getMolarDensity(this.phase);
        int rows = 4;
        int cols = 4;
        doubleW[][] ar = new doubleW[rows][cols];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                ar[i][j] = new doubleW(0.0);
            }
        }
        this.Leachman.AlpharLeachman(0, 0, temperature, molarDensity, ar);
        return ar;
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkEos fluid1 = new SystemSrkEos();
        fluid1.addComponent("hydrogen", 90.0);
        fluid1.setTemperature(300.0);
        fluid1.setPressure(50.0);
        fluid1.init(0);
        ThermodynamicOperations ops = new ThermodynamicOperations(fluid1);
        ops.TPflash();
        String hydrogenType = "normal";
        System.out.println("density Leachman " + fluid1.getPhase(0).getDensity_Leachman(hydrogenType));
        NeqSimLeachman test = new NeqSimLeachman(fluid1.getPhase("gas"), hydrogenType);
        System.out.println("density " + test.getDensity());
        System.out.println("pressure " + test.getPressure());
        double[] properties = test.propertiesLeachman();
        System.out.println("Pressure [kPa]:            " + properties[0]);
        System.out.println("Compressibility factor:            " + properties[1]);
        System.out.println("d(P)/d(rho) [kPa/(mol/l)]            " + properties[2]);
        System.out.println("d^2(P)/d(rho)^2 [kPa/(mol/l)^2]:            " + properties[3]);
        System.out.println("d2(P)/d2(T) [kPa/K]:             " + properties[4]);
        System.out.println("d(P)/d(T) [kPa/K]:             " + properties[5]);
        System.out.println("Energy [J/mol]:             " + properties[6]);
        System.out.println("Enthalpy [J/mol]:             " + properties[7]);
        System.out.println("Entropy [J/mol-K]:             " + properties[8]);
        System.out.println("Isochoric heat capacity [J/mol-K]:             " + properties[9]);
        System.out.println("Isobaric heat capacity [J/mol-K]:            " + properties[10]);
        System.out.println("Speed of sound [m/s]:            " + properties[11]);
        System.out.println("Gibbs energy [J/mol]:            " + properties[12]);
        System.out.println("Joule-Thomson coefficient [K/kPa]:            " + properties[13]);
        System.out.println("Isentropic exponent:           " + properties[14]);
    }
}

