/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations;

import java.awt.BorderLayout;
import java.awt.Container;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import neqsim.api.ioc.CalculationResult;
import neqsim.thermo.component.ComponentHydrate;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSoreideWhitson;
import neqsim.thermodynamicoperations.OperationInterface;
import neqsim.thermodynamicoperations.chemicalequilibrium.ChemicalEquilibrium;
import neqsim.thermodynamicoperations.flashops.CalcIonicComposition;
import neqsim.thermodynamicoperations.flashops.CriticalPointFlash;
import neqsim.thermodynamicoperations.flashops.PHflash;
import neqsim.thermodynamicoperations.flashops.PHflashGERG2008;
import neqsim.thermodynamicoperations.flashops.PHflashLeachman;
import neqsim.thermodynamicoperations.flashops.PHflashSingleComp;
import neqsim.thermodynamicoperations.flashops.PHflashVega;
import neqsim.thermodynamicoperations.flashops.PHsolidFlash;
import neqsim.thermodynamicoperations.flashops.PSFlash;
import neqsim.thermodynamicoperations.flashops.PSFlashGERG2008;
import neqsim.thermodynamicoperations.flashops.PSFlashLeachman;
import neqsim.thermodynamicoperations.flashops.PSFlashVega;
import neqsim.thermodynamicoperations.flashops.PSflashSingleComp;
import neqsim.thermodynamicoperations.flashops.PUflash;
import neqsim.thermodynamicoperations.flashops.PVrefluxflash;
import neqsim.thermodynamicoperations.flashops.SaturateWithWater;
import neqsim.thermodynamicoperations.flashops.SolidFlash1;
import neqsim.thermodynamicoperations.flashops.TPflash;
import neqsim.thermodynamicoperations.flashops.TPgradientFlash;
import neqsim.thermodynamicoperations.flashops.TSFlash;
import neqsim.thermodynamicoperations.flashops.TVflash;
import neqsim.thermodynamicoperations.flashops.TVfractionFlash;
import neqsim.thermodynamicoperations.flashops.VHflashQfunc;
import neqsim.thermodynamicoperations.flashops.VSflash;
import neqsim.thermodynamicoperations.flashops.VUflashQfunc;
import neqsim.thermodynamicoperations.flashops.dTPflash;
import neqsim.thermodynamicoperations.flashops.saturationops.AddIonToScaleSaturation;
import neqsim.thermodynamicoperations.flashops.saturationops.BubblePointPressureFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.BubblePointPressureFlashDer;
import neqsim.thermodynamicoperations.flashops.saturationops.BubblePointTemperatureNoDer;
import neqsim.thermodynamicoperations.flashops.saturationops.CalcSaltSatauration;
import neqsim.thermodynamicoperations.flashops.saturationops.CheckScalePotential;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyPressureFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.CricondebarFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.DewPointPressureFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.DewPointTemperatureFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.DewPointTemperatureFlashDer;
import neqsim.thermodynamicoperations.flashops.saturationops.FreezingPointTemperatureFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.HCdewPointPressureFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.HydrateEquilibriumLine;
import neqsim.thermodynamicoperations.flashops.saturationops.HydrateFormationPressureFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.HydrateFormationTemperatureFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.HydrateInhibitorConcentrationFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.HydrateInhibitorwtFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.SolidComplexTemperatureCalc;
import neqsim.thermodynamicoperations.flashops.saturationops.WATcalc;
import neqsim.thermodynamicoperations.flashops.saturationops.WaterDewPointEquilibriumLine;
import neqsim.thermodynamicoperations.flashops.saturationops.WaterDewPointTemperatureFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.WaterDewPointTemperatureMultiphaseFlash;
import neqsim.thermodynamicoperations.phaseenvelopeops.multicomponentenvelopeops.CricondenBarFlash;
import neqsim.thermodynamicoperations.phaseenvelopeops.multicomponentenvelopeops.CricondenThermFlash;
import neqsim.thermodynamicoperations.phaseenvelopeops.multicomponentenvelopeops.HPTphaseEnvelope;
import neqsim.thermodynamicoperations.phaseenvelopeops.multicomponentenvelopeops.PTphaseEnvelope;
import neqsim.thermodynamicoperations.phaseenvelopeops.multicomponentenvelopeops.PTphaseEnvelopeNew2;
import neqsim.thermodynamicoperations.phaseenvelopeops.multicomponentenvelopeops.PTphaseEnvelopeNew3;
import neqsim.thermodynamicoperations.phaseenvelopeops.reactivecurves.PloadingCurve2;
import neqsim.thermodynamicoperations.propertygenerator.OLGApropertyTableGeneratorWaterKeywordFormat;
import neqsim.thermodynamicoperations.propertygenerator.OLGApropertyTableGeneratorWaterStudents;
import neqsim.thermodynamicoperations.propertygenerator.OLGApropertyTableGeneratorWaterStudentsPH;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import neqsim.util.exception.InvalidInputException;
import neqsim.util.exception.IsNaNException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class ThermodynamicOperations
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ThermodynamicOperations.class);
    private Thread thermoOperationThread = new Thread();
    private OperationInterface operation = null;
    SystemInterface system = null;
    boolean writeFile = false;
    String fileName = null;
    private boolean runAsThread = false;
    protected String[][] resultTable = null;

    public ThermodynamicOperations() {
    }

    public ThermodynamicOperations(SystemInterface system) {
        this.system = system;
    }

    public SystemInterface getSystem() {
        return this.system;
    }

    public void setSystem(SystemInterface system) {
        this.system = system;
    }

    public void TPSolidflash() {
        this.operation = new SolidFlash1(this.system);
        this.getOperation().run();
    }

    public void TPVflash(double volumeSpec, String unit) {
        unit = "m3";
        this.TPflash();
        double startVolume = this.system.getVolume(unit);
        this.system.setTotalNumberOfMoles(this.system.getNumberOfMoles() * volumeSpec / startVolume);
        this.system.init(3);
    }

    public void TPflash() {
        if (this.system != null && this.system.getClass().getName().equals("neqsim.thermo.system.SystemSoreideWhitson")) {
            this.TPflashSoreideWhitson();
            return;
        }
        double flowRate = this.system.getTotalNumberOfMoles();
        if (flowRate < 1.0E-5) {
            this.system.setTotalNumberOfMoles(1.0);
            this.system.init(1);
        }
        this.operation = new TPflash(this.system, this.system.doSolidPhaseCheck());
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
        if (flowRate < 1.0E-5) {
            double minimumFlowRate = 1.0E-50;
            if (flowRate < 1.0E-50) {
                this.system.setTotalNumberOfMoles(1.0E-50);
            } else {
                this.system.setTotalNumberOfMoles(flowRate);
            }
            this.system.init(1);
        }
    }

    public void TPflashSoreideWhitson() {
        double flowRate = this.system.getTotalNumberOfMoles();
        if (flowRate < 1.0E-5) {
            this.system.setTotalNumberOfMoles(1.0);
            this.system.init(1);
        }
        this.operation = new TPflash(this.system, this.system.doSolidPhaseCheck());
        boolean rerun = true;
        int iterationCount = 0;
        while (rerun) {
            this.operation = new TPflash(this.system, this.system.doSolidPhaseCheck());
            if (!this.isRunAsThread()) {
                this.getOperation().run();
            } else {
                this.run();
            }
            rerun = ((SystemSoreideWhitson)this.system).calcSalinity();
            if (++iterationCount < 10) continue;
            System.err.println("Warning: Maximum number of iterations (10) reached in TPflash salinity loop. Stopping further execution.");
            break;
        }
        if (flowRate < 1.0E-5) {
            double minimumFlowRate = 1.0E-50;
            if (flowRate < 1.0E-50) {
                this.system.setTotalNumberOfMoles(1.0E-50);
            } else {
                this.system.setTotalNumberOfMoles(flowRate);
            }
            this.system.init(1);
        }
    }

    public void TPflash(boolean checkForSolids) {
        this.operation = new TPflash(this.system, checkForSolids);
        this.getOperation().run();
    }

    public SystemInterface TPgradientFlash(double height, double temperature) {
        this.operation = new TPgradientFlash(this.system, height, temperature);
        this.getOperation().run();
        return this.operation.getThermoSystem();
    }

    public void dTPflash(String[] comps) {
        this.operation = new dTPflash(this.system, comps);
        this.getOperation().run();
    }

    public void saturateWithWater() {
        this.operation = new SaturateWithWater(this.system);
        this.getOperation().run();
    }

    public void chemicalEquilibrium() {
        if (this.system.isChemicalSystem()) {
            this.operation = new ChemicalEquilibrium(this.system);
            this.getOperation().run();
        }
    }

    public void PHflash(double Hspec, int type) {
        this.operation = this.system.getPhase(0).getNumberOfComponents() == 1 ? new PHflashSingleComp(this.system, Hspec, type) : new PHflash(this.system, Hspec, type);
        this.getOperation().run();
    }

    public void PHflash(double Hspec, String enthalpyUnit) {
        double conversionFactor = 1.0;
        switch (enthalpyUnit) {
            case "J": {
                conversionFactor = 1.0;
                break;
            }
            case "J/mol": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.PHflash(Hspec / conversionFactor);
    }

    public void PHflash(double Hspec) {
        this.PHflash(Hspec, 0);
    }

    public void PHflashGERG2008(double Hspec) {
        this.operation = new PHflashGERG2008(this.system, Hspec);
        this.getOperation().run();
    }

    public void PHflashLeachman(double Hspec) {
        this.operation = new PHflashLeachman(this.system, Hspec);
        this.getOperation().run();
    }

    public void PHflashVega(double Hspec) {
        this.operation = new PHflashVega(this.system, Hspec);
        this.getOperation().run();
    }

    public void PUflash(double Uspec) {
        this.operation = new PUflash(this.system, Uspec);
        this.getOperation().run();
    }

    public void PUflash(double Pspec, double Uspec, String unitPressure, String unitEnergy) {
        this.system.setPressure(Pspec, unitPressure);
        this.PUflash(Uspec, unitEnergy);
    }

    public void PUflash(double Uspec, String unitEnergy) {
        double conversionFactorEntr = 1.0;
        switch (unitEnergy) {
            case "J": {
                conversionFactorEntr = 1.0;
                break;
            }
            case "J/mol": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.PUflash(Uspec / conversionFactorEntr);
    }

    public void PHflash2(double Hspec, int type) {
        this.operation = new PHflash(this.system, Hspec, type);
        this.getOperation().run();
    }

    public void criticalPointFlash() {
        this.operation = new CriticalPointFlash(this.system);
        this.getOperation().run();
    }

    public void PHsolidFlash(double Hspec) {
        this.operation = new PHsolidFlash(this.system, Hspec);
        this.getOperation().run();
    }

    public void PSflash(double Sspec) {
        this.operation = this.system.getPhase(0).getNumberOfComponents() == 1 ? new PSflashSingleComp(this.system, Sspec, 0) : new PSFlash(this.system, Sspec, 0);
        this.getOperation().run();
    }

    public void PSflash(double Sspec, String unit) {
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.PSflash(Sspec / conversionFactor);
    }

    public void TSflash(double Sspec) {
        this.operation = new TSFlash(this.system, Sspec);
        this.getOperation().run();
    }

    public void TSflash(double Sspec, String unit) {
        double conversionFactor = 1.0;
        switch (unit) {
            case "J/K": {
                conversionFactor = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kgK": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactor = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.TSflash(Sspec / conversionFactor);
    }

    public void PSflashGERG2008(double Sspec) {
        this.operation = new PSFlashGERG2008(this.system, Sspec);
        this.getOperation().run();
    }

    public void PSflashLeachman(double Sspec) {
        this.operation = new PSFlashLeachman(this.system, Sspec);
        this.getOperation().run();
    }

    public void PSflashVega(double Sspec) {
        this.operation = new PSFlashVega(this.system, Sspec);
        this.getOperation().run();
    }

    public void PSflash2(double Sspec) {
        this.operation = new PSFlash(this.system, Sspec, 0);
        this.getOperation().run();
    }

    public void VSflash(double volume, double entropy, String unitVol, String unitEntropy) {
        double conversionFactorV = 1.0;
        double conversionFactorEntr = 1.0;
        switch (unitVol) {
            case "m3": {
                conversionFactorV = 100000.0;
                break;
            }
        }
        switch (unitEntropy) {
            case "J/K": {
                conversionFactorEntr = 1.0;
                break;
            }
            case "J/molK": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kgK": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kgK": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.VSflash(volume * conversionFactorV, entropy / conversionFactorEntr);
    }

    public void VSflash(double volume, double entropy) {
        this.operation = new VSflash(this.system, volume, entropy);
        this.getOperation().run();
    }

    public void TVflash(double Vspec, String unit) {
        double conversionFactor = 1.0;
        switch (unit) {
            case "m3": {
                conversionFactor = 100000.0;
                break;
            }
        }
        this.TVflash(Vspec * conversionFactor);
    }

    public void TVflash(double Vspec) {
        this.operation = new TVflash(this.system, Vspec);
        this.getOperation().run();
    }

    public void TVfractionFlash(double Vspec) {
        this.operation = new TVfractionFlash(this.system, Vspec);
        this.getOperation().run();
    }

    public void PVrefluxFlash(double refluxspec, int refluxPhase) {
        this.operation = new PVrefluxflash(this.system, refluxspec, refluxPhase);
        this.getOperation().run();
    }

    public void VHflash(double Vspec, double Hspec) {
        this.operation = new VHflashQfunc(this.system, Vspec, Hspec);
        this.getOperation().run();
    }

    public void VHflash(double volume, double enthalpy, String unitVol, String unitEnthalpy) {
        double conversionFactorV = 1.0;
        double conversionFactorEntr = 1.0;
        switch (unitVol) {
            case "m3": {
                conversionFactorV = 100000.0;
                break;
            }
        }
        switch (unitEnthalpy) {
            case "J/K": {
                conversionFactorEntr = 1.0;
                break;
            }
            case "J/mol": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.VHflash(volume * conversionFactorV, enthalpy / conversionFactorEntr);
    }

    public void VUflash(double volume, double energy, String unitVol, String unitEnergy) {
        double conversionFactorV = 1.0;
        double conversionFactorEntr = 1.0;
        switch (unitVol) {
            case "m3": {
                conversionFactorV = 100000.0;
                break;
            }
        }
        switch (unitEnergy) {
            case "J/K": {
                conversionFactorEntr = 1.0;
                break;
            }
            case "J/mol": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles();
                break;
            }
            case "J/kg": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass();
                break;
            }
            case "kJ/kg": {
                conversionFactorEntr = 1.0 / this.system.getTotalNumberOfMoles() / this.system.getMolarMass() / 1000.0;
                break;
            }
        }
        this.VUflash(volume * conversionFactorV, energy / conversionFactorEntr);
    }

    public void VUflash(double Vspec, double Uspec) {
        this.operation = new VUflashQfunc(this.system, Vspec, Uspec);
        this.getOperation().run();
    }

    public void bubblePointTemperatureFlash() throws IsNaNException {
        BubblePointTemperatureNoDer operation = new BubblePointTemperatureNoDer(this.system);
        operation.run();
        if (Double.isNaN(this.system.getTemperature()) || operation.isSuperCritical()) {
            throw new IsNaNException(this, "bubblePointTemperatureFlash", "Could not find solution - possible no bubble point exists");
        }
    }

    public void freezingPointTemperatureFlash() throws IsNaNException {
        this.operation = new FreezingPointTemperatureFlash(this.system);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this, "freezingPointTemperatureFlash", "Could not find solution - possible no freezing point exists");
        }
    }

    public void freezingPointTemperatureFlash(String phaseName) throws IsNaNException {
        this.operation = new FreezingPointTemperatureFlash(this.system);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this, "freezingPointTemperatureFlash", "Could not find solution - possible no freezing point exists");
        }
    }

    public void waterDewPointTemperatureFlash() throws IsNaNException {
        this.operation = new WaterDewPointTemperatureFlash(this.system);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this, "waterDewPointTemperatureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void waterDewPointTemperatureMultiphaseFlash() throws IsNaNException {
        this.operation = new WaterDewPointTemperatureMultiphaseFlash(this.system);
        this.getOperation().run();
    }

    public void waterPrecipitationTemperature() throws IsNaNException {
        double lowTemperature = 0.0;
        this.dewPointTemperatureFlash();
        if (this.system.getTemperature() > lowTemperature) {
            lowTemperature = this.system.getTemperature();
        }
        this.system.setTemperature(lowTemperature);
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this, "waterPrecipitationTemperature", "Could not find solution - possible no dew point exists");
        }
    }

    public void calcSaltSaturation(String saltName) throws IsNaNException {
        this.operation = new CalcSaltSatauration(this.system, saltName);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this, "calcSaltSaturation", "Could not find solution - possible no dew point exists");
        }
    }

    public void checkScalePotential(int phaseNumber) throws IsNaNException {
        this.operation = new CheckScalePotential(this.system, phaseNumber);
        this.getOperation().run();
        this.resultTable = this.getOperation().getResultTable();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this, "checkScalePotential", "Could not find solution - possible no dew point exists");
        }
    }

    public void addIonToScaleSaturation(int phaseNumber, String scaleSaltName, String nameOfIonToBeAdded) throws IsNaNException {
        this.operation = new AddIonToScaleSaturation(this.system, phaseNumber, scaleSaltName, nameOfIonToBeAdded);
        this.getOperation().run();
        this.resultTable = this.getOperation().getResultTable();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this, "addIonToScaleSaturation", "Could not find solution - possible no dew point exists");
        }
    }

    public void hydrateFormationPressure() throws IsNaNException {
        this.operation = new HydrateFormationPressureFlash(this.system);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this, "hydrateFormationPressure", "Could not find solution - possible no dew point exists");
        }
    }

    public void calcWAT() throws IsNaNException {
        this.operation = new WATcalc(this.system);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this, "calcWAT", "Could not find solution - possible no dew point exists");
        }
    }

    public void run() {
        this.setThermoOperationThread(new Thread(this.operation));
        this.getThermoOperationThread().start();
    }

    public boolean waitAndCheckForFinishedCalculation(int maxTime) {
        try {
            this.getThermoOperationThread().join(maxTime);
            this.getThermoOperationThread().interrupt();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        boolean didFinish = !this.getThermoOperationThread().isInterrupted();
        return didFinish;
    }

    public void waitToFinishCalculation() {
        try {
            this.getThermoOperationThread().join();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void calcSolidComlexTemperature() throws IsNaNException {
        this.operation = new SolidComplexTemperatureCalc(this.system);
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this, "calcSolidComlexTemperature", "error in WAT() - could not find solution - possible no dew point exists");
        }
    }

    public void calcSolidComlexTemperature(String comp1, String comp2) throws IsNaNException {
        if (this.operation == null) {
            this.operation = new SolidComplexTemperatureCalc(this.system, comp1, comp2);
        }
        this.getOperation().run();
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this, "calcSolidComlexTemperature", "error in WAT() - could not find solution - possible no dew point exists");
        }
    }

    public double[] calcImobilePhaseHydrateTemperature(double[] temperature, double[] pressure) {
        ThermodynamicOperations opsTemp;
        double[] hydTemps = new double[temperature.length];
        SystemInterface systemTemp = this.system.clone();
        for (int i = 0; i < temperature.length; ++i) {
            opsTemp = new ThermodynamicOperations(systemTemp);
            systemTemp.setTemperature(temperature[i]);
            systemTemp.setPressure(pressure[i]);
            opsTemp.TPflash();
            systemTemp.display();
            systemTemp = systemTemp.phaseToSystem(0);
        }
        opsTemp = new ThermodynamicOperations(systemTemp);
        systemTemp.setHydrateCheck(true);
        systemTemp.setMixingRule(9);
        try {
            opsTemp.hydrateFormationTemperature();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        systemTemp.display();
        return hydTemps;
    }

    public double calcTOLHydrateFormationTemperature() {
        this.TPflash();
        SystemInterface systemTemp = this.system.phaseToSystem(0);
        ThermodynamicOperations opsTemp = new ThermodynamicOperations(systemTemp);
        try {
            opsTemp.hydrateFormationTemperature();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        systemTemp.display();
        this.system.setTemperature(systemTemp.getTemperature());
        this.TPflash();
        return this.system.getTemperature();
    }

    public void hydrateInhibitorConcentration(String inhibitorName, double hydEqTemperature) {
        this.operation = new HydrateInhibitorConcentrationFlash(this.system, inhibitorName, hydEqTemperature);
        this.operation.run();
    }

    public void hydrateInhibitorConcentrationSet(String inhibitorName, double wtfrac) {
        this.operation = new HydrateInhibitorwtFlash(this.system, inhibitorName, wtfrac);
        this.operation.run();
    }

    public void hydrateFormationTemperature(double initialTemperatureGuess) {
        this.system.setTemperature(initialTemperatureGuess);
        this.operation = new HydrateFormationTemperatureFlash(this.system);
        for (int i = 0; i < this.system.getPhase(4).getNumberOfComponents(); ++i) {
            ((ComponentHydrate)this.system.getPhase(4).getComponent(i)).getHydrateStructure();
        }
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
    }

    public void hydrateFormationTemperature() throws IsNaNException {
        double factor = 1.0;
        if (this.system.getPhase(0).hasComponent("methanol")) {
            factor -= 2.0 * this.system.getPhase(0).getComponent("methanol").getz() / this.system.getPhase(0).getComponent("water").getz();
        }
        if (this.system.getPhase(0).hasComponent("MEG")) {
            factor -= 2.0 * this.system.getPhase(0).getComponent("MEG").getz() / this.system.getPhase(0).getComponent("water").getz();
        }
        if (factor < 2.0) {
            factor = 2.0;
        }
        this.system.setTemperature(273.0 + this.system.getPressure() / 100.0 * 20.0 * factor - 20.0);
        if (this.system.getTemperature() > 298.15) {
            this.system.setTemperature(298.0);
        }
        this.operation = new HydrateFormationTemperatureFlash(this.system);
        for (int i = 0; i < this.system.getPhase(4).getNumberOfComponents(); ++i) {
            ((ComponentHydrate)this.system.getPhase(4).getComponent(i)).getHydrateStructure();
        }
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
    }

    public void hydrateFormationTemperature(int structure) throws IsNaNException {
        this.system.setTemperature(274.0);
        if (structure == 0) {
            this.system.setSolidPhaseCheck("water");
            this.system.setHydrateCheck(true);
            this.operation = new FreezingPointTemperatureFlash(this.system);
        } else {
            this.operation = new HydrateFormationTemperatureFlash(this.system);
        }
        for (int i = 0; i < this.system.getPhase(4).getNumberOfComponents(); ++i) {
            ((ComponentHydrate)this.system.getPhases()[4].getComponent(i)).setHydrateStructure(structure - 1);
        }
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
        if (Double.isNaN(this.system.getTemperature())) {
            throw new IsNaNException(this, "hydrateFormationTemperature", "Could not find solution - possible no dew point exists");
        }
    }

    public void hydrateEquilibriumLine(double minimumPressure, double maximumPressure) {
        this.operation = new HydrateEquilibriumLine(this.system, minimumPressure, maximumPressure);
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
    }

    public void calcCricoP(double[] cricondenBar, double[] cricondenBarX, double[] cricondenBarY) {
        double phasefraction = 0.9999999999;
        this.operation = new CricondenBarFlash(this.system, this.fileName, phasefraction, cricondenBar, cricondenBarX, cricondenBarY);
        this.getOperation().run();
    }

    public void calcCricoT(double[] cricondenTherm, double[] cricondenThermX, double[] cricondenThermY) {
        double phasefraction = 0.9999999999;
        this.operation = new CricondenThermFlash(this.system, this.fileName, phasefraction, cricondenTherm, cricondenThermX, cricondenThermY);
        this.getOperation().run();
    }

    public void waterDewPointLine(double minimumPressure, double maximumPressure) {
        this.operation = new WaterDewPointEquilibriumLine(this.system, minimumPressure, maximumPressure);
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
    }

    public double calcCricondenBar() {
        this.system.init(0);
        this.operation = new CricondebarFlash(this.system);
        this.operation.run();
        return this.system.getPressure();
    }

    public void bubblePointPressureFlash() throws IsNaNException {
        this.system.init(0);
        ConstantDutyPressureFlash operation = new ConstantDutyPressureFlash(this.system);
        this.system.setBeta(1, 0.9999999999);
        this.system.setBeta(0, 1.0E-10);
        operation.run();
        if (Double.isNaN(this.system.getPressure()) || operation.isSuperCritical()) {
            throw new IsNaNException(this, "bubblePointPressureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void bubblePointPressureFlash(boolean derivatives) throws IsNaNException {
        ConstantDutyPressureFlash operation = null;
        operation = derivatives ? new BubblePointPressureFlashDer(this.system) : new BubblePointPressureFlash(this.system);
        try {
            operation.run();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        if (Double.isNaN(this.system.getPressure()) || operation.isSuperCritical()) {
            throw new IsNaNException(this, "bubblePointPressureFlash", "Could not find solution - possible no bubble point exists");
        }
    }

    public void constantPhaseFractionPressureFlash(double fraction) throws IsNaNException {
        this.system.init(0);
        if (fraction < 1.0E-10) {
            fraction = 1.0E-10;
        }
        if (fraction > 0.9999999999) {
            fraction = 0.9999999999;
        }
        ConstantDutyPressureFlash operation = new ConstantDutyPressureFlash(this.system);
        this.system.setBeta(1, 1.0 - fraction);
        this.system.setBeta(0, fraction);
        operation.run();
        if (Double.isNaN(this.system.getPressure()) || operation.isSuperCritical()) {
            throw new IsNaNException(this, "constantPhaseFractionPressureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void constantPhaseFractionTemperatureFlash(double fraction) throws IsNaNException {
        this.system.init(0);
        if (fraction < 1.0E-10) {
            fraction = 1.0E-10;
        }
        if (fraction > 0.9999999999) {
            fraction = 0.9999999999;
        }
        ConstantDutyTemperatureFlash operation = new ConstantDutyTemperatureFlash(this.system);
        this.system.setBeta(1, 1.0 - fraction);
        this.system.setBeta(0, fraction);
        operation.run();
        if (Double.isNaN(this.system.getPressure()) || operation.isSuperCritical()) {
            throw new IsNaNException(this, "constantPhaseFractionTemperatureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void dewPointMach(String componentName, String specification, double spec) throws IsNaNException {
        double newTemperature;
        double dn = 0.0;
        if (!this.system.getPhase(0).hasComponent(componentName)) {
            throw new IsNaNException(this, "dewPointMach", "Specified component is not present in mixture: " + componentName);
        }
        dn = this.system.getNumberOfMoles() / 1000000.0;
        this.system.addComponent(componentName, dn);
        double oldTemperature = newTemperature = this.system.getTemperature();
        int iterations = 0;
        if (specification.equals("dewPointTemperature")) {
            do {
                this.system.init(0);
                this.dewPointTemperatureFlash();
                newTemperature = this.system.getTemperature();
                double oldMoles = this.system.getPhase(0).getComponent(componentName).getNumberOfmoles();
                if (++iterations > 1) {
                    this.system.addComponent(componentName, -((double)iterations / (30.0 + (double)iterations)) * (newTemperature - spec) / ((newTemperature - oldTemperature) / dn));
                } else {
                    this.system.addComponent(componentName, this.system.getNumberOfMoles() / 1000000.0);
                }
                dn = this.system.getPhase(0).getComponent(componentName).getNumberOfmoles() - oldMoles;
                oldTemperature = newTemperature;
            } while (Math.abs(dn / this.system.getPhase(0).getComponent(componentName).getNumberOfmoles()) > 1.0E-9 || iterations < 5 || iterations > 105);
            this.dewPointTemperatureFlash();
        }
        if (Double.isNaN(this.system.getPressure())) {
            throw new IsNaNException(this, "dewPointMach", "Could not find solution - possible no dew point exists");
        }
    }

    public void dewPointTemperatureFlash() throws IsNaNException {
        DewPointTemperatureFlash operation = new DewPointTemperatureFlash(this.system);
        operation.run();
        if (Double.isNaN(this.system.getTemperature()) || operation.isSuperCritical()) {
            throw new IsNaNException(this, "dewPointTemperatureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void dewPointTemperatureFlash(boolean derivatives) throws IsNaNException {
        ConstantDutyTemperatureFlash operation = new DewPointTemperatureFlash(this.system);
        if (derivatives) {
            operation = new DewPointTemperatureFlashDer(this.system);
        }
        operation.run();
        if (Double.isNaN(this.system.getTemperature()) || operation.isSuperCritical()) {
            throw new IsNaNException(this, "dewPointTemperatureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public void dewPointPressureFlashHC() throws IsNaNException {
        this.system.init(0);
        HCdewPointPressureFlash operation = new HCdewPointPressureFlash(this.system);
        operation.run();
        if (Double.isNaN(this.system.getPressure()) || operation.isSuperCritical()) {
            throw new IsNaNException(this, "dewPointPressureFlashHC", "Could not find solution - possible no dew point exists");
        }
    }

    public void dewPointPressureFlash() throws IsNaNException {
        this.system.init(0);
        DewPointPressureFlash operation = new DewPointPressureFlash(this.system);
        operation.run();
        if (Double.isNaN(this.system.getPressure()) || operation.isSuperCritical()) {
            throw new IsNaNException(this, "dewPointPressureFlash", "Could not find solution - possible no dew point exists");
        }
    }

    public JFreeChart getJfreeChart() {
        return this.getOperation().getJFreeChart("");
    }

    public void calcPTphaseEnvelope() {
        this.operation = new PTphaseEnvelope(this.system, this.fileName, 0.9999999999, 1.0, false);
        this.getOperation().run();
    }

    public void calcPTphaseEnvelope(boolean bubfirst, double lowPres) {
        double phasefraction = 0.9999999999;
        if (bubfirst) {
            phasefraction = 1.0E-10;
        }
        this.operation = new PTphaseEnvelope(this.system, this.fileName, phasefraction, lowPres, bubfirst);
        this.getOperation().run();
    }

    public void calcPTphaseEnvelope(double lowPres) {
        this.operation = new PTphaseEnvelope(this.system, this.fileName, 1.0E-10, lowPres, true);
        this.getOperation().run();
    }

    public void calcPTphaseEnvelope(boolean bubfirst) {
        double phasefraction = 0.9999999999;
        if (bubfirst) {
            phasefraction = 1.0E-10;
        }
        this.operation = new PTphaseEnvelope(this.system, this.fileName, phasefraction, 1.0, bubfirst);
        if (!this.isRunAsThread()) {
            this.getOperation().run();
        } else {
            this.run();
        }
    }

    public void calcPTphaseEnvelope(double lowPres, double phasefraction) {
        this.operation = new PTphaseEnvelope(this.system, this.fileName, phasefraction, lowPres, true);
        this.getOperation().run();
    }

    public void calcPTphaseEnvelope2() {
        this.operation = new PTphaseEnvelopeNew2(this.system, this.fileName, 0.9999999999, 1.0, false);
        this.getOperation().run();
    }

    public void calcPTphaseEnvelopeNew() {
        this.getOperation().run();
    }

    public void calcPTphaseEnvelopeNew3(double minPressure, double maxPressure, double minTemp, double maxTemp, double pressureStep, double tempStep) {
        this.operation = new PTphaseEnvelopeNew3(this.system, minPressure, maxPressure, minTemp, maxTemp, pressureStep, tempStep);
        this.operation.run();
    }

    public void OLGApropTable(double minTemp, double maxTemp, int temperatureSteps, double minPres, double maxPres, int pressureSteps, String filename, int TABtype) {
        if (TABtype == 0) {
            this.operation = new OLGApropertyTableGeneratorWaterKeywordFormat(this.system);
            ((OLGApropertyTableGeneratorWaterKeywordFormat)this.operation).setPressureRange(minPres, maxPres, pressureSteps);
            ((OLGApropertyTableGeneratorWaterKeywordFormat)this.operation).setTemperatureRange(minTemp, maxTemp, temperatureSteps);
            ((OLGApropertyTableGeneratorWaterKeywordFormat)this.operation).run();
            ((OLGApropertyTableGeneratorWaterKeywordFormat)this.operation).writeOLGAinpFile(filename);
        } else {
            this.operation = new OLGApropertyTableGeneratorWaterStudents(this.system);
            ((OLGApropertyTableGeneratorWaterStudents)this.operation).setFileName(filename);
            ((OLGApropertyTableGeneratorWaterStudents)this.operation).setPressureRange(minPres, maxPres, pressureSteps);
            ((OLGApropertyTableGeneratorWaterStudents)this.operation).setTemperatureRange(minTemp, maxTemp, temperatureSteps);
            this.getOperation().run();
            ((OLGApropertyTableGeneratorWaterStudents)this.operation).writeOLGAinpFile(filename);
        }
    }

    public void OLGApropTablePH(double minEnthalpy, double maxEnthalpy, int enthalpySteps, double minPres, double maxPres, int pressureSteps, String filename, int TABtype) {
        this.operation = new OLGApropertyTableGeneratorWaterStudentsPH(this.system);
        ((OLGApropertyTableGeneratorWaterStudentsPH)this.operation).setFileName(filename);
        ((OLGApropertyTableGeneratorWaterStudentsPH)this.operation).setPressureRange(minPres, maxPres, pressureSteps);
        ((OLGApropertyTableGeneratorWaterStudentsPH)this.operation).setEnthalpyRange(minEnthalpy, maxEnthalpy, enthalpySteps);
        this.getOperation().run();
    }

    public void calcPloadingCurve() {
        this.operation = new PloadingCurve2(this.system);
        this.getOperation().run();
    }

    public void calcHPTphaseEnvelope() {
        this.operation = new HPTphaseEnvelope(this.system);
        this.operation.run();
    }

    public void printToFile(String name) {
        this.getOperation().printToFile(name);
    }

    public double[][] getData() {
        return this.getOperation().getPoints(0);
    }

    public String[][] getDataPoints() {
        String[][] str = new String[this.getOperation().getPoints(0).length][this.getOperation().getPoints(0)[0].length];
        for (int i = 0; i < this.getOperation().getPoints(0).length; ++i) {
            for (int j = 0; j < this.getOperation().getPoints(0)[0].length; ++j) {
                str[i][j] = Double.toString(this.getOperation().getPoints(0)[i][j]);
            }
        }
        return str;
    }

    public String[][] getResultTable() {
        return this.resultTable;
    }

    public double dewPointTemperatureCondensationRate() {
        double dT = 1.1;
        try {
            this.dewPointTemperatureFlash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.system.setTemperature(this.system.getTemperature() - dT);
        this.TPflash();
        double condensationRate = this.system.getPhase(1).getMass() / (this.system.getVolume() * 1.0E-5);
        try {
            this.dewPointTemperatureFlash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return condensationRate / dT;
    }

    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        try {
            this.getThermoOperationThread().join();
        }
        catch (Exception ex) {
            logger.error("Thread did not finish", (Throwable)ex);
        }
        this.getOperation().displayResult();
    }

    public void setResultTable(String[][] resultTable) {
        this.resultTable = resultTable;
    }

    @ExcludeFromJacocoGeneratedReport
    public void display() {
        if (this.resultTable == null) {
            return;
        }
        JFrame dialog = new JFrame("System-Report");
        Container dialogContentPane = dialog.getContentPane();
        dialogContentPane.setLayout(new BorderLayout());
        Object[] names = new String[this.resultTable[0].length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = "";
        }
        JTable Jtab = new JTable(this.resultTable, names);
        JScrollPane scrollpane = new JScrollPane(Jtab);
        dialogContentPane.add(scrollpane);
        dialog.pack();
        dialog.setVisible(true);
    }

    public double[] get(String name) {
        return this.getOperation().get(name);
    }

    public OperationInterface getOperation() {
        return this.operation;
    }

    public boolean isRunAsThread() {
        return this.runAsThread;
    }

    public void setRunAsThread(boolean runAsThread) {
        this.runAsThread = runAsThread;
    }

    public Thread getThermoOperationThread() {
        return this.thermoOperationThread;
    }

    public void setThermoOperationThread(Thread thermoOperationThread) {
        this.thermoOperationThread = thermoOperationThread;
    }

    public void addData(String name, double[][] data) {
        this.operation.addData(name, data);
    }

    public void calcIonComposition(int phaseNumber) {
        this.operation = new CalcIonicComposition(this.system, phaseNumber);
        this.getOperation().run();
        this.resultTable = this.getOperation().getResultTable();
    }

    public void flash(FlashType flashType, double spec1, double spec2, String unitSpec1, String unitSpec2) {
        switch (flashType) {
            case PT: {
                this.system.setPressure(spec1, unitSpec1);
                this.system.setTemperature(spec2, unitSpec2);
                this.TPflash();
                break;
            }
            case TP: {
                this.system.setTemperature(spec1, unitSpec1);
                this.system.setPressure(spec2, unitSpec2);
                this.TPflash();
                break;
            }
            case TV: {
                this.system.setTemperature(spec1, unitSpec1);
                this.TVflash(spec2, unitSpec2);
                break;
            }
            case PH: {
                this.system.setPressure(spec1, unitSpec1);
                this.PHflash(spec2, unitSpec2);
                break;
            }
            case TS: {
                this.system.setTemperature(spec1, unitSpec1);
                this.TSflash(spec2, unitSpec2);
                break;
            }
        }
    }

    public CalculationResult propertyFlash(List<Double> Spec1, List<Double> Spec2, int FlashMode, List<String> components, List<List<Double>> onlineFractions) {
        boolean hasOnlineFractions;
        FlashType flashType = FlashMode == 1 ? FlashType.PT : (FlashMode == 2 ? FlashType.PH : (FlashMode == 3 ? FlashType.PS : null));
        Double[][] fluidProperties = new Double[Spec1.size()][70];
        String[] calculationError = new String[Spec1.size()];
        Double[] sum = new Double[Spec1.size()];
        String[] systemComponents = this.system.getComponentNames();
        if (components != null) {
            for (String inputCompName : components) {
                if (this.system.hasComponent(inputCompName)) continue;
                for (int t = 0; t < Spec1.size(); ++t) {
                    calculationError[t] = "Input component list does not match fluid component list.";
                }
            }
        } else {
            components = Arrays.asList(systemComponents);
        }
        boolean bl = hasOnlineFractions = onlineFractions != null;
        if (hasOnlineFractions) {
            double range = 5.0;
            for (int t = 0; t < sum.length; ++t) {
                sum[t] = 0.0;
                for (int comp = 0; comp < onlineFractions.size(); ++comp) {
                    sum[t] = sum[t] + onlineFractions.get(comp).get(t);
                }
                if (sum[t] >= 1.0 - range / 100.0 && sum[t] <= 1.0 + range / 100.0 || sum[t] >= 100.0 - range && sum[t] <= 100.0 + range) continue;
                calculationError[t] = "Sum of fractions must be approximately 1 or 100, currently (" + String.valueOf(sum[t]) + ")";
            }
            if (this.system.getTotalNumberOfMoles() == 0.0) {
                this.system.setTotalNumberOfMoles(1.0);
            }
        } else {
            double[] fraction = this.system.getMolarComposition();
            sum[0] = 0.0;
            for (int comp = 0; comp < fraction.length; ++comp) {
                sum[0] = sum[0] + fraction[comp];
            }
            double range = 1.0E-8;
            if (!(sum[0] >= 1.0 - range && sum[0] <= 1.0 + range || sum[0] >= 100.0 - range && sum[0] <= 100.0 + range)) {
                for (int t = 0; t < Spec1.size(); ++t) {
                    calculationError[t] = "Sum of fractions must be approximately to 1 or 100, currently (" + String.valueOf(sum[0]) + ")";
                    if (sum[0] != 0.0) continue;
                    calculationError[t] = calculationError[t] + ". Have you called init(0)?";
                }
            }
        }
        for (int t = 0; t < Spec1.size(); ++t) {
            try {
                if (flashType == null) {
                    throw new RuntimeException(new InvalidInputException("ThermodynamicOperations", "propertyFlash", "FlashMode", "must be 1, 2 or 3"));
                }
                Double Sp1 = Spec1.get(t);
                Double Sp2 = Spec2.get(t);
                if (Sp1 == null || Sp2 == null || Double.isNaN(Sp1) || Double.isNaN(Sp2)) {
                    calculationError[t] = "Sp1 or Sp2 is NaN";
                    logger.info("Sp1 or Sp2 is NULL for datapoint {}", (Object)t);
                    continue;
                }
                if (calculationError[t] != null) {
                    logger.info("{}", (Object)calculationError[t]);
                    continue;
                }
                if (hasOnlineFractions) {
                    double[] fraction = new double[this.system.getNumberOfComponents()];
                    block14: for (int compIndex = 0; compIndex < fraction.length; ++compIndex) {
                        for (int index = 0; index < components.size(); ++index) {
                            if (systemComponents[compIndex] != ComponentInterface.getComponentNameFromAlias(components.get(index))) continue;
                            fraction[compIndex] = onlineFractions.get(index).get(t);
                            continue block14;
                        }
                    }
                    this.system.setMolarComposition(fraction);
                    this.system.init(0);
                }
                this.system.setPressure(Sp1);
                switch (flashType) {
                    case PT: {
                        this.system.setTemperature(Sp2);
                        this.TPflash();
                        break;
                    }
                    case PH: {
                        this.PHflash((double)Sp2, "J/mol");
                        break;
                    }
                    case PS: {
                        this.PSflash(Sp2, "J/molK");
                        break;
                    }
                    default: {
                        throw new RuntimeException(new InvalidInputException("ThermodynamicOperations", "propertyFlash", "FlashMode", "must be 1, 2 or 3"));
                    }
                }
                this.system.init(2);
                this.system.initPhysicalProperties();
                fluidProperties[t] = this.system.getProperties().getValues();
                continue;
            }
            catch (Exception ex) {
                calculationError[t] = ex.getMessage();
                logger.warn(calculationError[t]);
            }
        }
        return new CalculationResult(fluidProperties, calculationError);
    }

    public static enum FlashType {
        TP,
        PT,
        PH,
        PS,
        TV,
        TS;

    }
}

