/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.Flash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class CalcIonicComposition
extends Flash {
    private static final long serialVersionUID = 1000L;
    Logger logger = LogManager.getLogger(CalcIonicComposition.class);
    int phaseNumber;
    String[][] resultTable = null;

    public CalcIonicComposition(SystemInterface system, int phaseNum) {
        this.system = system;
        this.phaseNumber = phaseNum;
    }

    @Override
    public void run() {
        this.resultTable = new String[this.system.getPhase(0).getNumberOfComponents() + 2][4];
        this.resultTable[0][0] = "Component";
        this.resultTable[0][1] = "mmol/kgSolvent";
        this.resultTable[0][2] = "mg/kgSolvent";
        this.resultTable[0][3] = "Act.Coef";
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        DecimalFormat nf = new DecimalFormat();
        symbols.setDecimalSeparator('.');
        nf.setDecimalFormatSymbols(symbols);
        nf.setMaximumFractionDigits(5);
        nf.applyPattern("#.#####E0");
        int ionNumber = 0;
        for (int i = 0; i < this.system.getPhase(this.phaseNumber).getNumberOfComponents(); ++i) {
            this.resultTable[ionNumber + 1][0] = this.system.getPhase(this.phaseNumber).getComponent(i).getComponentName();
            this.resultTable[ionNumber + 1][1] = Double.valueOf(nf.format(this.system.getPhase(this.phaseNumber).getComponent(i).getNumberOfMolesInPhase() / (this.system.getPhase(this.phaseNumber).getComponent("water").getNumberOfMolesInPhase() * this.system.getPhase(this.phaseNumber).getComponent("water").getMolarMass()) * 1000.0)).toString();
            this.resultTable[ionNumber + 1][2] = Double.valueOf(nf.format(this.system.getPhase(this.phaseNumber).getComponent(i).getNumberOfMolesInPhase() * this.system.getPhase(this.phaseNumber).getComponent(i).getMolarMass() / (this.system.getPhase(this.phaseNumber).getComponent("water").getNumberOfMolesInPhase() * this.system.getPhase(this.phaseNumber).getComponent("water").getMolarMass()) * 1000000.0)).toString();
            this.resultTable[ionNumber + 1][3] = Double.valueOf(nf.format(this.system.getPhase(this.phaseNumber).getActivityCoefficient(i, this.system.getPhase(this.phaseNumber).getComponent("water").getComponentNumber()))).toString();
            ++ionNumber;
        }
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }

    @Override
    public String[][] getResultTable() {
        return this.resultTable;
    }
}

