/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import Jama.Matrix;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.BaseOperation;
import neqsim.thermodynamicoperations.flashops.RachfordRice;
import neqsim.thermodynamicoperations.flashops.SolidFlash;
import neqsim.thermodynamicoperations.flashops.SysNewtonRhapsonTPflash;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Flash
extends BaseOperation {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(Flash.class);
    SystemInterface system;
    SystemInterface minimumGibbsEnergySystem;
    public double[] minGibsPhaseLogZ;
    public double[] minGibsLogFugCoef;
    int i = 0;
    int j = 0;
    int iterations = 0;
    int maxNumberOfIterations = 50;
    double gibbsEnergy = 0.0;
    double gibbsEnergyOld = 0.0;
    double Kold = 0.0;
    double deviation = 0.0;
    double g0 = 0.0;
    double g1 = 0.0;
    double[] lnOldOldOldK;
    double[] lnOldOldK;
    double[] lnK;
    double[] lnOldK;
    double[] oldoldDeltalnK;
    double[] oldDeltalnK;
    double[] deltalnK;
    double[] tm;
    double tmLimit = -1.0E-8;
    int lowestGibbsEnergyPhase = 0;
    SysNewtonRhapsonTPflash secondOrderSolver;
    protected boolean solidCheck = false;
    protected boolean stabilityCheck = false;
    protected boolean findLowestGibbsPhaseIsChecked = false;

    public int findLowestGibbsEnergyPhase() {
        if (!this.findLowestGibbsPhaseIsChecked) {
            this.minimumGibbsEnergySystem = this.system.clone();
            this.minimumGibbsEnergySystem.init(0);
            if (this.minimumGibbsEnergySystem.getTotalNumberOfMoles() < 1.0E-20) {
                this.minimumGibbsEnergySystem.setTotalNumberOfMoles(1.0);
            }
            this.minimumGibbsEnergySystem.init(1);
            this.lowestGibbsEnergyPhase = this.minimumGibbsEnergySystem.getPhase(0).getGibbsEnergy() * (1.0 - Math.signum(this.minimumGibbsEnergySystem.getPhase(0).getGibbsEnergy()) * 1.0E-8) < this.minimumGibbsEnergySystem.getPhase(1).getGibbsEnergy() ? 0 : 1;
            this.findLowestGibbsPhaseIsChecked = true;
        }
        return this.lowestGibbsEnergyPhase;
    }

    public void stabilityAnalysis() throws IsNaNException, TooManyIterationsException {
        int i;
        double[] logWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] deltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldDeltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldDeltalogWi = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[][] Wi = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        boolean secondOrderStabilityAnalysis = false;
        double[] oldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] oldoldoldlogw = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[] d = new double[this.system.getPhases()[0].getNumberOfComponents()];
        double[][] x = new double[2][this.system.getPhases()[0].getNumberOfComponents()];
        double[] error = new double[2];
        this.tm = new double[2];
        double[] alpha = null;
        Matrix f = new Matrix(this.system.getPhases()[0].getNumberOfComponents(), 1);
        Matrix df = null;
        int maxiterations = 100;
        double fNorm = 1.0E10;
        double fNormOld = 0.0;
        for (int i2 = 0; i2 < this.system.getPhases()[0].getNumberOfComponents(); ++i2) {
            d[i2] = this.minGibsPhaseLogZ[i2] + this.minGibsLogFugCoef[i2];
        }
        SystemInterface clonedSystem = this.minimumGibbsEnergySystem;
        double[] sumw = new double[2];
        sumw[1] = 0.0;
        sumw[0] = 0.0;
        for (int i3 = 0; i3 < clonedSystem.getPhase(0).getNumberOfComponents(); ++i3) {
            sumw[1] = sumw[1] + clonedSystem.getPhase(0).getComponent(i3).getz() / clonedSystem.getPhase(0).getComponent(i3).getK();
            if (!(clonedSystem.getPhase(0).getComponent(i3).getz() > 0.0)) continue;
            sumw[0] = sumw[0] + clonedSystem.getPhase(0).getComponent(i3).getK() * clonedSystem.getPhase(0).getComponent(i3).getz();
        }
        int start = 0;
        int end = 1;
        int mult = 1;
        if (this.lowestGibbsEnergyPhase == 0) {
            start = end;
            end = 0;
            mult = -1;
        }
        for (int i4 = 0; i4 < clonedSystem.getPhase(0).getNumberOfComponents(); ++i4) {
            clonedSystem.getPhase(1).getComponent(i4).setx(clonedSystem.getPhase(0).getComponent(i4).getz() / clonedSystem.getPhase(0).getComponent(i4).getK() / sumw[1]);
            clonedSystem.getPhase(0).getComponent(i4).setx(clonedSystem.getPhase(0).getComponent(i4).getK() * clonedSystem.getPhase(0).getComponent(i4).getz() / sumw[0]);
        }
        for (int j = start; j >= end; j += mult) {
            int i5;
            for (int i6 = 0; i6 < clonedSystem.getPhases()[0].getNumberOfComponents(); ++i6) {
                Wi[j][i6] = clonedSystem.getPhase(j).getComponent(i6).getx();
                logWi[i6] = Math.log(Wi[j][i6]);
            }
            this.iterations = 0;
            fNorm = 1.0E10;
            boolean acceleration = true;
            double olderror = 1.0E10;
            do {
                ++this.iterations;
                error[j] = 0.0;
                for (i5 = 0; i5 < clonedSystem.getPhases()[0].getNumberOfComponents(); ++i5) {
                    oldoldoldlogw[i5] = oldoldlogw[i5];
                    oldoldlogw[i5] = oldlogw[i5];
                    oldlogw[i5] = logWi[i5];
                    oldoldDeltalogWi[i5] = oldoldlogw[i5] - oldoldoldlogw[i5];
                    oldDeltalogWi[i5] = oldlogw[i5] - oldoldlogw[i5];
                }
                if (this.iterations <= maxiterations - 10 || !this.system.isImplementedCompositionDeriativesofFugacity()) {
                    try {
                        clonedSystem.init(1, j);
                    }
                    catch (Exception e) {
                        logger.error(e.toString());
                        throw e;
                    }
                    fNormOld = fNorm;
                    for (i5 = 0; i5 < clonedSystem.getPhases()[0].getNumberOfComponents(); ++i5) {
                        f.set(i5, 0, Math.sqrt(Wi[j][i5]) * (Math.log(Wi[j][i5]) + clonedSystem.getPhase(j).getComponent(i5).getLogFugacityCoefficient() - d[i5]));
                    }
                    fNorm = f.norm2();
                    if (fNorm > fNormOld && this.iterations > 3 && (this.iterations - 1) % 7 != 0 && this.iterations > 10) break;
                    if (this.iterations % 7 == 0 && fNorm < fNormOld && !secondOrderStabilityAnalysis && acceleration) {
                        double vec1 = 0.0;
                        double vec2 = 0.0;
                        double prod1 = 0.0;
                        double prod2 = 0.0;
                        this.i = 0;
                        while (this.i < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                            vec1 = oldDeltalogWi[this.i] * oldoldDeltalogWi[this.i];
                            vec2 = Math.pow(oldoldDeltalogWi[this.i], 2.0);
                            prod1 += vec1 * vec2;
                            prod2 += vec2 * vec2;
                            ++this.i;
                        }
                        double lambda = prod1 / prod2;
                        this.i = 0;
                        while (this.i < clonedSystem.getPhases()[0].getNumberOfComponents()) {
                            int n = this.i;
                            logWi[n] = logWi[n] + lambda / (1.0 - lambda) * deltalogWi[this.i];
                            int n2 = j;
                            error[n2] = error[n2] + Math.abs((logWi[this.i] - oldlogw[this.i]) / oldlogw[this.i]);
                            Wi[j][this.i] = Math.exp(logWi[this.i]);
                            ++this.i;
                        }
                        if (error[j] > olderror) {
                            acceleration = false;
                        }
                    } else {
                        for (i5 = 0; i5 < clonedSystem.getPhases()[0].getNumberOfComponents(); ++i5) {
                            logWi[i5] = d[i5] - clonedSystem.getPhase(j).getComponent(i5).getLogFugacityCoefficient();
                            int n = j;
                            error[n] = error[n] + Math.abs((logWi[i5] - oldlogw[i5]) / oldlogw[i5]);
                            Wi[j][i5] = Math.exp(logWi[i5]);
                        }
                    }
                } else {
                    if (!secondOrderStabilityAnalysis) {
                        alpha = new double[this.system.getPhases()[0].getNumberOfComponents()];
                        df = new Matrix(this.system.getPhases()[0].getNumberOfComponents(), this.system.getPhases()[0].getNumberOfComponents());
                        secondOrderStabilityAnalysis = true;
                    }
                    clonedSystem.init(3, j);
                    for (i5 = 0; i5 < clonedSystem.getPhases()[0].getNumberOfComponents(); ++i5) {
                        alpha[i5] = 2.0 * Math.sqrt(Wi[j][i5]);
                    }
                    for (i5 = 0; i5 < clonedSystem.getPhases()[0].getNumberOfComponents(); ++i5) {
                        f.set(i5, 0, Math.sqrt(Wi[j][i5]) * (Math.log(Wi[j][i5]) + clonedSystem.getPhase(j).getComponent(i5).getLogFugacityCoefficient() - d[i5]));
                        for (int k = 0; k < clonedSystem.getPhases()[0].getNumberOfComponents(); ++k) {
                            double kronDelt = i5 == k ? 1.5 : 0.0;
                            df.set(i5, k, kronDelt + Math.sqrt(Wi[j][k] * Wi[j][i5]) * clonedSystem.getPhase(j).getComponent(i5).getdfugdn(k));
                        }
                    }
                    Matrix dx = df.solve(f).times(-1.0);
                    for (int i7 = 0; i7 < clonedSystem.getPhases()[0].getNumberOfComponents(); ++i7) {
                        Wi[j][i7] = Math.pow((alpha[i7] + dx.get(i7, 0)) / 2.0, 2.0);
                        logWi[i7] = Math.log(Wi[j][i7]);
                        int n = j;
                        error[n] = error[n] + Math.abs((logWi[i7] - oldlogw[i7]) / oldlogw[i7]);
                    }
                }
                sumw[j] = 0.0;
                for (i5 = 0; i5 < clonedSystem.getPhases()[0].getNumberOfComponents(); ++i5) {
                    int n = j;
                    sumw[n] = sumw[n] + Wi[j][i5];
                }
                for (i5 = 0; i5 < clonedSystem.getPhases()[0].getNumberOfComponents(); ++i5) {
                    deltalogWi[i5] = logWi[i5] - oldlogw[i5];
                    clonedSystem.getPhase(j).getComponent(i5).setx(Wi[j][i5] / sumw[j]);
                }
                olderror = error[j];
            } while (f.norm1() > 0.001 && error[j] > 0.001 && this.iterations < maxiterations || this.iterations % 7 == 0 || this.iterations < 3);
            if (this.iterations >= maxiterations) {
                throw new TooManyIterationsException("too many iterations", null, (long)maxiterations);
            }
            this.tm[j] = 1.0;
            for (i5 = 0; i5 < clonedSystem.getPhases()[0].getNumberOfComponents(); ++i5) {
                int n = j;
                this.tm[n] = this.tm[n] - Wi[j][i5];
                x[j][i5] = clonedSystem.getPhase(j).getComponent(i5).getx();
            }
            if (this.tm[j] < this.tmLimit && error[j] < 1.0E-6) break;
            this.tm[j] = 1.0;
        }
        double diffx = 0.0;
        for (i = 0; i < clonedSystem.getPhase(0).getNumberOfComponents(); ++i) {
            diffx += Math.abs(clonedSystem.getPhase(this.j).getComponent(i).getx() - this.minimumGibbsEnergySystem.getPhase(0).getComponent(i).getx());
        }
        if (diffx < 1.0E-10) {
            this.tm[0] = 0.0;
            this.tm[1] = 0.0;
        }
        if ((this.tm[0] < this.tmLimit || this.tm[1] < this.tmLimit) && !Double.isNaN(this.tm[0]) && !Double.isNaN(this.tm[1])) {
            for (i = 0; i < clonedSystem.getPhases()[0].getNumberOfComponents(); ++i) {
                if (this.system.getPhase(0).getComponent(i).getx() < 1.0E-100) continue;
                if (this.tm[0] < this.tmLimit) {
                    this.system.getPhases()[1].getComponent(i).setK(clonedSystem.getPhase(0).getComponent(i).getx() / clonedSystem.getPhase(1).getComponent(i).getx());
                    this.system.getPhases()[0].getComponent(i).setK(clonedSystem.getPhase(0).getComponent(i).getx() / clonedSystem.getPhase(1).getComponent(i).getx());
                } else if (this.tm[1] < this.tmLimit) {
                    this.system.getPhases()[1].getComponent(i).setK(clonedSystem.getPhase(0).getComponent(i).getx() / clonedSystem.getPhase(1).getComponent(i).getx());
                    this.system.getPhases()[0].getComponent(i).setK(clonedSystem.getPhase(0).getComponent(i).getx() / clonedSystem.getPhase(1).getComponent(i).getx());
                } else {
                    logger.info("error in stability anlysis");
                    this.system.init(0);
                }
                if (!Double.isNaN(this.tm[this.j])) continue;
                this.tm[this.j] = 0.0;
            }
        }
    }

    public boolean stabilityCheck() {
        boolean stable = false;
        this.lowestGibbsEnergyPhase = this.findLowestGibbsEnergyPhase();
        if (this.system.getPhase(this.lowestGibbsEnergyPhase).getNumberOfComponents() > 1) {
            try {
                this.stabilityAnalysis();
            }
            catch (Exception ex) {
                logger.error("error ", (Throwable)ex);
            }
        }
        if (this.tm[0] > this.tmLimit && this.tm[1] > this.tmLimit || this.system.getPhase(0).getNumberOfComponents() == 1) {
            stable = true;
            this.system.init(0);
            this.system.setNumberOfPhases(1);
            if (this.lowestGibbsEnergyPhase == 0) {
                this.system.setPhaseType(0, PhaseType.GAS);
            } else {
                this.system.setPhaseType(0, PhaseType.LIQUID);
            }
            this.system.init(1);
            if (this.solidCheck && !this.system.doMultiPhaseCheck()) {
                this.solidPhaseFlash();
            }
        } else {
            RachfordRice rachfordRice = new RachfordRice();
            try {
                this.system.setBeta(rachfordRice.calcBeta(this.system.getKvector(), this.minimumGibbsEnergySystem.getzvector()));
            }
            catch (Exception ex) {
                if (!Double.isNaN(rachfordRice.getBeta()[0])) {
                    this.system.setBeta(rachfordRice.getBeta()[0]);
                } else {
                    this.system.setBeta(Double.NaN);
                }
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            this.system.calc_x_y();
            this.system.init(1);
        }
        return stable;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void displayResult() {
        this.system.display();
    }

    public void solidPhaseFlash() {
        boolean solidPhase = false;
        double frac = 0.0;
        int solid = 0;
        double[] tempVar = new double[this.system.getPhases()[0].getNumberOfComponents()];
        if (!this.system.hasSolidPhase()) {
            this.system.setNumberOfPhases(this.system.getNumberOfPhases() + 1);
            this.system.setPhaseIndex(this.system.getNumberOfPhases() - 1, 3);
        }
        this.system.init(1);
        for (int k = 0; k < this.system.getPhase(0).getNumberOfComponents(); ++k) {
            if (!this.system.getPhase(0).getComponent(k).doSolidCheck()) continue;
            tempVar[k] = this.system.getPhase(0).getComponent(k).getz();
            for (int i = 0; i < this.system.getNumberOfPhases() - 1; ++i) {
                int n = k;
                tempVar[n] = tempVar[n] - this.system.getBeta(i) * this.system.getPhases()[3].getComponent(k).getFugacityCoefficient() / this.system.getPhase(i).getComponent(k).getFugacityCoefficient();
            }
            if (!(tempVar[k] > 0.0) || !(tempVar[k] > frac)) continue;
            solidPhase = true;
            solid = k;
            frac = tempVar[k];
            for (int p = 0; p < this.system.getPhases()[0].getNumberOfComponents(); ++p) {
                this.system.getPhases()[3].getComponent(p).setx(1.0E-20);
            }
            this.system.getPhases()[3].getComponents()[solid].setx(1.0);
        }
        if (solidPhase) {
            if (frac < this.system.getPhases()[0].getComponents()[solid].getz() + 1.0E10) {
                for (int i = 0; i < this.system.getNumberOfPhases() - 1; ++i) {
                }
                this.system.init(1);
                this.system.setBeta(this.system.getNumberOfPhases() - 1, frac);
                this.system.initBeta();
                this.system.setBeta(this.system.getNumberOfPhases() - 1, this.system.getPhases()[3].getComponent(solid).getNumberOfmoles() / this.system.getNumberOfMoles());
                this.system.init(1);
                SolidFlash solflash = new SolidFlash(this.system);
                solflash.setSolidComponent(solid);
                solflash.run();
            }
        } else {
            this.system.setNumberOfPhases(this.system.getNumberOfPhases() - 1);
        }
    }

    @Override
    public void printToFile(String name) {
    }

    @Override
    public double[][] getPoints(int i) {
        return null;
    }

    @Override
    public String[][] getResultTable() {
        return null;
    }

    @Override
    public void addData(String name, double[][] data) {
    }
}

