/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.Flash;
import neqsim.thermodynamicoperations.flashops.QfuncFlash;
import neqsim.thermodynamicoperations.flashops.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PSFlashLeachman
extends QfuncFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PSFlashLeachman.class);
    double Sspec = 0.0;
    Flash tpFlash;
    double entropy_Leachman = 0.0;
    double cP_Leachman = 0.0;

    public PSFlashLeachman(SystemInterface system, double Sspec) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Sspec = Sspec;
    }

    @Override
    public double calcdQdTT() {
        return -this.cP_Leachman / this.system.getTemperature();
    }

    @Override
    public double calcdQdT() {
        return -this.entropy_Leachman + this.Sspec;
    }

    @Override
    public double solveQ() {
        double oldTemp = this.system.getTemperature();
        double nyTemp = this.system.getTemperature();
        int iterations = 1;
        double error = 1.0;
        double errorOld = 1.0E11;
        double factor = 0.8;
        boolean correctFactor = true;
        double newCorr = 1.0;
        do {
            if (error > errorOld && factor > 0.1 && correctFactor) {
                factor *= 0.5;
            } else if (error < errorOld && correctFactor) {
                factor = 1.0;
            }
            ++iterations;
            oldTemp = this.system.getTemperature();
            double[] LeachmanProps = this.system.getPhase(0).getProperties_Leachman();
            this.entropy_Leachman = LeachmanProps[8] * this.system.getPhase(0).getNumberOfMolesInPhase();
            this.cP_Leachman = LeachmanProps[10] * this.system.getPhase(0).getNumberOfMolesInPhase();
            newCorr = factor * this.calcdQdT() / this.calcdQdTT();
            nyTemp = oldTemp - newCorr;
            if (Math.abs(this.system.getTemperature() - nyTemp) > 10.0) {
                nyTemp = this.system.getTemperature() - Math.signum(this.system.getTemperature() - nyTemp) * 10.0;
                correctFactor = false;
            } else if (nyTemp < 0.0) {
                nyTemp = Math.abs(this.system.getTemperature() - 10.0);
                correctFactor = false;
            } else if (Double.isNaN(nyTemp)) {
                nyTemp = oldTemp + 1.0;
                correctFactor = false;
            } else {
                correctFactor = true;
            }
            this.system.setTemperature(nyTemp);
            errorOld = error;
        } while (((error = Math.abs(this.calcdQdT())) + errorOld > 1.0E-8 || iterations < 3) && iterations < 200);
        return nyTemp;
    }

    @Override
    public void run() {
        this.tpFlash.run();
        if (this.system.getNumberOfPhases() > 1) {
            logger.error("PSFlashLeachman only supprt single phase gas calculations");
            return;
        }
        this.solveQ();
        this.system.init(3);
    }
}

