/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.Flash;
import neqsim.thermodynamicoperations.flashops.QfuncFlash;
import neqsim.thermodynamicoperations.flashops.TPflash;
import neqsim.util.ExcludeFromJacocoGeneratedReport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SaturateWithWater
extends QfuncFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SaturateWithWater.class);
    Flash tpFlash;

    public SaturateWithWater(SystemInterface system) {
        this.system = system;
        this.tpFlash = new TPflash(system);
    }

    @Override
    public void run() {
        if (!this.system.getPhase(0).hasComponent("water")) {
            this.system.addComponent("water", this.system.getTotalNumberOfMoles() / 100.0);
            this.system.setMixingRule(this.system.getMixingRule());
        }
        boolean changedMultiPhase = false;
        if (!this.system.doMultiPhaseCheck()) {
            this.system.setMultiPhaseCheck(true);
            changedMultiPhase = true;
        }
        if (this.system.getComponent("water").getNumberOfmoles() < this.system.getTotalNumberOfMoles() / 2.0) {
            this.system.addComponent("water", this.system.getTotalNumberOfMoles());
        }
        this.tpFlash = new TPflash(this.system);
        this.tpFlash.run();
        boolean hasAq = false;
        if (this.system.hasPhaseType(PhaseType.AQUEOUS)) {
            hasAq = true;
        }
        double lastdn = 0.0;
        lastdn = this.system.hasPhaseType(PhaseType.AQUEOUS) ? this.system.getPhase(PhaseType.AQUEOUS).getNumberOfMolesInPhase() : this.system.getPhase(0).getNumberOfMolesInPhase();
        double dn = 1.0;
        int i = 0;
        do {
            ++i;
            lastdn = this.system.getNumberOfPhases() == 1 && hasAq ? -this.system.getComponent("water").getNumberOfmoles() * 0.1 : (!hasAq ? Math.abs(lastdn) * 1.05 : -this.system.getPhaseOfType("aqueous").getComponent("water").getNumberOfMolesInPhase() * 0.9);
            dn = lastdn / this.system.getNumberOfMoles();
            this.system.addComponent("water", lastdn);
            this.tpFlash.run();
            hasAq = this.system.hasPhaseType(PhaseType.AQUEOUS);
        } while (Math.abs(dn) > 1.0E-7 && i <= 50);
        if (i == 50) {
            logger.error("could not find solution - in water saturate : dn  " + dn);
        }
        if (this.system.hasPhaseType(PhaseType.AQUEOUS)) {
            this.system.removePhase(this.system.getNumberOfPhases() - 1);
            this.tpFlash.run();
        }
        if (changedMultiPhase) {
            this.system.setMultiPhaseCheck(false);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public static void main(String[] args) {
        SystemSrkCPAstatoil testSystem = new SystemSrkCPAstatoil(343.15, 150.0);
        testSystem.addComponent("methane", 75.0);
        testSystem.addComponent("ethane", 7.5);
        testSystem.addComponent("propane", 4.0);
        testSystem.addComponent("n-butane", 1.0);
        testSystem.addComponent("i-butane", 0.6);
        testSystem.addComponent("n-hexane", 0.3);
        testSystem.addPlusFraction("C6", 1.3, 0.1003, 0.8232);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(10);
        testSystem.setMultiPhaseCheck(true);
        testSystem.init(0);
        ThermodynamicOperations testOps = new ThermodynamicOperations(testSystem);
        try {
            testOps.TPflash();
            testOps.saturateWithWater();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

