/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import Jama.Matrix;
import java.io.Serializable;
import neqsim.mathlib.nonlinearsolver.NewtonRhapson;
import neqsim.thermo.system.SystemInterface;

public class SysNewtonRhapsonTPflashNew
implements Serializable {
    private static final long serialVersionUID = 1000L;
    int neq = 0;
    int iter = 0;
    int ic02p = -100;
    int ic03p = -100;
    int testcrit = 0;
    int npCrit = 0;
    double beta = 0.0;
    double ds = 0.0;
    double dTmax = 1.0;
    double dPmax = 1.0;
    double avscp = 0.1;
    double TC1 = 0.0;
    double TC2 = 0.0;
    double PC1 = 0.0;
    double PC2 = 0.0;
    Matrix Jac;
    Matrix fvec;
    Matrix u;
    Matrix uold;
    Matrix Xgij;
    SystemInterface system;
    int numberOfComponents;
    int speceq = 0;
    Matrix a = new Matrix(4, 4);
    Matrix s = new Matrix(1, 4);
    Matrix xg;
    Matrix xcoef;
    NewtonRhapson solver;
    boolean etterCP = false;
    boolean etterCP2 = false;

    public SysNewtonRhapsonTPflashNew(SystemInterface system, int numberOfPhases, int numberOfComponents) {
        this.system = system;
        this.numberOfComponents = numberOfComponents;
        this.neq = numberOfComponents + 1;
        this.Jac = new Matrix(this.neq, this.neq);
        this.fvec = new Matrix(this.neq, 1);
        this.u = new Matrix(this.neq, 1);
        this.Xgij = new Matrix(this.neq, 4);
        this.setu();
        this.uold = this.u.copy();
        this.solver = new NewtonRhapson();
        this.solver.setOrder(3);
    }

    public void setfvec() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.fvec.set(i, 0, this.u.get(i, 0) + Math.log(this.system.getPhases()[1].getComponent(i).getFugacityCoefficient() / this.system.getPhases()[0].getComponent(i).getFugacityCoefficient()));
        }
        double fsum = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            fsum = fsum + this.system.getPhases()[1].getComponent(i).getx() - this.system.getPhases()[0].getComponent(i).getx();
        }
        this.fvec.set(this.numberOfComponents, 0, fsum);
    }

    public void setJac() {
        int i;
        this.Jac.timesEquals(0.0);
        double dij = 0.0;
        double[] dxidlnk = new double[this.numberOfComponents];
        double[] dyidlnk = new double[this.numberOfComponents];
        double[] dxidbeta = new double[this.numberOfComponents];
        double[] dyidbeta = new double[this.numberOfComponents];
        double tempJ = 0.0;
        double sumdyidbeta = 0.0;
        double sumdxidbeta = 0.0;
        int nofc = this.numberOfComponents;
        for (i = 0; i < this.numberOfComponents; ++i) {
            dxidlnk[i] = -this.system.getBeta() * this.system.getPhases()[0].getComponent(i).getx() * this.system.getPhases()[1].getComponent(i).getx() / this.system.getPhases()[0].getComponent(i).getz();
            dyidlnk[i] = this.system.getPhases()[1].getComponent(i).getx() + this.system.getPhases()[0].getComponent(i).getK() * dxidlnk[i];
            dyidbeta[i] = this.system.getPhases()[0].getComponent(i).getK() * this.system.getPhases()[0].getComponent(i).getz() * (1.0 - this.system.getPhases()[0].getComponent(i).getK()) / Math.pow(1.0 - this.system.getBeta() + this.system.getBeta() * this.system.getPhases()[0].getComponent(i).getK(), 2.0);
            dxidbeta[i] = this.system.getPhases()[0].getComponent(i).getz() * (1.0 - this.system.getPhases()[0].getComponent(i).getK()) / Math.pow(1.0 - this.system.getBeta() + this.system.getBeta() * this.system.getPhases()[0].getComponent(i).getK(), 2.0);
            sumdyidbeta += dyidbeta[i];
            sumdxidbeta += dxidbeta[i];
        }
        for (i = 0; i < this.numberOfComponents; ++i) {
            for (int j = 0; j < this.numberOfComponents; ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = dij + this.system.getPhases()[1].getComponent(i).getdfugdx(j) * dyidlnk[j] - this.system.getPhases()[0].getComponent(i).getdfugdx(j) * dxidlnk[j];
                this.Jac.set(i, j, tempJ);
            }
            this.Jac.set(i, nofc, this.system.getPhases()[1].getComponent(i).getdfugdx(i) * dyidbeta[i] - this.system.getPhases()[0].getComponent(i).getdfugdx(i) * dxidbeta[i]);
            this.Jac.set(nofc, i, dyidlnk[i] - dxidlnk[i]);
        }
        this.Jac.set(nofc, nofc, sumdyidbeta - sumdxidbeta);
    }

    public void setu() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.u.set(i, 0, Math.log(this.system.getPhases()[0].getComponent(i).getK()));
        }
        this.u.set(this.numberOfComponents, 0, this.system.getBeta());
    }

    public void init() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.system.getPhases()[0].getComponent(i).setK(Math.exp(this.u.get(i, 0)));
            this.system.getPhases()[1].getComponent(i).setK(Math.exp(this.u.get(i, 0)));
        }
        this.system.setBeta(this.u.get(this.numberOfComponents, 0));
        this.system.calc_x_y();
        this.system.init(3);
    }

    public void solve(int np) {
        Matrix dx;
        this.iter = 0;
        do {
            ++this.iter;
            this.init();
            this.setfvec();
            this.setJac();
            dx = this.Jac.solve(this.fvec);
            this.u.minusEquals(dx);
        } while (dx.norm2() / this.u.norm2() > 1.0E-10);
        this.init();
    }
}

