/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.Flash;
import neqsim.thermodynamicoperations.flashops.RachfordRice;
import neqsim.thermodynamicoperations.flashops.SysNewtonRhapsonTPflash;
import neqsim.thermodynamicoperations.flashops.TPmultiflash;
import neqsim.thermodynamicoperations.flashops.TPmultiflashWAX;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class TPflash
extends Flash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(TPflash.class);
    SystemInterface clonedSystem;
    double presdiff = 1.0;

    public TPflash() {
    }

    public TPflash(SystemInterface system) {
        this.system = system;
        this.lnOldOldOldK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.lnOldOldK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.lnOldK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.lnK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.oldoldDeltalnK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.oldDeltalnK = new double[system.getPhases()[0].getNumberOfComponents()];
        this.deltalnK = new double[system.getPhases()[0].getNumberOfComponents()];
    }

    public TPflash(SystemInterface system, boolean checkForSolids) {
        this(system);
        this.solidCheck = checkForSolids;
    }

    public void sucsSubs() {
        this.deviation = 0.0;
        this.i = 0;
        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
            if (this.system.getPhase(0).getComponent(this.i).getIonicCharge() != 0.0 || this.system.getPhase(0).getComponent(this.i).isIsIon()) {
                this.Kold = this.system.getPhase(0).getComponent(this.i).getK();
                this.system.getPhase(0).getComponent(this.i).setK(1.0E-40);
                this.system.getPhase(1).getComponent(this.i).setK(this.system.getPhase(0).getComponent(this.i).getK());
            } else {
                this.Kold = this.system.getPhase(0).getComponent(this.i).getK();
                this.system.getPhase(0).getComponent(this.i).setK(this.system.getPhase(1).getComponent(this.i).getFugacityCoefficient() / this.system.getPhase(0).getComponent(this.i).getFugacityCoefficient() * this.presdiff);
                if (Double.isNaN(this.system.getPhase(0).getComponent(this.i).getK())) {
                    this.system.getPhase(0).getComponent(this.i).setK(this.Kold);
                    this.system.init(1);
                }
                this.system.getPhase(1).getComponent(this.i).setK(this.system.getPhase(0).getComponent(this.i).getK());
                this.deviation += Math.abs(Math.log(this.system.getPhase(0).getComponent(this.i).getK()) - Math.log(this.Kold));
            }
            ++this.i;
        }
        double oldBeta = this.system.getBeta();
        RachfordRice rachfordRice = new RachfordRice();
        try {
            this.system.setBeta(rachfordRice.calcBeta(this.system.getKvector(), this.system.getzvector()));
        }
        catch (IsNaNException ex) {
            logger.warn("Not able to calculate beta. Value is NaN");
            this.system.setBeta(oldBeta);
        }
        catch (TooManyIterationsException ex) {
            logger.warn("Not able to calculate beta, calculation is not converging.");
            this.system.setBeta(oldBeta);
        }
        if (this.system.getBeta() > 0.999999999999) {
            this.system.setBeta(0.999999999999);
        }
        if (this.system.getBeta() < 1.0E-12) {
            this.system.setBeta(1.0E-12);
        }
        this.system.calc_x_y();
        this.system.init(1);
    }

    public void accselerateSucsSubs() {
        double prod1 = 0.0;
        double prod2 = 0.0;
        this.i = 0;
        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
            prod1 += this.oldDeltalnK[this.i] * this.oldoldDeltalnK[this.i];
            prod2 += this.oldoldDeltalnK[this.i] * this.oldoldDeltalnK[this.i];
            ++this.i;
        }
        double lambda = prod1 / prod2;
        this.i = 0;
        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
            int n = this.i;
            this.lnK[n] = this.lnK[n] + lambda / (1.0 - lambda) * this.deltalnK[this.i];
            this.system.getPhase(0).getComponent(this.i).setK(Math.exp(this.lnK[this.i]));
            this.system.getPhase(1).getComponent(this.i).setK(Math.exp(this.lnK[this.i]));
            ++this.i;
        }
        double oldBeta = this.system.getBeta();
        RachfordRice rachfordRice = new RachfordRice();
        try {
            this.system.setBeta(rachfordRice.calcBeta(this.system.getKvector(), this.system.getzvector()));
        }
        catch (Exception ex) {
            this.system.setBeta(rachfordRice.getBeta()[0]);
            if (this.system.getBeta() > 0.999999999999 || this.system.getBeta() < 1.0E-12) {
                this.system.setBeta(oldBeta);
            }
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.system.calc_x_y();
        this.system.init(1);
    }

    public void setNewK() {
        this.i = 0;
        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
            this.lnOldOldOldK[this.i] = this.lnOldOldK[this.i];
            this.lnOldOldK[this.i] = this.lnOldK[this.i];
            this.lnOldK[this.i] = this.lnK[this.i];
            this.lnK[this.i] = Math.log(this.system.getPhase(1).getComponent(this.i).getFugacityCoefficient()) - Math.log(this.system.getPhase(0).getComponent(this.i).getFugacityCoefficient());
            this.oldoldDeltalnK[this.i] = this.lnOldOldK[this.i] - this.lnOldOldOldK[this.i];
            this.oldDeltalnK[this.i] = this.lnOldK[this.i] - this.lnOldOldK[this.i];
            this.deltalnK[this.i] = this.lnK[this.i] - this.lnOldK[this.i];
            ++this.i;
        }
    }

    public void resetK() {
        this.i = 0;
        while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
            this.lnK[this.i] = this.lnOldK[this.i];
            this.system.getPhase(0).getComponent(this.i).setK(Math.exp(this.lnK[this.i]));
            this.system.getPhase(1).getComponent(this.i).setK(Math.exp(this.lnK[this.i]));
            ++this.i;
        }
        try {
            RachfordRice rachfordRice = new RachfordRice();
            this.system.setBeta(rachfordRice.calcBeta(this.system.getKvector(), this.system.getzvector()));
            this.system.calc_x_y();
            this.system.init(1);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void run() {
        TPflash operation;
        if (this.system.isForcePhaseTypes() && this.system.getMaxNumberOfPhases() == 1) {
            this.system.setNumberOfPhases(1);
            return;
        }
        this.findLowestGibbsPhaseIsChecked = false;
        int minGibbsPhase = 0;
        double minimumGibbsEnergy = 0.0;
        this.system.init(0);
        this.system.init(1);
        minGibbsPhase = this.system.getPhase(0).getGibbsEnergy() * (1.0 - Math.signum(this.system.getPhase(0).getGibbsEnergy()) * 1.0E-8) < this.system.getPhase(1).getGibbsEnergy() ? 0 : 1;
        minimumGibbsEnergy = this.system.getPhase(minGibbsPhase).getGibbsEnergy();
        if (this.system.getPhase(0).getNumberOfComponents() == 1 || this.system.getMaxNumberOfPhases() == 1) {
            this.system.setNumberOfPhases(1);
            if (minGibbsPhase == 0) {
                this.system.setPhaseIndex(0, 0);
            } else {
                this.system.setPhaseIndex(0, 1);
            }
            if (this.solidCheck) {
                ThermodynamicOperations operation2 = new ThermodynamicOperations(this.system);
                operation2.TPSolidflash();
            }
            return;
        }
        this.minGibsPhaseLogZ = new double[this.system.getPhase(0).getNumberOfComponents()];
        this.minGibsLogFugCoef = new double[this.system.getPhase(0).getNumberOfComponents()];
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            if (this.system.getPhase(minGibbsPhase).getComponent(i).getz() > 1.0E-50) {
                this.minGibsPhaseLogZ[i] = Math.log(this.system.getPhase(minGibbsPhase).getComponent(i).getz());
            }
            this.minGibsLogFugCoef[i] = this.system.getPhase(minGibbsPhase).getComponent(i).getLogFugacityCoefficient();
        }
        this.presdiff = this.system.getPhase(1).getPressure() / this.system.getPhase(0).getPressure();
        if (Math.abs(this.system.getPhase(0).getPressure() - this.system.getPhase(1).getPressure()) > 1.0E-12) {
            this.i = 0;
            while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                this.system.getPhase(0).getComponent(this.i).setK(this.system.getPhase(0).getComponent(this.i).getK() * this.presdiff);
                this.system.getPhase(1).getComponent(this.i).setK(this.system.getPhase(0).getComponent(this.i).getK());
                ++this.i;
            }
        }
        if (this.system.isChemicalSystem()) {
            this.system.getChemicalReactionOperations().solveChemEq(1, 0);
            this.system.getChemicalReactionOperations().solveChemEq(1, 1);
        }
        try {
            RachfordRice rachfordRice = new RachfordRice();
            this.system.setBeta(rachfordRice.calcBeta(this.system.getKvector(), this.system.getzvector()));
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
        this.system.calc_x_y();
        this.system.init(1);
        if (this.system.getBeta() > 0.9999999999989 || this.system.getBeta() < 1.1000000000000002E-12) {
            this.system.setBeta(0.5);
            this.sucsSubs();
        }
        for (int k = 0; k < 3; ++k) {
            if (!(this.system.getBeta() < 0.9999999999989) || !(this.system.getBeta() > 1.1000000000000002E-12)) continue;
            this.sucsSubs();
            if ((this.system.getGibbsEnergy() - minimumGibbsEnergy) / Math.abs(minimumGibbsEnergy) < -1.0E-12) break;
        }
        int totiter = 0;
        double tpdx = 1.0;
        double tpdy = 1.0;
        double dgonRT = 1.0;
        boolean passedTests = false;
        if (this.system.getBeta() > 0.9999999999989 || this.system.getBeta() < 1.1000000000000002E-12) {
            tpdx = 1.0;
            tpdy = 1.0;
            dgonRT = 1.0;
        } else if (this.system.getGibbsEnergy() < minimumGibbsEnergy * 0.999999999999) {
            tpdx = -1.0;
            tpdy = -1.0;
            dgonRT = -1.0;
        } else {
            this.i = 0;
            while (this.i < this.system.getPhases()[0].getNumberOfComponents()) {
                if (this.system.getComponent(this.i).getz() > 1.0E-50) {
                    tpdy += this.system.getPhase(0).getComponent(this.i).getx() * (Math.log(this.system.getPhase(0).getComponent(this.i).getFugacityCoefficient()) + Math.log(this.system.getPhase(0).getComponent(this.i).getx()) - this.minGibsPhaseLogZ[this.i] - this.minGibsLogFugCoef[this.i]);
                    tpdx += this.system.getPhase(1).getComponent(this.i).getx() * (Math.log(this.system.getPhase(1).getComponent(this.i).getFugacityCoefficient()) + Math.log(this.system.getPhase(1).getComponent(this.i).getx()) - this.minGibsPhaseLogZ[this.i] - this.minGibsLogFugCoef[this.i]);
                }
                ++this.i;
            }
            dgonRT = this.system.getPhase(0).getBeta() * tpdy + (1.0 - this.system.getPhase(0).getBeta()) * tpdx;
            if (dgonRT > 0.0) {
                if (tpdx < 0.0) {
                    this.i = 0;
                    while (this.i < this.system.getPhases()[0].getNumberOfComponents()) {
                        this.system.getPhase(0).getComponent(this.i).setK(Math.exp(Math.log(this.system.getPhase(1).getComponent(this.i).getFugacityCoefficient()) - this.minGibsLogFugCoef[this.i]) * this.presdiff);
                        this.system.getPhase(1).getComponent(this.i).setK(this.system.getPhase(0).getComponent(this.i).getK());
                        ++this.i;
                    }
                } else if (tpdy < 0.0) {
                    this.i = 0;
                    while (this.i < this.system.getPhase(0).getNumberOfComponents()) {
                        this.system.getPhase(0).getComponent(this.i).setK(Math.exp(this.minGibsLogFugCoef[this.i] - Math.log(this.system.getPhase(0).getComponent(this.i).getFugacityCoefficient())) * this.presdiff);
                        this.system.getPhase(1).getComponent(this.i).setK(this.system.getPhase(0).getComponent(this.i).getK());
                        ++this.i;
                    }
                } else {
                    passedTests = true;
                }
            }
        }
        if ((passedTests || dgonRT > 0.0 && tpdx > 0.0 && tpdy > 0.0 || Double.isNaN(this.system.getBeta())) && this.system.checkStability() && this.stabilityCheck()) {
            TPflash operation3;
            if (this.system.doMultiPhaseCheck()) {
                operation3 = new TPmultiflash(this.system, this.system.doSolidPhaseCheck());
                ((TPmultiflash)operation3).run();
            }
            if (this.solidCheck) {
                this.solidPhaseFlash();
            }
            if (this.system.isMultiphaseWaxCheck()) {
                operation3 = new TPmultiflashWAX(this.system, true);
                ((TPmultiflashWAX)operation3).run();
            }
            this.system.orderByDensity();
            this.system.init(1);
            return;
        }
        this.setNewK();
        this.gibbsEnergyOld = this.gibbsEnergy = this.system.getGibbsEnergy();
        double gasgib = this.system.getPhase(0).getGibbsEnergy();
        this.system.setPhaseType(0, PhaseType.LIQUID);
        this.system.init(1, 0);
        double liqgib = this.system.getPhase(0).getGibbsEnergy();
        if (gasgib * (1.0 - Math.signum(gasgib) * 1.0E-8) < liqgib) {
            this.system.setPhaseType(0, PhaseType.GAS);
        }
        this.system.init(1);
        int accelerateInterval = 7;
        int newtonLimit = 20;
        int timeFromLastGibbsFail = 0;
        double chemdev = 0.0;
        double oldChemDiff = 1.0;
        double diffChem = 1.0;
        do {
            this.iterations = 0;
            do {
                ++this.iterations;
                if (this.iterations < newtonLimit || this.system.isChemicalSystem() || !this.system.isImplementedCompositionDeriativesofFugacity()) {
                    if (timeFromLastGibbsFail > 6 && this.iterations % accelerateInterval == 0 && !this.system.isChemicalSystem() && !this.system.doSolidPhaseCheck()) {
                        this.accselerateSucsSubs();
                    } else {
                        this.sucsSubs();
                    }
                } else if (this.iterations >= newtonLimit && Math.abs(this.system.getPhase(0).getPressure() - this.system.getPhase(1).getPressure()) < 1.0E-5) {
                    if (this.iterations == newtonLimit) {
                        this.secondOrderSolver = new SysNewtonRhapsonTPflash(this.system, 2, this.system.getPhases()[0].getNumberOfComponents());
                    }
                    try {
                        this.deviation = this.secondOrderSolver.solve();
                    }
                    catch (Exception ex) {
                        this.sucsSubs();
                    }
                } else {
                    this.sucsSubs();
                }
                this.gibbsEnergyOld = this.gibbsEnergy;
                this.gibbsEnergy = this.system.getGibbsEnergy();
                if (((this.gibbsEnergy - this.gibbsEnergyOld) / Math.abs(this.gibbsEnergyOld) > 1.0E-8 || this.system.getBeta() < 1.01E-12 || this.system.getBeta() > 0.99999999999899) && !this.system.isChemicalSystem() && timeFromLastGibbsFail > 0) {
                    this.resetK();
                    timeFromLastGibbsFail = 0;
                    continue;
                }
                ++timeFromLastGibbsFail;
                this.setNewK();
            } while (this.deviation > 1.0E-10 && this.iterations < this.maxNumberOfIterations);
            if (!this.system.isChemicalSystem()) continue;
            oldChemDiff = chemdev;
            chemdev = 0.0;
            double[] xchem = new double[this.system.getPhase(0).getNumberOfComponents()];
            for (int phaseNum = 1; phaseNum < this.system.getNumberOfPhases(); ++phaseNum) {
                this.i = 0;
                while (this.i < this.system.getPhase(phaseNum).getNumberOfComponents()) {
                    xchem[this.i] = this.system.getPhase(phaseNum).getComponent(this.i).getx();
                    ++this.i;
                }
                this.system.init(1);
                this.system.getChemicalReactionOperations().solveChemEq(phaseNum, 1);
                this.i = 0;
                while (this.i < this.system.getPhase(phaseNum).getNumberOfComponents()) {
                    chemdev += Math.abs(xchem[this.i] - this.system.getPhase(phaseNum).getComponent(this.i).getx()) / xchem[this.i];
                    ++this.i;
                }
            }
            diffChem = Math.abs(oldChemDiff - chemdev);
        } while (diffChem > 1.0E-6 && chemdev > 1.0E-6 && ++totiter < 300 || this.system.isChemicalSystem() && totiter < 2);
        if (this.system.isChemicalSystem()) {
            this.sucsSubs();
        }
        if (this.system.doMultiPhaseCheck()) {
            operation = new TPmultiflash(this.system, this.system.doSolidPhaseCheck());
            ((TPmultiflash)operation).run();
        } else {
            try {
                if (this.system.getPhase(0).getType() == PhaseType.GAS) {
                    gasgib = this.system.getPhase(0).getGibbsEnergy();
                    this.system.setPhaseType(0, PhaseType.LIQUID);
                    this.system.init(1, 0);
                    liqgib = this.system.getPhase(0).getGibbsEnergy();
                } else {
                    liqgib = this.system.getPhase(0).getGibbsEnergy();
                    this.system.setPhaseType(0, PhaseType.GAS);
                    this.system.init(1, 0);
                    gasgib = this.system.getPhase(0).getGibbsEnergy();
                }
                if (gasgib * (1.0 - Math.signum(gasgib) * 1.0E-8) < liqgib) {
                    this.system.setPhaseType(0, PhaseType.GAS);
                }
            }
            catch (Exception e) {
                this.system.setPhaseType(0, PhaseType.GAS);
            }
            this.system.init(1);
        }
        if (this.solidCheck) {
            this.solidPhaseFlash();
        }
        if (this.system.isMultiphaseWaxCheck()) {
            operation = new TPmultiflashWAX(this.system, true);
            ((TPmultiflashWAX)operation).run();
        }
        for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
            if (!(this.system.getBeta(i) < 1.01E-12)) continue;
            this.system.removePhase(i);
        }
        this.system.orderByDensity();
        this.system.init(1);
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TPflash other = (TPflash)obj;
        if (Double.compare(this.presdiff, other.presdiff) != 0) {
            return false;
        }
        if (this.solidCheck != other.solidCheck) {
            return false;
        }
        return !(this.system == null ? other.system != null : !this.system.equals(other.system));
    }
}

