/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import Jama.Matrix;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.Flash;

public class TPgradientFlash
extends Flash {
    private static final long serialVersionUID = 1000L;
    private SystemInterface system;
    private double temperature;
    private double height;
    private Matrix Jac;
    private Matrix fvec;
    private Matrix dx;
    private SystemInterface localSystem;
    private SystemInterface tempSystem;
    private double deltaHeight;
    private double deltaT;

    public TPgradientFlash() {
    }

    public TPgradientFlash(SystemInterface system, double height, double temperature) {
        this.system = system;
        this.temperature = temperature;
        this.height = height;
        int numComponents = system.getPhase(0).getNumberOfComponents();
        this.Jac = new Matrix(numComponents + 1, numComponents + 1);
        this.fvec = new Matrix(numComponents + 1, 1);
    }

    public void setfvec() {
        double sumx = 0.0;
        int numComponents = this.system.getPhase(0).getNumberOfComponents();
        double gravity = 9.80665;
        double gasConstant = 8.3144621;
        for (int i = 0; i < numComponents; ++i) {
            ComponentInterface component = this.localSystem.getPhase(0).getComponent(i);
            double fugacityCoeff = component.getFugacityCoefficient();
            double componentX = component.getx();
            double pressure = this.localSystem.getPressure();
            double logTerm = Math.log(fugacityCoeff * componentX * pressure);
            double molarMassTerm = component.getMolarMass() * gravity * this.deltaHeight / (gasConstant * this.tempSystem.getPhase(0).getTemperature());
            this.fvec.set(i, 0, logTerm - Math.log(this.tempSystem.getPhases()[0].getComponent(i).getFugacityCoefficient() * this.tempSystem.getPhases()[0].getComponent(i).getx() * this.tempSystem.getPressure()) - molarMassTerm);
            sumx += componentX;
        }
        this.fvec.set(numComponents, 0, sumx - 1.0);
    }

    public void setJac() {
        int i;
        this.Jac.timesEquals(0.0);
        int numComponents = this.system.getPhase(0).getNumberOfComponents();
        for (i = 0; i < numComponents; ++i) {
            for (int j = 0; j < numComponents; ++j) {
                double dij = i == j ? 1.0 : 0.0;
                double fugacityCoeff = this.localSystem.getPhases()[0].getComponent(i).getFugacityCoefficient();
                double componentX = this.localSystem.getPhases()[0].getComponent(i).getx();
                double pressure = this.localSystem.getPressure();
                double tempJ = 1.0 / (fugacityCoeff * componentX * pressure) * (fugacityCoeff * dij * pressure + this.localSystem.getPhases()[0].getComponent(i).getdfugdx(j) * componentX * pressure);
                this.Jac.set(i, j, tempJ);
            }
        }
        for (int j = 0; j < numComponents; ++j) {
            this.Jac.set(numComponents, j, 1.0);
        }
        for (i = 0; i < numComponents; ++i) {
            double fugacityCoeff = this.localSystem.getPhases()[0].getComponent(i).getFugacityCoefficient();
            double componentX = this.localSystem.getPhases()[0].getComponent(i).getx();
            double pressure = this.localSystem.getPressure();
            double tempJ = 1.0 / (fugacityCoeff * componentX * pressure) * (this.localSystem.getPhases()[0].getComponent(i).getdfugdp() * componentX * pressure + fugacityCoeff * componentX);
            this.Jac.set(i, numComponents, tempJ);
        }
        this.Jac.set(numComponents, numComponents, 0.0);
    }

    public void setNewX() {
        int numComponents = this.system.getPhase(0).getNumberOfComponents();
        double relaxationFactor = 0.8;
        for (int i = 0; i < numComponents; ++i) {
            ComponentInterface component = this.localSystem.getPhase(0).getComponent(i);
            double newX = component.getx() - relaxationFactor * this.dx.get(i, 0);
            component.setx(newX);
        }
        double newPressure = this.localSystem.getPressure() - relaxationFactor * this.dx.get(numComponents, 0);
        this.localSystem.setPressure(newPressure);
    }

    @Override
    public void run() {
        this.tempSystem = this.system.clone();
        this.tempSystem.init(0);
        this.tempSystem.init(3);
        this.localSystem = this.system.clone();
        this.deltaT = (this.temperature - this.system.getTemperature()) / 20.0;
        this.deltaHeight = this.height / 20.0;
        for (int step = 0; step < 20; ++step) {
            this.localSystem.setTemperature(this.localSystem.getTemperature() + this.deltaT);
            int iter = 0;
            double tolerance = 1.0E-10;
            int maxIterations = 50;
            do {
                ++iter;
                this.localSystem.init(3);
                this.setfvec();
                this.setJac();
                this.dx = this.Jac.solve(this.fvec);
                this.setNewX();
            } while (this.dx.norm2() > tolerance && iter < maxIterations);
            this.tempSystem = this.localSystem.clone();
            this.tempSystem.init(3);
        }
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.localSystem;
    }
}

