/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.Flash;
import neqsim.thermodynamicoperations.flashops.TPflash;
import org.jfree.chart.JFreeChart;

public class TVflash
extends Flash {
    private static final long serialVersionUID = 1000L;
    double Vspec = 0.0;
    Flash tpFlash;

    public TVflash(SystemInterface system, double Vspec) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Vspec = Vspec;
    }

    public double calcdQdVdP() {
        double dQdVP = 0.0;
        for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
            dQdVP += 1.0 / this.system.getPhase(i).getdPdVTn();
        }
        return dQdVP;
    }

    public double calcdQdV() {
        double dQ = this.system.getVolume() - this.Vspec;
        return dQ;
    }

    public double solveQ() {
        double oldPres = this.system.getPressure();
        double nyPres = this.system.getPressure();
        double iterations = 1.0;
        double error = 100.0;
        double numericdQdVdP = 0.0;
        double dQdV = 0.0;
        double olddQdV = 0.0;
        double pressureStep = 1.0;
        do {
            oldPres = nyPres;
            this.system.init(3);
            double dQDVdP = this.calcdQdVdP();
            numericdQdVdP = (this.calcdQdV() - olddQdV) / pressureStep;
            nyPres = (iterations += 1.0) < 5.0 ? oldPres - 0.1 * this.calcdQdV() / dQDVdP : oldPres - 1.0 * this.calcdQdV() / numericdQdVdP;
            if (nyPres <= 0.0) {
                nyPres = oldPres * 0.9;
            }
            if (nyPres >= oldPres * 2.0) {
                nyPres = oldPres * 2.0;
            }
            pressureStep = nyPres - oldPres;
            olddQdV = this.calcdQdV();
            this.system.setPressure(nyPres);
            this.tpFlash.run();
        } while ((error = Math.abs(this.calcdQdV()) / this.system.getVolume()) > 1.0E-9 && iterations < 200.0 || iterations < 3.0);
        return nyPres;
    }

    @Override
    public void run() {
        this.tpFlash.run();
        this.solveQ();
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

